<?php
/*
  $Id: cmcic.php,v 1.03  11/10/2011 Sbastien STRAZIERI (support@agence-web-360.com)

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2011 Agence Web 360 - http://www.agence-web-360.com

  Released under the GNU General Public License
*/

define("CMCIC_CTLHMAC","V1.04.sha1.php--[CtlHmac%s%s]-%s");
define("CMCIC_CTLHMACSTR", "CtlHmac%s%s");
define("CMCIC_CGI2_RECEIPT","version=2\ncdr=%s");
define("CMCIC_CGI2_MACOK","0");
define("CMCIC_CGI2_MACNOTOK","1\n");
define("CMCIC_CGI2_FIELDS", "%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*");
define("CMCIC_CGI1_FIELDS", "%s*%s*%s%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s*%s");


/*****************************************************************************
*
* Classe / Class : CMCIC_Tpe
*
*****************************************************************************/

class CMCIC_Tpe {

	var $sVersion;	// Version du TPE - TPE Version (Ex : 3.0)
	var $sNumero;	// Numero du TPE - TPE Number (Ex : 1234567)
	var $sCodeSociete;	// Code Societe - Company code (Ex : companyname)
	var $sLangue;	// Langue - Language (Ex : FR, DE, EN, ..)
	var $_sCle;		// La cl - The Key
	

	// ----------------------------------------------------------------------------
	//
	// Constructeur / Constructor
	//
	// ----------------------------------------------------------------------------
	
	function CMCIC_Tpe($sLangue = "FR") {

		$chemincle = "cmcic/".MODULE_PAYMENT_CMCIC_TPE.".key";
   		if (file_exists($chemincle)) {
			$data_cle = explode(' ',nl2br(file_get_contents($chemincle)));
			define ("CMCIC_CLE", substr($data_cle[2], 0, -3));
   		}

	
		// contrle de l'existence des constantes de paramtrages.
		$aRequiredConstants = array('CMCIC_CLE', 'MODULE_PAYMENT_CMCIC_VERSION', 'MODULE_PAYMENT_CMCIC_TPE', 'MODULE_PAYMENT_CMCIC_SOCIETE');
		
		$this->_checkTpeParams($aRequiredConstants);
		$this->sVersion = MODULE_PAYMENT_CMCIC_VERSION;
		$this->_sCle = CMCIC_CLE;
		$this->sNumero = MODULE_PAYMENT_CMCIC_TPE;
		$this->sCodeSociete = MODULE_PAYMENT_CMCIC_SOCIETE;
		$this->sLangue = $sLangue;
	}

	// ----------------------------------------------------------------------------
	//
	// Fonction / Function : getCle
	//
	// Renvoie la cl du TPE / return the TPE Key
	//
	// ----------------------------------------------------------------------------

	function getCle() {

		return $this->_sCle;
	}

	// ----------------------------------------------------------------------------
	//
	// Fonction / Function : _checkTpeParams
	//
	// Contrle l'existence des constantes d'initialisation du TPE
	// Check for the initialising constants of the TPE
	//
	// ----------------------------------------------------------------------------

	function _checkTpeParams($aConstants) {

		for ($i = 0; $i < count($aConstants); $i++)
			if (!defined($aConstants[$i]))
				die ("Erreur paramtre " . $aConstants[$i] . " indfini");
	}

}


/*****************************************************************************
*
* Classe / Class : CMCIC_Hmac
*
*****************************************************************************/

class CMCIC_Hmac {

	var $_sUsableKey;	// La cl du TPE en format oprationnel / The usable TPE key

	// ----------------------------------------------------------------------------
	//
	// Constructeur / Constructor
	//
	// ----------------------------------------------------------------------------

	function CMCIC_Hmac($oTpe) {
		
		$this->_sUsableKey = $this->_getUsableKey($oTpe);
	}

	// ----------------------------------------------------------------------------
	//
	// Fonction / Function : _getUsableKey
	//
	// Renvoie la cl dans un format utilisable par la certification hmac
	// Return the key to be used in the hmac function
	//
	// ----------------------------------------------------------------------------

	function _getUsableKey($oTpe){

		$hexStrKey  = substr($oTpe->getCle(), 0, 38);
		$hexFinal   = "" . substr($oTpe->getCle(), 38, 2) . "00";
    
		$cca0=ord($hexFinal); 

		if ($cca0>70 && $cca0<97) 
			$hexStrKey .= chr($cca0-23) . substr($hexFinal, 1, 1);
		else { 
			if (substr($hexFinal, 1, 1)=="M") 
				$hexStrKey .= substr($hexFinal, 0, 1) . "0"; 
			else 
				$hexStrKey .= substr($hexFinal, 0, 2);
		}


		return pack("H*", $hexStrKey);
	}

	// ----------------------------------------------------------------------------
	//
	// Fonction / Function : computeHmac
	//
	// Renvoie le sceau HMAC d'une chaine de donnes
	// Return the HMAC for a data string
	//
	// ----------------------------------------------------------------------------

	function computeHmac($sData) {

		return strtolower($this->hmac_sha1($this->_sUsableKey, $sData));
	}

	// ----------------------------------------------------------------------------
	//
	// Fonction / Function : hmac_sha1
	//
	// RFC 2104 HMAC implementation for PHP >= 4.3.0 - Creates a SHA1 HMAC.
	// Eliminates the need to install mhash to compute a HMAC
	// Adjusted from the md5 version by Lance Rushing .
	//
	// Implmentation RFC 2104 HMAC pour PHP >= 4.3.0 - Cration d'un SHA1 HMAC.
	// Elimine l'installation de mhash pour le calcul d'un HMAC
	// Adapte de la version MD5 de Lance Rushing.
	//
	// ----------------------------------------------------------------------------

	function hmac_sha1 ($key, $data) {
		
		$length = 64; // block length for SHA1
		if (strlen($key) > $length) { $key = pack("H*",sha1($key)); }
		$key  = str_pad($key, $length, chr(0x00));
		$ipad = str_pad('', $length, chr(0x36));
		$opad = str_pad('', $length, chr(0x5c));
		$k_ipad = $key ^ $ipad ;
		$k_opad = $key ^ $opad;

		return sha1($k_opad  . pack("H*",sha1($k_ipad . $data)));
	}	

}

// ----------------------------------------------------------------------------
// function getMethode 
//
// IN: 
// OUT: Donnes soumises par GET ou POST / Data sent by GET or POST
// description: Renvoie le tableau des donnes / Send back the data array
// ----------------------------------------------------------------------------

function getMethode(){
    if ($_SERVER["REQUEST_METHOD"] == "GET")  
        return $_GET; 

    if ($_SERVER["REQUEST_METHOD"] == "POST")
	return $_POST;

    die ('Invalid REQUEST_METHOD (not GET, not POST).');
}

// ----------------------------------------------------------------------------
// function HtmlEncode
//
// IN:  chaine a encoder / String to encode
// OUT: Chaine encode / Encoded string
//
// Description: Encode special characters under HTML format
//                           ********************
//              Encodage des caractres spciaux au format HTML
// ----------------------------------------------------------------------------
function HtmlEncode ($data){
    $SAFE_OUT_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890._-";
    $encoded_data = "";
    $result = "";
    for ($i=0; $i<strlen($data); $i++)
    {
        if (strchr($SAFE_OUT_CHARS, $data{$i})) {
            $result .= $data{$i};
        }
        else if (($var = bin2hex(substr($data,$i,1))) <= "7F"){
            $result .= "&#x" . $var . ";";
        }
        else
            $result .= $data{$i};
            
    }
    return $result;
}

/*****************************************************************************
*
* Classe / Class : cmcic
*
*****************************************************************************/

class cmcic {
	var $code, $title, $description, $enabled; 
	// class constructor
	function cmcic()	{
		global $order;

		$this->code = 'cmcic';
		$this->title = MODULE_PAYMENT_CMCIC_TEXT_TITLE;
		$this->description = MODULE_PAYMENT_CMCIC_TEXT_DESCRIPTION;
		$this->sort_order = MODULE_PAYMENT_CMCIC_SORT_ORDER;
		$this->enabled = ((MODULE_PAYMENT_CMCIC_STATUS == 'True') ? true : false);
		$this->public_title = MODULE_PAYMENT_CMCIC_TEXT_TITLE;
		$this->signature = 'CMCiC|CMCiC|3.0c';
		$this->api_version = '3.0';

		if ((int)MODULE_PAYMENT_CMCIC_ORDER_STATUS_ID > 0) {
			$this->order_status = MODULE_PAYMENT_CMCIC_ORDER_STATUS_ID;
		} 

		if (is_object($order)) $this->update_status();

		// Construction de la cible du formulaire
		if (MODULE_PAYMENT_CMCIC_BANQUE=='CiC') $this->form_action_url = 'https://ssl.paiement.cic-banques.fr/';
		elseif (MODULE_PAYMENT_CMCIC_BANQUE=='CreditMut') $this->form_action_url = 'https://paiement.creditmutuel.fr/';
		elseif (MODULE_PAYMENT_CMCIC_BANQUE=='OBC') $this->form_action_url = 'https://ssl.paiement.banque-obc.fr/';
		if (MODULE_PAYMENT_CMCIC_MODE=='test') $this->form_action_url .= 'test/';
		$this->form_action_url .= 'paiement.cgi';

	} 
	// class methods
	function update_status()	{
		global $order;

		if (($this->enabled == true) && ((int)MODULE_PAYMENT_CMCIC_ZONE > 0)) {
			$check_flag = false;
			$check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_CMCIC_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
			while ($check = tep_db_fetch_array($check_query)) {
				if ($check['zone_id'] < 1) {
					$check_flag = true;
					break;
				} elseif ($check['zone_id'] == $order->billing['zone_id']) {
					$check_flag = true;
					break;
				} 
			} 

			if ($check_flag == false) {
				$this->enabled = false;
			} 
		} 
	} 

	function javascript_validation()	{
		return false;
	} 

	function selection()	{
		if (MODULE_PAYMENT_CMCIC_BANQUE=='CiC') $image_banque = 'divers/cic.gif';
		elseif (MODULE_PAYMENT_CMCIC_BANQUE=='CreditMut') $image_banque = 'divers/cybermut.jpg';
		elseif (MODULE_PAYMENT_CMCIC_BANQUE=='OBC') $image_banque = 'divers/obc.gif';

		return array('id' => $this->code,
			'module' => $this->title . '<br>' . tep_image(DIR_WS_IMAGES . $image_banque));
	} 

	function pre_confirmation_check()	{
		return false;
	} 

	function confirmation()	{
		if (MODULE_PAYMENT_CMCIC_BANQUE=='CiC') $image_banque = 'divers/cic.gif';
		elseif (MODULE_PAYMENT_CMCIC_BANQUE=='CreditMut') $image_banque = 'divers/cybermut.jpg';
		elseif (MODULE_PAYMENT_CMCIC_BANQUE=='OBC') $image_banque = 'divers/obc.gif';

		return array('title' => tep_image(DIR_WS_IMAGES . $image_banque));
	} 

	function process_button()	{
		global $order, $currencies, $currency, $customer_id; 

		//generation de la reference dans la table cmcic_reference pour assurer l'unicite
		$sql_data_array = array('order_id'=> 0);
		tep_db_perform('cmcic_reference', $sql_data_array);
		$new_id = tep_db_insert_id();
		$reference = str_pad($new_id, 12, "0", STR_PAD_LEFT);
		//on enregistre la reference
		tep_db_perform('cmcic_reference', array('ref_number' => $reference), 'update', "ref_id=". $new_id);

		$version = MODULE_PAYMENT_CMCIC_VERSION;
		$societe = MODULE_PAYMENT_CMCIC_SOCIETE;

		$sOptions = "";

		// Reference: unique, alphaNum (A-Z a-z 0-9), 12 characters max
		$sReference = $reference;

		// Amount : format  "xxxxx.yy" (no spaces)
		// $sMontant = 1.01;
		$sMontant = number_format($order->info['total'] * $currencies->get_value($order->info['currency']), $currencies->currencies[$order->info['currency']]['decimal_places'], '.', '');

		// Currency : ISO 4217 compliant
		// $sDevise  = "EUR";
		$sDevise  = $order->info['currency'];

		// free texte : a bigger reference, session context for the return on the merchant website
		//$sTexteLibre = "Texte Libre";
		$sTexteLibre = tep_session_id();

		// transaction date : format d/m/y:h:m:s
		$sDate = date('d/m/Y:H:i:s');

		// Language of the company code
		$sLangue = "FR";

		// customer email
		// $sEmail = "test@test.zz";
		$email_query = tep_db_query("select customers_email_address from " . TABLE_CUSTOMERS . " where customers_id = '" . (int)$customer_id . "'");
		$email = tep_db_fetch_array($email_query);
		$sEmail = $email['customers_email_address'];

		// ----------------------------------------------------------------------------

		// between 2 and 4
		//$sNbrEch = "4";
		$sNbrEch = "";

		// date echeance 1 - format dd/mm/yyyy
		//$sDateEcheance1 = date("d/m/Y");
		$sDateEcheance1 = "";

		// montant chance 1 - format  "xxxxx.yy" (no spaces)
		//$sMontantEcheance1 = "0.26" . $sDevise;
		$sMontantEcheance1 = "";

		// date echeance 2 - format dd/mm/yyyy
		//$sDateEcheance2 = date("d/m/Y", mktime(0, 0, 0, date("m") +1 , date("d"), date("Y")));
		$sDateEcheance2 = "";

		// montant chance 2 - format  "xxxxx.yy" (no spaces)
		//$sMontantEcheance2 = "0.25" . $sDevise;
		$sMontantEcheance2 = "";

		// date echeance 3 - format dd/mm/yyyy
		//$sDateEcheance3 = date("d/m/Y", mktime(0, 0, 0, date("m") +2 , date("d"), date("Y")));
		$sDateEcheance3 = "";

		// montant chance 3 - format  "xxxxx.yy" (no spaces)
		//$sMontantEcheance3 = "0.25" . $sDevise;
		$sMontantEcheance3 = "";

		// date echeance 4 - format dd/mm/yyyy
		//$sDateEcheance4 = date("d/m/Y", mktime(0, 0, 0, date("m") +3 , date("d"), date("Y")));
		$sDateEcheance4 = "";

		// montant chance 4 - format  "xxxxx.yy" (no spaces)
		//$sMontantEcheance4 = "0.25" . $sDevise;
		$sMontantEcheance4 = "";

		// ----------------------------------------------------------------------------

		$oTpe = new CMCIC_Tpe($sLangue);
		$oHmac = new CMCIC_Hmac($oTpe);

		// Control String for support
		$CtlHmac = sprintf(CMCIC_CTLHMAC, $oTpe->sVersion, $oTpe->sNumero, $oHmac->computeHmac(sprintf(CMCIC_CTLHMACSTR, $oTpe->sVersion, $oTpe->sNumero)));

		// Data to certify
		$PHP1_FIELDS = sprintf(CMCIC_CGI1_FIELDS,$oTpe->sNumero,
                                              $sDate,
                                              $sMontant,
                                              $sDevise,
                                              $sReference,
                                              $sTexteLibre,
                                              $oTpe->sVersion,
                                              $oTpe->sLangue,
                                              $oTpe->sCodeSociete, 
                                              $sEmail,
                                              $sNbrEch,
                                              $sDateEcheance1,
                                              $sMontantEcheance1,
                                              $sDateEcheance2,
                                              $sMontantEcheance2,
                                              $sDateEcheance3,
                                              $sMontantEcheance3,
                                              $sDateEcheance4,
                                              $sMontantEcheance4,
                                              $sOptions);

		// MAC computation
		$sMAC = $oHmac->computeHmac($PHP1_FIELDS);

		// ----------------------------------------------------------------------------
		// Your Page displaying payment button to be customized  
		// ----------------------------------------------------------------------------


		$process_button_string = tep_draw_hidden_field('MAC', HtmlEncode($sMAC)) . "\n" .
		tep_draw_hidden_field('version', HtmlEncode($oTpe->sVersion)) . "\n" .
		tep_draw_hidden_field('TPE', HtmlEncode($oTpe->sNumero)) . "\n" .
		tep_draw_hidden_field('date', HtmlEncode($sDate)) . "\n" .
		tep_draw_hidden_field('montant', HtmlEncode($sMontant . $sDevise)) . "\n" .
		tep_draw_hidden_field('reference', HtmlEncode($sReference)) . "\n" .
		tep_draw_hidden_field('lgue', HtmlEncode($oTpe->sLangue)) . "\n" .
		tep_draw_hidden_field('societe', HtmlEncode($oTpe->sCodeSociete)) . "\n" .
		tep_draw_hidden_field('url_retour', HtmlEncode(tep_href_link(FILENAME_DEFAULT)), '' , 'SSL') . "\n" .
		tep_draw_hidden_field('url_retour_ok', HtmlEncode(tep_href_link(FILENAME_CHECKOUT_SUCCESS)) ,'', 'SSL') . "\n" .
		tep_draw_hidden_field('url_retour_err', HtmlEncode(tep_href_link(FILENAME_CHECKOUT_PAYMENT)) ,'', 'SSL') . "\n" .
		tep_draw_hidden_field('texte-libre', HtmlEncode($sTexteLibre)) . "\n" .
		tep_draw_hidden_field('mail', $sEmail) . "\n" .
		tep_draw_hidden_field('bouton', HtmlEncode(MODULE_PAYMENT_CMCIC_BOUTON)) . "\n" ;

		if (MODULE_PAYMENT_CMCIC_MODE=='test'){
?>
<b>MODE TEST - DONNEES DU FORMULAIRE BANCAIRE:</b>
<p><span class="name">CLE SHA1</span> : <span class="value"><?php echo CMCIC_CLE;?></span></p>
<pre>
&lt;form <span class="name">action</span>="<span class="value"><?php echo $this->form_action_url ;?>"</span> method="post" id="PaymentRequest"&gt;
&lt;input type="hidden" name="<span class="name">MAC</span>"              value="<span class="value"><?php echo HtmlEncode($sMAC);?></span>" /&gt;
&lt;input type="hidden" name="<span class="name">version</span>"          value="<span class="value"><?php echo HtmlEncode($oTpe->sVersion);?></span>" /&gt;
&lt;input type="hidden" name="<span class="name">TPE</span>"              value="<span class="value"><?php echo HtmlEncode($oTpe->sNumero);?></span>" /&gt;
&lt;input type="hidden" name="<span class="name">date</span>"             value="<span class="value"><?php echo HtmlEncode($sDate);?></span>" /&gt;
&lt;input type="hidden" name="<span class="name">montant</span>"          value="<span class="value"><?php echo HtmlEncode($sMontant . $sDevise);?></span>" /&gt;
&lt;input type="hidden" name="<span class="name">reference</span>"        value="<span class="value"><?php echo HtmlEncode($sReference);?></span>" /&gt;
&lt;input type="hidden" name="<span class="name">lgue</span>"             value="<span class="value"><?php echo HtmlEncode($oTpe->sLangue);?></span>" /&gt;
&lt;input type="hidden" name="<span class="name">societe</span>"          value="<span class="value"><?php echo HtmlEncode($oTpe->sCodeSociete);?></span>" /&gt;
&lt;input type="hidden" name="<span class="name">url_retour</span>"       value="<span class="value"><?php echo HtmlEncode(tep_href_link(FILENAME_DEFAULT));?></span>" /&gt;
&lt;input type="hidden" name="<span class="name">url_retour_ok</span>"    value="<span class="value"><?php echo HtmlEncode(tep_href_link(FILENAME_CHECKOUT_SUCCESS));?></span>" /&gt;
&lt;input type="hidden" name="<span class="name">url_retour_err</span>"   value="<span class="value"><?php echo HtmlEncode(tep_href_link(FILENAME_CHECKOUT_PAYMENT));?></span>" /&gt;
&lt;input type="hidden" name="<span class="name">texte-libre</span>"      value="<span class="value"><?php echo HtmlEncode($sTexteLibre);?></span>" /&gt;
&lt;input type="hidden" name="<span class="name">mail</span>"             value="<span class="value"><?php echo $sEmail;?></span>" /&gt;
&lt;input type="submit" name="<span class="name">bouton</span>"           value="<span class="value"><?php echo HtmlEncode(MODULE_PAYMENT_CMCIC_BOUTON);?></span>" /&gt;
&lt;/form&gt;
</pre>
<?php	
		}

		return $process_button_string;
	} 

	function before_process()	{
		//empeche de valider en lancant directement l'adresse de checkout_process
		tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
	} 

	function after_process()	{
		return false;
	} 

	function get_error()	{
		return false;
	} 

	function check()	{
		if (!isset($this->_check)) {
			$check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_CMCIC_STATUS'");
			$this->_check = tep_db_num_rows($check_query);
		} 
		return $this->_check;
	} 

	function install()	{
		// vrifie si on a un ou plusieurs fichiers .key dans le repertoire "../cmcic"
		$dir = @opendir('../cmcic/');
	    while(($file = @readdir($dir)) !== false) {
			if(preg_match("#^[0-9]{7}.key$#", $file)) {
				$file = explode('.key', $file);
				$numsCom[] = $file[0];
			}
	    }
		if ( count($numsCom)) {
			$default = $numsCom[0];
			$txt_numCom = "\'" . $default . "\'";
			if ( count($numsCom)>1) {
				foreach ($numsCom as $numCom){
					$txt_numCom .= ", \'" . $numsCom . "\'";
				}
			}
		}
		else {
			$default = 'NULL';
			$txt_numCom = "\'" . $default . "\'";
		}
		
		// teste l'existence des tables et les ajoute si ncessaire
		if (!$this->mysql_table_exists('cmcic_response')) {
			tep_db_query("
			CREATE TABLE `cmcic_response` (
				`resp_id` int(11) NOT NULL auto_increment,
				`MAC` varchar(40) NOT NULL,
				`ref_number` varchar(12) NOT NULL default '',
				`TPE` varchar(7) NOT NULL,
				`date` varchar(21) NOT NULL,
				`montant` varchar(12) NOT NULL,
				`texte_libre` varchar(255),
				`code_retour` varchar(10) NOT NULL,
				`retourPLUS` varchar(50),   
				PRIMARY KEY  (`resp_id`)
			) TYPE=MyISAM;
			");
		}
		if (!$this->mysql_table_exists('cmcic_reference')) {
			tep_db_query("
			CREATE TABLE `cmcic_reference` (
				`ref_id` int(11) NOT NULL auto_increment,
				`ref_number` varchar(12) NOT NULL default '',
				`order_id` int(5) NOT NULL default '0',
				PRIMARY KEY  (`ref_id`)
			) TYPE=MyISAM;
			");
		}
		
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Activer Module Cybermut', 'MODULE_PAYMENT_CMCIC_STATUS', 'True', 'Voulez-vous activer le module de paiment Cybermut ?', '6', '1', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Sort order of display.', 'MODULE_PAYMENT_CMCIC_SORT_ORDER', '0', 'Sort order of display. Lowest is displayed first.', '6', '0', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Payment Zone', 'MODULE_PAYMENT_CMCIC_ZONE', '0', 'If a zone is selected, only enable this payment method for that zone.', '6', '2', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Numero TPE', 'MODULE_PAYMENT_CMCIC_TPE', '".$default."' , 'Numero du TPE', '6', '2', 'tep_cfg_select_option(array(". $txt_numCom ."), ', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Version du Kit', 'MODULE_PAYMENT_CMCIC_VERSION', '3.0', 'Version du kit open source', '6', '2', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Societe', 'MODULE_PAYMENT_CMCIC_SOCIETE', 'Site1', 'Code societe', '6', '15', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Bouton', 'MODULE_PAYMENT_CMCIC_BOUTON', 'Paiement CB', 'Mot a afficher sur le bouton du paiement', '6', '35', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Serveur bancaire', 'MODULE_PAYMENT_CMCIC_BANQUE', 'CiC', 'Banque utilisee pour les transactions', '6', '3', 'tep_cfg_select_option(array(\'CiC\', \'CreditMut\', \'OBC\'), ', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Mode d\'utilisation', 'MODULE_PAYMENT_CMCIC_MODE', 'test', 'Selectionner un mode d\'utilisation', '6', '4', 'tep_cfg_select_option(array(\\'test\', \'production\'), ', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Simulation', 'MODULE_PAYMENT_CMCIC_SIMULATION', 'Oui', 'Souhaitez vous simuler une commande en mode test ?', '6', '5', 'tep_cfg_select_option(array(\'Oui\', \'Non\'), ', now())");	
	} 

	function remove()	{
		tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
	} 

	function keys()	{
		return array('MODULE_PAYMENT_CMCIC_STATUS', 'MODULE_PAYMENT_CMCIC_ZONE', 'MODULE_PAYMENT_CMCIC_SORT_ORDER', 'MODULE_PAYMENT_CMCIC_TPE', 'MODULE_PAYMENT_CMCIC_VERSION', 'MODULE_PAYMENT_CMCIC_SOCIETE', 'MODULE_PAYMENT_CMCIC_BOUTON', 'MODULE_PAYMENT_CMCIC_BANQUE', 'MODULE_PAYMENT_CMCIC_MODE', 'MODULE_PAYMENT_CMCIC_SIMULATION');
	}

    function mysql_table_exists($table){
		$num_rows = @mysql_num_rows(mysql_query("SELECT COUNT(*) FROM $table"));
		if($num_rows) return TRUE;
		else return FALSE;
    }
}
?>