<?php
/*
  $Id: tnt.php,v 1.3 2003/01/05 09:24:47 jpcivade Exp $

  The Exchange Project - Community Made Shopping!
  http://www.theexchangeproject.org

  Copyright (c) 2000,2001 The Exchange Project

  Released under the GNU General Public License

    adaptation Stphane GUIBOUD-RIBAUD <devteam@e-network.fr>
	           xaglo <xaglo@free.fr>
			   
	mise a jour v1.4.2 by fram 2003/05/10	
	
	MAJ v1.5 by lepoissonrouge 19/06/2005
	MAJ v1.5.2 by lepoissonrouge 20/11/2005	   
adaptation fot TNT by pacmanito 27/04/2007

www.oscommerce-fr.info
*/


  class tnt {
    var $code, $title, $description, $icon, $enabled;

// class constructor
    function tnt() 
	{
      $this->code = 'tnt';
      $this->title = MODULE_SHIPPING_TNT_TEXT_TITLE;
      $this->description = MODULE_SHIPPING_TNT_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_SHIPPING_TNT_SORT_ORDER;
      $this->icon = DIR_WS_ICONS . 'tnt.gif';
      $this->tax_class = MODULE_SHIPPING_TNT_TAX_CLASS;
      $this->enabled = MODULE_SHIPPING_TNT_STATUS;
	}

// class methods
    function quote($method = '') 
	{
      global $order, $cart, $shipping_weight;

      $this->quotes = array('id' => $this->code,
                            'module' => MODULE_SHIPPING_TNT_TEXT_TITLE,
                            'methods' => array());

      if (tep_not_null($this->icon))
	$this->quotes['icon'] = tep_image($this->icon, $this->title);

      $dest_country = $order->delivery['country']['iso_code_2'];

      if (($dest_country != 'FR') && ($dest_country != 'FX')) {
	$this->quotes['error'] = MODULE_SHIPPING_TNT_INVALID_ZONE;
	return $this->quotes;
      }

	$cost = constant('MODULE_SHIPPING_TNT_NATIONAL');
      $table = split("[:,]" , $cost);
      for ($i = 0; $i < sizeof($table); $i+=2) {
	if ($shipping_weight > $table[$i])
	  continue;

	$this->quotes['methods'][] = array('id'    => $this->code,
					   'title' => $shipping_weight . ' ' . MODULE_SHIPPING_TNT_TEXT_UNITS,
					   'cost'  => $table[$i+1] + MODULE_SHIPPING_TNT_HANDLING);
	
      if ($this->tax_class > 0) {
        $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
      }
    return $this->quotes;
      }

      $this->quotes['error'] = MODULE_SHIPPING_TNT_TOO_HEAVY;
      return $this->quotes;
    }

    function check() {
      $check = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_TNT_STATUS'");
      $check = tep_db_num_rows($check);

      return $check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Valider tnt', 'MODULE_SHIPPING_TNT_STATUS', 'True', 'Activer / Dsactiver tnt sans perdre les valeurs chang&eacute;es', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('tnt express France', 'MODULE_SHIPPING_TNT_NATIONAL', '1:14.70, 5:17.06, 6:17.65, 7:18.24, 8:18.83, 9:19.42, 10:20.01, 11:20.60, 12:21.19, 13:21.78, 14:22.3, 15:22.96, 16:23.55, 17:24.14, 18:24.73, 19:25.32, 20:25.91, 21:26.50, 22:27.09, 23:27.68, 24:28.27, 25:28.86, 26:29.45, 27:30.04, 28:30.63, 29:31.22, 30:31.81', 'Port bas&eacute; sur le poids total des produits, tarif national HT. Exemple: 1:6.15, 2:6.95, etc. Jusqu\' 1 Kg factur 6.15, jusqu\' 2 Kg , 6.95, etc', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Frais fixes', 'MODULE_SHIPPING_TNT_HANDLING', '0', 'Frais fixes (emballage) pour tnt', '6', '0', now())");
	  tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Classe de taxe', 'MODULE_SHIPPING_TNT_TAX_CLASS', '0', 'Appliquer le taux de taxe suivant sur les frais de livraison.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Code postal', 'MODULE_SHIPPING_TNT_STORE_POSTCODE', '05000', 'Code postal de la boutique', '6', '0', now())");
	  tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordre de tri', 'MODULE_SHIPPING_TNT_SORT_ORDER', '0', 'Ordre de tri pour l\'affichage (Le plus petit nombre est montr&eacute; en premier).', '6', '0', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_SHIPPING_TNT_STATUS', 
		'MODULE_SHIPPING_TNT_NATIONAL', 
		'MODULE_SHIPPING_TNT_HANDLING', 
		'MODULE_SHIPPING_TNT_STORE_POSTCODE', 
		'MODULE_SHIPPING_TNT_TAX_CLASS',
		'MODULE_SHIPPING_TNT_SORT_ORDER');
    }
  }
?>
