<?php

/**
 * Traite la reponse de la banque au commercant, renvoi sur checkout_process pour validation de la commande
 * 
 *      $Id$ cmcic_response.php v 1.0 30/01/2004
 * 
 *      Contribution par E. DA MOTA aka Vilain Mamuth (vilain_mamuth@yahoo.com)
 *      Copyright 2003 MaCCS - Body's Cult http://www.bodyscult.com
 */
// remplace application top, enleve la contrainte du cookie qui n'existe pas lorsque le serveur de la banque envoi son code retour
// l'id de session est recupere  partir du champ texte-libre renvoy par CM - CIC

// set the level of error reporting
error_reporting(E_ALL &~E_NOTICE);

//recuparation des donnes renvoyes par la banque
$request_method = $HTTP_SERVER_VARS["REQUEST_METHOD"];
$wRequestVars = "HTTP_" . $request_method . "_VARS";
$RequestVars = ${$wRequestVars};

// include server parameters
require('includes/configure.php');
require(DIR_WS_INCLUDES . 'add_ccgvdc_application_top.php');
require(DIR_WS_CLASSES . 'PriceFormatter.php');

if ($request_type == 'NONSSL') {
	define('DIR_WS_CATALOG', DIR_WS_HTTP_CATALOG);
} else {
	define('DIR_WS_CATALOG', DIR_WS_HTTPS_CATALOG);
} 
// include the list of project filenames
require(DIR_WS_INCLUDES . 'filenames.php');
// include the list of project database tables
require(DIR_WS_INCLUDES . 'database_tables.php');
// include the database functions
require(DIR_WS_FUNCTIONS . 'database.php');
// make a connection to the database... now
tep_db_connect() or die('Unable to connect to database server!');
// set the application parameters
$configuration_query = tep_db_query('select configuration_key as cfgKey, configuration_value as cfgValue from ' . TABLE_CONFIGURATION);
while ($configuration = tep_db_fetch_array($configuration_query)) {
	define($configuration['cfgKey'], $configuration['cfgValue']);
} 
// define general functions used application-wide
require(DIR_WS_FUNCTIONS . 'general.php');
require(DIR_WS_FUNCTIONS . 'html_output.php');
// include shopping cart class
require(DIR_WS_CLASSES . 'shopping_cart.php');
// check if sessions are supported, otherwise use the php3 compatible session class
if (!function_exists('session_start')) {
	define('PHP_SESSION_NAME', 'osCsid');
	define('PHP_SESSION_PATH', $cookie_path);
	define('PHP_SESSION_DOMAIN', $cookie_domain);
	define('PHP_SESSION_SAVE_PATH', SESSION_WRITE_DIRECTORY);

	include(DIR_WS_CLASSES . 'sessions.php');
} 
// define how the session functions will be used
require(DIR_WS_FUNCTIONS . 'sessions.php');
// set the session name and save path
tep_session_name('osCsid');
tep_session_save_path(SESSION_WRITE_DIRECTORY);
// ********************************************************************************************************************
// recuperation de l'id de session contenu dans texte-libre
tep_session_id($RequestVars['texte-libre']);
// ********************************************************************************************************************
// start the session
$session_started = false;
tep_session_start();
$session_started = true;
// create the shopping cart & fix the cart if necesary
if (tep_session_is_registered('cart') && is_object($cart)) {
	if (PHP_VERSION < 4) {
		$broken_cart = $cart;
		$cart = new shoppingCart;
		$cart->unserialize($broken_cart);
	} 
} else {
	tep_session_register('cart');
	$cart = new shoppingCart;
} 
// include currencies class and create an instance
require(DIR_WS_CLASSES . 'currencies.php');
$currencies = new currencies();
// include the mail classes
require(DIR_WS_CLASSES . 'mime.php');
require(DIR_WS_CLASSES . 'email.php');
// set the language
if (!tep_session_is_registered('language') || isset($HTTP_GET_VARS['language'])) {
	if (!tep_session_is_registered('language')) {
		tep_session_register('language');
		tep_session_register('languages_id');
	} 

	include(DIR_WS_CLASSES . 'language.php');
	$lng = new language();

	if (isset($HTTP_GET_VARS['language']) && tep_not_null($HTTP_GET_VARS['language'])) {
		$lng->set_language($HTTP_GET_VARS['language']);
	} else {
		$lng->get_browser_language();
	} 

	$language = $lng->language['directory'];
	$languages_id = $lng->language['id'];
} 
// include the language translations
require(DIR_WS_LANGUAGES . $language . '.php');
// currency
if (!tep_session_is_registered('currency') || isset($HTTP_GET_VARS['currency']) || ((USE_DEFAULT_LANGUAGE_CURRENCY == 'true') && (LANGUAGE_CURRENCY != $currency))) {
	if (!tep_session_is_registered('currency')) tep_session_register('currency');

	if (isset($HTTP_GET_VARS['currency'])) {
		if (!$currency = tep_currency_exists($HTTP_GET_VARS['currency'])) $currency = (USE_DEFAULT_LANGUAGE_CURRENCY == 'true') ? LANGUAGE_CURRENCY : DEFAULT_CURRENCY;
	} else {
		$currency = (USE_DEFAULT_LANGUAGE_CURRENCY == 'true') ? LANGUAGE_CURRENCY : DEFAULT_CURRENCY;
	} 
} 
// ________________________________________________________________________________________________________________
include(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CHECKOUT_PROCESS);
// load selected payment module
include(DIR_WS_MODULES . 'payment/cmcic.php');
$payment_modules = new cmcic();

// load the selected shipping module
require(DIR_WS_CLASSES . 'shipping.php');
$shipping_modules = new shipping($shipping);

require(DIR_WS_CLASSES . 'order.php');
$order = new order;

// on archive les donnes reues de la banque dans la table cmcic_response
tep_db_perform('cmcic_response', array(
			'ref_number' => $RequestVars['reference'],
			'MAC' => $RequestVars['MAC'],
			'TPE' => $RequestVars['TPE'],
			'date' => $RequestVars['date'],
			'montant' => $RequestVars['montant'],
			'texte_libre' => $RequestVars['texte-libre'],
			'code_retour' => $RequestVars['code-retour'],
			'retourPLUS' => $RequestVars['retourPLUS'])	
									);

require(DIR_WS_CLASSES . 'order_total.php');
$order_total_modules = new order_total;
// on verifie que c bien la banque qui repond par le check du MAC
if (!$payment_modules->checkMAC($RequestVars)) {
	// qqch ne va pas dans la requete, on previent la banque et on arrete tout
	$payment_modules->sendAR("NotValid");
} else {
	// le MAC est correct, on regarde le code retour
	switch ($RequestVars['code-retour']) {
		case "Annulation" :
			tep_mail(STORE_NAME . ': CYBERMUT', STORE_OWNER_EMAIL_ADDRESS , "Commande Annule : " . $RequestVars['reference'],
				"Cette commande a t annule", STORE_NAME, STORE_OWNER_EMAIL_ADDRESS);
			$payment_modules->sendAR("Valid");
			break;
		case "payetest":
		case "paiement": 
			// on procede  la validation de la commande et on envoi l'accus de rception;
// ------------------ copie du code de checkout_process, uniquement ce qu'il faut pour valider la commande ----------------
// attention  certaines contributions qui sont suceptibles de demander la modification de checkout_process, les modifs sont  apporter aussi ici
			// Validation de la commande
			$order_totals = $order_total_modules->process();

			$sql_data_array = array('customers_id' => $customer_id,
				'customers_name' => $order->customer['firstname'] . ' ' . $order->customer['lastname'],
				'customers_company' => $order->customer['company'],
				'customers_street_address' => $order->customer['street_address'],
				'customers_suburb' => $order->customer['suburb'],
				'customers_city' => $order->customer['city'],
				'customers_postcode' => $order->customer['postcode'],
				'customers_state' => $order->customer['state'],
				'customers_country' => $order->customer['country']['title'],
				'customers_telephone' => $order->customer['telephone'],
				'customers_email_address' => $order->customer['email_address'],
				'customers_address_format_id' => $order->customer['format_id'],
				'delivery_name' => $order->delivery['firstname'] . ' ' . $order->delivery['lastname'],
				'delivery_company' => $order->delivery['company'],
				'delivery_street_address' => $order->delivery['street_address'],
				'delivery_suburb' => $order->delivery['suburb'],
				'delivery_city' => $order->delivery['city'],
				'delivery_postcode' => $order->delivery['postcode'],
				'delivery_state' => $order->delivery['state'],
				'delivery_country' => $order->delivery['country']['title'],
				'delivery_address_format_id' => $order->delivery['format_id'],
				'billing_name' => $order->billing['firstname'] . ' ' . $order->billing['lastname'],
				'billing_company' => $order->billing['company'],
				'billing_street_address' => $order->billing['street_address'],
				'billing_suburb' => $order->billing['suburb'],
				'billing_city' => $order->billing['city'],
				'billing_postcode' => $order->billing['postcode'],
				'billing_state' => $order->billing['state'],
				'billing_country' => $order->billing['country']['title'],
				'billing_address_format_id' => $order->billing['format_id'],
				'payment_method' => $order->info['payment_method'],
				'cc_type' => $order->info['cc_type'],
				'cc_owner' => $order->info['cc_owner'],
				'cc_number' => $order->info['cc_number'],
				'cc_expires' => $order->info['cc_expires'],
				'date_purchased' => 'now()',
				'orders_status' => $order->info['order_status'],
				'currency' => $order->info['currency'],
				'currency_value' => $order->info['currency_value']);
			tep_db_perform(TABLE_ORDERS, $sql_data_array);
			$insert_id = tep_db_insert_id();
			for ($i = 0, $n = sizeof($order_totals); $i < $n; $i++) {
				$sql_data_array = array('orders_id' => $insert_id,
					'title' => $order_totals[$i]['title'],
					'text' => $order_totals[$i]['text'],
					'value' => $order_totals[$i]['value'],
					'class' => $order_totals[$i]['code'],
					'sort_order' => $order_totals[$i]['sort_order']);
				tep_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
			} 

  if ( isset($order->info['num_relais_mr_id']) )
  {
    $sql_data_array['num_relais_mr_id'] = $order->info['num_relais_mr_id'];
  }

			$customer_notification = (SEND_EMAILS == 'true') ? '1' : '0';
			$sql_data_array = array('orders_id' => $insert_id,
				'orders_status_id' => $order->info['order_status'],
				'date_added' => 'now()',
				'customer_notified' => $customer_notification,
				'comments' => $order->info['comments']);
			tep_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array); 
			// initialized for the email confirmation
			$products_ordered = '';
			$subtotal = 0;
			$total_tax = 0;

			for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
				// Stock Update - Joao Correia
				if (STOCK_LIMITED == 'true') {
					if (DOWNLOAD_ENABLED == 'true') {
						$stock_query_raw = "SELECT products_quantity, pad.products_attributes_filename 
                            FROM " . TABLE_PRODUCTS . " p
                            LEFT JOIN " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                             ON p.products_id=pa.products_id
                            LEFT JOIN " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad
                             ON pa.products_attributes_id=pad.products_attributes_id
                            WHERE p.products_id = '" . tep_get_prid($order->products[$i]['id']) . "'"; 
						// Will work with only one option for downloadable products
						// otherwise, we have to build the query dynamically with a loop
						$products_attributes = $order->products[$i]['attributes'];
						if (is_array($products_attributes)) {
							$stock_query_raw .= " AND pa.options_id = '" . $products_attributes[0]['option_id'] . "' AND pa.options_values_id = '" . $products_attributes[0]['value_id'] . "'";
						} 
						$stock_query = tep_db_query($stock_query_raw);
					} else {
						$stock_query = tep_db_query("select products_quantity from " . TABLE_PRODUCTS . " where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
					} 
					if (tep_db_num_rows($stock_query) > 0) {
						$stock_values = tep_db_fetch_array($stock_query); 
						// do not decrement quantities if products_attributes_filename exists
						if ((DOWNLOAD_ENABLED != 'true') || (!$stock_values['products_attributes_filename'])) {
							$stock_left = $stock_values['products_quantity'] - $order->products[$i]['qty'];
						} else {
							$stock_left = $stock_values['products_quantity'];
						} 
						tep_db_query("update " . TABLE_PRODUCTS . " set products_quantity = '" . $stock_left . "' where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
						if (($stock_left < 1) && (STOCK_ALLOW_CHECKOUT == 'false')) {
							tep_db_query("update " . TABLE_PRODUCTS . " set products_status = '0' where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
						} 
					} 
				} 
				// Update products_ordered (for bestsellers list)
				tep_db_query("update " . TABLE_PRODUCTS . " set products_ordered = products_ordered + " . sprintf('%d', $order->products[$i]['qty']) . " where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");

				$sql_data_array = array('orders_id' => $insert_id,
					'products_id' => tep_get_prid($order->products[$i]['id']),
					'products_model' => $order->products[$i]['model'],
					'products_name' => $order->products[$i]['name'],
					'products_price' => $order->products[$i]['price'],

									//debut modif by paddyl for ecotax
									'ecotax_rates_id' => $order->products[$i]['ecotax_rates_id'],
                                    'final_price' => $order->products[$i]['final_price']+tep_round(tep_get_ecotax_price_value($order->products[$i]['ecotax_rates_id'])+tep_get_ecotax_price_value($order->products[$i]['ecotax_rates_id'])*($order->products[$i]['ecotax_taxe_rate']/100),2),
									//fin modif by paddybl for ecotax
									
					'products_tax' => $order->products[$i]['tax'],
					
														//debut modif by paddyl for ecotax
                            		'products_ecotax' => tep_round(tep_get_ecotax_price_value($order->products[$i]['ecotax_rates_id'])+tep_get_ecotax_price_value($order->products[$i]['ecotax_rates_id'])*($order->products[$i]['ecotax_taxe_rate']/100), $currencies->currencies[DEFAULT_CURRENCY]['decimal_places']),
									//fin modif by paddybl for ecotax
									
					'products_quantity' => $order->products[$i]['qty']);
				tep_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array);
				$order_products_id = tep_db_insert_id(); 
//------insert customer choosen option to order--------
    $products_ordered_attributes = '';
    if (isset($order->products[$i]['attributes'])) {
      for ($j=0, $n2=sizeof($order->products[$i]['attributes']); $j<$n2; $j++) {
        
        $sql_data_array = array('orders_id' => $insert_id,
                                'orders_products_id' => $order_products_id,
                                'products_options' => $order->products[$i]['attributes'][$j]['option'],
                                'products_options_values' => $order->products[$i]['attributes'][$j]['value'],
                                'options_values_price' => $order->products[$i]['attributes'][$j]['price'],
                                'price_prefix' => $order->products[$i]['attributes'][$j]['prefix'],
                                'products_options_id' => $order->products[$i]['attributes'][$j]['option_id'],
                                'products_options_values_id' => $order->products[$i]['attributes'][$j]['value_id']);
        tep_db_perform(TABLE_ORDERS_PRODUCTS_ATTRIBUTES, $sql_data_array);
        
        if (DOWNLOAD_ENABLED == 'true') {
          $attributes_query = "select pad.products_attributes_maxdays, pad.products_attributes_maxcount , pad.products_attributes_filename
                           from " . TABLE_PRODUCTS_ATTRIBUTES . " pa,
                                " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad
                              where pa.products_id = '" . $order->products[$i]['id'] . "'
                                and pa.options_id = '" . $order->products[$i]['attributes'][$j]['option_id'] . "'
                                and pa.options_values_id = '" . $order->products[$i]['attributes'][$j]['value_id'] . "'
                                and pa.products_attributes_id = pad.products_attributes_id";
          $attributes = tep_db_query($attributes_query);
          
          $attributes_values = tep_db_fetch_array($attributes);
        
          if ( isset($attributes_values['products_attributes_filename']) && tep_not_null($attributes_values['products_attributes_filename']) ) {
            $sql_data_array = array('orders_id' => $insert_id,
                                    'orders_products_id' => $order_products_id,
                                    'orders_products_filename' => $attributes_values['products_attributes_filename'],
                                    'download_maxdays' => $attributes_values['products_attributes_maxdays'],
                                    'download_count' => $attributes_values['products_attributes_maxcount']);
            tep_db_perform(TABLE_ORDERS_PRODUCTS_DOWNLOAD, $sql_data_array);
          }
        }
		//debut modif by paddyl for ecotax

        $products_ordered_attributes .= "\n\t" . $order->products[$i]['attributes'][$j]['option'] . ' ' . $order->products[$i]['attributes'][$j]['value'] . ' ' . $order->products[$i]['attributes'][$j]['prefix'] . ' ' . $currencies->display_price($order->products[$i]['attributes'][$j]['price'], tep_get_tax_rate($products[$i]['tax_class_id']),0, 1);
		//fin modif by paddybl for ecotax
      }
    }
//------insert customer choosen option eof ----
				$total_weight += ($order->products[$i]['qty'] * $order->products[$i]['weight']);
				$total_tax += tep_calculate_tax($total_products_price, $products_tax) * $order->products[$i]['qty'];
				$total_cost += $total_products_price;

//debut modif by paddybl for ecotax
    $products_ordered .= $order->products[$i]['qty'] . ' x ' . tep_db_decoder($order->products[$i]['name']) . ' (' . $order->products[$i]['model'] . ') = ' . $currencies->display_price($order->products[$i]['final_price'], $order->products[$i]['tax'],0, $order->products[$i]['qty']) . $products_ordered_attributes . "\n";
	if (MODULE_ORDER_TOTAL_ECOTAX_STATUS=='true' && !$order->products[$i]['ecotax_rates_id']=="0"){$products_ordered .='Eco-participation : Catgorie '.$order->products[$i]['ecotax_description'][0]['code'].' '.''.$currencies->display_price(tep_get_ecotax_price_value($order->products[$i]['ecotax_rates_id']), $order->products[$i]['ecotax_taxe_rate'],0, $order->products[$i]['qty']).'<br>';}
//fin modif by paddybl for ecotax
			} 
			// lets start with the email confirmation  
			$email_order = STORE_NAME . "\n" .
			EMAIL_RECAP_COMMANDE_DEBUT . "\n" .
			EMAIL_SEPARATOR . "\n" .
			EMAIL_TEXT_ORDER_NUMBER . ' ' . $insert_id . "\n" .
			EMAIL_TEXT_INVOICE_URL . ' ' . tep_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id=' . $insert_id, 'SSL', false) . "\n" .
			EMAIL_TEXT_DATE_ORDERED . ' ' . strftime(DATE_FORMAT_LONG) . "\n\n";
			if ($order->info['comments']) {
				$email_order .= tep_db_output($order->info['comments']) . "\n\n";
			} 
			$email_order .= EMAIL_TEXT_PRODUCTS . "\n" .
			EMAIL_SEPARATOR . "\n" . $products_ordered .
			EMAIL_SEPARATOR . "\n";

			for ($i = 0, $n = sizeof($order_totals); $i < $n; $i++) {
	//			$email_order .= strip_tags($order_totals[$i]['title']) . ' ' . strip_tags($order_totals[$i]['text']) . "\n";

				$email_order .= ($order_totals[$i]['title']) . ' ' . ($order_totals[$i]['text']) . "\n";
			} 

			if ($order->content_type != 'virtual') {
				$email_order .= "\n" . EMAIL_TEXT_DELIVERY_ADDRESS . "\n" .
				EMAIL_SEPARATOR . "\n" .
				tep_address_label($customer_id, $sendto, 0, '', "\n") . "\n";
			} 

			$email_order .= "\n" . EMAIL_TEXT_BILLING_ADDRESS . "\n" .
			EMAIL_SEPARATOR . "\n" .
			tep_address_label($customer_id, $billto, 0, '', "\n") . "\n\n";
			if (is_object($$payment)) {
				$email_order .= EMAIL_TEXT_PAYMENT_METHOD . "\n" .
				EMAIL_SEPARATOR . "\n";
				$payment_class = $$payment;
				$email_order .= $payment_class->title . "\n\n";
				if ($payment_class->email_footer) {
					$email_order .= $payment_class->email_footer . "\n\n";
				} 
			} 
      $email_order .= EMAIL_RECAP_COMMANDE_FIN . "\n\n";
			tep_mail($order->customer['firstname'] . ' ' . $order->customer['lastname'], $order->customer['email_address'], EMAIL_TEXT_SUBJECT, $email_order, STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS); 
			// send emails to other people
			if (SEND_EXTRA_ORDER_EMAILS_TO != '') {
				tep_mail('', SEND_EXTRA_ORDER_EMAILS_TO, EMAIL_TEXT_SUBJECT, $email_order, STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);
			} 

// load the after_process function from the payment modules
  $payment_modules->after_process();

			$cart->reset(true); 

			// unregister session variables used during checkout
			tep_session_unregister('sendto');
			tep_session_unregister('billto');
			tep_session_unregister('shipping');
			tep_session_unregister('payment');
			tep_session_unregister('comments'); 
// ________________________________________________________________________________________________________________
// on enregistre la valeur de la derniere commande
$order_id = $insert_id;
tep_session_register('order_id');
tep_db_perform('cmcic_reference', array('order_id' => $order_id), 'update', "ref_number='". $RequestVars['reference']."'");

			// traitement termin, on envoi l'accus
			$payment_modules->sendAR("Valid");
			break;
		default:
			$payment_modules->sendAR("NotValid");
	} // switch 
	// remplacement de application bottom
	// close session (store variables)
	tep_session_close();
} 

?>