<?php

#################################################################
#  $Id: rss-news.php,v 1.0 2004/03/22 12:00:00 phv Exp $        #
#  osCommerce, Open Source E-Commerce Solutions                 #
#  http://www.oscommerce.com                                    #
#  Copyright (c) 2004 Tom Nitzschner (http://www.toms-home.com) #
#  Released under the GNU General Public License                #
#################################################################

#######################################################################
# This rss news feed cript gets a defined count of new items from the #
# system database and displays them to the rss news reader software.  #
# The only items you should have to edit are the system values right  #
# below this block.                                                   #
#######################################################################

################################
# Edit these to suit your site #
################################

$Title = "ThailandWholesales"; //Enter an appropriate title for your website
$SiteLink = "http://www.thailandwholesales.com"; //Enter your main shopping cart link
$Description = "Bringing wholesale products at factory direct prices to you."; //Enter a description of your site
#$blank_image = ""; //Enter name of your place holder (blank) image - leace at '' if no image is used
$product_count = 11;
$email="info@hototem.com";
$date = date('r');

##################
# End of editing #
##################

###########################################
# Start to generate the xml/rss feed page #
###########################################

header("Content-Type: text/xml");
echo "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
echo "<rss version=\"2.0\">\n";
require('includes/application_top.php');
echo "<channel>\n";
echo "<title>$Title</title>\n";
echo "<link>$SiteLink</link>\n";
echo "<description>$Description</description>\n";
echo "<language>en-us</language>\n";
echo "<pubDate>$date</pubDate>\n";
echo "<lastBuildDate>$date</lastBuildDate>\n";
echo "<docs>http://www.petefreitag.com/item/465.cfm</docs>\n";
echo "<generator>PHP Script</generator>\n";
echo "<managingEditor>$email </managingEditor>\n";
echo "<webMaster>$email </webMaster>\n";

###########################################
# SQL to select the required product rows #
###########################################
$count = 0;
$query="select p.products_id, p.products_image, p.products_tax_class_id, p.products_price, p.products_date_added, pd.products_description from " . TABLE_PRODUCTS . " as p, " . TABLE_PRODUCTS_DESCRIPTION . " as pd where pd.language_id='1' and p.products_id=pd.products_id and p.products_status='1' and p.products_image!='$blank_image' order by p.products_date_added desc limit $product_count";
$product_query = tep_db_query($query);
$num_rows = tep_db_num_rows($product_query);
if ($num_rows < $product_count) {
    $product_count = $num_rows;
}
#####################################
# Loop to get the required products #
#####################################
while ($count < $product_count) {
    tep_db_data_seek($product_query, $count);
    $next_product = tep_db_fetch_array($product_query);
    $next_product['products_name'] = tep_get_products_name($next_product['products_id']);
    $next_product['specials_new_products_price'] = tep_get_products_special_price($next_product['products_id']);
    if (tep_not_null($next_product['specials_new_products_price'])) {
	$price = $currencies->display_price($next_product['specials_new_products_price'], tep_get_tax_rate($next_product['products_tax_class_id']));
    } else {
        $price = $currencies->display_price($next_product['products_price'], tep_get_tax_rate($next_product['products_tax_class_id']));
    }
    $link = HTTP_SERVER . DIR_WS_CATALOG;
    $link .= "product_info.php?products_id=" . $next_product['products_id'];
    $linkimage = HTTP_SERVER . DIR_WS_CATALOG .DIR_WS_IMAGES;
    $linkimage .= $next_product['products_image'];
//    $pd = str_replace("<", "&lt;", $next_product['products_description']);
//    $pd = str_replace(">", "&gt;", $pd);
//    $pd = strip_tags($pd);
	$pd = strip_tags($next_product['products_description']);
    $pd = substr($pd, 0, 300);
    echo "<item>\n";
    echo "<title>".$next_product['products_name']."</title>\n";
    echo "<link>$link</link>\n";
    echo "<guid>$link</guid>\n";
    echo "<description>&lt;a href=\"$link\"&gt;&lt;img src=\"$linkimage\" alt=\"".$next_product['products_name']."\" title=\"".$next_product['products_name']."\" width=\"50\" height=\"50\"&gt;&lt;/a&gt;" . $pd ."... &lt;br&gt;Item Price: $price</description>\n";
    echo "</item>\n";
    $count++;
}
###################################################
# Finished looping, now close of the xml/rss page #
###################################################
echo "</channel>\n";
echo "</rss>";
?>
