<?php
/* 
	French Chronopost Shipping module v.20060820 by Philippe BLAIN <pblain@free.fr>.
	This module has been adapted to fit in the osCommerce 2.2 MS2-051113.
	
	Based on the "zones" shipping module.
	Credits go to the original developpers on www.oscommerce-fr.info :
			# titep and Benot ESTRADE (v1.0 - 20020401).
			# Thenab (Update v2.1 - 20060413).

	
   TARIFS MARCHANDISES CHRONOPOST_RC POINTS DE VENTE
   AU 10 JUILLET 2006, EN EUROS HT, AU DEPART DE FRANCE METROPOLITAINE ET MONACO.
   
   Toutes les zones Chronopost ont t implmentes. Pas de limite programme sur le poids.
   
   Les colis confis doivent correspondre aux normes suivantes :
		Poids : infrieur ou gal  30 kg.
		Dimensions minimales : 22,9 cm x 16,2 cm
		Dimensions maximales : la somme de la longueur + 2 hauteurs + 2 largeurs ne doit pas excder 300 cm,
		                                 la longueur ne devant pas excder 150 cm.

  USAGE :
  Le module Chronopost est prconfigur pour des Kgs et des EUROS.
  Vrifiez que c'est le cas dans la configuration de votre boutique, sinon vous devrez transformer ici
  tous les tarifs et poids dans vos units.
  
  Aprs copie des fichiers dans leur bon rpertoire; pour installer le module,
  allez dans l'admin d'OSC, cliquez sur le menu 'Modules', puis sur 'Expdition'.
  Tous les modules d'expdition devraient apparaitre.
  Slectionnez 'Chronopost International' et cliquez sur le bouton vert 'Installer'.
  La configuration du module doit appaitre,  droite. Cliquez sur 'Editer'.
  
  VEUILLEZ NOTER QUE VOUS PERDREZ VOS PARAMETRES EVENTUELLEMENT SAISIS
  SI VOUS DESINTALLEZ CE MODULE.
  Prvoyez une sauvegarde de votre base de donnes avant toute modification.
  
  Pour activer cette mthode d'expdition, vrifiez que 'Module Chronopost activ' est 'True'.
  Pour la dsactiver, positionnez sur 'False', puis 'Mise  jour'.

  Les zones Chronopost sont prconfigures et comprennent les codes ISO (2 lettres majuscules)
  des pays appartenant  telle zone, spars par une virgule (sans espace ou autre caractre de ponctuation).
  Vous pouvez modifier ces listes  votre guise pour restreindre les pays d'expdition (conseill).
  Pour la plupart des boutiques, vous n'entrerez pas la totalit des pays en raison de fraude de certains endroits.
  Un message indiquant l'impossibilit de livrer avec cette mthode s'affichera pour une commande  destination
  d'un pays non list.
  
  Pour chaque zone Chronopost, il y a un tarif d'expdition et un supplment correspondant.
  Vous pouvez mettre  jour ces tarifs/supplments.
  Les tarifs fonctionnent sur le principe de tranches 'poids:cout' spars par une virgule.
  
  Si vous souhaitez avoir une tranche de 0  3 Kgs qui coutera 5.50 EUR HT d'expdition, vous devez la dfinir comme ceci : 3:5.5
  
  Exemple : tarif EUR HT vers Zone X pour des colis pesant entre 0 et 15 Kgs
    1:3.5,2:3.95,3:5.2,4:6.45,5:7.7,6:10.4,7:11.85,8:13.3,9:14.75,10:16.2,11:17.65,12:19.1,13:20.55,14:22,15:23.45
 
  Pour chaque zone Chronopost, un supplment HT est utilis pour les colis dont le poids dpasse le maximum du tarif
  correspondant (par 0.5 ou 1 Kg supplmentaire).
  Il n'y a pas de limite dans le programme quand au poids maximum calcul mais la configuration de la boutique OsCommerce
  impose un poids maximum expdiable (Admin->Configuration->Expdition) au dela duquel les colis sont fractionns.
  Pour Chronopost, ce poids est de 30 Kgs.
  
  Si vous voulez ajouter des frais fixes aux commandes par Chronopost, remplissez le champ 'Frais fixes Chronopost'.
  
  Si vous voulez restreindre l'expdition  une zone de taxation, remplissez le champ 'Expdier seulement vers cette zone de taxe'.
  Le module vrifie alors que le code ISO du pays de livraison est dans cette zone de taxation existante, sinon cette mthode
  d'expdition n'apparait pas pour la commande. 
  
  AVERTISSEMENTS:
  Par dfaut, le module fonctionne avec 12 zones.
  Ceci peut tre facilement chang en modifiant la ligne suivante, dans le constructeur chronopost :
    $this->num_chronopost.
   
  Il s'avre que le systme d'expdition d'OSC arrondit automatiquement
  le poids d'expdition jusqu' l'unit entire la plus proche.
  Ceci rend plus difficile de concevoir des tables prcises d'expdition.
  Si vous le voulez, vous pouvez modifier "shipping.php" pour vous dbarasser de l'arrondi.
  
  Pour finir, sachez qu'il y a une limite  255 caractres dans la base de donnes pour vos paramtres de zones et de tarifs.
*/

//********************************************************************************************
  class chronopostrc1 {
    var $code, $title, $description, $sort_order, $icon, $tax_class, $enabled, $num_chronopost, $quotes;

	/* class constructor */
//********************************************************************************************
    function chronopostrc1() {
    	global $order;
    	
      $this->code         = 'chronopostrc1';

      $this->title           = MODULE_SHIPPING_CHRONOPOST_RC_TEXT_TITLE;
      $this->description = MODULE_SHIPPING_CHRONOPOST_RC_TEXT_DESCRIPTION;
      $this->sort_order  = MODULE_SHIPPING_CHRONOPOST_RC_SORT_ORDER;

  if (!tep_session_is_registered('customer_id')) {  //pas enregistr
      $this->icon           = DIR_WS_ICONS . 'chronorelais.jpg';
	}else
	     { // enregistr 
      $this->icon           = DIR_WS_ICONS . 'chronorelais_rc1.jpg';
		           }

      $this->title           = MODULE_SHIPPING_CHRONOPOST_RC_TEXT_TITLE;
      $this->tax_class    = MODULE_SHIPPING_CHRONOPOST_RC_TAX_CLASS;
      $this->enabled     = ((MODULE_SHIPPING_CHRONOPOST_RC_STATUS == 'True') ? true : false);
      /* CUSTOMIZE THE FOLLOWING SETTING WITH THE NUMBER OF ZONES */
      $this->num_chronopost = 12; /* Zone Domestique + 9 Zones + 2 Zones hors UE (4 et 7) */
    
   	/* Vrification que le pays de livraison est dans la zone de taxation restreinte, sinon le module se dsactive. */
      if ( ($this->enabled == true) && ((int)MODULE_SHIPPING_CHRONOPOST_RC_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_SHIPPING_CHRONOPOST_RC_ZONE . "' and zone_country_id = '" . $order->delivery['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->delivery['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }
//********************************************************************************************
	function quote() {
      global $order, $shipping_weight, $shipping_num_boxes;

      $this->quotes = array('id' => $this->code,
                            'module' => MODULE_SHIPPING_CHRONOPOST_RC_TEXT_TITLE,
                            'methods' => array());

      if (tep_not_null($this->icon))	$this->quotes['icon'] = tep_image($this->icon, $this->title);

    	/* Recherche zone Chronopost du pays de destination */
      $dest_country = $order->delivery['country']['iso_code_2'];
      $dest_zone = 0;
//      for ($i = 1; $i <= $this->num_chronopost; $i ++) {
//				$countries_table = constant('MODULE_SHIPPING_CHRONOPOST_RC_COUNTRIES_' . $i);
				$countries_table = constant('MODULE_SHIPPING_CHRONOPOST_RC_COUNTRIES_1');
				$iso_codes_array = split("[,]", $countries_table);
//				if (in_array($dest_country, $iso_codes_array)) {
//	  				$dest_zone = $i;
	  				$dest_zone = 1;
//	  				break;
//				}
 //     }

      if (($dest_country != 'FR') && ($dest_country != 'FX')) {
	  				$dest_zone = 0;
      }

      if ($dest_zone == 0) {
				$this->quotes['error'] = MODULE_SHIPPING_CHRONOPOST_RC_INVALID_ZONE;
				return $this->quotes;
      }
       if ($dest_zone==1 && (substr($order->delivery['postcode'],0,3) =='971' || 
							substr($order->delivery['postcode'],0,3) =='972'||
							substr($order->delivery['postcode'],0,3) =='973'||
							substr($order->delivery['postcode'],0,3) =='974'||
							substr($order->delivery['postcode'],0,3) =='975'||
							substr($order->delivery['postcode'],0,3) =='976')) {
				$this->quotes['error'] = MODULE_SHIPPING_CHRONOPOST_RC2_UNDEFINED_RATE;
				return $this->quotes;
      }


      if ($dest_zone==1 && (substr($order->delivery['postcode'],0,3) =='984' || 
							substr($order->delivery['postcode'],0,3) =='986'||
							substr($order->delivery['postcode'],0,3) =='987'||
							substr($order->delivery['postcode'],0,3) =='988')) {
				$this->quotes['error'] = MODULE_SHIPPING_CHRONOPOST_RC2_UNDEFINED_RATE;
				return $this->quotes;
      }
  		/* Calcul du cout d'1 colis (voir colis fractionns dans la classe 'shipping') */
      $table = split("[:,]", constant('MODULE_SHIPPING_CHRONOPOST_RC_COST_' . $dest_zone));
      $n = count($table);
      $cost = -1;
      /* Tarif spcial CORSE +15 EUR HT*/
      $sup_corse = 12;
      
      /* Comparaison du poids d'1 colis avec le max dans table */
		if ($shipping_weight > $table[$n-2]) { /* Supplment */
       	if ($dest_zone == 1) /* Zone Domestique */
       		$weight_sup = ceil($shipping_weight - $table[$n-2]);
       	else /* Autres zones */
         	$weight_sup = ceil(($shipping_weight - $table[$n-2]) * 2);
     	
         $cost = $table[$n-1];
 	  		if ($dest_zone==1 && (substr($order->delivery['postcode'],0,2) =='2A' || substr($order->delivery['postcode'],0,2) =='2B'|| substr($order->delivery['postcode'],0,2) =='20'))
	  			$cost += $sup_corse;
	  		$cost += $weight_sup * constant('MODULE_SHIPPING_CHRONOPOST_RC_SUPPLEMENT_' . $dest_zone);
         $cost += MODULE_SHIPPING_CHRONOPOST_RC_HANDLING + SHIPPING_HANDLING;
         
      }
      else { /* Dans la table tarifs */
      	for ($i = 0; $i < $n; $i+=2) {
				if ($shipping_weight <= $table[$i]) {
	  				$cost = $table[$i+1];
	  				if ($dest_zone==1 && (substr($order->delivery['postcode'],0,2) =='2A' || substr($order->delivery['postcode'],0,2) =='2B'|| substr($order->delivery['postcode'],0,2) =='20'))
	  					$cost += $sup_corse;
	  				$cost += MODULE_SHIPPING_CHRONOPOST_RC_HANDLING + SHIPPING_HANDLING;
	  				break;
				}
      	}
      }
      			
      if ($cost == -1) { /* Tarif n'existe pas */
				$this->quotes['error'] = MODULE_SHIPPING_CHRONOPOST_RC_UNDEFINED_RATE;
				return $this->quotes;
      }
      /* Cout de tous les colis */
      $cost *= $shipping_num_boxes;
//////////////////////////////////
// faire la collecte des parametres relais colis Adresse 1 la plus proche

	$tab_rc=0; // cette valeur fixe le point relais colis des  5 propositions 0=1 , 1=2  ect.. jusqua a 5

	


	// UPLOADER LA LIBRAIRIE NUSOAP DANS UN DOSSIER DE VOTRE SERVEUR : ICI ./libs/
	// CHARGEMENT DE LA LIBRAIRIE NUSOAP
	require_once('./libs/nusoap/nusoap.php');

	// ADRESSE DU WSDL DU WEBSERVICE
	$wsdl = "http://wsshipping.chronopost.fr/soap.point.relais/services/ServiceRechercheBt?wsdl";

	// APPEL DE LA FONCTION CONSTRUCTEUR DE L'OBJET CLIENT SOAP
	$client = new soapclient($wsdl, 'wsdl');

	// CHECK DES ERREURS A L'APPEL DU CONSTRUCTEUR
	$err = $client->getError();
	if ($err) echo "<h2>Erreur constructeur :</h2><pre>".$err."</pre>";

	// LISTING DES PARAMETRES NECESSAIRES A L'APPEL SOAP DANS UN TABLEAU

    $date_rc=date("Y-m-d\TH:i:s");

	$parametres = array('codePostal' => $order->delivery['postcode'],'date' => $date_rc);

	// RECUPERATION DES RESULTATS ATTENDUS DU SERVICE APPELE
	$result = $client->call('rechercheBtParCodeproduitEtCodepostalEtDate', $parametres);

	// ERREUR DANS L'APPEL DU SERVICE WEB
	if ($client->fault) {

		$relais_colis="Erreur dans appel du service web chronorelais indisponible";
	}
	else {
		$err = $client->getError();
		// SI ON A UNE ERREUR DE RETOUR DE DONNEES DU SERVICE WEB
		if ($err) {

		$relais_colis= "Erreur de retour de donnes chronorelais :".$err ;
         }
		// SI TOUT VA BIEN ON RECUPERE LES DONNEES DANS LE TABLEAU $result
		else {

            $h_lundi = $result[$tab_rc][horairesOuvertureLundi];
			$h_lundi = ereg_replace("00:00-00:00 00:00-00:00","Ferm",$h_lundi);
			$h_lundi = ereg_replace("-12:00 12:00","",$h_lundi);
			$h_lundi = ereg_replace(" 00:00-00:00","",$h_lundi);
			$h_lundi = ereg_replace("00:00-00:00 ","",$h_lundi);


            $h_mardi = $result[$tab_rc][horairesOuvertureMardi];
			$h_mardi = ereg_replace("00:00-00:00 00:00-00:00","Ferm",$h_mardi);
			$h_mardi = ereg_replace("-12:00 12:00","",$h_mardi);
			$h_mardi = ereg_replace(" 00:00-00:00","",$h_mardi);
			$h_mardi = ereg_replace("00:00-00:00 ","",$h_mardi);

            $h_mercredi = $result[$tab_rc][horairesOuvertureMercredi];
			$h_mercredi = ereg_replace("00:00-00:00 00:00-00:00","Ferm",$h_mercredi);
			$h_mercredi = ereg_replace("-12:00 12:00","",$h_mercredi);
			$h_mercredi = ereg_replace(" 00:00-00:00","",$h_mercredi);
			$h_mercredi = ereg_replace("00:00-00:00 ","",$h_mercredi);

            $h_jeudi = $result[$tab_rc][horairesOuvertureJeudi];
			$h_jeudi = ereg_replace("00:00-00:00 00:00-00:00","Ferm",$h_jeudi);
			$h_jeudi = ereg_replace("-12:00 12:00","",$h_jeudi);
			$h_jeudi = ereg_replace(" 00:00-00:00","",$h_jeudi);
			$h_jeudi = ereg_replace("00:00-00:00 ","",$h_jeudi);

            $h_vendredi = $result[$tab_rc][horairesOuvertureVendredi];
			$h_vendredi = ereg_replace("00:00-00:00 00:00-00:00","Ferm",$h_vendredi);
			$h_vendredi = ereg_replace("-12:00 12:00","",$h_vendredi);
			$h_vendredi = ereg_replace(" 00:00-00:00","",$h_vendredi);
			$h_vendredi = ereg_replace("00:00-00:00 ","",$h_vendredi);

            $h_samedi = $result[$tab_rc][horairesOuvertureSamedi];
			$h_samedi = ereg_replace("00:00-00:00 00:00-00:00","Ferm",$h_samedi);
			$h_samedi = ereg_replace("-12:00 12:00","",$h_samedi);
			$h_samedi = ereg_replace(" 00:00-00:00","",$h_samedi);
			$h_samedi = ereg_replace("00:00-00:00 ","",$h_samedi);

            $h_dimanche = $result[$tab_rc][horairesOuvertureDimanche];
			$h_dimanche = ereg_replace("00:00-00:00 00:00-00:00","Ferm",$h_dimanche);
			$h_dimanche = ereg_replace("-12:00 12:00","",$h_dimanche);
			$h_dimanche = ereg_replace(" 00:00-00:00","",$h_dimanche);
			$h_dimanche = ereg_replace("00:00-00:00 ","",$h_dimanche);

         $relais_colis=
			'<table  style="border:1px;border-style:solid;border-color:#d6d6d6;text-align:left;color:#e07016;font-size:10px;"><tr><td>
			Code du point Chrono Relais :<span style="text-align:left;color:#e07016;font-size:12px;"><b>'. $result[$tab_rc][identifiantChronopostPointA2PAS] .'</b></td></tr>'.
		'<tr><td>'.$result[$tab_rc][nomEnseigne] .'</td></tr>'.
		'<tr><td>'.$result[$tab_rc][adresse1] .'</td></tr>'.
		'<tr><td>'.$result[$tab_rc][adresse2] .'</td></tr>'.
		'<tr><td>'.$result[$tab_rc][adresse3] .'</td></tr>'.
		'<tr><td>'.$result[$tab_rc][codePostal] .'&#155;'.
			$result[$tab_rc][localite] .'</td></tr>'.
'</table>'.

			'<a href="/shopping_cart.php" class="tt"><font size="2">Horaires du point Relais</font><span class="tooltip"><span class="top"></span><span class="middle"><table style="border:1px;border-style:solid;border-color:#d6d6d6;text-align:left;color:#e07016;font-size:10px;">'.
		'<tr><td>	Lundi :</td><td>'.$h_lundi .'</td></tr>'.
		'<tr><td>	Mardi :</td><td>'.$h_mardi .'</td></tr>'.
		'<tr><td>	Mercredi :</td><td>'.$h_mercredi .'</td></tr>'.
		'<tr><td>	Jeudi :</td><td>'.$h_jeudi .'</td></tr>'.
		'<tr><td>	Vendredi :</td><td>'.$h_vendredi .'</td></tr>'.
		'<tr><td>	Samedi :</td><td>'.$h_samedi .'</td></tr>'.
		'<tr><td>	Dimanche :</td><td>'.$h_dimanche .'</td></tr>'.

  '</table></span><span class="bottom"></span></span></a> '; 


		}
	}

/*        $relais_colis=
			'<span style="text-align:left;color:#e07016;font-size:10px;">
			Code du point Chrono Relais :<b>'. $result[$tab_rc][identifiantChronopostPointA2PAS] .'</b></br>'.
			$result[$tab_rc][nomEnseigne] .'</br>'.
			$result[$tab_rc][adresse1] .'</br>'.
			$result[$tab_rc][adresse2] .'</br>'.
			$result[$tab_rc][adresse3] .'</br>'.
			$result[$tab_rc][codePostal] .'  '.
		 	$result[$tab_rc][localite] .'</br>'.
'</span><br>'.

			'<span style="text-align:left;color:#e07016;font-size:10px;">Horaires</br>'.
'	Lundi :		'. $h_lundi .'</br>'.
'	Mardi :		'. $h_mardi .'</br>'.
'	Mercredi :	'. $h_mercredi .'</br>'.
'	Jeudi :		'. $h_jeudi .'</br>'.
'	Vendredi :	'. $h_vendredi .'</br>'.
'	Samedi :	'. $h_samedi .'</br>'.
'	Dimanche :	'. $h_dimanche .'</br>'.

'</span>'; 


		}
	}*/



  if (!tep_session_is_registered('customer_id')) {  //pas enregistr
              $relais_colis="";
	}else
	     { // enregistr 

		           }


////////////////////////
		/* Stockage paramtres */
      $this->quotes['methods'][] = array(
			'id'    => $this->code,
			'title' => $shipping_num_boxes . ' x ' . $shipping_weight . MODULE_SHIPPING_CHRONOPOST_RC_TEXT_UNITS . $order->delivery['country']['title'] . '<br>' .$relais_colis ,
			'cost'  => $cost); 

		/* Returns the tax rate for a zone / class -  TABLES: tax_rates, zones_to_geo_zones */
		if ($this->tax_class > 0)
			$this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
       
		return $this->quotes;
    }
//********************************************************************************************
    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_CHRONOPOST_RC_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
    }
//********************************************************************************************
    function install() {
         	
    	/*Activation du module Chronopost */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Module ChronoRelais activ ?', 'MODULE_SHIPPING_CHRONOPOST_RC_STATUS', 'True', 'Voulez-vous activer l\'expdition par ChronoRelais ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

      /* Ajouter des frais fixes HT ? */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Frais fixes ChronoRelais', 'MODULE_SHIPPING_CHRONOPOST_RC_HANDLING', '0', 'Les frais fixes HT d\'expdition par ChronoRelais (emballage, ...)', '6', '0', now())");
      
        /* Appliquer une classe de taxe ? */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Classe de Taxe', 'MODULE_SHIPPING_CHRONOPOST_RC_TAX_CLASS', '0', 'Indiquez la classe de taxe pour ce service de livraison.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");

      /* Expdier seulement vers une zone de taxe ? */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Expdier seulement vers cette zone de taxe', 'MODULE_SHIPPING_CHRONOPOST_RC_ZONE', '0', 'Si une zone de taxe est slectionne, ce mode de livraison fonctionnera uniquement pour la zone choisie.', '6', '0', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
      
      /* Ordre d'affichage */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordre de Tri', 'MODULE_SHIPPING_CHRONOPOST_RC_SORT_ORDER', '0', 'Ordre de tri pour l\'affichage.', '6', '0', now())");
      
      /* DEFINITIONS DES ZONES CHRONOPOST_RC */
 
      /* Zone tarifaire Domestique (ie France et France mtropolitaine FR et FX) */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone Domestique - Pays', 'MODULE_SHIPPING_CHRONOPOST_RC_COUNTRIES_1', 'FR,FX', 'Codes ISO des pays de cette zone, spars par une virgule.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone Domestique - [Poids:Tarif]', 'MODULE_SHIPPING_CHRONOPOST_RC_COST_1', '2:27.42,5:32.88,10:41.88,15:50.94,20:59.99,25:69.05,30:78.10', 'Table des tarifs vers la Zone Domestique.', '6', '0', now())");
tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone Domestique - Supplment au del', 'MODULE_SHIPPING_CHRONOPOST_RC_SUPPLEMENT_1', '2.15', 'Supplment HT pour 1 kg.', '6', '0', now())");
 
  
/* changement du type titre dans la table orders_total ALTER TABLE Nom_de_la_table MODIFY Nom_de_la_colonne type_de_donnees*/

    		$query = sprintf("ALTER TABLE orders_total WHERE MODIFY title text");


   }
//********************************************************************************************
	function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }
//********************************************************************************************
	function keys() {
      $keys = array(
		    'MODULE_SHIPPING_CHRONOPOST_RC_STATUS',
		    'MODULE_SHIPPING_CHRONOPOST_RC_HANDLING',
		    'MODULE_SHIPPING_CHRONOPOST_RC_TAX_CLASS',
		     'MODULE_SHIPPING_CHRONOPOST_RC_ZONE',
		     'MODULE_SHIPPING_CHRONOPOST_RC_SORT_ORDER'
		    );
      for ($i = 1; $i <= $this->num_chronopost; $i ++) {
        $keys[count($keys)] = 'MODULE_SHIPPING_CHRONOPOST_RC_COUNTRIES_' . $i;
        $keys[count($keys)] = 'MODULE_SHIPPING_CHRONOPOST_RC_COST_' . $i;
        $keys[count($keys)] = 'MODULE_SHIPPING_CHRONOPOST_RC_SUPPLEMENT_' . $i;
      }
      return $keys;
	}
}
?>
