<?php
/* 
	French Chronopost Shipping module v.20060820 by Philippe BLAIN <pblain@free.fr>.
	This module has been adapted to fit in the osCommerce 2.2 MS2-051113.
	
	Based on the "zones" shipping module.
	Credits go to the original developpers on www.oscommerce-fr.info :
			# titep and Benot ESTRADE (v1.0 - 20020401).
			# Thenab (Update v2.1 - 20060413).

	
   TARIFS MARCHANDISES CHRONOPOST POINTS DE VENTE
   AU 10 JUILLET 2006, EN EUROS HT, AU DEPART DE FRANCE METROPOLITAINE ET MONACO.
   
   Toutes les zones Chronopost ont t implmentes. Pas de limite programme sur le poids.
   
   Les colis confis doivent correspondre aux normes suivantes :
		Poids : infrieur ou gal  30 kg.
		Dimensions minimales : 22,9 cm x 16,2 cm
		Dimensions maximales : la somme de la longueur + 2 hauteurs + 2 largeurs ne doit pas excder 300 cm,
		                                 la longueur ne devant pas excder 150 cm.

  USAGE :
  Le module Chronopost est prconfigur pour des Kgs et des EUROS.
  Vrifiez que c'est le cas dans la configuration de votre boutique, sinon vous devrez transformer ici
  tous les tarifs et poids dans vos units.
  
  Aprs copie des fichiers dans leur bon rpertoire; pour installer le module,
  allez dans l'admin d'OSC, cliquez sur le menu 'Modules', puis sur 'Expdition'.
  Tous les modules d'expdition devraient apparaitre.
  Slectionnez 'Chronopost International' et cliquez sur le bouton vert 'Installer'.
  La configuration du module doit appaitre,  droite. Cliquez sur 'Editer'.
  
  VEUILLEZ NOTER QUE VOUS PERDREZ VOS PARAMETRES EVENTUELLEMENT SAISIS
  SI VOUS DESINTALLEZ CE MODULE.
  Prvoyez une sauvegarde de votre base de donnes avant toute modification.
  
  Pour activer cette mthode d'expdition, vrifiez que 'Module Chronopost activ' est 'True'.
  Pour la dsactiver, positionnez sur 'False', puis 'Mise  jour'.

  Les zones Chronopost sont prconfigures et comprennent les codes ISO (2 lettres majuscules)
  des pays appartenant  telle zone, spars par une virgule (sans espace ou autre caractre de ponctuation).
  Vous pouvez modifier ces listes  votre guise pour restreindre les pays d'expdition (conseill).
  Pour la plupart des boutiques, vous n'entrerez pas la totalit des pays en raison de fraude de certains endroits.
  Un message indiquant l'impossibilit de livrer avec cette mthode s'affichera pour une commande  destination
  d'un pays non list.
  
  Pour chaque zone Chronopost, il y a un tarif d'expdition et un supplment correspondant.
  Vous pouvez mettre  jour ces tarifs/supplments.
  Les tarifs fonctionnent sur le principe de tranches 'poids:cout' spars par une virgule.
  
  Si vous souhaitez avoir une tranche de 0  3 Kgs qui coutera 5.50 EUR HT d'expdition, vous devez la dfinir comme ceci : 3:5.5
  
  Exemple : tarif EUR HT vers Zone X pour des colis pesant entre 0 et 15 Kgs
    1:3.5,2:3.95,3:5.2,4:6.45,5:7.7,6:10.4,7:11.85,8:13.3,9:14.75,10:16.2,11:17.65,12:19.1,13:20.55,14:22,15:23.45
 
  Pour chaque zone Chronopost, un supplment HT est utilis pour les colis dont le poids dpasse le maximum du tarif
  correspondant (par 0.5 ou 1 Kg supplmentaire).
  Il n'y a pas de limite dans le programme quand au poids maximum calcul mais la configuration de la boutique OsCommerce
  impose un poids maximum expdiable (Admin->Configuration->Expdition) au dela duquel les colis sont fractionns.
  Pour Chronopost, ce poids est de 30 Kgs.
  
  Si vous voulez ajouter des frais fixes aux commandes par Chronopost, remplissez le champ 'Frais fixes Chronopost'.
  
  Si vous voulez restreindre l'expdition  une zone de taxation, remplissez le champ 'Expdier seulement vers cette zone de taxe'.
  Le module vrifie alors que le code ISO du pays de livraison est dans cette zone de taxation existante, sinon cette mthode
  d'expdition n'apparait pas pour la commande. 
  
  AVERTISSEMENTS:
  Par dfaut, le module fonctionne avec 12 zones.
  Ceci peut tre facilement chang en modifiant la ligne suivante, dans le constructeur chronopost :
    $this->num_chronopost.
   
  Il s'avre que le systme d'expdition d'OSC arrondit automatiquement
  le poids d'expdition jusqu' l'unit entire la plus proche.
  Ceci rend plus difficile de concevoir des tables prcises d'expdition.
  Si vous le voulez, vous pouvez modifier "shipping.php" pour vous dbarasser de l'arrondi.
  
  Pour finir, sachez qu'il y a une limite  255 caractres dans la base de donnes pour vos paramtres de zones et de tarifs.
*/

  class chronopost {
    var $code, $title, $description, $sort_order, $icon, $tax_class, $enabled, $num_chronopost, $quotes;

	/* class constructor */
    function chronopost() {
    	global $order;
    	
      $this->code         = 'chronopost';
      $this->title           = MODULE_SHIPPING_CHRONOPOST_TEXT_TITLE;
      $this->description = MODULE_SHIPPING_CHRONOPOST_TEXT_DESCRIPTION;
      $this->sort_order  = MODULE_SHIPPING_CHRONOPOST_SORT_ORDER;
      $this->icon           = DIR_WS_ICONS . 'shipping_chronopost.gif';
      $this->tax_class    = MODULE_SHIPPING_CHRONOPOST_TAX_CLASS;
      $this->enabled     = ((MODULE_SHIPPING_CHRONOPOST_STATUS == 'True') ? true : false);
      /* CUSTOMIZE THE FOLLOWING SETTING WITH THE NUMBER OF ZONES */
      $this->num_chronopost = 12; /* Zone Domestique + 9 Zones + 2 Zones hors UE (4 et 7) */
    
   	/* Vrification que le pays de livraison est dans la zone de taxation restreinte, sinon le module se dsactive. */
      if ( ($this->enabled == true) && ((int)MODULE_SHIPPING_CHRONOPOST_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_SHIPPING_CHRONOPOST_ZONE . "' and zone_country_id = '" . $order->delivery['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->delivery['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }

	function quote() {
      global $order, $shipping_weight, $shipping_num_boxes;

      $this->quotes = array('id' => $this->code,
                            'module' => MODULE_SHIPPING_CHRONOPOST_TEXT_TITLE,
                            'methods' => array());

      if (tep_not_null($this->icon))	$this->quotes['icon'] = tep_image($this->icon, $this->title);

    	/* Recherche zone Chronopost du pays de destination */
      $dest_country = $order->delivery['country']['iso_code_2'];
      $dest_zone = 0;
      for ($i = 1; $i <= $this->num_chronopost; $i ++) {
				$countries_table = constant('MODULE_SHIPPING_CHRONOPOST_COUNTRIES_' . $i);
				$iso_codes_array = split("[,]", $countries_table);
				if (in_array($dest_country, $iso_codes_array)) {
	  				$dest_zone = $i;
	  				break;
				}
      }

      if (($dest_country != 'FR') && ($dest_country != 'FX') && ($dest_country != 'MC')) {
	  				$dest_zone = 0;
      }

      if ($dest_zone == 0) {
				$this->quotes['error'] = MODULE_SHIPPING_CHRONOPOST_INVALID_ZONE;
				return $this->quotes;
      }
       if ($dest_zone==1 && (substr($order->delivery['postcode'],0,3) =='971' || 
							substr($order->delivery['postcode'],0,3) =='972'||
							substr($order->delivery['postcode'],0,3) =='973'||
							substr($order->delivery['postcode'],0,3) =='974'||
							substr($order->delivery['postcode'],0,3) =='975'||
							substr($order->delivery['postcode'],0,3) =='976')) {
				$this->quotes['error'] = MODULE_SHIPPING_CHRONOPOST_RC2_UNDEFINED_RATE;
				return $this->quotes;
      }


      if ($dest_zone==1 && (substr($order->delivery['postcode'],0,3) =='984' || 
							substr($order->delivery['postcode'],0,3) =='986'||
							substr($order->delivery['postcode'],0,3) =='987'||
							substr($order->delivery['postcode'],0,3) =='988')) {
				$this->quotes['error'] = MODULE_SHIPPING_CHRONOPOST_RC2_UNDEFINED_RATE;
				return $this->quotes;
      } 
  		/* Calcul du cout d'1 colis (voir colis fractionns dans la classe 'shipping') */
      $table = split("[:,]", constant('MODULE_SHIPPING_CHRONOPOST_COST_' . $dest_zone));
      $n = count($table);
      $cost = -1;
      /* Tarif spcial CORSE +15 EUR HT*/
      $sup_corse = 12;
      
      /* Comparaison du poids d'1 colis avec le max dans table */
		if ($shipping_weight > $table[$n-2]) { /* Supplment */
       	if ($dest_zone == 1) /* Zone Domestique */
       		$weight_sup = ceil($shipping_weight - $table[$n-2]);
       	else /* Autres zones */
         	$weight_sup = ceil(($shipping_weight - $table[$n-2]) * 2);
     	
         $cost = $table[$n-1];
 	  		if ($dest_zone==1 && (substr($order->delivery['postcode'],0,2) =='2A' || substr($order->delivery['postcode'],0,2) =='2B'|| substr($order->delivery['postcode'],0,2) =='20'))
	  			$cost += $sup_corse;
	  		$cost += $weight_sup * constant('MODULE_SHIPPING_CHRONOPOST_SUPPLEMENT_' . $dest_zone);
         $cost += MODULE_SHIPPING_CHRONOPOST_HANDLING + SHIPPING_HANDLING;
         
      }
      else { /* Dans la table tarifs */
      	for ($i = 0; $i < $n; $i+=2) {
				if ($shipping_weight <= $table[$i]) {
	  				$cost = $table[$i+1];
	  				if ($dest_zone==1 && (substr($order->delivery['postcode'],0,2) =='2A' || substr($order->delivery['postcode'],0,2) =='2B'|| substr($order->delivery['postcode'],0,2) =='2B'|| substr($order->delivery['postcode'],0,2) =='20'))
	  					$cost += $sup_corse;
	  				$cost += MODULE_SHIPPING_CHRONOPOST_HANDLING + SHIPPING_HANDLING;
	  				break;
				}
      	}
      }
      			
      if ($cost == -1) { /* Tarif n'existe pas */
				$this->quotes['error'] = MODULE_SHIPPING_CHRONOPOST_UNDEFINED_RATE;
				return $this->quotes;
      }
      /* Cout de tous les colis */
      $cost *= $shipping_num_boxes;

		/* Stockage paramtres */
      $this->quotes['methods'][] = array(
			'id'    => $this->code,
			'title' => $shipping_num_boxes . ' x ' . $shipping_weight . MODULE_SHIPPING_CHRONOPOST_TEXT_UNITS . $order->delivery['country']['title'],
			'cost'  => $cost); 

		/* Returns the tax rate for a zone / class -  TABLES: tax_rates, zones_to_geo_zones */
		if ($this->tax_class > 0)
			$this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
       
		return $this->quotes;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_CHRONOPOST_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
         	
    	/*Activation du module Chronopost */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Module Chronopost activ ?', 'MODULE_SHIPPING_CHRONOPOST_STATUS', 'True', 'Voulez-vous activer l\'expdition par Chronopost ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

      /* Ajouter des frais fixes HT ? */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Frais fixes Chronopost', 'MODULE_SHIPPING_CHRONOPOST_HANDLING', '0', 'Les frais fixes HT d\'expdition par Chronopost (emballage, ...)', '6', '0', now())");
      
        /* Appliquer une classe de taxe ? */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Classe de Taxe', 'MODULE_SHIPPING_CHRONOPOST_TAX_CLASS', '0', 'Indiquez la classe de taxe pour ce service de livraison.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");

      /* Expdier seulement vers une zone de taxe ? */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Expdier seulement vers cette zone de taxe', 'MODULE_SHIPPING_CHRONOPOST_ZONE', '0', 'Si une zone de taxe est slectionne, ce mode de livraison fonctionnera uniquement pour la zone choisie.', '6', '0', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
      
      /* Ordre d'affichage */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordre de Tri', 'MODULE_SHIPPING_CHRONOPOST_SORT_ORDER', '0', 'Ordre de tri pour l\'affichage.', '6', '0', now())");
      
      /* DEFINITIONS DES ZONES CHRONOPOST */
 
      /* Zone tarifaire Domestique (ie France et France mtropolitaine FR et FX) */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone Domestique - Pays', 'MODULE_SHIPPING_CHRONOPOST_COUNTRIES_1', 'FR,FX', 'Codes ISO des pays de cette zone, spars par une virgule.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone Domestique - [Poids:Tarif]', 'MODULE_SHIPPING_CHRONOPOST_COST_1', '2:27.42,5:32.88,10:41.88,15:50.94,20:59.99,25:69.05,30:78.10', 'Table des tarifs vers la Zone Domestique.', '6', '0', now())");
tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone Domestique - Supplment au del', 'MODULE_SHIPPING_CHRONOPOST_SUPPLEMENT_1', '2.15', 'Supplment HT pour 1 kg.', '6', '0', now())");
 
      /* Zone tarifaire 1 (vers l'Union Europenne seulement) */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 1 - Pays', 'MODULE_SHIPPING_CHRONOPOST_COUNTRIES_2', 'BE,LU', 'Codes ISO des pays de cette zone, spars par une virgule.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 1 - [Poids:Tarif]', 'MODULE_SHIPPING_CHRONOPOST_COST_2', '0.5:36.75,1:47.46,1.5:58.17,2:68.88,2.5:79.59,3:90.30,3.5:93.34,4:96.38,4.5:99.42,5:102.46,5.5:105.50,6:108.54,6.5:111.58,7:114.62,7.5:117.66,8:120.70,8.5:123.74,9:126.78,9.5:129.82,10:132.86', 'Table des tarifs vers la Zone 1.', '6', '0', now())");
tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 1 - Supplment au del', 'MODULE_SHIPPING_CHRONOPOST_SUPPLEMENT_2', '2.67', 'Supplment HT pour 0.5 kg.', '6', '0', now())");

      /* Zone tarifaire 2 (vers l'Union Europenne seulement) */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 2 - Pays', 'MODULE_SHIPPING_CHRONOPOST_COUNTRIES_3', 'DE,ES,GB,IT,NL', 'Codes ISO des pays de cette zone, spars par une virgule.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 2 - [Poids:Tarif]', 'MODULE_SHIPPING_CHRONOPOST_COST_3', '0.5:37.80,1:48.85,1.5:59.90,2:70.95,2.5:82.00,3:93.05,3.5:96.19,4:99.33,4.5:102.47,5:105.61,5.5:108.75,6:111.89,6.5:115.03,7:118.17,7.5:121.31,8:124.45,8.5:127.59,9:130.73,9.5:133.87,10:137.01', 'Table des tarifs vers la Zone 2. ', '6', '0', now())");
tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 2 - Supplment au del', 'MODULE_SHIPPING_CHRONOPOST_SUPPLEMENT_3', '2.74', 'Supplment HT pour 0.5 kg.', '6', '0', now())");

      /* Zone tarifaire 3 (vers l'Union Europenne seulement) */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 3 - Pays', 'MODULE_SHIPPING_CHRONOPOST_COUNTRIES_4', 'AC,AT,DK,FI,GR,IE,ME,PT,SE', 'Codes ISO des pays de cette zone, spars par une virgule.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 3 - [Poids:Tarif]', 'MODULE_SHIPPING_CHRONOPOST_COST_4', '0.5:41.10,1:53.52,1.5:65.94,2:78.36,2.5:90.78,3:103.20,3.5:107.00,4:110.80,4.5:114.60,5:118.40,5.5:122.20,6:126.00,6.5:129.80,7:133.60,7.5:137.40,8:141.20,8.5:145.00,9:148.80,9.5:152.60,10:156.40', 'Table des tarifs vers la Zone 3. ', '6', '0', now())");
tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 3 - Supplment au del', 'MODULE_SHIPPING_CHRONOPOST_SUPPLEMENT_4', '3.33', 'Supplment HT pour 0.5 kg.', '6', '0', now())");

      /* Zone tarifaire 4 (vers l'Union Europenne) */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 4 dans Union Europenne - Pays', 'MODULE_SHIPPING_CHRONOPOST_COUNTRIES_5', 'AD,MT,PL', 'Codes ISO des pays de cette zone, spars par une virgule.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 4 dans Union Europenne - [Poids:Tarif]', 'MODULE_SHIPPING_CHRONOPOST_COST_5', '0.5:43.70,1:56.95,1.5:70.20,2:83.45,2.5:96.70,3:109.95,3.5:114.01,4:118.07,4.5:122.13,5:126.19,5.5:130.25,6:134.31,6.5:138.37,7:142.43,7.5:146.49,8:150.55,8.5:154.61,9:158.67,9.5:162.73,10:166.79', 'Table des tarifs vers la Zone 4 dans UE. ', '6', '0', now())");
tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 4 dans Union Europenne - Supplment au del', 'MODULE_SHIPPING_CHRONOPOST_SUPPLEMENT_5', '2.67', 'Supplment HT pour 0.5 kg.', '6', '0', now())");

			/* Zone tarifaire 4 (vers les pays hors Union Europenne) */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 4 hors Union Europenne - Pays', 'MODULE_SHIPPING_CHRONOPOST_COUNTRIES_6', 'IC,FO,GI,GS,IS,JE,LI,NO,SM,CH,TR,VA', 'Codes ISO des pays de cette zone, spars par une virgule.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 4 hors Union Europenne - [Poids:Tarif]', 'MODULE_SHIPPING_CHRONOPOST_COST_6', '0.5:50.00,1:63.25,1.5:76.50,2:89.75,2.5:103.00,3:116.25,3.5:120.31,4:124.37,4.5:128.43,5:132.49,5.5:136.55,6:140.61,6.5:144.67,7:148.73,7.5:152.79,8:156.85,8.5:160.91,9:164.97,9.5:169.03,10:173.09', 'Table des tarifs vers la Zone 4 hors UE. ', '6', '0', now())");
tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 4 hors Union Europenne - Supplment au del', 'MODULE_SHIPPING_CHRONOPOST_SUPPLEMENT_6', '3.69', 'Supplment HT pour 0.5 kg.', '6', '0', now())");

			/* Zone tarifaire 5 */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 5 - Pays', 'MODULE_SHIPPING_CHRONOPOST_COUNTRIES_7', 'CA,MX,US', 'Codes ISO des pays de cette zone, spars par une virgule.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 5 - [Poids:Tarif]', 'MODULE_SHIPPING_CHRONOPOST_COST_7', '0.5:58.40,1:71.79,1.5:85.18,2:98.57,2.5:111.96,3:125.35,3.5:129.88,4:134.41,4.5:138.94,5:143.47,5.5:148.00,6:152.53,6.5:157.06,7:161.59,7.5:166.12,8:170.65,8.5:175.18,9:179.71,9.5:184.24,10:188.77', 'Table des tarifs vers la Zone 5. ', '6', '0', now())");
tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 4 - Supplment au del', 'MODULE_SHIPPING_CHRONOPOST_SUPPLEMENT_7', '4.12', 'Supplment HT pour 0.5 kg.', '6', '0', now())");

      /* Zone tarifaire 6 */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 6 - Pays', 'MODULE_SHIPPING_CHRONOPOST_COUNTRIES_8', 'GP,MQ,RE', 'Codes ISO des pays de cette zone, spars par une virgule.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 6 - [Poids:Tarif]', 'MODULE_SHIPPING_CHRONOPOST_COST_8', '0.5:61.75,1:75.37,1.5:88.99,2:102.61,2.5:116.23,3:129.85,3.5:134.43,4:139.01,4.5:143.59,5:148.17,5.5:152.75,6:157.33,6.5:161.91,7:166.49,7.5:171.07,8:175.65,8.5:180.23,9:184.81,9.5:189.39,10:193.97', 'Table des tarifs vers la Zone 6. ', '6', '0', now())");
tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 6 - Supplment au del', 'MODULE_SHIPPING_CHRONOPOST_SUPPLEMENT_8', '4.44', 'Supplment HT pour 0.5 kg.', '6', '0', now())");

      /* Zone tarifaire 7 (vers l'Union Europenne) */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 7 dans Union Europenne - Pays', 'MODULE_SHIPPING_CHRONOPOST_COUNTRIES_9', 'EE,HU,LV,LT,SK,SI,CZ', 'Codes ISO des pays de cette zone, spars par une virgule.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 7 dans Union Europenne - [Poids:Tarif]', 'MODULE_SHIPPING_CHRONOPOST_COST_9', '0.5:64.20,1:81.20,1.5:98.20,2:115.20,2.5:132.20,3:149.20,3.5:159.61,4:170.02,4.5:180.43,5:190.84,5.5:201.25,6:211.66,6.5:222.07,7:232.48,7.5:242.89,8:253.30,8.5:263.71,9:274.12,9.5:284.53,10:294.94', 'Table des tarifs vers la Zone 7 dans UE. ', '6', '0', now())");
tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 7 dans Union Europenne - Supplment au del', 'MODULE_SHIPPING_CHRONOPOST_SUPPLEMENT_9', '8.89', 'Supplment HT pour 0.5 kg.', '6', '0', now())");

			/*Zone tarifaire 7 (vers les pays hors Union Europenne) */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 7 hors Union Europenne - Pays', 'MODULE_SHIPPING_CHRONOPOST_COUNTRIES_10', 'ZA,AL,SA,BH,BD,BA,BG,CM,CD,KR,CI,HR,AE,GA,HK,ID,JP,KW,LB,MK,MY,MA,MU,MD,OM,QA,RO,RU,SN,CS,SG,TW,TH,TN,UA', 'Codes ISO des pays de cette zone, spars par une virgule.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 7 hors Union Europenne - [Poids:Tarif]', 'MODULE_SHIPPING_CHRONOPOST_COST_10', '0.5:73.65,1:90.65,1.5:107.65,2:124.65,2.5:141.65,3:158.65,3.5:169.06,4:179.47,4.5:189.88,5:200.29,5.5:210.70,6:221.11,6.5:231.52,7:241.93,7.5:252.34,8:262.75,8.5:273.16,9:283.57,9.5:293.98,10:304.39', 'Table des tarifs vers la Zone 7 hors UE. ', '6', '0', now())");
tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 7 hors Union Europenne - Supplment au del', 'MODULE_SHIPPING_CHRONOPOST_SUPPLEMENT_10', '8.89', 'Supplment HT pour 0.5 kg.', '6', '0', now())");

			/*Zone tarifaire 8 */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 8 - Pays', 'MODULE_SHIPPING_CHRONOPOST_COUNTRIES_11', 'AG,AI,AM,AN,AR,AU,AW,AZ,BB,BF,BI,BJ,BM,BR,BS,CD,CF,CG,CN,CU,CV,DJ,DM,DO,DZ,EG,GD,GE,GF,GH,GL,GM,GN,GQ,GW,HT,IL,IN,JM,JO,KH,KM,KN,KY,LC,LK,MG,MI,ML,MO,MR,MS,NC,NE,NG,NZ,PF,PH,PK,PM,PR,SY,TC,TD,TG,TT,VC,VE,VG,VI,VN,YE,YT', 'Codes ISO des pays de cette zone, spars par une virgule.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 8 - [Poids:Tarif]', 'MODULE_SHIPPING_CHRONOPOST_COST_11', '0.5:83.70,1:104.32,1.5:124.94,2:145.56,2.5:166.18,3:186.80,3.5:204.18,4:221.56,4.5:238.94,5:256.32,5.5:273.70,6:291.08,6.5:308.46,7:325.84,7.5:343.22,8:360.60,8.5:377.98,9:395.36,9.5:412.74,10:430.12', 'Table des tarifs vers la Zone 8. ', '6', '0', now())");
tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 8 - Supplment au del', 'MODULE_SHIPPING_CHRONOPOST_SUPPLEMENT_11', '12.67', 'Supplment HT pour 0.5 kg.', '6', '0', now())");

      /* Zone tarifaire 9 */
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 9 - Pays', 'MODULE_SHIPPING_CHRONOPOST_COUNTRIES_12', 'AF,AO,AS,BD,BN,BO,BT,BW,BZ,CK,CL,CO,CR,EC,ER,ET,FJ,FM,GT,GU,GY,HN,IQ,IR,KE,KG,KI,KP,KZ,LA,LR,LS,LY,MH,MM,MN,MP,MV,MW,MZ,NA,NI,NP,NR,PA,PE,PG,PS,PW,PY,RW,SB,SC,SD,SL,SO,SR,ST,SV,SZ,TJ,TL,TM,TO,TV,TZ,UG,UY,UZ,VU,WF,WS,ZM,ZW', 'Codes ISO des pays de cette zone, spars par une virgule.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 9 - [Poids:Tarif]', 'MODULE_SHIPPING_CHRONOPOST_COST_12', '0.5:92.80,1:114.95,1.5:137.10,2:159.25,2.5:181.40,3:203.55,3.5:222.23,4:240.91,4.5:259.59,5:278.27,5.5:296.95,6:315.63,6.5:334.31,7:352.99,7.5:371.67,8:390.35,8.5:409.03,9:427.71,9.5:446.39,10:465.07', 'Table des tarifs vers la Zone 9. ', '6', '0', now())");
tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone 9 - Supplment au del', 'MODULE_SHIPPING_CHRONOPOST_SUPPLEMENT_12', '13.59', 'Supplment HT pour 0.5 kg.', '6', '0', now())");

   }

	function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

	function keys() {
      $keys = array(
		    'MODULE_SHIPPING_CHRONOPOST_STATUS',
		    'MODULE_SHIPPING_CHRONOPOST_HANDLING',
		    'MODULE_SHIPPING_CHRONOPOST_TAX_CLASS',
		     'MODULE_SHIPPING_CHRONOPOST_ZONE',
		     'MODULE_SHIPPING_CHRONOPOST_SORT_ORDER'
		    );
      for ($i = 1; $i <= $this->num_chronopost; $i ++) {
        $keys[count($keys)] = 'MODULE_SHIPPING_CHRONOPOST_COUNTRIES_' . $i;
        $keys[count($keys)] = 'MODULE_SHIPPING_CHRONOPOST_COST_' . $i;
        $keys[count($keys)] = 'MODULE_SHIPPING_CHRONOPOST_SUPPLEMENT_' . $i;
      }
      return $keys;
	}
}
?>
