<?php
/*
  $Id: cmcic.php,v 1.01 2004/03/04 19:57:15 Vilain Mamuth (vilain_mamuth@yahoo.com) Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2004 MaCCS - Body's Cult

  Released under the GNU General Public License
*/
function html_encode ($data)
	{
	    $SAFE_OUT_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890._-";
	    $encoded_data = "";
	    $result = "";
	    for ($i=0; $i<strlen($data); $i++)
	    {
	        if (strchr($SAFE_OUT_CHARS, $data{$i})) {
	            $result .= $data{$i};
	        }
	        else if (($var = bin2hex(substr($data,$i,1))) <= "7F"){
	            $result .= "&#x" . $var . ";";
	        }
	        else
	            $result .= $data{$i};
	            
	    }
	    return $result;
	}
	
	

class cmcic {
	var $code, $title, $description, $enabled; 
	// class constructor
	function cmcic()
	{
		global $order;

		$this->code = 'cmcic';
		$this->title = MODULE_PAYMENT_CMCIC_TEXT_TITLE;
		$this->description = MODULE_PAYMENT_CMCIC_TEXT_DESCRIPTION;
		$this->sort_order = MODULE_PAYMENT_CMCIC_SORT_ORDER;
		$this->enabled = ((MODULE_PAYMENT_CMCIC_STATUS == 'True') ? true : false);

		if ((int)MODULE_PAYMENT_CMCIC_ORDER_STATUS_ID > 0) {
			$this->order_status = MODULE_PAYMENT_CMCIC_ORDER_STATUS_ID;
		} 

		if (is_object($order)) $this->update_status();

//		$this->form_action_url = html_encode('https://ssl.paiement.cic-banques.fr/test/paiement.cgi');
		$this->form_action_url = html_encode('https://ssl.paiement.cic-banques.fr/paiement.cgi');


		$chemincle = "cmcic/".MODULE_PAYMENT_CMCIC_TPE.".cle.2nde";
   		//$this->cle = (file_exists($chemincle))? file_get_contents($chemincle): "";
   		if (file_exists($chemincle)) {
   			$this->cle = file_get_contents($chemincle);
   			if (substr($this->cle,0,2)=="0x"){
   				$this->cle = substr($this->cle,2);
   			}
   		}
   		
   				
   				
   			
	} 
	// class methods
	function update_status()
	{
		global $order;

		if (($this->enabled == true) && ((int)MODULE_PAYMENT_CMCIC_ZONE > 0)) {
			$check_flag = false;
			$check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_CMCIC_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
			while ($check = tep_db_fetch_array($check_query)) {
				if ($check['zone_id'] < 1) {
					$check_flag = true;
					break;
				} elseif ($check['zone_id'] == $order->billing['zone_id']) {
					$check_flag = true;
					break;
				} 
			} 

			if ($check_flag == false) {
				$this->enabled = false;
			} 
		} 
	} 

	function javascript_validation()
	{
		return false;
	} 

	function selection()
	{
		return array('id' => $this->code,
			'module' => $this->title . '<br>' . tep_image(DIR_WS_IMAGES . 'divers/cybermut.gif'));
	} 

	function pre_confirmation_check()
	{
		return false;
	} 

	function confirmation()
	{
		return array('title' => tep_image(DIR_WS_IMAGES . 'divers/cybermut.gif'));
		
//		return false;
	} 

	function process_button()
	{
		global $order, $currencies, $currency; 
		// recuperation de la cl
		$clemac = "";
		if ($this->cle != "") {
			$sec_currency = $order->info['currency'];
			$cle = $this->cle;

			$tpe = MODULE_PAYMENT_CMCIC_TPE;
			$date = date('d/m/Y:H:i:s');
			$montant = number_format($order->info['total'] * $currencies->get_value($sec_currency), $currencies->currencies[$sec_currency]['decimal_places'], '.', '') . $sec_currency;
			//generation de la reference dans la table cmcic_reference pour assurer l'unicite
			$sql_data_array = array('order_id'=> 0);
			tep_db_perform('cmcic_reference', $sql_data_array);
			$new_id = tep_db_insert_id();
			$reference = str_pad($new_id, 12, "0", STR_PAD_LEFT);
			//on enregistre la reference
			tep_db_perform('cmcic_reference', array('ref_number' => $reference), 'update', "ref_id=". $new_id);

			$textelibre = tep_session_id();
			$version = MODULE_PAYMENT_CMCIC_VERSION;
			$langue = "FR";
			$societe = MODULE_PAYMENT_CMCIC_SOCIETE;
			$donnees = $tpe . "*" . $date . "*" . $montant . "*" . $reference . "*" . $textelibre . "*" . $version . "*" . $langue . "*" . $societe . "*";
			$clemac = $this->hmac_CMCIC($cle, $donnees);
		} 
		$process_button_string = tep_draw_hidden_field('MAC', html_encode($clemac)) . "\n" .
		tep_draw_hidden_field('version', html_encode($version)) . "\n" .
		tep_draw_hidden_field('TPE', html_encode($tpe)) . "\n" .
		tep_draw_hidden_field('date', html_encode($date)) . "\n" .
		tep_draw_hidden_field('montant', html_encode($montant)) . "\n" .
//		tep_draw_hidden_field('montant_a_capturer', html_encode($montant)) . "\n" .
//		tep_draw_hidden_field('montant_deja_capture', html_encode($montant)) . "\n" .
		tep_draw_hidden_field('montant_restant', html_encode($montant)) . "\n" .
		tep_draw_hidden_field('reference', html_encode($reference)) . "\n" .
		tep_draw_hidden_field('lgue', html_encode($langue)) . "\n" .
		tep_draw_hidden_field('societe', html_encode($societe)) . "\n" .
		tep_draw_hidden_field('url_retour', html_encode(tep_href_link(FILENAME_DEFAULT), '' , 'SSL')) . "\n" .
		tep_draw_hidden_field('url_retour_ok', html_encode(tep_href_link(FILENAME_CHECKOUT_SUCCESS) ,'', 'SSL')) . "\n" .
		tep_draw_hidden_field('url_retour_err', html_encode(tep_href_link(FILENAME_CHECKOUT_PAYMENT) ,'', 'SSL')) . "\n" .
		tep_draw_hidden_field('texte-libre', html_encode($textelibre)) . "\n" .
		tep_draw_hidden_field('bouton', html_encode(MODULE_PAYMENT_CMCIC_BOUTON)) . "\n" ;

		return $process_button_string;
	} 

	function before_process()
	{
		//empeche de valider en lancant directement l'adresse de checkout_process
		tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
	} 

	function after_process()
	{
		return false;
	} 

	function get_error()
	{
		return false;
	} 

	function check()
	{
		if (!isset($this->_check)) {
			$check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_CMCIC_STATUS'");
			$this->_check = tep_db_num_rows($check_query);
		} 
		return $this->_check;
	} 

	function install()
	{
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Activer Module Cybermut', 'MODULE_PAYMENT_CMCIC_STATUS', 'True', 'Voulez-vous activer le module de paiment Cybermut ?', '6', '1', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Sort order of display.', 'MODULE_PAYMENT_CMCIC_SORT_ORDER', '0', 'Sort order of display. Lowest is displayed first.', '6', '0', now())");

		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Numero TPE', 'MODULE_PAYMENT_CMCIC_TPE', '123456', 'Numro du TPE', '6', '2', now())");

		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Version du Kit', 'MODULE_PAYMENT_CMCIC_VERSION', '1.2open', 'Version du kit open source', '6', '2', now())");

		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Societe', 'MODULE_PAYMENT_CMCIC_SOCIETE', 'Site1', 'Code societe', '6', '15', now())");

		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Bouton', 'MODULE_PAYMENT_CMCIC_BOUTON', 'Paiement CB', 'Mot  afficher sur le bouton du paiement', '6', '35', now())");
	} 

	function remove()
	{
		tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
	} 

	function keys()
	{
		return array('MODULE_PAYMENT_CMCIC_STATUS', 'MODULE_PAYMENT_CMCIC_SORT_ORDER', 'MODULE_PAYMENT_CMCIC_TPE', 'MODULE_PAYMENT_CMCIC_VERSION', 'MODULE_PAYMENT_CMCIC_SOCIETE', 'MODULE_PAYMENT_CMCIC_BOUTON');
	} 
	// fonctions pour la cryptographie
	function hmac_sha1 ($key, $data)
	{ 
		// RFC 2104 HMAC implementation for PHP 4 >= 4.3.0 -
		// Creates a SHA1 HMAC.
		// Eliminates the need to install mhash to compute a HMAC
		// Adjusted from the md5 version by Lance Rushing .
		$b = 64; // block length for SHA1
		if (strlen($key) > $b) { $key = pack("H*", sha1($key));	} 
		$key = str_pad($key, $b, chr(0x00));
		$ipad = str_pad('', $b, chr(0x36));
		$opad = str_pad('', $b, chr(0x5c));
		$k_ipad = $key ^ $ipad ;
		$k_opad = $key ^ $opad;

		return sha1($k_opad . pack("H*", sha1($k_ipad . $data)));
	} 

	function hmac_CMCIC ($key, $data = "")
	{
		$pass = "uiaqK8vyTyxV8MzjukIg"; // Indiquez ici votre passphrase ! Vous pouvez en crer une alatoirement grce aux Cybermut Open Tools
		$k1 = pack("H*",sha1($pass));
		$l1 = strlen($k1);
		$k2 = pack("H*", $key);
		$l2 = strlen($k2);
		if ($l1 > $l2):
			$k2 = str_pad($k2, $l1, chr(0x00));
		elseif ($l2 > $l1):
			$k1 = str_pad($k1, $l2, chr(0x00));
		endif;
		if ($data == ""):
			$d = "CtlHmac" . MODULE_PAYMENT_CMCIC_VERSION . MODULE_PAYMENT_CMCIC_TPE;
		else:
			$d = $data;
		endif;
		return strtolower($this->hmac_sha1($k1 ^ $k2, $d));
	} 

	function checkMAC($bnkquery)

  {

     define("CMCIC_PHP2_FIELDS", "%s%s+%s+%s+%s+%s+%s+%s+");

     // procede au controle d'integrit des donnes renvoyes par le serveur

     $databank = sprintf(CMCIC_PHP2_FIELDS, $bnkquery['retourPLUS'],

                                   MODULE_PAYMENT_CMCIC_TPE,

                                   $bnkquery["date"],

                                   $bnkquery['montant'],

                                   $bnkquery['reference'],

                                   $bnkquery['texte-libre'],

                                   MODULE_PAYMENT_CMCIC_VERSION,

                                   $bnkquery['code-retour']);

     

     $hmacbank = strtolower($bnkquery['MAC']);

     // on verifie que le mac envoy par la banque correspond bien aux donnes recu

     if ($this->hmac_CMCIC($this->cle, $databank) == $hmacbank) {

        return true;

     } else {

        return false;

     }

     // ----------------------------------------------------------------------------------------------

  } 
	function sendAR($status)
	{
		switch ($status) {
			case "NotValid":
				print("Content-type: text/plain\nVersion: 1\nDocument falsifie");
				break;
			case "Valid":
				print("Content-type: text/plain\nVersion: 1\nOK");;
				break;
			default: ;
				print("Content-type: text/plain\nVersion: 1\nDocument falsifie");
		} // switch 
		// ----------------------------------------------------------------------------------------------
	} 
} 

?>