<?php
/*
  $Id: zipcode_validate.php,v 2.2 2004/11/16 01:50:52 PopTheTop Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Program to search all the customers and their address books to
  verify that the Zipcode and State data match up correctly.
  Be aware that US Post Office may change info at any time.

  The allstates array information was taken from a php script
  found on the Zend website in August 2004
  at https://www.zend.com/search_code_author.php?author=jasonthoma

  Released under the GNU General Public License

  ##########################################################
  HISTORY
  ##########################################################

  Nov 16, 2004 - Dave (baddog)
  Added Puerto Rico
  Shortened the name so that it gets displayed on 1 line
  Added the version number at the top

  Nov 16, 2004 - John P. New (jnew)
  User no longer has to modify database info in zipcode_validate.php.
  If all states and zip codes match in the customer's database, report now returns a message stating such.
  If no US addresses in the customer's database are found, report now returns a message stating such.
     Hey, thanks DooD!

  Nov 15, 2004 - Scott Moore (PopTheTop)
  Updated for osC v2.2 MS2
  Full re-write of original contribution to integrate with osC Admin section.
  Added link in Admin / Reports to run this contribution.
  Layout of report is now much nicer.
  Made it compatible with the Admin DHTML Menus contribution.

  Aug 31, 2004 - Doug Edmunds
  Original contribution and code and idea by: Doug Edmunds.
  http://www.oscommerce.com/community/contributions,2404
  What a great start!

  ##########################################################

*/

  require('includes/application_top.php');
  require('includes/configure.php');
?>

<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
<script language="javascript" src="includes/menu.js"></script>
<script language="javascript" src="includes/general.js"></script>
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->

<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
  <tr>
<?php
    if ($menu_dhtml == false ) {     // add for dhtml_menu
      echo '<td width="' . BOX_WIDTH . '" valign="top">';
      echo '<table border="0" width="' . BOX_WIDTH . '" cellspacing="1" cellpadding="1" class="columnLeft">';
      echo '<!-- left_navigation //-->';
      require(DIR_WS_INCLUDES . 'column_left.php');
      echo '<!-- left_navigation_eof //-->';
      echo '</table>';
      echo '</td>';
    } else {

    }

$ordertype=$_REQUEST['ordertype'];
if($ordertype=='' || $ordertype=='0')
{$order='';$ordertype=1;}else{$order='desc';$ordertype=0;}
echo $order;

?>
<!-- body_text //-->
    <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="2">
      <tr>
        <td><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <TD ALIGN="left" CLASS="pageHeading"><!-- Customer Zip Code Validator --><?php echo CUSTOMER_ZIP_CODE_VALIDATOR;?> <font class="smallText">[<a href='zipcode_notify.php'><!-- Send Email to All --><?php echo SEND_EMAIL_TO_ALL;?></a></font></TD>
            <TD ALIGN="right" CLASS="pageHeading"><font class="smallText">v2.2</font>&nbsp;</TD>
          </tr>
        </table></td>
      </tr>
      <tr>
        <td>
      <table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td valign="top">
        <table border="0" width="100%" cellspacing="0" cellpadding="2">
              <tr class="dataTableHeadingRow">
                <td width=200 class="dataTableHeadingContent">
        
        <NOBR><a href='zipcode_validate.php?sort=0&ordertype=<?php echo $ordertype; ?>'><!-- Mismatched State and Zipcode --> <?php echo MISMATCHED_STATE_AND_ZIPCODE;?></a></NOBR></td>
                <td width=200 class="dataTableHeadingContent"><NOBR><a href='zipcode_validate.php?sort=1&ordertype=<?php echo $ordertype; ?>'><!-- Address Book ID --><?php echo ADDRESS_BOOK_ID;?></a></NOBR></td>
                <td width=200 class="dataTableHeadingContent"><NOBR><a href='zipcode_validate.php?sort=2&ordertype=<?php echo$ordertype; ?>'><!-- Customer ID --><?php echo CUSTOMER_ID;?></a></NOBR></td>        
                <td class="dataTableHeadingContent"><NOBR><a href='zipcode_validate.php?sort=3&ordertype=<?php echo $ordertype; ?>'><!-- Customer --><?php echo CUSTOMER;?></a></NOBR></td>
        <td width=100 class="dataTableHeadingContent"><NOBR><!-- Remove --><?php echo REMOVE;?></NOBR></td>
              </tr>
<?php
function validstatezip($state, $zip5) {
   $allstates = array (
// US Addresses
     "AK" => array ("9950099929"),
     "AL" => array ("3500036999"),
     "AR" => array ("7160072999", "7550275505"),
     "AZ" => array ("8500086599"),
     "CA" => array ("9000096199"),
     "CO" => array ("8000081699"),
     "CT" => array ("0600006999"),
     "DC" => array ("2000020099", "2020020599"),
     "DE" => array ("1970019999"),
     "FL" => array ("3200033999", "3410034999"),
     "GA" => array ("3000031999"),
     "HI" => array ("9670096798", "9680096899"),
     "IA" => array ("5000052999"),
     "ID" => array ("8320083899"),
     "IL" => array ("6000062999"),
     "IN" => array ("4600047999"),
     "KS" => array ("6600067999"),
     "KY" => array ("4000042799", "4527545275"),
     "LA" => array ("7000071499", "7174971749"),
     "MA" => array ("0100002799"),
     "MD" => array ("2033120331", "2060021999"),
     "ME" => array ("0380103801", "0380403804", "0390004999"),
     "MI" => array ("4800049999"),
     "MN" => array ("5500056799"),
     "MO" => array ("6300065899"),
     "MS" => array ("3860039799"),
     "MT" => array ("5900059999"),
     "NC" => array ("2700028999"),
     "ND" => array ("5800058899"),
     "NE" => array ("6800069399"),
     "NH" => array ("0300003803", "0380903899"),
     "NJ" => array ("0700008999"),
     "NM" => array ("8700088499"),
     "NV" => array ("8900089899"),
     "NY" => array ("0040000599", "0639006390", "0900014999"),
     "OH" => array ("4300045999"),
     "OK" => array ("7300073199", "7340074999"),
     "OR" => array ("9700097999"),
     "PA" => array ("1500019699"),
     "RI" => array ("0280002999", "0637906379"),
     "SC" => array ("2900029999"),
     "SD" => array ("5700057799"),
     "TN" => array ("3700038599", "7239572395"),
     "TX" => array ("7330073399", "7394973949", "7500079999", "8850188599"),
     "UT" => array ("8400084799"),
     "VA" => array ("2010520199", "2030120301", "2037020370", "2200024699"),
     "VT" => array ("0500005999"),
     "WA" => array ("9800099499"),
     "WI" => array ("4993649936", "5300054999"),
     "WV" => array ("2470026899"),
     "WY" => array ("8200083199"),
// Puerto Rico
    "PA" => array ("1500019699"),
    "PR" => array ("0060000999"),
    "RI" => array ("0280002999", "0637906379"));

// if you use a drop down list for state selection, ensuring valid data,
// isset is not needed.  (Warnings can not be turned off with: @foreach...)

   if (isset($allstates[$state])) {
     //just do the main part of code
     $zip5 = substr($zip5, 0,5);

     foreach($allstates[$state] as $ziprange) {
       if (($zip5 >= substr($ziprange, 0, 5)) && ($zip5 <= substr($ziprange,5))) {
          return false;  // on match, jump out of foreach early :)
       }
     }
   }
  print("<tr class=dataTableRow onmouseover=rowOverEffect(this) onmouseout=rowOutEffect(this)>");
   print("<td class=dataTableContent>" . $state . " <FONT SIZE=2>&raquo;&raquo;</FONT> " . $zip5 . "</td>");
   return true;
}

  //$mysql_access = mysql_connect("localhost", DB_SERVER_USERNAME, DB_SERVER_PASSWORD);
  //mysql_select_db(DB_DATABASE, $mysql_access);
  $orderby="";
  $sort=$_REQUEST['sort'];
  if($sort==0)
  {$orderby="ORDER BY zo.zone_code $order, ad.entry_postcode $order";}
  elseif($sort==1)
  {$orderby="ORDER BY ad.address_book_id $order";}
  elseif($sort==2)
  {$orderby="ORDER BY ad.customers_id $order";}
  elseif($sort==3)
  {$orderby="ORDER BY ad.entry_firstname $order,ad.entry_lastname $order";}
  
  $query = "SELECT ad.address_book_id, ad.customers_id, ad.entry_lastname, ad.entry_firstname, ad.entry_postcode, zo.zone_code FROM ".TABLE_ADDRESS_BOOK." ad, ".TABLE_ZONES." zo where ad.entry_country_id = 223 and ad.entry_zone_id = zo.zone_id  $orderby";
  $mail_query = tep_db_query($query);
  
  $all_match = "TRUE"; // Set initial value
  $recordFound="False";
  while ($zips = tep_db_fetch_array($mail_query))  
  {
      if (validstatezip($zips['zone_code'], $zips['entry_postcode'])) {  // At least one mismatched zip code found
          print("<td class=dataTableContent>".$zips['address_book_id']."</td>");
        print("<td class=dataTableContent>".$zips['customers_id']."</td>");
          print("<td class=dataTableContent>".$zips['entry_firstname']." ".$zips['entry_lastname']."</td>");
      print("<td class=dataTableContent><a href='zipcode_remove.php?zipid=".$zips['address_book_id']."'>Remove</a></td>");
          print("</tr>");
      $all_match = "FALSE";
      $recordFound="True";
      }
    }
  
  if($recordFound=="False")
  {
    // No US addresses found
    print ("<tr class=dataTableRow onmouseover=rowOverEffect(this) onmouseout=rowOutEffect(this)><td class=dataTableContent colspan=4 align=left><BR>There are no US addresses in the Customers database<br><br></td></tr>");
  }
  

  if ($all_match == "TRUE") {
    // No mismatched iformation found
    print ("<tr class=dataTableRow onmouseover=rowOverEffect(this) onmouseout=rowOutEffect(this)><td class=dataTableContent colspan=4 align=left><BR>Records show that all Zip Codes and States match for all Customers<BR><BR></td></tr>");
  }
?>
            </table>
        </td>
          </tr>
        </table></td>
      </tr>
    </table></td>
<!-- body_text_eof //-->
  </tr>
</table>
<!-- body_eof //-->
<P>&nbsp;</P>
<P>&nbsp;</P>
<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- footer_eof //-->
</body>
</html>

<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
