<?php
/*
  $Id: ot_ecotax.php,v 1.14 2003/02/14 05:58:35 hpdl Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

  class ot_ecotax {
    var $title, $output;

    function ot_ecotax() {
      $this->code = 'ot_ecotax';
      $this->title = MODULE_ORDER_TOTAL_ECOTAX_TITLE;
      $this->description = MODULE_ORDER_TOTAL_ECOTAX_DESCRIPTION;
      $this->enabled = ((MODULE_ORDER_TOTAL_ECOTAX_STATUS == 'true') ? true : false);
      $this->sort_order = MODULE_ORDER_TOTAL_ECOTAX_SORT_ORDER;

      $this->output = array();
    }

    function process() {
	      global $order, $currencies;

      reset($order->info['ecotax_groups']);
      while (list($key, $value) = each($order->info['ecotax_groups'])) {
        if ($value > 0) {
          $this->output[] = array('title' => MODULE_ORDER_TOTAL_TAX_ECOTAX_TITLE.':',
                                  'text' => $currencies->format($value, true, $order->info['currency'], $order->info['currency_value']),
                                  'value' => $value);
								  
        }
      }
	   reset($order->info['ecotax_groups2']);
      while (list($key, $value) = each($order->info['ecotax_groups2'])) {
        if ($value > 0) {
          $this->output[] = array('title' => MODULE_ORDER_TOTAL_ECOTAX_TOTAL_TITLE.':',
                                  'text' => '<hr>'.$currencies->format($value, true, $order->info['currency'], $order->info['currency_value']),
                                  'value' => $value);
								  
        }
      }
	  }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_ECOTAX_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }

      return $this->_check;
    }

    function keys() {
      return array('MODULE_ORDER_TOTAL_ECOTAX_STATUS', 'MODULE_ORDER_TOTAL_ECOTAX_SORT_ORDER','MODULE_ORDER_TOTAL_ECOTAX_INCLUDE','MODULE_ORDER_TOTAL_POSITION_TABLE');
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Afficher EcoTax', 'MODULE_ORDER_TOTAL_ECOTAX_STATUS', 'true', 'Voulez-vous afficher l\'cotax ?', '6', '1','tep_cfg_select_option(array(\'true\', \'false\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordre de classement', 'MODULE_ORDER_TOTAL_ECOTAX_SORT_ORDER', '6', 'Position d\'affichage du module.', '6', '2', now())");


      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Inclure l\'cotax aux prix ?', 'MODULE_ORDER_TOTAL_ECOTAX_INCLUDE', 'True', 'True: L\'ecotax est ajout au tarif du produit<br>False: Le tarif cotax est affich seulement.', '6', '3', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
	  tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Position du tableau sur la facture', 'MODULE_ORDER_TOTAL_POSITION_TABLE', '540', 'Indique en pixel la position (depuis le haut de page) du tableau rcapitulatif des diffrentes co-participations sur la facture .', '6', '4', now())");
				  }
    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

  }
?>
