<?php
	/**
     * Fonction qui va chercher un fichier sur un FTP
     *
     * @access     static
     * @param    string            $servername                    Le nom du serveur ftp (sans ftp:// et sans /  la fin)
     * @param     string            $username                    Le login du ftp
     * @param     string            $password                    Le password du ftp
     * @param     string            $localpath                    Le chemin du site (http) o on sauve le fichier (+ nom fichier)
     * @param     string            $remotepath                    Le chemin sur le ftp o on cherche le fichier (+ nom fichier)
     * @return     boolean                                        True en cas de succs, false sinon
     */

    function ftpGetFile ($servername, $username, $password, $localpath, $remotepath) {
        $conn_id = ftp_connect ($servername);
        $login_result = ftp_login ($conn_id, $username, $password);
        if ((!$conn_id) || (!$login_result))
            return false;
        // On fait une sorte de ping pour vrifier que le fichier existe bel et bien
        if (@ftp_size($conn_id, $remotepath) < 0)
            return false;
        $upload = @ftp_get ($conn_id, $localpath, $remotepath, FTP_BINARY);
        if (!$upload)
            return false;
        ftp_close($conn_id);
        return true;
    }
?>