<?php
/*
  $Id: split_page_results.php,v 1.2 2004/03/05 00:36:42 ccwjr Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

  class splitPageResults {
    var $sql_query, $number_of_rows, $current_page_number, $number_of_pages, $number_of_rows_per_page, $page_name;

/* class constructor */
    function splitPageResults($query, $max_rows, $count_key = '*', $page_holder = 'page') {
      $this->sql_query = strtolower($query);  // force the quesry to all lower case
      $this->page_name = $page_holder;

      if (isset($_GET[$page_holder])) {
        $page = $_GET[$page_holder];
      } elseif (isset($_POST[$page_holder])) {
        $page = $_POST[$page_holder];
      } else {
        $page = '';
      }

      if (empty($page) || !is_numeric($page)) $page = 1;
      $this->current_page_number = $page;
         
         if ($max_rows <= 0){
          $max_rows = '1';
          }

      $this->number_of_rows_per_page = $max_rows;


      // SQL statements that have a "having" clause must be processed
      // as the full SQL statment.  Otherwise, a shorten version may be used.
      if (strpos($this->sql_query, ' having') === false) {
        $pos_to = strlen($this->sql_query);
        $pos_from = strpos($this->sql_query, ' from', 0);

        $pos_group_by = strpos($this->sql_query, ' group by', $pos_from);
        if (($pos_group_by < $pos_to) && ($pos_group_by != false)) $pos_to = $pos_group_by;

        $pos_order_by = strpos($this->sql_query, ' order by', $pos_from);
        if (($pos_order_by < $pos_to) && ($pos_order_by != false)) $pos_to = $pos_order_by;

        if (strpos($this->sql_query, 'distinct') || strpos($this->sql_query, 'group by')) {
          $count_string = 'distinct ' . tep_db_input($count_key);
        } else {
          $count_string = tep_db_input($count_key);
        }

        $count_query = tep_db_query("select count(" . $count_string . ") as total " . substr($this->sql_query, $pos_from, ($pos_to - $pos_from)));
        $count = tep_db_fetch_array($count_query);

        $this->number_of_rows = $count['total'];
      } else {
        $count_query = tep_db_query($this->sql_query);
        $this->number_of_rows = tep_db_num_rows($count_query);
      }

      $this->number_of_pages = ceil($this->number_of_rows / $this->number_of_rows_per_page);

      if ($this->current_page_number > $this->number_of_pages) {
        $this->current_page_number = $this->number_of_pages;
      }

      $offset = ($this->number_of_rows_per_page * ($this->current_page_number - 1));
      //newer version of mysql can not handle neg number in limit, temp fix
      if ($offset < '0'){
         $offset = '1';
         }
//      $this->sql_query .= " limit " . $offset . ", " . $this->number_of_rows_per_page;

// erreur offset negatif seb
$this->sql_query .= " limit " . max($offset, 0) . ", " . $this->number_of_rows_per_page;
    }

/* class functions */

////////////////////////////////////////////////////////////////////

// display split-page-number-links with style
    function display_links($max_page_links, $parameters = '') {
      global $PHP_SELF, $request_type;

      $display_links_string = '<table><tr>';

      $class = 'class="pageResults"';
// BOM Mod:allow for a call when there are no rows to be displayed
      if ($this->number_of_pages > 0) {

      if (tep_not_null($parameters) && (substr($parameters, -1) != '&')) $parameters .= '&';

// previous button - not displayed on first page
      if ($this->current_page_number > 1) $display_links_string .= '<td id="splitResults"><a  id="otherPageResults" href="' . tep_href_link(basename($PHP_SELF), $parameters . $this->page_name . '=' . ($this->current_page_number - 1), $request_type) . '" class="pageResults" title=" ' . PREVNEXT_TITLE_PREVIOUS_PAGE . ' ">' . PREVNEXT_BUTTON_PREV . '</a></td>';
// check if number_of_pages > $max_page_links
      $cur_window_num = intval($this->current_page_number / $max_page_links);
      if ($this->current_page_number % $max_page_links) $cur_window_num++;

      $max_window_num = intval($this->number_of_pages / $max_page_links);
      if ($this->number_of_pages % $max_page_links) $max_window_num++;

// previous window of pages
      if ($cur_window_num > 1) $display_links_string .= '<td id="splitResults"><a id="otherPageResults"   href="' . tep_href_link(basename($PHP_SELF), $parameters . $this->page_name . '=' . (($cur_window_num - 1) * $max_page_links), $request_type) . '" class="pageResults" title=" ' . sprintf(PREVNEXT_TITLE_PREV_SET_OF_NO_PAGE, $max_page_links) . ' ">...</a></td>';

// page nn button
      for ($jump_to_page = 1 + (($cur_window_num - 1) * $max_page_links); ($jump_to_page <= ($cur_window_num * $max_page_links)) && ($jump_to_page <= $this->number_of_pages); $jump_to_page++) {
        if ($jump_to_page == $this->current_page_number) {
          $display_links_string .= '<td id="splitResults"><span id="thisPageResults">' . $jump_to_page . '</span></td>';
        } else {
          $display_links_string .= '<td id="splitResults"><a id="otherPageResults" href="' . tep_href_link(basename($PHP_SELF), $parameters . $this->page_name . '=' . $jump_to_page, $request_type) . '" title=" ' . sprintf(PREVNEXT_TITLE_PAGE_NO, $jump_to_page) . ' ">' . $jump_to_page . '</a></td>';
        }
      }

// next window of pages
      if ($cur_window_num < $max_window_num) $display_links_string .= '<td id="splitResults"><a id="otherPageResults"  href="' . tep_href_link(basename($PHP_SELF), $parameters . $this->page_name . '=' . (($cur_window_num) * $max_page_links + 1), $request_type) . '" class="pageResults" title=" ' . sprintf(PREVNEXT_TITLE_NEXT_SET_OF_NO_PAGE, $max_page_links) . ' ">...</a></td>';

// next button
      if (($this->current_page_number < $this->number_of_pages) && ($this->number_of_pages != 1)) $display_links_string .= '<td id="splitResults"><a id="otherPageResults" href="' . tep_href_link(basename($PHP_SELF), $parameters . 'page=' . ($this->current_page_number + 1), $request_type) . '" class="pageResults" title=" ' . PREVNEXT_TITLE_NEXT_PAGE . ' ">' . PREVNEXT_BUTTON_NEXT . '</a></td>';

      } else {  // if zero rows, then simply say that
        $display_links_string .= '&nbsp;<b>0</b>&nbsp;';
      }
// EMO Mod
$display_links_string .= '</tr></table>';
      return $display_links_string;
    }
/////////////////////////////////////////////////////////////////////////////////

// display number of total products found
    function display_count($text_output) {
      $to_num = ($this->number_of_rows_per_page * $this->current_page_number);
      if ($to_num > $this->number_of_rows) $to_num = $this->number_of_rows;

      $from_num = ($this->number_of_rows_per_page * ($this->current_page_number - 1));

      if ($to_num == 0) {
        $from_num = 0;
      } else {
        $from_num++;
      }

      return sprintf($text_output, $from_num, $to_num, $this->number_of_rows);
    }
  }
?>