<?php
/*
  $Id: relais_colis.php InDeepLight SARL
*/

class relaiscolis {
    var $code, $title, $description, $icon, $enabled;
    // class RELAISCOLIS
    function relaiscolis ()
    {
        $this->code = 'relaiscolis';
        $this->title = MODULE_SHIPPING_RELAISCOLIS_TEXT_TITLE;
        $this->description = MODULE_SHIPPING_RELAISCOLIS_TEXT_DESCRIPTION;
        $this->sort_order = MODULE_SHIPPING_RELAISCOLIS_SORT_ORDER;
        $this->icon_click = DIR_WS_ICONS . 'relais_colis.gif'; // ou shipping_laposte.gif au choix
        $this->tax_class = MODULE_SHIPPING_RELAISCOLIS_TAX_CLASS;
        $this->enabled = MODULE_SHIPPING_RELAISCOLIS_STATUS;
    }
    // class methods
    function quote($method = '')
    {
        global $order, $cart, $shipping_weight;


		if (MODULE_SHIPPING_RELAISCOLIS_MODE == 'prix') {
			$order_total = $cart->show_total();
		} else {
			$order_total = $shipping_weight;
		}
        $this->quotes = array('id' => $this->code,
            'module' => MODULE_SHIPPING_RELAISCOLIS_TEXT_TITLE,
            'methods' => array());

        if (tep_not_null($this->icon))
            $this->quotes['icon'] = tep_image($this->icon, $this->title);

        if (tep_not_null($this->icon_click))
            $this->quotes['icon'] = '<a href="' . tep_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS_RELAIS_COLIS, '', 'SSL') . '">' . tep_image($this->icon_click, $this->title) . '</a>';

        $dest_country = $order->delivery['country']['iso_code_2'];

        if (($dest_country != 'FR') && ($dest_country != 'FX')) {
            $this->quotes['error'] = MODULE_SHIPPING_RELAISCOLIS_INVALID_ZONE;
            return $this->quotes;
        }

        $cost = constant('MODULE_SHIPPING_RELAISCOLIS_NATIONAL');
        $table = split("[:,]" , $cost);
        for ($i = 0; $i < sizeof($table); $i += 2) {
            // if ($shipping_weight > $table[$i])
            if ($order_total > $table[$i])
                continue;

            $this->quotes['methods'][] = array('id' => $this->code,
                //'title' => $order_total . ' ' . MODULE_SHIPPING_RELAISCOLIS_TEXT_UNITS,
                'title' =>  MODULE_SHIPPING_RELAISCOLIS_TEXT_WAY,
                'cost' => $table[$i + 1] + MODULE_SHIPPING_RELAISCOLIS_HANDLING);

            if ($this->tax_class > 0) {
                $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
            }
            return $this->quotes;
        }

        $this->quotes['error'] = MODULE_SHIPPING_RELAISCOLIS_TOO_HEAVY;
        return $this->quotes;
    }

    function check()
    {
        $check = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_RELAISCOLIS_STATUS'");
        $check = tep_db_num_rows($check);

        return $check;
    }

    function install()
    {
        tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Valider RELAISCOLIS', 'MODULE_SHIPPING_RELAISCOLIS_STATUS', 'True', 'Activer / Dsactiver RELAISCOLIS sans perdre les valeurs chang&eacute;es', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
        tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('M&eacute;thode de Tableau', 'MODULE_SHIPPING_RELAISCOLIS_MODE', 'poids', 'Le co&ucirc;t de livraison est bas&eacute; sur le total de la commande ou sur le poids des articles command&eacute;s ?', '6', '0', 'tep_cfg_select_option(array(\'poids\', \'prix\'), ', now())");
        tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('RELAISCOLIS national', 'MODULE_SHIPPING_RELAISCOLIS_NATIONAL', '60:8.03,200000:15.05', 'Port bas&eacute; sur le poids total des produits ou le montant de la commande, tarif national TTC. Exemple: 1:6.15, 2:6.95, etc. Jusqu\' 1 Kg factur 6.15, jusqu\' 2 Kg , 6.95, etc', '6', '0', now())");
        tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Frais fixes', 'MODULE_SHIPPING_RELAISCOLIS_HANDLING', '0', 'Frais fixes (emballage) pour RELAISCOLIS', '6', '0', now())");
        tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Classe de taxe', 'MODULE_SHIPPING_RELAISCOLIS_TAX_CLASS', '0', 'Appliquer le taux de taxe suivant sur les frais de livraison.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");
        tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Code postal', 'MODULE_SHIPPING_RELAISCOLIS_STORE_POSTCODE', '75000', 'Code postal de la boutique', '6', '0', now())");
        tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordre de tri', 'MODULE_SHIPPING_RELAISCOLIS_SORT_ORDER', '0', 'Ordre de tri pour l\'affichage (Le plus petit nombre est montr&eacute; en premier).', '6', '0', now())");
        // tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Livraison au poids ou au montant', 'MODULE_SHIPPING_RELAISCOLIS_STATUS', 'True', 'Voulez-vous permettre la livraison en fonction du poids total ou du montant de la commande ?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
    }

    function remove()
    {
        tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys()
    {
        return array('MODULE_SHIPPING_RELAISCOLIS_STATUS',
        	'MODULE_SHIPPING_RELAISCOLIS_MODE',
            'MODULE_SHIPPING_RELAISCOLIS_NATIONAL',
            'MODULE_SHIPPING_RELAISCOLIS_HANDLING',
            'MODULE_SHIPPING_RELAISCOLIS_STORE_POSTCODE',
            'MODULE_SHIPPING_RELAISCOLIS_TAX_CLASS',
            'MODULE_SHIPPING_RELAISCOLIS_SORT_ORDER');
    }
}

?>
