<?php

header("Content-Type:text/plain");

set_time_limit(0);
require('includes/application_top.php');
$separator = '|';

if (!function_exists ('html_entity_decode')) {
	function html_entity_decode ($string, $opt = ENT_COMPAT) {
		$string = preg_replace ('~&#x([0-9a-f]+);~ei', 'chr(hexdec("\\1"))', $string) ;
		$string = preg_replace ('~&#([0-9]+);~e', 'chr("\\1")', $string) ;
		$trans_tbl = get_html_translation_table (HTML_ENTITIES) ;
		$trans_tbl = array_flip ($trans_tbl) ;
		if ($opt & 1) { // Translating single quotes
			// Add single quote to translation table ; doesn't appear to be there by default
			$trans_tbl["&apos ;"] = "'" ;
		}
		if (! ($opt & 2)) { // Not translating double quotes
			// Remove double quote from translation table
			unset ($trans_tbl["&quot ;"]) ;
		}
		return strtr ($string, $trans_tbl) ;
	}
} 
//fin html_entity_decode

function cleanHtml($chaine)
{
	$chaine = nl2br($chaine);
	$chaine = strip_tags($chaine);
	$chaine = str_replace('  ',' ',$chaine);
	$chaine = str_replace('\n',' ',$chaine);
	$chaine = str_replace('\n\r',' ',$chaine);
	$chaine = str_replace('\r\n',' ',$chaine);
	$chaine = str_replace('\r',' ',$chaine);
	$chaine = str_replace('\t',' ',$chaine);
	$chaine = str_replace('|',' ',$chaine);
	$chaine = str_replace(CHR(10), '', $chaine);
	$chaine = str_replace(CHR(13), '', $chaine);
	$chaine = str_replace('&#233;', '', $chaine);
	$chaine = str_replace('&#244;', '', $chaine);
	$chaine = str_replace('&#224;', '', $chaine);
	$chaine = str_replace('&#232;', '', $chaine);
	$chaine = str_replace('&#352;', '', $chaine);
	$chaine = str_replace('&#234;', '', $chaine);
	$chaine = str_replace('&#226;', '', $chaine);
	$chaine = str_replace('&#231;', '', $chaine);
	$chaine = str_replace('&#251;', '', $chaine);
	$chaine = str_replace('&#178;', '', $chaine);
	$chaine = str_replace('&#176;', '', $chaine);
	$chaine = str_replace('&#8364;', '', $chaine);
	$chaine = str_replace('&#8211;', '-', $chaine);
	$chaine = str_replace('&#8217;', '\'', $chaine);
	$chaine = str_replace('&#8226;', '', $chaine);
	$chaine = str_replace('&#183;', '', $chaine);
	$chaine = str_replace('&#163;', '', $chaine);
	$chaine = str_replace('&#239;', '', $chaine);
	$chaine = str_replace('&#202;', '', $chaine);
	$chaine = str_replace('&#246;', '', $chaine);
	$chaine = str_replace('&#168;', '', $chaine);
	$chaine = str_replace('&#206;', '', $chaine);
	$chaine = str_replace('&#8221;', '', $chaine);
	$chaine = str_replace('&#238;', '', $chaine);
	$chaine = str_replace('&gt;', '>', $chaine);
	$chaine = str_replace('&#187;', '>', $chaine);
	$chaine = str_replace('&amp;', '&', $chaine);
	$chaine = str_replace('&nbsp;', ' ', $chaine);
	$chaine = str_replace('nbsp;', ' ', $chaine);
	$chaine = str_replace('', "'", $chaine);
	$chaine = str_replace('\\', '', $chaine);
	$chaine = str_replace(' Articles compl&eacute;mentaires','',$chaine);

	$alpha = array(' ');
	foreach ($alpha as $caractere)
	{
		$chaine = preg_replace( '~'.$caractere.'{2,}~i', $caractere, $chaine);
	}

	if(substr($chaine,0,1) == ' ')
	$chaine = substr($chaine,1);

	if(substr($chaine,0,-1) == ' ')
	$chaine = substr($chaine,0,-1);

	return ($chaine);
}

$included_categories_query = tep_db_query("SELECT c.categories_id, c.parent_id, cd.categories_name FROM " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd WHERE c.categories_id = cd.categories_id AND cd.language_id = FLOOR($languages_id)");
$inc_cat = array();

// Identification du nom de la catgorie, et l'id de la catgorie parent
while ($included_categories = tep_db_fetch_array($included_categories_query)) {
	$inc_cat[] = array (
	'id' => $included_categories['categories_id'],
	'parent' => $included_categories['parent_id'],
	'name' => $included_categories['categories_name']);
}

$cat_info = array();
for ($i=0; $i<sizeof($inc_cat); $i++)
$cat_info[$inc_cat[$i]['id']] = array (
'parent'=> $inc_cat[$i]['parent'],
'name'  => $inc_cat[$i]['name'],
'path'  => $inc_cat[$i]['id'],
'link'  => '' );

for ($i=0; $i<sizeof($inc_cat); $i++) {
	$cat_id = $inc_cat[$i]['id'];
	while ($cat_info[$cat_id]['parent'] != 0) {
		$cat_info[$inc_cat[$i]['id']]['path'] = $cat_info[$inc_cat[$i]['parent']]['name'] . '/' . $cat_info[$inc_cat[$i]['id']]['name'];
		$cat_id = $cat_info[$cat_id]['parent'];
	}
	$link_array = explode('_', $cat_info[$inc_cat[$i]['id']] ['path']);
	for ($j=0; $j<sizeof($link_array); $j++) {
		$cat_info[$inc_cat[$i]['id']]['link'] .= '&nbsp;<a href="' . tep_href_link(FILENAME_DEFAULT, 'cPath=' . $cat_info[$link_array[$j]]['path']) . '"><nobr>' . $cat_info[$link_array[$j]]['name'] . '</nobr></a>&nbsp;&raquo;&nbsp;';
	}
	while ($cat_info[$cat_id]['parent'] != 0){
		$cat_info[$inc_cat[$i]['id']]['split'] = $cat_info[$inc_cat[$i]['parent']]['name'] . ';' . $cat_info[$inc_cat[$i]['id']]['name'];
		$cat_id = $cat_info[$cat_id]['parent'];
	}
}

// Requte identifiant les produits disponibles dans le catalogue
$sql = "SELECT p.*,
   pd.products_name, pd.products_description,
   pc.categories_id, 
   pr.date_added as review_date, pr.customers_name, pr.reviews_rating,
   pt.reviews_text, pt.languages_id as lngr
   FROM (" . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_PRODUCTS_TO_CATEGORIES . " pc)
   LEFT JOIN reviews as pr ON (p.products_id = pr.products_id)
   LEFT JOIN reviews_description as pt ON (pr.reviews_id = pt.reviews_id)
   WHERE p.products_id = pd.products_id 
   AND p.products_id = pc.products_id
   AND pd.language_id = FLOOR($languages_id)
   AND p.products_status = 1
   ORDER BY pc.categories_id, pd.products_name";

$products_query = tep_db_query($sql);
echo 'id'.$separator.'reference_model'.$separator.'categorie'.$separator.'titre'.$separator.'prix'.$separator.'prixDiscount'.$separator.'disponibilite'.$separator.'stock'.$separator.'description'.$separator.'image'.$separator.'url'.$separator.''."\n";

while($products = tep_db_fetch_array($products_query)) {

	if (intval($products['manufacturers_id']) > 0) {
		$manufacturers_query = tep_db_query("SELECT manufacturers_name FROM " . TABLE_MANUFACTURERS . " WHERE manufacturers_id = " . $products['manufacturers_id']);
		$manufacturers_result = tep_db_fetch_array($manufacturers_query);
		$products['manufacturers_name'] = $manufacturers_result['manufacturers_name'];
	}

	$special_query = tep_db_query("SELECT specials_new_products_price , expires_date , specials_date_added FROM " . TABLE_SPECIALS . " WHERE products_id = " . $products['products_id'] . " AND status = '1' limit 1");
	$special_result = tep_db_fetch_array($special_query);
	if ($special_result['specials_new_products_price'] > 0) $products['products_price'] = $special_result['specials_new_products_price'];

	$product_delete = "oui";

	if ($products['products_status'] == '0')  {
		$product_delete = "non";
	}

	$product_active = "oui";

	if ($products['products_status'] == '0') {
		$product_active = "non";
	}

	//calcul des prix
	// la varaible $reduc permet de tester s'il y a une promo
	$price = $products['products_price'];
	if($special_result['specials_new_products_price'] == '' )   {
		$discount_price = '' ;
		$regular_price = $price;
		$reduc = false;
	}   else   {
		$discount_price = $special_result['specials_new_products_price'];
		$regular_price = $price;
		$reduc = true;
	}

	// Test barcod mod
	if (!$ean) $products['products_barcode'] == "";
	// Test ecotax
	if ($ecotax)   $ecotax_montant = $products['ecotax_rates_id'];
	else $ecotax_montant = 0;
	
	$chaine = cleanHtml($products['products_id']).$separator;
	$chaine .= cleanHtml($products['products_model']).$separator;
	$chaine .= cleanHtml($cat_info[$products['categories_id']]['name']).$separator;
	$chaine .= cleanHtml($products['products_name']).$separator;
	$chaine .= cleanHtml($regular_price).$separator;
	$chaine .= cleanHtml($discount_price).$separator;
	$chaine .= cleanHtml($product_active).$separator;
	$chaine .= cleanHtml($product_delete).$separator;
	
	$description = strip_tags (str_replace (array (chr (10), chr (13), '  '), ' ', preg_replace ('/< *br[ \/]*>/i', ' ', html_entity_decode ($products['products_description'])))) ;
	$chaine .= cleanHtml($description).$separator;
	
	$chaine .= tep_href_link(DIR_WS_IMAGES . $products['products_image']).$separator;
	$chaine .= tep_href_link(FILENAME_DEFAULT, 'product_info.php?products_id='.$products['products_id']).$separator;
	
	$chaine = $chaine."\n";
	echo $chaine;

}

?>