<?php
/**
 * @package Services_PayPal
 */

/**
 * Make sure our parent class is defined.
 */
require_once 'Services/PayPal/Type/XSDType.php';

/**
 * SubscriptionTermsType
 * 
 * SubscriptionTermsType - Type declaration to be used by other schemas. Terms of a
 * PayPal subscription.
 *
 * @package Services_PayPal
 */
class SubscriptionTermsType extends XSDType
{
    var $Amount;

    function SubscriptionTermsType()
    {
        parent::XSDType();
        $this->_namespace = 'urn:ebay:apis:eBLBaseComponents';
        $this->_elements = array_merge($this->_elements,
            array (
              'Amount' => 
              array (
                'required' => true,
                'type' => 'BasicAmountType',
                'namespace' => 'urn:ebay:apis:eBLBaseComponents',
              ),
            ));
        $this->_attributes = array_merge($this->_attributes,
            array (
              'period' => 
              array (
                'name' => 'period',
                'type' => 'xs:string',
                'use' => 'required',
              ),
            ));
    }

    function getAmount()
    {
        return $this->Amount;
    }
    function setAmount($Amount, $charset = 'iso-8859-1')
    {
        $this->Amount = $Amount;
        $this->_elements['Amount']['charset'] = $charset;
    }
}
