<?php
/*
 * This file is part of the partner api fnac marketplace package.
 * (c) 2008-2010 Francois Crossette <fcrossette@fnac.com>
 *
 * Example of a common use case for FNAC MARKETPLACE API
 *   - Authentication
 *   - Offers Update
 *   - Offers Query
 *   - Batch Status
 *   - Orders Query
 *   - Orders Update
 *
 */

/*
 * Init :
 *   $partner_id : unique id given by Fnac team
 *   $shop_id    : unique id of Fnac shop
 *   $key        : partner sauthentication key
 */

// CB

require('includes/import_top.php');
// CB
  $partner_id = fnac_fr_partner_id;
  $key        = fnac_fr_key;
  $shop_id    = fnac_fr_shop_id;

  $url        = 'https://vendeur.fnac.com/api.php/';

  try
  {
    /* call auth service  */
    $xmlAuthentication = simplexml_load_file('fnac/xml_files/authentification-request.xml');
    $xmlAuthentication->partner_id = $partner_id;
    $xmlAuthentication->shop_id = $shop_id;
    $xmlAuthentication->key = $key;

    /* Validated XML request using XSD */
    $dom = new DOMDocument;
    $dom->loadXML($xmlAuthentication->asXML());
    $valide = $dom->schemaValidate('fnac/xsd/AuthenticationService.xsd');
    if( ! $valide)
    {
      throw new Exception('xmlAuthentication: validation failed !');
    }

    // send xml to webservice auth
    $response = do_post_request($url . "auth", $xmlAuthentication->asXML());

    // load xml response
    $xmlResponse = simplexml_load_string(trim($response));
    // get token for session authentication
	$tokenForSession = $xmlResponse->token;
    // Post to this date , the session for this token is no more valid.
    $validityDateForSession = $xmlResponse->validity;


    /* call order query service */
    $xmlOrdersQuery = simplexml_load_file('fnac/xml_files/orders-query-request.xml');


   $now=date("c");
   $dateretention=date("c", mktime(0,0,0,date("m"),date("d")-30,date("Y")));


//	echo "<pre>";
// var_dump($xmlOrdersQuery);
//	echo "</pre>";

    $xmlOrdersQuery['partner_id'] = $partner_id;
    $xmlOrdersQuery['shop_id'] = $shop_id;
//    $xmlOrdersQuery['token'] = $tokenForSession;

$string = <<<XML
<?xml version="1.0" encoding="utf-8"?>
<orders_query results_count="100" partner_id="$partner_id"  shop_id="$shop_id"  token="$tokenForSession"  xmlns="http://www.fnac.com/schemas/mp-dialog.xsd">
  <paging>1</paging>
  <date type="CreatedAt">
    <min>$dateretention</min>
    <max>$now</max >
  </date>

  <sort_by>ASC</sort_by>

</orders_query>
XML;

$xmlOrdersQuery=simplexml_load_string($string);


    /* Validated XML request using XSD */
    $dom = new DOMDocument;
    $dom->loadXML($xmlOrdersQuery->asXML());
    $valide = $dom->schemaValidate('fnac/xsd/OrdersQueryService.xsd');
    if( ! $valide)
    {
      throw new Exception('xmlOrdersQuery: validation failed !');
    }
    // send xml to webservice OrdersQuery
    $response = do_post_request($url . "orders_query", $xmlOrdersQuery->asXML());
    // NOCDATA convert CDATA into string to avoid manual cast on value
    $xmlResponse = simplexml_load_string(trim($response), 'SimpleXMLElement', LIBXML_NOCDATA);
//	$xmlResponse_array = (array) $xmlResponse;

/************************************************** Traitement commande ***********************************************/




$mode_test=0;
$customer_id=0;
$status_commande = 1;
$payment_method="Virement bancaire FNAC";
$currency = "EUR";
$currency_value = 1.000000;
$marketplace_info = "Fnac Fr";
$id_tva=5; // aller voir le code id de la tava dans la table tax_rates

			$tva_query= tep_db_query("SELECT tax_rate FROM tax_rates WHERE tax_rates_id = '" . $id_tva . "'");
  		    $tva_values = tep_db_fetch_array($tva_query);
        	$tva = $tva_values['tax_rate'];


    /* get the result of query*/
    foreach($xmlResponse->order as $order)
    {
      // do what you want with the result
		echo "<pre>";
	    //  var_dump($order);
			print_r($order);
		//	print_r($xmlResponse_array);
		echo "</pre>";
		echo "<hr>";

			echo $order->order_id;	
			echo "</br>";
			echo $order->state;	
			echo "</br>";	
			echo $order->shipping_address->firstname;	
			echo $order->shipping_address->company;	
			echo "</br>";	
		echo "<hr>";

			//$date_achat = str_replace("T", " ", $item->purchase_date);
			//$date_achat = str_replace("+00:00", "", $date_achat);


			$pays_query= tep_db_query("SELECT countries_name FROM countries_orgine WHERE countries_iso_code_2 = '" . $order->shipping_address->country . "'");
  		    $pays_values = tep_db_fetch_array($pays_query);
        	$pays = $pays_values['countries_name'];

			$pays_iso3_query= tep_db_query("SELECT countries_name FROM countries_orgine WHERE countries_iso_code_3 = '" . $order->shipping_address->country . "'");
  		    $pays_values_iso3 = tep_db_fetch_array($pays_iso3_query);
        	$pays_iso3_fact = $pays_values_iso3['countries_name'];

			$pays_iso3_query= tep_db_query("SELECT countries_name FROM countries_orgine WHERE countries_iso_code_3 = '" . $order->shipping_address->country . "'");
  		    $pays_values_iso3 = tep_db_fetch_array($pays_iso3_query);
        	$pays_iso3_liv = $pays_values_iso3['countries_name'];

			$orders = tep_db_query("SELECT orders_id , date_purchased,market_p_id_com ,orders_status_mp FROM  " . TABLE_ORDERS . "  WHERE market_p_id_com = '" . $order->order_id ."' ORDER BY date_purchased DESC LIMIT 200 ");

			if ($order->state == 'Created') $order_status_id_mp = 33;
		    if ($order->state == 'Accepted') $order_status_id_mp = 34;
		    if ($order->state == 'Refused') $order_status_id_mp = 35;
		    if ($order->state == 'ToShip') $order_status_id_mp = 36;
		    if ($order->state == 'Shipped') $order_status_id_mp = 37;
		    if ($order->state == 'NotReceived') $order_status_id_mp = 38;
		    if ($order->state == 'Received') $order_status_id_mp = 39;
		    if ($order->state == 'Cancelled') $order_status_id_mp = 40;
		    if ($order->state == 'Refunded') $order_status_id_mp = 41;
		    if ($order->state == 'Error') $order_status_id_mp = 42;

			
			if (	(mysql_num_rows($orders)<1)
//					 &&(($order->state=="Shipped")
//					 ||($order->state=="Received")
//					 ||($order->state=="ToAccept")
//					 ||($order->state=="Created")
//				)

			){

		//	  	echo  $row_orders["orders_id"];
				echo  "___pas trouv";

  $sql_data_array_order = array('customers_id' => $customer_id,
                          'customers_name' =>  utf8_decode($order->shipping_address->lastname) ." " . utf8_decode($order->shipping_address->firstname) ,
                          'customers_company' => utf8_decode($order->shipping_address->company),
                          'customers_street_address' => utf8_decode($order->shipping_address->address1),
                          'customers_suburb' =>  utf8_decode($order->shipping_address->address2)." " . utf8_decode($order->shipping_address->address3),
                          'customers_city' => utf8_decode($order->shipping_address->city),
                          'customers_postcode' =>  utf8_decode($order->shipping_address->zipcode),
                          'customers_state' => '',
                          'customers_country' =>  $pays_iso3_fact,
                          'customers_telephone' => '',
                          'customers_email_address' => '',
                          'customers_address_format_id' => '1',

                          'delivery_name' =>    utf8_decode($order->shipping_address->lastname) ." " . utf8_decode($order->shipping_address->firstname) ,
                          'delivery_company' =>  utf8_decode($order->shipping_address->company),
                          'delivery_street_address' =>  utf8_decode($order->shipping_address->address1),
                          'delivery_suburb' => utf8_decode($order->shipping_address->address2)." " . utf8_decode($order->shipping_address->address3),
                          'delivery_city' =>  utf8_decode($order->shipping_address->city),
                          'delivery_postcode' =>   utf8_decode($order->shipping_address->zipcode),
                          'delivery_state' => '',
                          'delivery_country' =>   $pays_iso3_liv,
                          'delivery_address_format_id' => '1',

                          'billing_name' => utf8_decode($order->billing_address->lastname) ." " . utf8_decode($order->billing_address->firstname) ,
                          'billing_company' => utf8_decode($order->billing_address->company),
                          'billing_street_address' =>   utf8_decode($order->billing_address->address1),
                          'billing_suburb' =>   utf8_decode($order->billing_address->address2)." " . utf8_decode($order->billing_address->address3),
                          'billing_city' =>  utf8_decode($order->billing_address->city),
                          'billing_postcode' => utf8_decode($order->billing_address->zipcode),
                          'billing_state' => '',
                          'billing_country' =>  $pays_iso3_fact,
                          'billing_address_format_id' => '1',
                          'payment_method' =>  $payment_method,
                          'payment_info' => '',
                          'orders_status_mp' => $order_status_id_mp,						  
                          'date_purchased' => 'now()',
                          'last_modified' => 'now()',
                          'orders_status' => $status_commande,
                          'currency' => $currency,
                          'currency_value' => $currency_value,
                          'ipaddy' => '',
						  'market_p_id_com' => $order->order_id,
						  'market_p_id_fux' => '0',
						  'market_p_nom_flux' => $marketplace_info, 
 					       'ipisp' => '');
              

              
						  if ($mode_test<>1)  tep_db_perform(TABLE_ORDERS, $sql_data_array_order);
						  $insert_id = tep_db_insert_id();

				/************************************************** Fin Traitement commande details***********************************************/

							$total_ht=0;
							$total_ttc=0;
							$frais_port_ttc=0;

			    foreach($order->order_detail as $order_detail)
			    {
					echo "</br>";	
					echo utf8_decode($order_detail->product_name);
					echo "</br>";	
					echo utf8_decode($order_detail->price);	
					echo "</br>";
					echo $order_detail->offer_fnac_id;	
					echo "</br>";


								$prix_unitaire_ht= (floatval($order_detail->price)) / (($tva/100)+1);
								$total_ht=	($prix_unitaire_ht * $order_detail->quantity) +	$total_ht;

								$prix_unitaire_ttc= (floatval($order_detail->price));
								$total_ttc=	($prix_unitaire_ttc * $order_detail->quantity) +	$total_ttc;


							   echo "prix shipping : " .$frais_port_ttc=floatval($order_detail->shipping_price)+$frais_port_ttc;
							echo "<br>";


					$model_query= tep_db_query("SELECT products_id, products_model  FROM " . TABLE_PRODUCTS . " WHERE products_id LIKE '" . strval($order_detail->offer_seller_id) . "'");
  				    $model_values = tep_db_fetch_array($model_query);
       			 	$model = $model_values['products_model'];
       			 	$product_id = $model_values['products_id'];					


  						  $sql_data_array = array('orders_id' => $insert_id,
						                            'products_id' => $product_id,
						                            'products_model' => $model,
						                            'products_name' => utf8_decode($order_detail->product_name) ,
						                            'products_price' =>	$prix_unitaire_ht,
													'ecotax_rates_id' => '0',
						                            'final_price' => $prix_unitaire_ht,
						                            'products_tax' => $tva,
						                            'products_ecotax' => '',
						                            'products_quantity' => (int)$order_detail->quantity);
						   if ($mode_test<>1)   tep_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array);
						   if ($mode_test<>1)	destock_product_id('Fnac Fr' , (int)$product_id, $insert_id , (int)$order_detail->quantity, $model, 0);	
						   // $order_products_id = tep_db_insert_id();

				}


			                     	/**************************/
							echo "<br>";
							echo "<br>";
						//  statut history
						  $customer_notification = (SEND_EMAILS == 'false') ? '1' : '0';
						  $sql_data_array = array('orders_id' => $insert_id,
						                          'orders_status_id' => $status_commande,
						                          'date_added' => 'now()',
						                          'customer_notified' => $customer_notification,
						                          'comments' => 'commande FNAC');
						  if ($mode_test<>1)   tep_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);
						
						
						// order total
						
						
						  	$total_ht_txt= round($total_ht, 2);
							$total_ht_txt= str_replace(".", ",", $total_ht_txt) . "";
						    $sql_data_array = array('orders_id' => $insert_id,
						                            'title' => 'Sous-Total HT :',
						                            'text' =>   $total_ht_txt,
						                            'value' => 	$total_ht, 
						                            'class' => "ot_subtotal_ht", 
						                            'sort_order' => "1");
						    if ($mode_test<>1)   tep_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
						
						
						  	$total_ttc_txt= round($total_ttc, 2);
							$total_ttc_txt= str_replace(".", ",", $total_ttc_txt)  . "";
						   $sql_data_array = array('orders_id' => $insert_id,
						                            'title' => '<b>Sous-Total</b>:',
						                            'text' => 	$total_ttc_txt,
						                            'value' => 	$total_ttc,
						                            'class' => "ot_subtotal",
						                            'sort_order' => "2");
						   if ($mode_test<>1)   tep_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);

							

							$frais_port_ttc_txt= round($frais_port_ttc, 2);	
							$frais_port_ttc_txt=  str_replace(".", ",", $frais_port_ttc_txt)  . "";
						    $sql_data_array = array('orders_id' => $insert_id,
						                            'title' => 'La poste',
						                            'text' => $frais_port_ttc_txt,
						                            'value' => 	$frais_port_ttc, 
						                            'class' => "ot_shipping", 
						                            'sort_order' => "4");
						    if ($mode_test<>1)   tep_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);

	
							$montant_total_ttc=floatval($frais_port_ttc+$total_ttc);
							$montant_tva= $montant_total_ttc - ($montant_total_ttc/ (($tva/100)+1) );
			
		
					    	$montant_tva_txt= round($montant_tva, 2);	
							$montant_tva_txt=  str_replace(".", ",", $montant_tva_txt) . "";

							
						    $sql_data_array = array('orders_id' => $insert_id,
						                            'title' => 'TVA:',
						                            'text' => 	$montant_tva_txt,
						                            'value' => 	$montant_tva, 
						                            'class' => "ot_tax", 
						                            'sort_order' => "4");
						    if ($mode_test<>1)   tep_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);

					    	$montant_total_ttc_txt= round($montant_total_ttc, 2);	
							$montant_total_ttc_txt=  "<b>" .str_replace(".", ",", $montant_total_ttc_txt)  . "</b>";

						    $sql_data_array = array('orders_id' => $insert_id,
						                            'title' => 'Montant total TTC  rgler:',
						                            'text' => 	$montant_total_ttc_txt,
						                            'value' => 	$montant_total_ttc, 
						                            'class' => "ot_total", 
						                            'sort_order' => "800");
						    if ($mode_test<>1)   tep_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
				/************************************************** Fin Traitement commande  details***********************************************/
				echo "<hr>";
			}
			else {
				echo  "___commande Fnac trouv___";
				$orders_trouve = tep_db_fetch_array($orders);
				$maj = 1;

				if  ($orders_trouve['orders_status_mp'] == $order_status_id_mp ) $maj = 0;
				if ($maj == 1 )	{
					$sql_data_array_order = array( 'orders_status_mp' => $order_status_id_mp);
					if ($mode_test<>1)  tep_db_perform(TABLE_ORDERS, $sql_data_array_order , 'update', "orders_id = '" . (int)$orders_trouve['orders_id'] . "'" );
				}
			}

    }

  }
  catch(Exception $e)
  {
    // do what you want with exception
    var_dump($e);
  }


/************************************************** Fin Traitement commande ***********************************************/


  /**
   * Simulate a post method
   *
   * @param string   $url              : target url
   * @param string   $data             : xml query
   * @param string   $optional_headers : optional headers
   *
   * @return response of the http request
   */
  /**  deplac dans generale fonction fnac
  function do_post_request($url, $data, $optional_headers = null)
  {


     $ch = curl_init();

     curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
     curl_setopt($ch, CURLOPT_POST, 1); 
     curl_setopt($ch, CURLOPT_URL, $url);
     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
     curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
     curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);


     $response = curl_exec($ch);

     if(0 != curl_errno($ch))
     {
       echo 'curl Error: '.curl_error($ch)."\n<br/>curl info:";
       echo '<pre>';
       print_r(curl_getinfo($ch));
       echo '</pre>';
     }

     curl_close($ch);

    return $response;
  }
   */
?>