<?php
/*
  $Id: kelkoo.php v2.0 2004/10/18

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2004 osCommerce

  Released under the GNU General Public License
*/

  require('includes/application_top.php');
  
$kelkoo_list = TEXT_CONTRY . "\n"; // A modifier au besoin dans le fichier languages
$kelkoo_list .= TEXT_TYPE . "\n";  // A modifier au besoin dans le fichier languages
$kelkoo_list .= TEXT_CURRENCY . "\n"; // A modifier au besoin dans le fichier languages

$kelkoo_subdir = "kelkoo/";
$kelkoo_dir = DIR_FS_CATALOG . $kelkoo_subdir;
$kelkoo_file = "kelkoo.txt";
  
if (!function_exists('html_entity_decode')) {
 function html_entity_decode ($string, $opt = ENT_COMPAT) {
   $trans_tbl = get_html_translation_table (HTML_ENTITIES);
   $trans_tbl = array_flip ($trans_tbl);
   if ($opt & 1) { // Translating single quotes
     // Add single quote to translation table; doesn't appear to be there by default
     $trans_tbl["&apos;"] = "'";
   }
   if (!($opt & 2)) { // Not translating double quotes
     // Remove double quote from translation table
     unset($trans_tbl["&quot;"]);
   }
   return strtr ($string, $trans_tbl); 
 }
}

// Just to be safe;o)$description = ereg_replace('<[^>]*>', '', $description);
if (!defined("ENT_COMPAT")) define("ENT_COMPAT", 2);
if (!defined("ENT_NOQUOTES")) define("ENT_NOQUOTES", 0);
if (!defined("ENT_QUOTES")) define("ENT_QUOTES", 3);

function clean_html_kelkoo($description, $length) {
  global $its_cleaned;
  $its_cleaned = html_entity_decode ($description);
  $its_cleaned = strip_tags ($description);
  $its_cleaned = trim ($its_cleaned);
  $its_cleaned = strtolower ($its_cleaned);
  $its_cleaned = str_replace(chr(9),"",$its_cleaned);  //$its_cleaned = str_replace("\t","",$its_cleaned);
  $its_cleaned = str_replace(chr(10),"",$its_cleaned);//$its_cleaned = str_replace("\n","",$its_cleaned);
  $its_cleaned = str_replace(chr(13),"",$its_cleaned);//$its_cleaned = str_replace("\r","",$its_cleaned);
  $its_cleaned = preg_replace("[<(.*?)>]","",$its_cleaned);
  if (strlen($its_cleaned) > $length) {
    $its_cleaned = substr($its_cleaned, 0, $length-3);
    $its_cleaned .= '...';
  }
  return $its_cleaned;
}  

$kelkoo_list .= "url\ttitle\tdescription\tprice\tofferid\timage\tcategory\tavailability\tdeliverycost\n";

$products_query = tep_db_query("SELECT 
p.products_id, 
p.products_quantity, 
p.products_model, 
p.products_image, 
p.products_price, 
p.products_tax_class_id, 
p.products_compare_expedition, 
pd.products_name, 
pd.products_description, 
cd.categories_name FROM 
" . TABLE_PRODUCTS . " p, 
" . TABLE_PRODUCTS_DESCRIPTION . " pd, 
" . TABLE_PRODUCTS_TO_CATEGORIES . " p2c, 
" . TABLE_CATEGORIES . " c, 
" . TABLE_CATEGORIES_DESCRIPTION . " cd
WHERE p.products_id = pd.products_id 
AND (cd.categories_id = c.parent_id OR (c.parent_id = 0 AND cd.categories_id = c.categories_id))
AND p.products_id = p2c.products_id 
AND c.categories_id = p2c.categories_id 
AND p.products_status = 1 
AND p.products_price <> 0 
AND p.products_compare_status = 1 
AND pd.language_id = '" . (int)$languages_id . "' 
AND cd.language_id = '" . (int)$languages_id . "' 
GROUP BY p.products_id, cd.categories_id 
ORDER BY cd.categories_name, pd.products_name");

$expedition_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key  = 'EXPEDITION_PRICE'");
$expedition_price = tep_db_fetch_array($expedition_query);
// increment pour donner un numro d'offre, prfrable  l'id
$increment = 347;

while($products = tep_db_fetch_array($products_query)) {  
  $increment++;

// Lien vers le produit;
  $kelkoo_list .= tep_catalog_href_link('product_info.php', 'products_id=' . $products['products_id'], 'NONSSL', false) . "\t";

// Nom du produit
  $kelkoo_list .= clean_html_kelkoo($products['products_name'], 80) . "\t";

// Description ou nom  
  $kelkoo_list .= clean_html_kelkoo($products['products_description'], 160) . "\t";

// Prix du produit (price)
  if ($new_price = tep_get_products_special_price($products['products_id'])) {
    $kelkoo_list .= number_format((tep_round($new_price, $currencies->currencies[DEFAULT_CURRENCY]['decimal_places'])) + (tep_calculate_tax($new_price, tep_get_tax_rate($products['products_tax_class_id']))), 2, ',', '') . "\t";
  } else {
    $kelkoo_list .= number_format((tep_round($products['products_price'], $currencies->currencies[DEFAULT_CURRENCY]['decimal_places'])) + (tep_calculate_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']))) , 2, ',', '') . "\t";
  }                   
// Numro de l'offre                     
  $kelkoo_list .= $increment . "\t";

// image
  if (tep_not_null($products['products_image'])) {
     $kelkoo_list .= tep_catalog_href_link(DIR_WS_IMAGES . $products['products_image'], '', 'NONSSL', false) . "\t";
  } else {
     $kelkoo_list .= "no_image\t";
  }

// Categorie
  $kelkoo_list .= $products['categories_name'] . "\t";

// Qt en stock
  if ( $products['products_quantity'] > 0 ) {
    $kelkoo_list .=  "001\t";
  } else {
    $kelkoo_list .=  "003\t";
  }     

// Cout de la livraison
  if ( $products['products_compare_expedition'] == 0 ) {
    $kelkoo_list .= substr($expedition_price['configuration_value'], 0 , 20);
  } else {
    $kelkoo_list .= $products['products_compare_expedition'];
  }

  $kelkoo_list .= "\n";
}

$fp= fopen($kelkoo_dir . $kelkoo_file,"w");
fputs($fp,"$kelkoo_list");
fclose($fp);
?>

<!doctype html>
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->

<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="3">
  <tr>
    <td width="<?php echo BOX_WIDTH; ?>" valign="top"><table border="0" width="<?php echo BOX_WIDTH; ?>" cellspacing="1" cellpadding="1" class="columnLeft">
<!-- left_navigation //-->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- left_navigation_eof //-->
    </table></td>
<!-- body_text //-->
    <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="0">
      <tr>
        <td><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td CLASS="pageHeading"><?php echo HEADING_TITLE; ?></td>
            <td class="pageHeading" align="right"><?php echo tep_draw_separator('pixel_trans.gif', HEADING_IMAGE_WIDTH, HEADING_IMAGE_HEIGHT); ?></td>
          </tr>
        </table></td>
      </tr>
      <tr>
         <td><?php echo tep_draw_separator('pixel_trans.gif', '1', '50'); ?></td>
      <tr>
        <td><table width="100%" cellspacing="0" cellpadding="0" border="0">
          <tr>
            <td class="main">
            <?php
              if (is_file($kelkoo_dir . $kelkoo_file)) {
                $sizefile = 1024*filesize($kelkoo_dir . $kelkoo_file)/pow(2,20);
                $sizeformatted = sprintf("%0.0f Ko", $sizefile);
                $datefile = strftime(DATE_FORMAT_SHORT, filemtime($kelkoo_dir . $kelkoo_file));
                echo TEXT_KELKOO_DOWNLOAD . ' -> <a href="' . tep_catalog_href_link($kelkoo_subdir . $kelkoo_file, '', 'NONSSL', false) . '" target="_blank\">' . '<font color="red">' . $sizeformatted . ' - ' . $datefile . '</font></a>';
              } else echo TEXT_KELKOO_NOFILE . ' ' . $kelkoo_dir; ?>
            </td>
          </tr>
          <tr>
            <td><?php echo tep_draw_separator('pixel_trans.gif', '1', '10') ?></td>
          </tr>
          <tr>
            <td class="main"><?php if (is_file($kelkoo_dir . $kelkoo_file)) echo TEXT_KELKOO_UPLOAD; ?></td>
          </tr>
         </table></td>
      </tr>
    </table></td>
<!-- body_text_eof //-->
  </tr>
</table>
<!-- body_eof //-->

<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- footer_eof //-->
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
