<?php
/*
  $Id: whos_online.php,v 3.4 2008/1/28 SteveDallas Exp $

  2007 Dec 4  v3.3.2 Glen Hoag aka SteveDallas Removed bug introduced by previous contributor that 
                                                prevented cart display if STORE_SESSIONS was set to null
  2007 Dec 2  v3.3.1 Glen Hoag aka SteveDallas Minor fix to correct link for IP lookup
  2007 Dec 1  v3.3   Glen Hoag aka SteveDallas Many fixes for HTML 4.01 DTD conformance
                                               Rewrote product/category name display for robustness
                                               Added product/category name display for Ultimate SEO URLs
                                               Fixed gethostbyname errors 
                                               Rewrote duplicate counting code

  updated version number because of version number jumble and provide installation instructions.

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

  require('includes/application_top.php');

  require(DIR_WS_CLASSES . 'currencies.php');
  $currencies = new currencies();

/*
  Configuration Values
    Set these to easily personalize your Whos Online
*/

// Seconds that a visitor is considered "active"
  $active_time = 300;
// Seconds before visitor is removed from display
  $track_time = 3600;

// Automatic refresh times in seconds and display names
//   Time and Display Text order must match between the arrays
//   "None" is handled separately in the code
  $refresh_time = array(     30,    60,     120,     300,    600 );
  $refresh_display = array( '0:30', '1:00', '2:00', '5:00', '10:00' );

// Images used for status lights
  $status_active_cart = 'icon_status_cart.gif'; // replace word cart with green if you dont want the new icon.
  $status_active_cart_top = 'icon_status_cart_top.gif';
  $status_inactive_cart = 'icon_status_cart_red.gif';
  $status_active_nocart = 'summary_customers.gif';
  $status_inactive_nocart = 'summary_customers_red.gif';
  $status_active_bot = 'icon_status_green_border_light.gif';
  $status_inactive_bot = 'icon_status_red_border_light.gif';

// Text color used for table entries - different colored text for different users
//   Named colors and Hex values should work fine here
  $fg_color_bot = 'maroon';
  $fg_color_admin = 'darkblue';
  $fg_color_guest = 'green';
  $fg_color_account = 'blue'; // '#000000'; // Black

// Added by Erick Cedano aka Graphicore.
// Previous versions required adding this function to admin/includes/functions/general.php
  if (!function_exists("tep_get_ip_address")) {
    function tep_get_ip_address($ip) {
      if (isset($_SERVER)) {
        if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
          $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
          $ip = $_SERVER['HTTP_CLIENT_IP'];
        } else {
          $ip = $_SERVER['REMOTE_ADDR'];
        }
      } else {
        if (getenv('HTTP_X_FORWARDED_FOR')) {
          $ip = getenv('HTTP_X_FORWARDED_FOR');
        } elseif (getenv('HTTP_CLIENT_IP')) {
          $ip = getenv('HTTP_CLIENT_IP');
        } else {
          $ip = getenv('REMOTE_ADDR');
        }
      }
      return $ip;
    }
  }

// Define manually possible name of Bots
  $bot_name = array('google','inktomisearch','crawl');

// Determines status and cart of visitor and displays appropriate icon.
  function tep_check_cart($customer_id, $session_id) {
    global $cart, $status_active_cart, $status_active_cart_top, $status_inactive_cart, $status_active_nocart, $status_inactive_nocart, $status_inactive_bot, $status_active_bot, $active_time;

    // Pull Session data from the correct source.

    if (STORE_SESSIONS == 'mysql') {
      $session_data = tep_db_query("select value from " . TABLE_SESSIONS . " WHERE sesskey = '" . $session_id . "'");
      $session_data = tep_db_fetch_array($session_data);
      $session_data = trim($session_data['value']);
    } else {
      if ((file_exists(tep_session_save_path() . '/sess_' . $session_id)) && (filesize(tep_session_save_path() . '/sess_' . $session_id) > 0)) {
        $session_data = file(tep_session_save_path() . '/sess_' . $session_id);
        $session_data = trim(implode('', $session_data));
      }
    }

    if ($length = strlen($session_data)) {
      if (PHP_VERSION < 4) {
        $start_id = strpos($session_data, 'customer_id[==]s');
        $start_cart = strpos($session_data, 'cart[==]o');
        $start_currency = strpos($session_data, 'currency[==]s');
        $start_country = strpos($session_data, 'customer_country_id[==]s');
        $start_zone = strpos($session_data, 'customer_zone_id[==]s');
      } else {
        $start_id = strpos($session_data, 'customer_id|s');
        $start_cart = strpos($session_data, 'cart|O');
        $start_currency = strpos($session_data, 'currency|s');
        $start_country = strpos($session_data, 'customer_country_id|s');
        $start_zone = strpos($session_data, 'customer_zone_id|s');
      }

      for ($i=$start_cart; $i<$length; $i++) {
        if ($session_data[$i] == '{') {
          if (isset($tag)) {
            $tag++;
          } else {
            $tag = 1;
          }
        } elseif ($session_data[$i] == '}') {
          $tag--;
        } elseif ( (isset($tag)) && ($tag < 1) ) {
          break;
        }
      }

      $session_data_id = substr($session_data, $start_id, (strpos($session_data, ';', $start_id) - $start_id + 1));
      $session_data_cart = substr($session_data, $start_cart, $i);
      $session_data_currency = substr($session_data, $start_currency, (strpos($session_data, ';', $start_currency) - $start_currency + 1));
      $session_data_country = substr($session_data, $start_country, (strpos($session_data, ';', $start_country) - $start_country + 1));
      $session_data_zone = substr($session_data, $start_zone, (strpos($session_data, ';', $start_zone) - $start_zone + 1));

      session_decode($session_data_id);
      session_decode($session_data_currency);
      session_decode($session_data_country);
      session_decode($session_data_zone);
      session_decode($session_data_cart);

      if (PHP_VERSION < 4) {
        $broken_cart = $cart;
        $cart = new shoppingCart;
        $cart->unserialize($broken_cart);
      }

      if (is_object($cart)) {
        $products = $cart->get_products();
      }
    }
		
    $which_query = $session_data;
    $who_data =   tep_db_query("select time_entry, time_last_click
                                 from " . TABLE_WHOS_ONLINE . "
                                 where session_id='" . $session_id . "'");
    $who_query = tep_db_fetch_array($who_data);

    // Determine if visitor active/inactive
    $xx_mins_ago_long = (time() - $active_time);

    if($customer_id < 0) {
	// inactive 
      if ($who_query['time_last_click'] < $xx_mins_ago_long) {
        return tep_image(DIR_WS_IMAGES . $status_inactive_bot, TEXT_STATUS_INACTIVE_BOT);
	// active 
      } else {
        return tep_image(DIR_WS_IMAGES . $status_active_bot, TEXT_STATUS_ACTIVE_BOT);
      }
    }	

    // Determine active/inactive and cart/no cart status
    // no cart
    if ( sizeof($products) == 0 ) {
      // inactive
      if ($who_query['time_last_click'] < $xx_mins_ago_long) {
        return tep_image(DIR_WS_IMAGES . $status_inactive_nocart, TEXT_STATUS_INACTIVE_NOCART);
      // active
      } else {
        return tep_image(DIR_WS_IMAGES . $status_active_nocart, TEXT_STATUS_ACTIVE_NOCART);
      }
    // cart
    } else {
      // inactive
      if ($who_query['time_last_click'] < $xx_mins_ago_long) {
        return tep_image(DIR_WS_IMAGES . $status_inactive_cart, TEXT_STATUS_INACTIVE_CART);
      // active
      } else {
        return tep_image(DIR_WS_IMAGES . $status_active_cart, TEXT_STATUS_ACTIVE_CART);
      }
    }
  }

  /* Display the details about a visitor */
  function display_details() {
    global $whos_online, $is_bot, $is_admin, $is_guest, $is_account;

    // Display Name
    echo '<b>' . TABLE_HEADING_FULL_NAME . ':</b> ' . $whos_online['full_name'];
    echo '<br clear="all">' . tep_draw_separator('pixel_trans.gif', '10', '4') . '<br clear="all">';

    // Display Customer ID for non-bots
    if ( !$is_bot ){
      echo '<b>' . TABLE_HEADING_CUSTOMER_ID . ':</b> ' . $whos_online['customer_id'];
      echo '<br clear="all">' . tep_draw_separator('pixel_trans.gif', '10', '4') . '<br clear="all">';
    }

    //  original code of 2.8      :      echo '<b>' . TABLE_HEADING_IP_ADDRESS . ':</b> ' . $whos_online['ip_address'];  // commenter for whois by azer v1.9

    // Display IP Address modified by azer for 1.9, to be tested if it doesnt work comment the ligne using variable and uncomment the whois url hardcoded ligne
    // whois url hardcoded        :  
    echo '<b>' . TABLE_HEADING_IP_ADDRESS . ':</b> ' . "<a href='http://www.dnsstuff.com/tools/whois.ch?ip=$whos_online[ip_address]' target='_new'>" . $whos_online['ip_address'] . "</a>";
    // whois url with variable added in admin    :     echo '<b>' . TABLE_HEADING_IP_ADDRESS . ':</b> ' . "<a href='" . AZER_WHOSONLINE_WHOIS_URL . $whos_online['ip_address'] . "' target='_new'>" . $whos_online['ip_address'] . "</a>";

    echo '<br clear="all">' . tep_draw_separator('pixel_trans.gif', '10', '4') . '<br clear="all">';

    // Display User Agent
    echo '<b>' . TEXT_USER_AGENT . ':</b> ' . $whos_online['user_agent'];
    echo '<br clear="all">' . tep_draw_separator('pixel_trans.gif', '10', '4') . '<br clear="all">';

    // Display Session ID.  Bots with no Session ID, have it set to their IP address.  Don't display these.
    if ( $whos_online['session_id'] != $whos_online['ip_address'] ) {
      echo '<b>' . TEXT_OSCID . ':</b> ' . $whos_online['session_id'];
      echo '<br clear="all">' . tep_draw_separator('pixel_trans.gif', '10', '4') . '<br clear="all">';
    }

    // Display Referer if available
    if($whos_online['http_referer'] != "" ) {
      echo '<b>' . TABLE_HEADING_HTTP_REFERER . ':</b> ' . $whos_online['http_referer'];
      echo '<br clear="all">' . tep_draw_separator('pixel_trans.gif', '10', '4') . '<br clear="all">';
    }
  }

  // Time to remove old entries
  $xx_mins_ago = (time() - $track_time);

  // remove entries that have expired
  tep_db_query("delete from " . TABLE_WHOS_ONLINE . " where time_last_click < '" . $xx_mins_ago . "'");
?>

<!doctype html>
<html <?php echo HTML_PARAMS; ?>>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">

<!-- WOL 1.6 - Cleaned up refresh -->
<?php if( $_SERVER["QUERY_STRING"] > 0 ){  ?>
    <meta http-equiv="refresh" content="<?php echo htmlspecialchars($_SERVER["QUERY_STRING"]);?>;URL=whos_online.php?<?php echo htmlspecialchars($_SERVER["QUERY_STRING"]);?>">
<?php } ?>
<!-- WOL 1.6 EOF -->

    <title><?php echo TITLE; ?></title>
    <link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
    <script type="text/javascript" language="javascript" src="includes/general.js"></script>
  </head>
  <body>
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->

<!-- body //-->
    <table border="0" width="100%" cellspacing="2" cellpadding="2">
      <tr>
        <td width="<?php echo BOX_WIDTH; ?>" valign="top">
          <table border="0" width="<?php echo BOX_WIDTH; ?>" cellspacing="1" cellpadding="1" class="columnLeft">
<!-- left_navigation //-->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- left_navigation_eof //-->
          </table>
        </td>
<!-- body_text //-->
        <td width="100%" valign="top">
          <table border="0" width="100%" cellspacing="0" cellpadding="2">
            <tr>
              <td>
                <table border="0" width="100%" cellspacing="0" cellpadding="0">
                  <tr>
                    <td valign="bottom" class="pageHeading">
                      <?php echo HEADING_TITLE; ?>
                      <br clear="all"><br><span class="smallText" style="color:#909090"><? echo TEXT_SET_REFRESH_RATE; ?>:&nbsp;</span>
                      <span style="font-size: 10px; color:#0000CC">
            <!-- For loop displays refresh time links -->
            <?php
              echo '                      <a class="menuBoxContentLink" href="whos_online.php"><b> ' . TEXT_NONE_ . ' </b></a>';
              foreach ($refresh_time as $key => $value) {
                echo ' &#183; <a class="menuBoxContentLink" href="whos_online.php?' . $value . '"><b>' . $refresh_display[$key] . '</b></a>';
              }
            ?>
                      </span>

                      <!-- Display Profile links -->
                      <br clear="all">
                      <span class="smallText" style="color:#909090"><?php echo TEXT_PROFILE_DISPLAY; ?>:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                      <span style="font-size: 10px; color:#0000CC">
                      <a href="whos_online.php" class="menuBoxContentLink"><b><?php echo TEXT_NONE_; ?></b></a> &#183;
                      <a href="whos_online.php?showAll" class="menuBoxContentLink"><b><? echo TEXT_ALL; ?></b></a> &#183;
                      <a href="whos_online.php?showBots" class="menuBoxContentLink"><b><? echo TEXT_BOTS; ?></b></a> &#183;
                      <a href="whos_online.php?showCust" class="menuBoxContentLink"><b><? echo TEXT_CUSTOMERS; ?></b></a>
                      </span></span>
                    </td>

<!-- Status Legend - Uses variables for image names -->
                    <td align="right" class="smallText" valign="bottom">
                      <table border="0" cellspacing="0" cellpadding="0">
                        <tr>
                          <td class="smallText"><?php echo
                            tep_image(DIR_WS_IMAGES . $status_active_cart_top, TEXT_STATUS_ACTIVE_CART) . '&nbsp;' . TEXT_STATUS_ACTIVE_CART . '&nbsp;&nbsp;';?>
                          </td>
           	              <td class="smallText"><?php echo
                            tep_image(DIR_WS_IMAGES . $status_inactive_cart, TEXT_STATUS_INACTIVE_CART) . '&nbsp;' . TEXT_STATUS_INACTIVE_CART . '&nbsp;&nbsp;';?>
                          </td>
                        </tr>
                        <tr>
                          <td class="smallText"><?php echo
                            tep_image(DIR_WS_IMAGES . $status_active_nocart, TEXT_STATUS_ACTIVE_NOCART) . '&nbsp;' . TEXT_STATUS_ACTIVE_NOCART   .'&nbsp;&nbsp;';?>
                          </td>
           	              <td class="smallText"><?php echo
                            tep_image(DIR_WS_IMAGES . $status_inactive_nocart, TEXT_STATUS_INACTIVE_NOCART) . '&nbsp;' . TEXT_STATUS_INACTIVE_NOCART   . '&nbsp;&nbsp;';?>
                          </td>
                        </tr>
                        <tr>
                          <td class="smallText"><?php echo
                            tep_image(DIR_WS_IMAGES . $status_active_bot, TEXT_STATUS_ACTIVE_BOT) . '&nbsp;' . TEXT_STATUS_ACTIVE_BOT . '&nbsp;&nbsp;';?>
                          </td>
           	              <td class="smallText"><?php echo
                            tep_image(DIR_WS_IMAGES . $status_inactive_bot, TEXT_STATUS_INACTIVE_BOT) . '&nbsp;' . TEXT_STATUS_INACTIVE_BOT . '&nbsp;&nbsp;';?>
                          </td>
                        </tr>
                      </table>
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
              <td class="pageHeading" align="center">
                <font size="2" face="Arial" color="blue">
                  <script type="text/javascript" language="JavaScript">
                    <!-- Begin
                    Stamp = new Date();
                    document.write('<?php echo TEXT_LAST_REFRESH. '&nbsp;'; ?>');
                    var Hours;
                    var Mins;
                    var Time;
                    Hours = Stamp.getHours();
                    if (Hours >= 12) {
                      Time = " p.m.";
                      Hours -= 12;
                    } else {
                      Time = " a.m.";
                    }
                    if (Hours == 0) {
                      Hours = 12;
                    }
                    Mins = Stamp.getMinutes();
                    if (Mins < 10) {
                      Mins = "0" + Mins;
                    }
                    document.write('&nbsp;' + Hours + ":" + Mins + Time );
                    // End -->
                  </script>
                </font>
              </td>
            </tr>
            <tr>
              <td valign="top">
                <table border="0" width="100%" cellspacing="0" cellpadding="0">
                  <tr>
                    <td valign="top">
                      <table border="0" width="100%" cellspacing="0" cellpadding="2">
                        <tr class="dataTableHeadingRow">
                          <td class="dataTableHeadingContent" colspan="2" nowrap align="center"><?php echo TABLE_HEADING_ONLINE; ?></td>
                          <td class="dataTableHeadingContent" nowrap><?php echo TABLE_HEADING_FULL_NAME; ?></td>
                          <td class="dataTableHeadingContent" nowrap><?php echo TABLE_HEADING_IP_ADDRESS; ?></td>
                          <td class="dataTableHeadingContent" nowrap><?php echo TABLE_HEADING_ENTRY_TIME; ?></td>
                          <td class="dataTableHeadingContent" nowrap><?php echo TABLE_HEADING_LAST_CLICK; ?></td>
                          <td class="dataTableHeadingContent" width="200"><?php echo TABLE_HEADING_LAST_PAGE_URL; ?>&nbsp;</td>
                          <td class="dataTableHeadingContent" align="center"><?php echo TABLE_HEADING_USER_SESSION; ?>&nbsp;</td>
                          <td class="dataTableHeadingContent" align="center" nowrap><?php echo TABLE_HEADING_HTTP_REFERER; ?>&nbsp;</td>
                        </tr>

<?php
  // Order by is on Last Click. Also initialize total_bots and total_admin counts
  $whos_online_query = tep_db_query("select customer_id, full_name, ip_address, time_entry, time_last_click, last_page_url, http_referer, user_agent, session_id from " . TABLE_WHOS_ONLINE . ' order by time_last_click DESC');
  $total_bots = 0;
  $total_admin = 0;
  $total_guests = 0;
  $total_loggedon = 0;
  $total_dupes = 0;
  $total_non = 0;
  $ip_addrs = array();

  while ($whos_online = tep_db_fetch_array($whos_online_query)) {
    $whos_online_non = false;
    $time_online = ($whos_online['time_last_click'] - $whos_online['time_entry']);
    if ((!isset($HTTP_GET_VARS['info']) || (isset($HTTP_GET_VARS['info']) && ($HTTP_GET_VARS['info'] == $whos_online['session_id']))) && !isset($info)) {
      $info = $whos_online['session_id'];
    }

    //Get hostname from IP address
    if (strstr($whos_online['ip_address'], ',')) {
      //if multiple responses, use first one
      $ips = explode(',', $whos_online['ip_address']);
      $whos_online['ip_address'] = $ips[0];
    }
    if ($whos_online['ip_address'] == 'unknown') {
      $hostname = $whos_online['ip_address'];
    } else {
      $hostname = gethostbyaddr($whos_online['ip_address']);
    }			

    //Check for duplicates
    if (in_array($whos_online['ip_address'],$ip_addrs)) {
		$total_dupes++; 
		$whos_online_non=true;
	}
    $ip_addrs[] = $whos_online['ip_address'];

    if ($whos_online['session_id'] == $info) {
       if($whos_online['http_referer'] != "")
       {
        $http_referer_url = $whos_online['http_referer'];
       }
      echo '
                        <tr id="defaultSelected" class="dataTableRowSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">' . "\n";
    } else {
      echo '
                        <tr class="dataTableRow" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="document.location.href=\'' . tep_href_link(FILENAME_WHOS_ONLINE, tep_get_all_get_params(array('info', 'action')) . 'info=' . $whos_online['session_id'], 'NONSSL') . '\'">' . "\n";
    }

    // Display Status
    //   Check who it is and set values
    $is_bot = $is_admin = $is_guest = $is_account = false;

    // Bot detection
    // Manual detection by Erick Cedano
    $ec=0;
    while($ec < count($bot_name)) {
      if (strstr($hostname,$bot_name[$ec])) {
	  $ecbot = true;
	}     
	$ec++;
    }
    // End of Manual Detection

    if (($whos_online['customer_id'] < 0) or ($ecbot == 'true')) {  // Modified by Erick Cedano
      $total_bots++;
      $whos_online_non=true;
      $fg_color = $fg_color_bot;
      $is_bot = true;
      $ecbot = false;

      // Admin detection
//    } elseif ($whos_online['ip_address'] == tep_get_ip_address() ) {
    } elseif ($whos_online['ip_address'] == $_SERVER["REMOTE_ADDR"]) {
      $total_admin++;
      $fg_color = $fg_color_admin;
      $is_admin = true;
    // Guest detection (may include Bots not detected by Prevent Spider Sessions/spiders.txt)
    } elseif ($whos_online['customer_id'] == 0) {
      $fg_color = $fg_color_guest;
      $is_guest = true;
      $total_guests++;
    // Everyone else (should only be account holders)
    } else {
      $fg_color = $fg_color_account;
      $is_account = true;
      $total_loggedon++;
    }
	if ($whos_online_non) {$total_non++;};
?>
                          <!-- Status Light -->
                          <td class="dataTableContent" align="left" valign="top"><?php echo '&nbsp;' . tep_check_cart($whos_online['customer_id'], $whos_online['session_id']); ?></td>

                          <!-- Time Online -->
                          <td class="dataTableContent" valign="top"><font color="<?php echo $fg_color; ?>"><?php echo gmdate('H:i:s', $time_online); ?></font>&nbsp;</td>

                          <!-- Name -->
                          <?php
                          echo '
                          <td class="dataTableContent" valign="top"><font color="' . $fg_color .'">';

                          // WOL 1.6 Restructured to Check for Guest or Admin
                          if ( $is_guest || $is_admin ){
                            echo $whos_online['full_name'] . '&nbsp;';
                          // Check for Bot
                          } elseif ( $is_bot ) {
                            // Tokenize UserAgent and try to find Bots name
                            $tok = strtok($whos_online['full_name']," ();/");
                            while ($tok !== false) {  // edited from forum perfectpassion
                              if ( strlen(strtolower($tok)) > 3 )
                                if ( !strstr(strtolower($tok), "mozilla") &&
                                     !strstr(strtolower($tok), "compatible") &&
                                     !strstr(strtolower($tok), "msie") &&
                                     !strstr(strtolower($tok), "windows")
                                   ) {
                                  echo "$tok";
                                  break;
                                }
                              $tok = strtok(" ();/");
                            }
                          // Check for Account
                          } elseif ( $is_account ) {
                            echo '<a HREF="customers.php?selected_box=customers&cID=' . $whos_online['customer_id'] . '&action=edit">';
                            echo '<font color="' . $fg_color . '">' . $whos_online['full_name'] . '</font></a>';
                          } else {
                            echo TEXT_ERROR;
                          }
                          echo '</font></td>';
                          ?>

                          <!-- IP Address -->
                          <td class="dataTableContent" valign="top"> 
                            <?php
                            // Show 'Admin' instead of IP for Admin
                            if ( $is_admin ) {
                              echo '<font color="' . $fg_color . '">' . TEXT_ADMIN . '</font>' . "\n";
                            } elseif ( $hostname == 'unknown' ) {
                              echo '<font color="' . $fg_color . '">' . $hostname . '</font>' . "\n";
                            } else {
                              echo '<a href="http://www.showmyip.com/?ip=' . $whos_online['ip_address'] . '&amp;get=nmap" target="_blank">';
                              echo '<font color="' . $fg_color . '">' . $hostname . '</font></a>' . "\n";
                            }
                            ?>
                          </td>

                          <!-- Time Entry -->
                          <td class="dataTableContent" valign="top"><font color="<?php echo $fg_color; ?>"><?php echo date('H:i:s', $whos_online['time_entry']); ?></font></td>

                          <!-- Last Click -->
                          <td class="dataTableContent" align="center" valign="top"><font color="<?php echo $fg_color; ?>"><?php echo date('H:i:s', $whos_online['time_last_click']); ?></font>&nbsp;</td>

                          <!-- Last URL -->
                          <td class="dataTableContent" valign="top"><?php
                            $temp_url_link = $whos_online['last_page_url'];
                            if (eregi('^(.*)' . tep_session_name() . '=[a-f,0-9]+[&]*(.*)', $whos_online['last_page_url'], $array)) {
                              $temp_url_display =  $array[1] . $array[2];
                            } else {
                              $temp_url_display = $whos_online['last_page_url'];
                            }

                            // WOL 1.6 - Removes osCsid from the Last Click URL and the link
                            if ( $osCsid_position = strpos($temp_url_display, "osCsid") )
                              $temp_url_display = substr_replace($temp_url_display, "", $osCsid_position - 1 );
                            if ( $osCsid_position = strpos($temp_url_link, "osCsid") )
                              $temp_url_link = substr_replace($temp_url_link, "", $osCsid_position - 1 );

                            // escape any special characters to conform to HTML DTD
                            $temp_url_display = htmlspecialchars($temp_url_display);

                            // alteration for last url product name  bof
                            if (strpos($temp_url_link,'product_info.php')) {
                              if (strpos($temp_url_link,'products_id=')) {
                                //Standard osC install using parameters
                                $temp = strstr($temp_url_link,'?');
                                $temp=str_replace('?','',$temp);
                                $parameters=split("&",$temp);

                                $i=0;
                                while($i < count($parameters)) {
                                  $a=split("=",$parameters[$i]);
                                  if ($a[0]=="products_id") { $products_id=$a[1]; }
                                  $i++;
                                }
                              } elseif (strpos($temp_url_link,'products_id/')) {
                                //osC search-engine safe URL
                                $temp = strstr($temp_url_link,'products_id');
                                $temparr=split("\/",$temp);
                                $products_id=$temparr[1];
                              } else {
                                //couldn't figure it out
                                $products_id = '';
                              }
                              if ($products_id) {
                                $product_query=tep_db_query("select products_name from products_description where products_id='" . $products_id . "' and language_id = '" . $languages_id . "'");
                                $product = tep_db_fetch_array($product_query);                           
                                $display_link = $product['products_name'].' <i>(Produit)</i>';
                              } else {
                                $display_link = $temp_url_display;
                              }
                            } elseif (strpos($temp_url_link,'cPath')) {
                              if (strpos($temp_url_link,'cPath=')) {
                                //Standard osC install using parameters
                                $temp = strstr($temp_url_link,'?');
                                $temp=str_replace('?','',$temp);
                                $parameters=split("&",$temp);

                                $i=0;
                                while($i < count($parameters)) {
                                  $a=split("=",$parameters[$i]);
                                  if ($a[0]=="cPath") { $cat=$a[1]; }
                                  $i++;
                                }
                              } elseif (strpos($temp_url_link,'cPath/')) {
                                //osC search-engine safe URL
                                $temp = strstr($temp_url_link,'cPath');
                                $temparr=split("\/",$temp);
                                $cat=$temparr[1];
                              } else {
                                //couldn't figure it out
                                $cat = '';
                              }

                              $parameters=split("_",$cat);
 
                              $i=0;
                              while($i < count($parameters)) {
                                $category_query=tep_db_query("select categories_name from categories_description where categories_id='" . $parameters[$i] . "' and language_id = '" . $languages_id . "'");
                                $category = tep_db_fetch_array($category_query);                           
                                if ($i>0) { $cat_list.=' / ' . $category['categories_name']; } else { $cat_list=$category['categories_name']; }

                                $i++; 
                              }
                              $display_link = $cat_list.' <i>(Categorie)</i>';
                            } else {
                              $display_link = $temp_url_display;
                            }

                            // alteration for last url product name  eof
 
                            // Get product and category from Ultimate SEO URLs bof
                            if ( preg_match('/^(.*)-p-(.*).html/',$temp_url_link,$matches) ) {
                              $products_id=$matches[2];
                              $product_query=tep_db_query("select products_name from products_description where products_id='" . $products_id . "' and language_id = '" . $languages_id . "'");
                              $product = tep_db_fetch_array($product_query);

                              $display_link = $product['products_name'].' <i>(Product)</i>';
                            } elseif ( preg_match('/^(.*)-c-(.*).html/',$temp_url_link,$matches) ) {
                              $cat=$matches[2];
                              $parameters=split("_",$cat);

                              $i=0;
                              while($i < count($parameters)) {
                                $category_query=tep_db_query("select categories_name from categories_description where categories_id='" . $parameters[$i] . "' and language_id = '" . $languages_id . "'");
                                $category = tep_db_fetch_array($category_query);                           
                                if ($i>0) { $cat_list.=' / '.$category['categories_name']; } else { $cat_list=$category['categories_name']; }
 
                                $i++;
                              }
                              $display_link = $cat_list.' <i>(Categorie)</i>';
                            }
                            // Get product and category from Ultimate SEO URLs eof

                            echo '<a HREF="' . (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . htmlspecialchars($temp_url_link) . '" target="_blank"><font color="' . $fg_color . '">' . $display_link . '</font></a></td>';
                          ?>

                          <!-- osCsid? -->
                          <td class="dataTableContent" align="center" valign="top"><font color="<?php echo $fg_color; ?>"><?php echo (($whos_online['session_id'] != $whos_online['ip_address']) ? TEXT_IN_SESSION : TEXT_NO_SESSION);?></font></td>

                          <!-- Referer? -->
                          <td class="dataTableContent" align="center" valign="top"><font color="<?php echo $fg_color; ?>"><?php echo (($whos_online['http_referer'] == "") ? TEXT_HTTP_REFERER_NOT_FOUND : TEXT_HTTP_REFERER_FOUND);?></font></td>
                        </tr>

                      <?php
                        if ( $_SERVER["QUERY_STRING"] == showAll || ($_SERVER["QUERY_STRING"] == showBots && $is_bot) || ($_SERVER["QUERY_STRING"] == showCust && ( $is_guest || $is_account || $is_admin )) ) {
                      ?>
                        <tr class="dataTableRow">
                          <td class="dataTableContent" colspan="3"></td>
                          <td class="dataTableContent" colspan="6"><font color="<?php echo $fg_color; ?>"><?php display_details(); ?></font></td>
                        </tr>
                      <?php
                        }
    } // closes "while" statement
                      ?>
<?php
  //Display HTTP referer, if any
  if(isset($http_referer_url)) {
?>
                        <tr>
	                    <td class="smallText" colspan="9"><?php echo '<strong>' . TEXT_HTTP_REFERER_URL . ':</strong><a href="' . htmlspecialchars($http_referer_url) . '" target="_blank">' . htmlspecialchars($http_referer_url) . '</a>'; ?></td>
                        </tr>
<?php
  }
?>
<?php
  $total_sess = tep_db_num_rows($whos_online_query);
  // Subtract Bots and Me from Real Customers.  Only subtract me once as Dupes will remove others
  $total_cust = $total_sess - $total_non - ($total_admin > 1? 1 : $total_admin);
?>
                        <tr>
                          <!-- WOL 1.4 - Added Bot and Me counts -->
                          <td class="smallText" colspan="9"><br>
                            <table border="0" cellpadding="0" cellspacing="0" width="600">
                              <tr>
		                    <td class="smallText" align="left" colspan="2">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php echo sprintf(TEXT_NUMBER_OF_CUSTOMERS, $total_sess);?></td>
	                        </tr>
	                        <tr>
		                    <td class="smallText" align="right" width="30"><?php print "$total_dupes" ?></td>
		                    <td class="smallText" align="left" width="570">&nbsp;&nbsp;<?php echo TEXT_DUPLICATE_IP; ?></td>
	                        </tr>
	                        <tr>
		                    <td class="smallText" align="right" width="30"><?php print "$total_bots" ?></td>
		                    <td class="smallText" width="570">&nbsp;&nbsp;<?php echo TEXT_BOTS; ?></td>
	                        </tr>
	                        <tr>
                                <td class="smallText" align="right" width="30"><?php print "$total_admin" ?></td>
                                <td class="smallText" width="570">&nbsp;&nbsp;<?php echo TEXT_ME; ?></td>
                              </tr>
                              <tr>
                                <td class="smallText" align="right" width="30"><?php print "$total_cust" ?></td>
                                <td class="smallText" width="570">&nbsp;&nbsp;<?php echo TEXT_REAL_CUSTOMERS; ?></td>
                              </tr>
                            </table><br>
                            <?php echo "<b>" . TEXT_MY_IP_ADDRESS . ":</b>&nbsp;".$_SERVER["REMOTE_ADDR"]; ?><br>
                            <?php echo TEXT_NOT_AVAILABLE;?>
                          </td>
                          <!-- WOL 1.4 eof -->
                        </tr>
                      </table>
                    </td>

<?php
  $heading = array();
  $contents = array();

  $heading[] = array('text' => '<b>' . TABLE_HEADING_SHOPPING_CART . '</b>');

  if (isset($info)) {
    if (STORE_SESSIONS == 'mysql') { // Modified by Erick Cedano
      $session_data = tep_db_query("select value from " . TABLE_SESSIONS . " WHERE sesskey = '" . $info . "'");
      $session_data = tep_db_fetch_array($session_data);
      $session_data = trim($session_data['value']);
    } else {
      if ( (file_exists(tep_session_save_path() . '/sess_' . $info)) && (filesize(tep_session_save_path() . '/sess_' . $info) > 0) ) {
        $session_data = file(tep_session_save_path() . '/sess_' . $info);
        $session_data = trim(implode('', $session_data));
      }
    }
    if ($length = strlen($session_data)) {

      if (PHP_VERSION < 4) {
        $start_id = strpos($session_data, 'customer_id[==]s');
        $start_cart = strpos($session_data, 'cart[==]o');
        $start_currency = strpos($session_data, 'currency[==]s');
        $start_country = strpos($session_data, 'customer_country_id[==]s');
        $start_zone = strpos($session_data, 'customer_zone_id[==]s');
      } else {
        $start_id = strpos($session_data, 'customer_id|s');
        $start_cart = strpos($session_data, 'cart|O');
        $start_currency = strpos($session_data, 'currency|s');
        $start_country = strpos($session_data, 'customer_country_id|s');
        $start_zone = strpos($session_data, 'customer_zone_id|s');
      }

      for ($i=$start_cart; $i<$length; $i++) {
        if ($session_data[$i] == '{') {
          if (isset($tag)) {
            $tag++;
          } else {
            $tag = 1;
          }
        } elseif ($session_data[$i] == '}') {
          $tag--;
        } elseif ( (isset($tag)) && ($tag < 1) ) {
          break;
        }
      }

      $session_data_id = substr($session_data, $start_id, (strpos($session_data, ';', $start_id) - $start_id + 1));
      $session_data_cart = substr($session_data, $start_cart, $i);
      $session_data_currency = substr($session_data, $start_currency, (strpos($session_data, ';', $start_currency) - $start_currency + 1));
      $session_data_country = substr($session_data, $start_country, (strpos($session_data, ';', $start_country) - $start_country + 1));
      $session_data_zone = substr($session_data, $start_zone, (strpos($session_data, ';', $start_zone) - $start_zone + 1));

      session_decode($session_data_id);
      session_decode($session_data_currency);
      session_decode($session_data_country);
      session_decode($session_data_zone);
      session_decode($session_data_cart);

      if (PHP_VERSION < 4) {
        $broken_cart = $cart;
        $cart = new shoppingCart;
        $cart->unserialize($broken_cart);
      }

      if (is_object($cart)) {
        $products = $cart->get_products();
        for ($i = 0, $n = sizeof($products); $i < $n; $i++) {
          $contents[] = array('text' => $products[$i]['quantity'] . ' x ' . $products[$i]['name']);
        }
      if (sizeof($products) > 0) {
        $contents[] = array('text' => tep_draw_separator('pixel_black.gif', '100%', '1'));
        $contents[] = array('align' => 'right', 'text' => TEXT_SHOPPING_CART_SUBTOTAL . ' ' . $currencies->format($cart->show_total(), true, $currency));
      } else {
        $contents[] = array('text' => '<i>' . TEXT_EMPTY . '</i>');
      }
    }
  }
 }
   // Show shopping cart contents for selected entry
?>
                    <td valign="top">
 <?php
  $box = new box;
   echo $box->infoBox($heading, $contents);
?>
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
          </table>
        </td>
<!-- body_text_eof //-->
      </tr>
    </table>
<!-- body_eof //-->

<!-- footer //-->
    <?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- footer_eof //-->
    <br>
  </body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>