<?php
/*
  $Id: abxAPIQueue.php,v 1.6 2008/10/23 21:19:20 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/
  if (class_exists('abxDatabase') === false) {
    require_once(DIR_FS_ABX_CLASSES . 'abxDatabase.php');
    $abxDatabase = &abxDatabase::connect(DB_SERVER, DB_SERVER_USERNAME, DB_SERVER_PASSWORD);
    $abxDatabase->selectDatabase(DB_DATABASE);
  }

  class abxAPIQueue {

	function add($method, $data, $custom = null)
	{
		global $abxDatabase;
	      
		$api = array(
		  'method' 		=> $method,
		  'data'        => serialize($data),
		  'status'		=> 0,
		  'created'     => 'now()',
		  'custom1'		=> $custom
		);
		
		return $abxDatabase->insert(TABLE_ABX_API_QUEUE, $api);
    }
    
    function process()
    {
      global $abxDatabase;

      // Let's only process 5 API calls at a time
      $query = $abxDatabase->query('SELECT id, method, retries, data FROM ' . TABLE_ABX_API_QUEUE . ' WHERE status = 0 AND retries < 3 LIMIT 5');
      $count = 0;

      while ($api_method = $query->next())
      {
      	$data = unserialize($api_method['data']);

      	// do the api call
        $response = abxAPI::call($api_method['method'], $data);
        if(abxAPI::isError($response))
        {
			// capture the error and add a retry.  We stop retrying after 3 failures.
			$update = array(
			  'status'		=> 0,
			  'retries'		=> $api_method['retries'] + 1,
			  'updated'     => 'now()',
			  'return_code' => $response['message']
			);
			$abxDatabase->update(TABLE_ABX_API_QUEUE, $update, 'id = ' . $api_method['id']);
        }
        else
        {
			// change the status code so that we do not re-process
			$update = array(
			  'status'		=> 1,
			  'updated'     => 'now()',
			  'return_code' => $response['message']
			);
			$abxDatabase->update(TABLE_ABX_API_QUEUE, $update, 'id = ' . $api_method['id']);
        }

		$count++;
      }

      return $count;
    }
    
    function cleanup()
    {
      global $abxDatabase;
      
      $abxDatabase->query('DELETE FROM ' . TABLE_ABX_API_QUEUE . ' WHERE updated < DATE_SUB(now(), INTERVAL 30 DAY)');
    }
  }//end class
?>