<?php
/*
  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  AuctionBlox, Inc.
  Copyright (c) 2008 AuctionBlox, Inc.
  http://www.auctionblox.com

  Released under the GNU General Public License
*/

  class_exists('abxCurrenciesIpn') || require_once(DIR_FS_ABX_EXTERNAL_CART . 'includes/classes/abxCurrenciesIpn.php');    
  class_exists('abxBasketService') || require_once(dirname(__FILE__).'/abxBasketService.php');
  class_exists('abxAttributes')    || require_once(DIR_FS_ABX_EXTERNAL . CART_INTEGRATION . '/includes/classes/abxAttributes.php');
  
//  define('ABX_DEFAULT_ORDER_STATUS_ID', DEFAULT_ORDERS_STATUS_ID); // You can change that do any order status id
  
  class abxOrderService
  {
    var $orderId,
        $customerId,
        $customerPassword,
        $currency;
    
    function saveOrder(&$orderInfo)
    {
      global $abxDatabase, $languages_id;
      
      if(isset($orderInfo['order']['orderItem']['title']))
      {
        // Means we only have *1* order item, and the array structure is different...sucks!
        $orderItems = array($orderInfo['order']['orderItem']);
      }
      else
      {
        // Already have an array like we want when order items >= 2
        $orderItems = $orderInfo['order']['orderItem'];
      }
      
      $saleIds = array();
      foreach($orderItems as $orderItem)
      {
        $saleIds[] = $orderItem['saleId'];
        if(!intval($orderItem['productId']))
        {
          //var_dump($orderInfo['order']);
          return array('code' => 'error.order.missing-productid', 'order' => $orderInfo['order']['orderNumber']);
        }
      }
      
      // Look up any existing order for these sales
      // Ensure that all sales are on the order
      $sales = abxBasketService::getBasketItemsByUuid($saleIds);      
      
      if(sizeof($sales) !== sizeof($saleIds))
      {
        return array('code' => 'error.sales.incomplete');
      }
      
      foreach($sales as $sale)
      {
        if((int)($sale['orders_id']) > 0)
          return array('code' => 'error.order.completed', 'orderId' => $sale['orders_id']);
      }
      
      $attr = new abxAttributes();      
      
      // Determine the correct order status
      reset($sales);
      $orderStatus = AUCTIONBLOX_ORDER_PROCESSED_STATUS;    // We assume no attributes first!
      foreach($sales as $sale)
      {
        if($attr->hasAttributes($sale['products_id']))
        {
          // We have at least one product with attributes, so put the order in pending status
          $orderStatus = AUCTIONBLOX_ORDER_PENDING_STATUS;
        }
      }

      // get buyer info
      $buyerCountryId       = $this->getCountryIdByIsoCode($orderInfo['order']['billingAddress']['country']);
      $buyerZoneId          = $this->getZoneIdByState($orderInfo['order']['billingAddress']['state'],$buyerCountryId);
      $buyerCountryInfo     = $this->getCountryInfo($buyerCountryId);    
      
      //  Create the customer details
      if ($customerDetails = $this->getCustomer($orderInfo['order']['buyer']['email'])) {
            $customerCountryDetails = $this->getCountryInfo($customerDetails['entry_country_id']); 
        
            $customerArray = array(   
                'customers_id'                  => $customerDetails['customers_id'],
                'customers_name'                => $customerDetails['customers_firstname'] . ' ' . $customerDetails['customers_lastname'],
                'customers_company'             => null,
                'customers_street_address'      => $customerDetails['entry_street_address'],
                'customers_city'                => $customerDetails['entry_city'],
                'customers_postcode'            => $customerDetails['entry_postcode'],
                'customers_state'               => $customerDetails['entry_state'],
                'customers_country'             => $customerCountryDetails['countries_name'],
                'customers_telephone'           => $orderInfo['order']['billingAddress']['phone'],
                'customers_email_address'       => $orderInfo['order']['buyer']['email'],
                'customers_address_format_id'   => $customerCountryDetails['address_format_id'])
            ;
      } else {
            $customerId = $this->createCustomer($orderInfo, $buyerCountryId, $buyerZoneId);
            $customerArray = array(   
                'customers_id'                  => $customerId,
                'customers_name'                => $orderInfo['order']['billingAddress']['fullName'],
                'customers_company'             => null,
                'customers_street_address'      => rtrim(implode(",", array($orderInfo['order']['billingAddress']['street1'],$orderInfo['order']['billingAddress']['street2'])),","),
                'customers_city'                => $orderInfo['order']['billingAddress']['city'],
                'customers_postcode'            => $orderInfo['order']['billingAddress']['postalCode'],
                'customers_state'               => $orderInfo['order']['billingAddress']['state'],
                'customers_country'             => $buyerCountryInfo['countries_name'],
                'customers_telephone'           => $orderInfo['order']['billingAddress']['phone'],
                'customers_email_address'       => $orderInfo['order']['buyer']['email'],
                'customers_address_format_id'   => $buyerCountryInfo['address_format_id'])
            ;       
      }
        
      
      $sql_data_array = array(    
            'delivery_name'                 => $orderInfo['order']['shippingAddress']['fullName'],
            'delivery_company'              => null,
            'delivery_street_address'       => rtrim(implode(",", array($orderInfo['order']['shippingAddress']['street1'],$orderInfo['order']['shippingAddress']['street2'])),","),
            'delivery_city'                 => $orderInfo['order']['shippingAddress']['city'],
            'delivery_postcode'             => $orderInfo['order']['shippingAddress']['postalCode'],
            'delivery_state'                => $orderInfo['order']['shippingAddress']['state'],
            'delivery_country'              => $buyerCountryInfo['countries_name'],
            'delivery_address_format_id'    => $buyerCountryInfo['address_format_id'],
            'billing_name'                  => $orderInfo['order']['billingAddress']['fullName'],
            'billing_company'               => null,
            'billing_street_address'        => rtrim(implode(",", array($orderInfo['order']['billingAddress']['street1'],$orderInfo['order']['billingAddress']['street2'])),","),
            'billing_city'                  => $orderInfo['order']['billingAddress']['city'],
            'billing_postcode'              => $orderInfo['order']['billingAddress']['postalCode'],
            'billing_state'                 => $orderInfo['order']['billingAddress']['state'],
            'billing_country'               => $buyerCountryInfo['countries_name'],
            'billing_address_format_id'     => $buyerCountryInfo['address_format_id'],
            'payment_method'                => $orderInfo['order']['transaction']['paymentMethod'],
            'last_modified'                 => date("Y-m-d H:i:s"), // we need to convert from UTC - date_to_sql_date_format($orderInfo['order']['transaction']['timestamp']),
            'date_purchased'                => date("Y-m-d H:i:s"), // we need to convert from UTC - date_to_sql_date_format($orderInfo['order']['transaction']['timestamp']),
            'orders_status'                 => $orderStatus,
            'currency'                      => $orderInfo['order']['transaction']['currency'],
            'currency_value'                => 1
      ); 
      
      $sql_data_array = array_merge($customerArray, $sql_data_array);

      $this->orderId = $abxDatabase->insert(TABLE_ORDERS, $sql_data_array);

      // create items
      reset($orderItems);
      foreach ($orderItems as $orderItem) 
      {
        $this->addOrderProduct($orderItem);         
      }

      // We've verified that these are the same sales...we looked them up
      $listingIds = array();
      reset($sales);
      foreach($sales as $sale)
      {
        if(!$attr->hasAttributes($sale['products_id']))
          abxBasketService::setOrderId($this->orderId, $sale['auction_basket_id'], true);  // move sale to checked out as well
        else
        {
          abxBasketService::setOrderId($this->orderId, $sale['auction_basket_id'], false);
        }
        
        $listingIds[] = $sale['ext_id'];
      }
      
      
    
      $subTotal = (DISPLAY_PRICE_WITH_TAX == 'true') ? $orderInfo['order']['total'] : $orderInfo['order']['total'] - $orderInfo['order']['tax'];

      $this->orderTotals[] = $this->createOrderTotal($this->orderId, 'ot_subtotal', 1, $orderInfo['order']['subtotal'], $orderInfo['order']['transaction']['currency'], 'Subtotal');
      $this->orderTotals[] = $this->createOrderTotal($this->orderId, 'ot_tax',      2, $orderInfo['order']['tax'],      $orderInfo['order']['transaction']['currency'], 'Tax');
      $this->orderTotals[] = $this->createOrderTotal($this->orderId, 'ot_shipping', 3, $orderInfo['order']['shipping'], $orderInfo['order']['transaction']['currency'], $orderInfo['order']['shippingMethod']); 
      $this->orderTotals[] = $this->createOrderTotal($this->orderId, 'ot_total',    4, $orderInfo['order']['total'],    $orderInfo['order']['transaction']['currency'], 'Total', true);

      $comment =    "AuctionBlox Order Import" . "\r\n"  .
                    " Payment Status    = " . $orderInfo['order']['transaction']['status'] . "\r\n" .
                    " Payment Method    = " . $orderInfo['order']['transaction']['paymentMethod'] . "\r\n" . 
                    " Payment Id        = " . $orderInfo['order']['transaction']['transactionId'] . "\r\n" .
                    " Payment Date      = " . $orderInfo['order']['transaction']['timestamp'].  " UTC\r\n" .
                    " Payment Amount    = " . abxCurrenciesIpn::format($orderInfo['order']['transaction']['amount'], $orderInfo['order']['transaction']['currency']) . "\r\n" . 
                    " Payment Currency  = " . $orderInfo['order']['transaction']['currency'] .  "\r\n" .
                    " eBay User ID      = " . $orderInfo['order']['buyer']['userId'] . "\r\n" .
                    " eBay Item(s)      = " . implode(', ', $listingIds);

      
      $this->orderStatusHistory = $this->createStatusHistory($this->orderId, $orderStatus, $comment);

      return array('code' => 'success', 'orderId' => $this->orderId);
    }

    function createOrderTotal ($orderId, $class, $sortOrder, $value, $currencyCode, $title, $bold=false) {

        global $abxDatabase;

        $formattedValue = abxCurrenciesIpn::format($value, $currencyCode);

        $text = ($bold)
              ? "<b>" . $formattedValue . "</b>"
              : $formattedValue;

        $sql_data_array = array(
            'orders_id'         => $orderId,
            'title'             => $title,
            'text'              => $text,
            'value'             => $value,
            'class'             => $class,
            'sort_order'        => $sortOrder
        );

        $sql_data_array['id'] = $abxDatabase->insert(TABLE_ORDERS_TOTAL, $sql_data_array);

        return $sql_data_array;
    }

    /*
        This function should be extended to notify customer etc.
    */
    function createStatusHistory ($orderId, $status, $comment) {

        global $abxDatabase;
        $sql_data_array = array(
            'orders_id'         => $orderId,
            'orders_status_id'  => $status,
            'date_added'        => 'now()',
            'customer_notified' => 0,
            'comments'          => $comment
        );

        $sql_data_array['id'] = $abxDatabase->insert(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);

        return $sql_data_array;
    }

    function addOrderProduct (&$itemDetails) {

        global $abxDatabase;

        $model = '';
        if(intval($itemDetails['productId']))
        {
            if (STOCK_LIMITED == 'true') {
                if (DOWNLOAD_ENABLED == 'true') {
                    $stock_query_raw = "SELECT          products_quantity, pad.products_attributes_filename " .
                                       "FROM " .        TABLE_PRODUCTS . " p " .
                                       "LEFT JOIN " .   TABLE_PRODUCTS_ATTRIBUTES . " pa " .
                                       "ON              p.products_id=pa.products_id " .
                                       "LEFT JOIN " .   TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad " .
                                       "ON              pa.products_attributes_id=pad.products_attributes_id " .
                                       "WHERE           p.products_id = " . (int)$itemDetails['productId'];
    
                    $stock_values = $abxDatabase->fetch_row($stock_query_raw);
                } else {
                    $stock_values = $abxDatabase->fetch_row("select products_quantity from " . TABLE_PRODUCTS . " where products_id = " . (int)$itemDetails['productId']);
                }
    
                if (!empty($stock_values) > 0) {
    
                    // do not decrement quantities if products_attributes_filename exists
                    if (DOWNLOAD_ENABLED != 'true' || !$stock_values['products_attributes_filename'])
                        $stock_left = $stock_values['products_quantity'] - (int)$itemDetails['quantity'];
                    else
                        $stock_left = $stock_values['products_quantity'];
    
                    $abxDatabase->update(TABLE_PRODUCTS, array('products_quantity' => $stock_left), 'products_id = ' . (int)$itemDetails['productId']);
    
                    if ($stock_left < 1 && STOCK_ALLOW_CHECKOUT == 'false')
                      $abxDatabase->update(TABLE_PRODUCTS, array('products_status' => 0), 'products_id = ' . (int)$itemDetails['productId']);
                }
            }

            // Update products_ordered (for bestsellers list)
            $query = "UPDATE " . TABLE_PRODUCTS . " SET products_ordered = products_ordered + " . (int)$itemDetails['quantity'] . " WHERE products_id = " . (int)$itemDetails['productId'];
            $abxDatabase->query($query);
            
            $model = $this->getProductModel($itemDetails['productId']);
        }

        // calculate net from gross
        $taxRate = 0;

        if ($itemDetails['tax'] > 0)
            $taxRate = number_format($itemDetails['tax'] / $itemDetails['subtotal'] * 100, 2);

        // Update order items
        $sql_data_array = array(
          'orders_id'           => $this->orderId,
          'products_id'         => $itemDetails['productId'],
          'products_model'      => $model,
          'products_name'       => $itemDetails['title'],
          'products_price'      => $itemDetails['subtotal'],
          'final_price'         => $itemDetails['total'],
          'products_tax'        => $taxRate,
          'products_quantity'   => $itemDetails['quantity']
        );

        $order_products_id = $abxDatabase->insert(TABLE_ORDERS_PRODUCTS, $sql_data_array);
        return $order_products_id;
    }

    function getCustomer($email) {

        global $abxDatabase;

        $sQuery = "SELECT" .
                 " c.customers_id," .
                 " c.customers_firstname," .
                 " c.customers_lastname," .
                 " c.customers_default_address_id," .
                 " a.entry_street_address," .
                 " a.entry_suburb," .
                 " a.entry_postcode," .
                 " a.entry_city," .
                 " a.entry_state," .
                 " a.entry_country_id," .
                 " a.entry_zone_id" .
                 " FROM %s c" .
                 " LEFT JOIN %s a ON c.customers_id = a.customers_id" .
                 " WHERE a.address_book_id = c.customers_default_address_id" .
                 " AND c.customers_email_address = '%s'" .
                 " LIMIT 1";

        $sQuery = sprintf(
          $sQuery,
          TABLE_CUSTOMERS,
          TABLE_ADDRESS_BOOK,
          $abxDatabase->escape($email)
        );

        return $abxDatabase->fetch_row($sQuery);

    }

    function createCustomer(&$orderInfo, $countryID, $zoneId) {

      global $abxDatabase;

      $nameArray = $this->convertName($orderInfo['order']['billingAddress']['fullName']);

      $aCustomer = array(
        'customers_gender'        => 'U',   // unknown
        'customers_firstname'     => $nameArray['firstName'],
        'customers_lastname'      => $nameArray['lastName'],
        'customers_email_address' => $orderInfo['order']['buyer']['email'],
        //'customers_telephone'     => $orderInfo['order']['billingAddress']['phone'], //CRE 6.3 does not have this
        'customers_newsletter'    => '0',
        'customers_password'      => $this->getNewPassword()
      );

      $this->customerId = $abxDatabase->insert(TABLE_CUSTOMERS, $aCustomer);

      $aInfo = array(
        'customers_info_id'                         => $this->customerId,
        'customers_info_number_of_logons'           => 0,
        'customers_info_date_account_created'       => date("Y-m-d H:i:s"),
        'customers_info_date_account_last_modified' => '0000-00-00 00:00:00'
      );

      $abxDatabase->insert(TABLE_CUSTOMERS_INFO, $aInfo);

      $aAddress = array(
        'customers_id'         => $this->customerId,
        'entry_gender'         => 'U',
        'entry_firstname'      => $nameArray['firstName'],
        'entry_lastname'       => $nameArray['lastName'],
        'entry_company'        => '',
        'entry_street_address' => rtrim(implode(",", array($orderInfo['order']['billingAddress']['street1'],$orderInfo['order']['billingAddress']['street2'])),","),
        'entry_suburb'         => '',
        'entry_city'           => $orderInfo['order']['billingAddress']['city'],
        'entry_postcode'       => $orderInfo['order']['billingAddress']['postalCode'],
        'entry_state'          => $orderInfo['order']['billingAddress']['state'],
        'entry_country_id'     => $countryID,
        'entry_zone_id'        => $zoneId
      );

      $addressId = $abxDatabase->insert(TABLE_ADDRESS_BOOK, $aAddress);

      $abxDatabase->update(
        TABLE_CUSTOMERS,
        array('customers_default_address_id' => $addressId),
        'customers_id='. $this->customerId
      );

      return $this->customerId;

    }

    // May not be required, just adds a new address to address book without verifying
    // that it is different from current default address
    function customerUpdate(&$order)
    {
        return true;

/*      global $abxDatabase;

      $nameArray = $this->convertName($order['buyer']['name']);

      $aAddress = array(
        'customers_id'         => $this->customerId,
        'entry_gender'         => 'U',
        'entry_firstname'      => $nameArray['firstName'],
        'entry_lastname'       => $nameArray['lastName'],
        'entry_company'        => '',
        'entry_street_address' => implode(",", array($order['buyer']['street1'],$order['buyer']['street2'])),
        'entry_suburb'         => '',
        'entry_city'           => $order['buyer']['city'],
        'entry_postcode'       => $order['buyer']['zip'],
        'entry_state'          => $order['buyer']['state'],
        'entry_country_id'     => $this->buyerCountryId,
        'entry_zone_id'        => $this->buyerZoneId
      );

      $addressId = $abxDatabase->insert(TABLE_ADDRESS_BOOK, $aAddress);

      $abxDatabase->update(
        TABLE_CUSTOMERS,
        array('customers_default_address_id' => $addressId),
        'customers_id='.$this->customerId
      );

      $sWhere = sprintf(
        "ext_email_address = '%s' LIMIT 1",
        $abxDatabase->escape($this->sEmail)
      );

      $aUpdate = array(
        'customers_id' => $this->customerId
      );

      $abxDatabase->update(TABLE_ABX_WINNERS, $aUpdate, $sWhere);
*/
    }

    function getNewPassword() {

        $sPassword = '';
        $nLength   = 8;

        for($i=0; $i<$nLength; $i++) {
            $sChar = chr(rand(48, 122));

        while(!ereg("[a-zA-Z0-9]", $sChar)) {
          if ($sChar == @$sLastChar) {
            continue;
          }
          $sChar = chr(rand(48, 90));
        }
        $sPassword .= $sChar;
        $sLastChar  = $sChar;
        }

        $this->customerPassword = $sPassword;
        $sSalt                  = substr(md5($sPassword), 0, 2);
        $sEncryptedPassword     = md5($sSalt.$sPassword).':'.$sSalt;

        return $sEncryptedPassword;

    }

    function convertName($name) {

        $firstName = $name;
        $lastName = '';

        $nameArray = explode(' ', $name);

        if (is_array($nameArray)) {

        $firstName = $nameArray[0];  // firstname should be first element
        $name = array_shift($nameArray);  // pop firstname off array

        foreach ($nameArray as $key => $lname)
            $lastName .= $lname . ' ';
        }

          return array('firstName' => $firstName,
                   'lastName' => rtrim($lastName));
    }

    function getCountryIdByIsoCode($sCountryIsoCode) {

        $aCountries = $this->getCountries();

        foreach($aCountries as $nCountryId => $aCountry) {
            if ($aCountry['countries_iso_code_2'] == $sCountryIsoCode) {
              return $nCountryId;
            }
        }
    }

    function getCountries($nCountryId = null) {
        static $aCountries;

        if (!$aCountries) {
            global $abxDatabase;

            $sQuery = "SELECT countries_id,"
                            ."countries_name,"
                            ."countries_iso_code_2,"
                            ."countries_iso_code_3,"
                            ."c.address_format_id,"
                            ."address_format "
                    ."FROM %s c "
                    ."LEFT JOIN %s a on c.address_format_id = a.address_format "
                    ."ORDER BY countries_name";

            $sQuery = sprintf($sQuery, TABLE_COUNTRIES, TABLE_ADDRESS_FORMAT);
            $Query = $abxDatabase->query($sQuery);

            while($aCountry = $Query->next()) {
              $aCountries[$aCountry['countries_id']] = $aCountry;
            }
        }

        return (!$nCountryId) ? $aCountries : $aCountries[$nCountryId];
    }

    function hasCountryZones($nCountry = null) {

        static $aCountries;

        if (!($nCountry = intval($nCountry))) {
            $nCountry = $this->nCountryId;
        }

        if ($nCountry = intval($nCountry)) {
            if (!isset($aCountries[$nCountry])) {
              global $abxDatabase;

              $sQuery = "SELECT count(*) AS total "
                       ."FROM %s "
                       ."WHERE zone_country_id = %d";

              $aRes = $abxDatabase->fetch_row(sprintf($sQuery, TABLE_ZONES, $nCountry));

              $aCountries[$nCountry] = ($aRes['total'] > 0);
            }

            return $aCountries[$nCountry];
        }

        return false;
    }

    function getZoneIdByState($sState, $nCountry) {

        global $abxDatabase;

        $bCountryZones = $this->hasCountryZones($nCountry);

        if ($bCountryZones) {
            $sQuery = "SELECT DISTINCT zone_id "
                     ."FROM %s "
                     ."WHERE zone_country_id = %d "
                      ."AND (zone_name = '%s' OR zone_code = '%s')";

            $sQuery = sprintf(
              $sQuery,
              TABLE_ZONES,
              $nCountry,
              $abxDatabase->escape($sState),
              $abxDatabase->escape($sState)
            );
            
            $Query = $abxDatabase->query($sQuery);
            
            if ($Query->numRows() == 1) {
              return $Query->valueInt('zone_id');
            }
        }
    }
    
    function getCountryInfo($countryId) {
        
       global $abxDatabase;

        $sQuery = "SELECT DISTINCT c.countries_id,"
                        ."c.countries_name,"
                        ."c.countries_iso_code_2,"
                        ."c.countries_iso_code_3,"
                        ."c.address_format_id,"
                        ."a.address_format "
                ."FROM %s c "
                ."LEFT JOIN %s a on c.address_format_id = a.address_format "
                ."WHERE c.countries_id = %d ";

        $sQuery = sprintf($sQuery, TABLE_COUNTRIES, TABLE_ADDRESS_FORMAT,$countryId);
        $Query = $abxDatabase->query($sQuery);

        // Should only be one row
        return $Query->next();
    }
    
    function getProductModel ($productId) {
        
      global $abxDatabase;
        
          $sql = "SELECT products_model "
              . " FROM " . TABLE_PRODUCTS 
              . " WHERE products_id = '" . (int)$productId . "'";
        
          $results =  $abxDatabase->fetch_row($sql, TABLE_PRODUCTS);
        
          return $results['products_model'];
    }
}  // end class
?>