dojo.provide("abx.widget.ShippingPortlet");

dojo.require("dijit._Widget");
dojo.require("dijit._Templated");
dojo.require("dijit.form.CheckBox");
dojo.require("dijit.form.FilteringSelect");
dojo.require("dijit.form.TextBox");
dojo.require("dojo.data.ItemFileReadStore");
dojo.require("abx.widget.DomesticShippingContainer");
dojo.require("abx.widget.InternationalShippingContainer");

dojo.declare("abx.widget.ShippingPortlet",
        [dijit._Widget,dijit._Templated],
        {        
        templatePath: dojo.moduleUrl("abx","layout/widget/ShippingPortlet.html"),
        templateString: "",
        src: "",
        widgetsInTemplate: true,
        
        siteWithoutCalculatedShipping: ["UK", "AT", "BFR", "FR", "DE", "IT", "BNL", "NL", "ES", "CH", "EMO"],
        
        digitalDeliveryCheckbox: null,
        digitalDeliveryCheckboxName: 'abxship_digital_delivery',
        shippingContainer: null,
        
        packageInfo: null,
        packageBox: null,
        packageBoxName: 'abxship_shipping_package_type', 
        dimensionsContainer: null,
        shippingDimensionsLength: null,
        shippingDimensionsLengthName: 'abxship_shipping_dimensions_length',
        shippingDimensionsWidth: null,
        shippingDimensionsWidthName: 'abxship_shipping_dimensions_width',
        shippingDimensionsHeight: null,
        shippingDimensionsHeightName: 'abxship_shipping_dimensions_height',
        shippingDimensionsUnits: null,
        shippingDimensionsUnitsName: 'abxship_shipping_dimensions_units',
        shippingWeight: null,
        shippingWeightName: 'abxship_shipping_weight',
        shippingWeightUnits: null,
        shippingWeightUnitsName: 'abxship_shipping_weight_units',
        
        domesticShippingContainer: null,
        internationalShippingContainer: null,        
        shippingPostalCode: null,
        shippingPostalCodeName: 'abxship_shipping_postal_code', 
        shippingDestination: null,
        shippingDestinationName: 'abxship_destination',
        
        handlingTimeName: 'abxship_handling_time',
        handlingTime: null,
        
        packagePopulated: false,
        
        redrawShippingPortlet: function(){
        
        	if (!this.internationalShippingContainer.servicesReady() || !this.domesticShippingContainer.servicesReady()){
        		setTimeout(dojo.hitch(this, 'redrawShippingPortlet'), 200);
        		return;
        	}
        
        	if (this.digitalDeliveryCheckbox.checked){
        		dojo.style(this.shippingContainer, 'display', 'none');
        	}
        	else{
        		dojo.style(this.shippingContainer, 'display', '');
        	}
        	
        	if (this.shippingDestination.getValue() == 'N'){
        		dojo.style(this.dimensionsContainer, 'display', 'none');
        		dojo.style(this.packageInfo, 'display', 'none');
        		dojo.style(this.domesticShippingContainer.domNode, 'display', 'none');
        		dojo.style(this.internationalShippingContainer.domNode, 'display', 'none');
        		return;
        	}
        	else if (this.shippingDestination.getValue() == 'D'){
        		dojo.style(this.internationalShippingContainer.domNode, 'display', 'none');
        		dojo.style(this.domesticShippingContainer.domNode, 'display', '');
        	}
        	else if (this.shippingDestination.getValue() == 'I'){
        		dojo.style(this.internationalShippingContainer.domNode, 'display', '');
        		dojo.style(this.domesticShippingContainer.domNode, 'display', '');
        	}
        	
        	if (this.domesticShippingContainer.dimensionsRequired() || (this.internationalShippingContainer.dimensionsRequired() && this.shippingDestination.getValue() == 'I')){
        		dojo.style(this.dimensionsContainer, 'display', '');
        	}
        	else{
        		dojo.style(this.dimensionsContainer, 'display', 'none');
        	}
        	
        	if (this.domesticShippingContainer.packageInfoRequired() || (this.internationalShippingContainer.packageInfoRequired() && this.shippingDestination.getValue() == 'I')){
        		dojo.style(this.packageInfo, 'display', '');
        	}
        	else{
        		dojo.style(this.packageInfo, 'display', 'none');        	
        	}
        
        },
        
        packageChange : function (){
        	var packageBoxValue = this.packageBox.getValue();
        	domFlatShippingServicesStore = new dojo.data.ItemFileReadStore({url: catalogUrl + 'abxn.php?abx=shippinginfo&type=dom_flat&site=' + abxSite});
        	domCalcShippingServicesStore = new dojo.data.ItemFileReadStore({url: catalogUrl + 'abxn.php?abx=shippinginfo&type=dom_calc&site=' + abxSite + '&package_type=' + packageBoxValue});
        	intFlatShippingServicesStore = new dojo.data.ItemFileReadStore({url: catalogUrl + 'abxn.php?abx=shippinginfo&type=int_flat&site=' + abxSite});
        	intCalcShippingServicesStore = new dojo.data.ItemFileReadStore({url: catalogUrl + 'abxn.php?abx=shippinginfo&type=int_calc&site=' + abxSite + '&package_type=' + packageBoxValue});
        	
        	this.domesticShippingContainer.packageChange();
        	this.internationalShippingContainer.packageChange();
        },
        
        setPackage: function(items, request){
        	if (abxShipping[this.packageBoxName]){
	        	this.packageBox.setValue(abxShipping[this.packageBoxName]);
	        }
	        
	        this.packagePopulated = true;
        },
        
        populateFields: function(){
        
        	if (this.domesticShippingContainer == null || 
        		this.internationalShippingContainer == null || 
        		!this.domesticShippingContainer.canBePopulated() || 
        		!this.internationalShippingContainer.canBePopulated()){
        		
        		setTimeout(dojo.hitch(this, 'populateFields'), 200);
        		return;
        	}
        	
        	var packageBoxValue = abxShipping[this.packageBoxName];
        	if (packageBoxValue == null || packageBoxValue == 'undefined'){
        		packageBoxValue = '';
        	}
        	//reinitialize these because sometimes they are loaded already and the callbacks do not work
        	domFlatShippingServicesStore = new dojo.data.ItemFileReadStore({url: catalogUrl + 'abxn.php?abx=shippinginfo&type=dom_flat&site=' + abxSite});
        	domCalcShippingServicesStore = new dojo.data.ItemFileReadStore({url: catalogUrl + 'abxn.php?abx=shippinginfo&type=dom_calc&site=' + abxSite + '&package_type=' + packageBoxValue});
        	intFlatShippingServicesStore = new dojo.data.ItemFileReadStore({url: catalogUrl + 'abxn.php?abx=shippinginfo&type=int_flat&site=' + abxSite});
        	intCalcShippingServicesStore = new dojo.data.ItemFileReadStore({url: catalogUrl + 'abxn.php?abx=shippinginfo&type=int_calc&site=' + abxSite + '&package_type=' + packageBoxValue});
        	        	
        	//populate field values
        	if (abxShipping[this.digitalDeliveryCheckboxName]){
        		this.digitalDeliveryCheckbox.setChecked(true);
        	}
        	this.packageBox.store.fetch({onComplete: dojo.hitch(this, 'setPackage')});
        	this.shippingDimensionsLength.setValue(abxShipping[this.shippingDimensionsLengthName]);
        	this.shippingDimensionsWidth.setValue(abxShipping[this.shippingDimensionsWidthName]);
        	this.shippingDimensionsHeight.setValue(abxShipping[this.shippingDimensionsHeightName]);
        	var shippingDimensionsUnitsVal = abxShipping[this.shippingDimensionsUnitsName];
        	if (null == shippingDimensionsUnitsVal || '' == shippingDimensionsUnitsVal){
        		shippingDimensionsUnitsVal = 'in';
        	}
        	this.shippingDimensionsUnits.setValue(shippingDimensionsUnitsVal);
        	this.shippingWeight.setValue(abxShipping[this.shippingWeightName]);
        	var shippingWeightUnitsVal = abxShipping[this.shippingWeightUnitsName];
        	if (null == shippingWeightUnitsVal || '' == shippingWeightUnitsVal){
        		shippingWeightUnitsVal = 'lb';
        	}
        	this.shippingWeightUnits.setValue(shippingWeightUnitsVal);
        	this.shippingPostalCode.setValue(abxShipping[this.shippingPostalCodeName]);
        	var shippingDestVal = abxShipping[this.shippingDestinationName];
        	if (null == shippingDestVal || '' == shippingDestVal){
        		shippingDestVal = 'I';
        	}
        	this.shippingDestination.setValue(shippingDestVal);

        	this.handlingTime.setValue(abxShipping[this.handlingTimeName]);
        	
        	this.domesticShippingContainer.populateFields();
        	this.internationalShippingContainer.populateFields();
        },
        
        wireAndDraw: function(){
        
        	if (this.domesticShippingContainer == null || 
        		this.internationalShippingContainer == null || 
        		!this.domesticShippingContainer.populated() || 
        		!this.internationalShippingContainer.populated()){
        		
        		setTimeout(dojo.hitch(this, 'wireAndDraw'), 200);
        		return;
        	}
        
        	dojo.subscribe('redraw_shipping_portlet', this, 'redrawShippingPortlet');
        	this.packageBox.onChange = dojo.hitch(this, 'packageChange');
        	this.digitalDeliveryCheckbox.onChange = dojo.hitch(this, 'redrawShippingPortlet');
        	this.shippingDestination.onChange = dojo.hitch(this, 'redrawShippingPortlet');
        	
           	this.domesticShippingContainer.wireAndDraw();
           	this.internationalShippingContainer.wireAndDraw();
           	
           	this.redrawShippingPortlet();
        },
        
        postCreate: function(){
        
        },
        
        startup: function(){
        
           	this.populateFields();
        	this.wireAndDraw();
        	
        }
        
});