<?php
/*
  $Id: inventory.php,v 1.4 2006/10/02 03:06:46 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxPaginator_Inventory extends abxWebServicePaginator {

    var
      $sMethod = 'inventory.getDetail';

    function filterTerms()
    {
      static $filterTerms = array();

      if (empty($filterTerms) === true)

        $filterTerms = array(
          'name' => 'type',
          'values' => abxConstants::getFeedbackTypes()
        );

      return $filterTerms;
    }

    function sortDefaultArray()
    {
      return array(
        'name' => 'qtyAvailable',
        'value' => 'desc'
      );
    }


    function searchTerms()
    {
      return array(
        array('id'=>"buyerId",'text'=>'SEARCH_LIST_1'),
        array('id'=>"listingId",'text'=>'SEARCH_LIST_2'),
        array('id'=>"buyerResponse",'text'=>'SEARCH_LIST_3')
      );
    }

    function tableDataHeadings()
    {
      return array(
        array('heading' => 'sku', 'sort_field' => 'sku'),
        array('heading' => 'Restock Level', 'sort_field' => 'restockLevel'),
//        array('heading' => 'All-Time', 'sort_field' => 'qtyTotal'),
        array('heading' => 'In Stock', 'sort_field' => 'qtyInStock'),
        array('heading' => 'Active', 'sort_field' => 'qtyActive'),
        array('heading' => 'Sold', 'sort_field' => 'qtyReserved'),
        array('heading' => 'Available', 'sort_field' => 'qtyAvailable')
      );
    }

    function tableDataRowContents($array)
    {
      return '<td align="right">' . $this->cell($array['sku']) . '</td>'.
             '<td align="right">' . $this->cell($array['restockLevel']) . '</td>'.
             '<td align="right">' . $this->cell($array['qtyInStock']) . '</td>'.
             '<td align="right">' . $this->cell($array['qtyActive']) . '</td>'.
             '<td align="right">' . $this->cell($array['qtyReserved']) . '</td>'.
             '<td align="right">' . $this->cell($array['qtyAvailable']) . '</td>';
    }

    function drawExtraHiddenFields()
    {
      return '<input type="hidden" name="abx_last" value="sales-feedback">';
    }

    function bulkActions()
    {
      return array(
        'PositiveFeedback' => array('icon'=>'feedback_pos.gif','alt'=>ACTION_POSITIVE_FEEDBACK),
        'NeutralFeedback'  => array('icon'=>'feedback_neu.gif','alt'=>ACTION_NEUTRAL_FEEDBACK),
        'NegativeFeedback' => array('icon'=>'feedback_neg.gif','alt'=>ACTION_NEGATIVE_FEEDBACK)
      );
    }

    function infoBox($action)
    {    	
      switch($action) {
        case 'PositiveFeedback':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_POSITIVE_FEEDBACK,TEXT_INFO_POSITIVE_FEEDBACK,'PositiveFeedbackConfirm','','',$this->infoBoxProfiles());
          break;
        case 'NeutralFeedback':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_NEUTRAL_FEEDBACK,TEXT_INFO_NEUTRAL_FEEDBACK,'NeutralFeedbackConfirm','','',$this->infoBoxProfiles());
          break;
        case 'NegativeFeedback':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_NEGATIVE_FEEDBACK,TEXT_INFO_NEGATIVE_FEEDBACK,'NegativeFeedbackConfirm','','',$this->infoBoxProfiles());
          break;
        case 'feedbackDownload':
          return $this->infoPageBox(TEXT_INFO_HEADING_DOWNLOAD_FEEDBACK,TEXT_INFO_DOWNLOAD_FEEDBACK, 'sales', 'downloadFeedbackConfirm','sales-feedback-download','', $this->infoBoxDownloads());
          break;
      }
    }
    
    function tableDataFooter()
    {
      return '<div style="float: right;"><form name="productsSynchronize" method="post"><div align="right">'.$this->submit(TEXT_SYNCHRONIZE_INVENTORY,'this.form','product-synchronize','inventory'.abxPage::getSearchParams(),'','greenButton').'<input type="hidden" name="perform"></form></div>';
    }
    
  }//end class
?>