<?php
/*
  $Id: items_templates.php,v 1.5 2008/08/13 19:06:10 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  if (class_exists('abxPaginator_Items') === false) {

    require_once(DIR_FS_ABX_PAGINATORS . 'items.php');

  }

  class abxPaginator_Items_Templates extends abxPaginator {
    
    function sortDefaultArray()
    {
      return array(
        'name' => 'i.last_modified',
        'value' => 'desc'
      );
    }
    
    function searchTerms()
    {
      return array(
        array('id'=>'i.label','text'=>'SEARCH_LIST_1'),
        array('id'=>'i.title','text'=>'SEARCH_LIST_2'),
        array('id'=>'i.listing_type','text'=>'SEARCH_LIST_3'),
        array('id'=>'i.duration','text'=>'SEARCH_LIST_4'),
        array('id'=>'i.price','text'=>'SEARCH_LIST_5'),
        array('id'=>'i.quantity','text'=>'SEARCH_LIST_6'),
        array('id'=>'i.last_modified','text'=>'SEARCH_LIST_7')
      );
    }

    function tableDataHeadings()
    {
      return array(
        array('heading' => HEADING_AUCTION_TITLE, 'sort_field' => 'i.title'),
        array('heading' => HEADING_AUCTION_TYPE, 'sort_field' => 'i.listing_type'),
        array('heading' => HEADING_AUCTION_QTY, 'sort_field' => 'i.quantity'),
        array('heading' => HEADING_AUCTION_DURATION, 'sort_field' => 'i.duration'),
        array('heading' => HEADING_AUCTION_PRICE, 'sort_field' => 'i.price'),
        array('heading' => HEADING_AUCTION_BIN_PRICE, 'sort_field' => 'i.bin_price'),
        array('heading' => HEADING_AUCTION_LABEL, 'sort_field' => 'i.label'),
        array('heading' => HEADING_AUCTION_PROFILE, 'sort_field' => 'i.profile_id'),
        array('heading' => HEADING_AUCTION_LAST_UPDATED, 'sort_field' => 'i.last_modified')
      );
    }
    
    function tableDataRowContents($array)
    {
      global $currencies, $listingTypes;

      static $profileID;

      if (isset($profileID) === false) {

        $profileID = array();

        $profiles = abxConstants::getProfilesDropDown();

        foreach((array)$profiles as $index => $profile)
          $profileID["{$profile['id']}"] = $profile['text'];

      }

      $listingTypes = abxConstants::getListingTypesShort();

      if (strtolower(get_class($this)) !== 'templatelistings_page' && empty($array['products_name']) === false) {

        $products_model = (empty($array['products_model']) === false) ? '&nbsp;('.$array['products_model'].')' : '';

        $array['title'] = $array['title'] . '<br /><span class="tableDataSubText">'.$array['products_name'].$products_model.'</span>';

      }

      $str .= '<td>' . $this->cell($array['title'],'150') . '</td>'.
              '<td>' . $this->cell($listingTypes[$array['listing_type']]) . '</td>'.
              '<td align="right">' . $this->cell($array['quantity']) . '</td>'.
              '<td align="right">' . $this->cell($array['duration']) . '</td>'.
              '<td align="right">' . $this->cell($currencies->format($array['price'])) . '</td>'.
              '<td align="right">' . $this->cell($currencies->format($array['bin_price'])) . '</td>'.
              '<td>' . $this->cellWrap($array['label'], 45) . '</td>'.
              '<td>' . $this->cellWrap($profileID[$array['profile_id']], 45) . '</td>'.
              '<td align="right">' . $this->cellWrapDate(abx_short_date($array['last_modified'])) . '</td>';

      return $str;
    }
    

    function bulkActions()
    {
      return array(
        'DeleteItems' => array('icon'=>'delete.gif','alt'=>ACTION_DELETE,'onclick' => "confirmBulkAction('".JAVASCRIPT_CONFIRM_DELETE."','".TEXT_TEMPLATES."','DeleteConfirm');"),
      );
    }

    function singleActions($array = array())
    {
      return array(
        'editTemplate' => array('icon'=>'edit.gif','alt'=>ACTION_EDIT,'url'=>abx_href_link(FILENAME_AUCTIONBLOX, 'abx=templates-edit&oID=' . $array['id'].'&'.abxPage::getSearchParams(array('abx')))),
        'createListing' => array('icon'=>'listings_create.gif','alt'=>ACTION_CREATE_LISTING,'url'=>abx_href_link(FILENAME_AUCTIONBLOX, 'abx=items-generate&oID=' . $array['id'].'&'.abxPage::getSearchParams(array('abx')))),
        'copyTemplate' => array('icon'=>'copy.gif','alt'=>ACTION_COPY,'url'=>abx_href_link(FILENAME_AUCTIONBLOX, 'abx=templates-copy&oID=' . $array['id'].'&'.abxPage::getSearchParams(array('abx'))))
      );
    }

    function tableDataFooter()
    {
      return '<div align="right">' . $this->navigation(TEXT_CREATE_TEMPLATE,'templates-new') . '</div>';
    }

  }//end class
?>