<?php
/*
  $Id: shipping_fixed.php,v 1.2 2005/05/27 14:53:41 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxPaginator_Macros_Manager extends abxPaginator {

    function filterTerms()
    {
      static $filterTerms;

      if(isset($filterTerms) === false) {

        $filterTerms = array(
          'values' => abx_get_category_tree()
        );

      }

      return $filterTerms;
    }

    function sortDefaultArray()
    {
      return array(
        'name' => 'pd.products_name',
        'value' => 'desc'
      );
    }

    function countSellerIDs()
    {
      return 0;
    }

    function searchTerms()
    {
      return array(
        array('id'=>"pd.products_name",'text'=>'SEARCH_LIST_1')
      );
    }

    function tableDataHeadings()
    {
      return array(
        array('heading' => TABLE_HEADING_PRODUCTS, 'sort_field' => 'products_name'),
        array('heading' => 'Exclude from eBay:'),
        array('heading' => '{CUSTOM1}'),
        array('heading' => '{CUSTOM2}'),
        array('heading' => '{CUSTOM3}'),
        array('heading' => '{CUSTOM4}'),
        array('heading' => '{CUSTOM5}'),
        array('heading' => '{CUSTOM6}'),
        array('heading' => '{CUSTOM7}'),
        array('heading' => '{CUSTOM8}'),
        array('heading' => '{CUSTOM9}'),
        array('heading' => '{CUSTOM10}')
      );
    }

    function tableDataRowContents($array)
    {
      global $currencies;

      $str = '<td>' . $this->cellWrap($array['products_name'], 150) . '</td>';
      $str .= '<td align="left">' . 
               $this->checkbox('auction', $abxPage->vars['auction']) . '&nbsp;Auction<br/>' .
               $this->checkbox('fixed', $abxPage->vars['fixed']) . '&nbsp;Fixed<br/>' .
               $this->checkbox('store', $abxPage->vars['store']) . '&nbsp;Store<br/>'.
              '</td>';


      if ($array['custom1'] != null) {
        
        $str .= '<td align="right">' . $this->input('custom1', $abxPage->vars['custom1']) . '</td>'.
                '<td align="right">' . $this->cell($array['custom2']) . '</td>'.
                '<td align="right">' . $this->cell($array['custom3']) . '</td>'.
                '<td align="right">' . $this->cell($array['custom4']) . '</td>'.
                '<td align="right">' . $this->cell($array['custom5']) . '</td>'.
                '<td align="right">' . $this->cell($array['custom6']) . '</td>'.
                '<td align="right">' . $this->cell($array['custom7']) . '</td>'.
                '<td align="right">' . $this->cell($array['custom8']) . '</td>'.
                '<td align="right">' . $this->cell($array['custom9']) . '</td>'.
                '<td align="right">' . $this->cell($array['custom10']) . '</td>';

      } else {

        $str .= '<td align="right">' . $this->input('custom1', $abxPage->vars['custom1'], "size=10") . '</td>'.
                '<td align="right">' . $this->input('custom2', $abxPage->vars['custom2'], "size=10") . '</td>'.
                '<td align="right">' . $this->input('custom3', $abxPage->vars['custom3'], "size=10") . '</td>'.
                '<td align="right">' . $this->input('custom4', $abxPage->vars['custom4'], "size=10") . '</td>'.
                '<td align="right">' . $this->cell('&nbsp;---&nbsp;') . '</td>'.
                '<td align="right">' . $this->cell('&nbsp;---&nbsp;') . '</td>'.
                '<td align="right">' . $this->cell('&nbsp;---&nbsp;') . '</td>'.
                '<td align="right">' . $this->cell('&nbsp;---&nbsp;') . '</td>'.
                '<td align="right">' . $this->cell('&nbsp;---&nbsp;') . '</td>'.
                '<td align="right">' . $this->cell('&nbsp;---&nbsp;') . '</td>';
      }

      return $str;
    }

    function bulkActions()
    {
      return array(
        'DeleteItems' => array('icon'=>'delete.gif','alt'=>ACTION_DELETE,'onclick' => "confirmBulkAction('".JAVASCRIPT_CONFIRM_DELETE."','".TEXT_SHIPPING_FIXED."','delete_confirm');"),
        'UpdateItems' => array('icon'=>'edit.gif','alt'=>ACTION_EDIT, 'enabled' => 'true', 'alt'=>ACTION_RELIST,'action'=>'macros-edit')
      );
    }
    
    function singleActions($array = array())
    {
      return array(
        'editListing' => array('icon'=>'edit.gif','alt'=>ACTION_EDIT,'url'=>abx_href_link(FILENAME_AUCTIONBLOX, 'abx=macros-edit&oID=' . $array['id'].abxPage::getSearchParams())),
      );
    }
    

    function updateListingFields()
    {
      global $abxDatabase;

      $nSelectedRows = count($_POST['abxList']);

      if ($nSelectedRows == 1)
        $single = abxMacros::queryById($_POST['abxList'][0]);

      $domestic_shipping      = $nSelectedRows == 1 ? $single['shipping'] : '';
      $domestic_shipping_addl = $nSelectedRows == 1 ? $single['shipping_addl'] : '';
      $global_shipping        = $nSelectedRows == 1 ? $single['shipping_global'] : '';
      $global_shipping_addl   = $nSelectedRows == 1 ? $single['shipping_global_addl'] : '';
      $is_enabled             = $nSelectedRows == 1 ? $single['is_enabled'] : '';

      $str = '<table border="0" width="100%" cellspacing="0" cellpadding="2" class="tableForm">' .
             '  <tr>' .
             '    <td>' . TEXT_PRODUCT_DOMESTIC_SHIPPING . '</td>'.'<td>'.$this->input('custom1', $domestic_shipping, 'size="10" maxlength="10"').'</td>'.
             '    <td>' . TEXT_PRODUCT_DOMESTIC_SHIPPING_ADDL . '</td>'.'<td>'.$this->input('products_domestic_additional_shipping', $domestic_shipping_addl, 'size="10" maxlength="10"').'</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . TEXT_PRODUCT_GLOBAL_SHIPPING . '</td>'.'<td>'.$this->input('products_global_shipping', $global_shipping, 'size="10" maxlength="10"').'</td>'.
             '    <td>' . TEXT_PRODUCT_GLOBAL_SHIPPING_ADDL . '</td>'.'<td>'.$this->input('products_global_additional_shipping', $global_shipping_addl, 'size="10" maxlength="10"').'</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . TEXT_ENABLE_FIXED_PRICES . '</td>'.'<td>'.$this->radio('fixed_price_enabled', '1', '', $is_enabled === '1') . '&nbsp;' . TEXT_TRUE . '&nbsp;' . $this->radio('fixed_price_enabled', '0', '', $is_enabled === '0') . '&nbsp;' . TEXT_FALSE.'</td>'.
             '    <td colspan="2">' .'&nbsp;' . '</td>'.
             '  </tr>' .
             '</table>';

      return array(array('text' => $str));
    }

    function infoBox($action)
    {
      switch($action) {
        case 'UpdateItems':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_CREATE_SHIPPING,TEXT_INFO_CREATE_INTRO,'create_confirm','','',$this->updateListingFields());
          break;
      }
    }

  }//end class
?>