<?php
//------------------------------------------------------------------------------------------------------------
// retour_spcheck_php.php
// KIT SPPLUS : Page de retour CGI paiement avec de test du contrle IP puis HMAC
//---------------------------------------------------------------------------------------------------------
// Destinataire :                Sites en intgration
// Auteur :                      Service intgration SP PLUS
// Numro Version :              1.2
// Date cration	:	             18/08/2005
// Date dernire Modification :  12/03/2007
//---------------------------------------------------------------------------------------------------------
//
//	LURL CGI de retour paiement doit tre utilise pour effectuer un traitement sur le site commerant, cette page
// nest pas visible et est appele la premire fois par le serveur de paiement ds que linternaute a valid son
// paiement. Cest une page applicative, son utilisation est facultative. Il sagit gnralement dune page dynamique
// (Php, Asp) pemettant une mise  jour du suivi de commande du site commerant.
//
// En effet, si le site offre un suivi de ltat des paiements, il est possible de synchroniser la base du commerant
// avec celle du serveur SP PLUS.
//
// Cette URL est appele  chaque fois quun vnement modifie ltat dune transaction (paramtre "etat").
//
// Ce script vous permettra de vrifier que l'appel sur la page CGI retour paiement vient
// bien du serveur de paiement SP PLUS. En effet, il permet dans un premier temps de filtrer l'adresse IP de
// l'appellant pour n'autoriser que le serveur SPPLUS puis de recalculer le HMAC pour le comparer  celui envoy.
//
// Ce script utilise la fonction de calcul nthmac($clent, $chaineParam) prsente dans l'API PHP php_spplus.so
//
// Dans cette configuration, le serveur SP PLUS se comporte comme un navigateur qui interroge une page de traitement
// situe sur le serveur du commerant. Le serveur va analyser le code affich par cette page et non la page elle-mme.
// La page doit donc SYSTEMATIQUEMENT rpondre "spcheckok" pour informer le serveur SPPLUS de la prise en compte de la
// requte. Si ce n'est pas le cas, le serveur SPPLUS appelle 3 fois la page avec le mme code d'tat et envoie un mail
// d'alerte au commerant et ce, pour chaque code d'tat envoy.
//
// Code Etat	Signification
// 1	Autorisation carte accepte
// 2	Autorisation carte refuse
// 4	Paiement par carte accept
// 5	Paiement par carte refus par la banque
// 6	Paiement par cheque accept
// 8	Chque encaiss
// 10 Transaction termine
// 11	Paiement annul par le commerant
// 12	Abandon de linternaute
// 15	Remboursement
// 99	Paiement de test en production
//
// Validation automatique des paiements :
// Paiement accept : cette page est appele 3 fois avec le code etat  1 puis  4 et  10
// Paiement refus :  cette page est appele avec le code etat correspondant ( 2 ou  5)
//
// Validation manuelle des paiements :
// Paiement accept : cette page est appele 1 fois avec avec le code etat 1
// elle sera  nouveau appele 2 fois avec le code etat 4 puis 10 lors de la validation
// du paiement par le commerant dans l'interface de suivi des paiements SPPLUS.
// Paiement refus :  cette page est appele avec le code etat correspondant ( 2 ou  5)
//
//------------------------------------------------------------------------------------------------------------

   // Nous rpondons SYSTEMATIQUEMENT au serveur SPPLUS
   echo("spcheckok");

   //------------------------------------------------------------------------------------------------------------
   // Liste des adresses IP de sortie des serveurs SP PLUS
   $liste_IP = array( "195.6.195.3",   "83.145.90.3",   "195.115.37.3", 
                      "195.6.195.8",   "83.145.90.8",   "195.115.37.8", 
                      "84.233.159.91", "84.233.159.92", "84.233.159.93", "84.233.159.94", 
                      "84.233.159.95", "84.233.159.96", "84.233.159.97", "84.233.159.98", 
                      "81.255.54.91",  "81.255.54.92",  "81.255.54.93",  "81.255.54.94", 
                      "81.255.54.95",  "81.255.54.96",  "81.255.54.97",  "81.255.54.98",
                      "212.99.102.96", "84.233.159.107", "81.255.54.107", "212.99.102.107"  
                    );

   // Nous testons que c'est bien le serveur SPPLUS qui appelle cette page
   // en rcuprant l'adresse IP de l'appelant puis en la testant
   $remote_addr = $_SERVER['REMOTE_ADDR'];
   if( in_array($remote_addr, $liste_IP) )
   {

      //------------------------------------------------------------------------------------------------------------
      // INFORMATIONS A MODIFIER POUR CHAQUE COMMERCANT FOURNIES PAR LE SERVICE INTEGRATION SPPLUS
      // cle marchand du commercant au format NT
      $clent = "58 6d fc 9c 34 91 9b 86 3f fd 64 63 c9 13 4a 26 ba 29 74 1e c7 e9 80 79";
      // code siret du commercant
      $codesiret = "00000000000001-01";

      echo("<p><b>Cl marchand utilise : </b>" . $clent . "<br>");
      echo("<b>code siret utilis : </b>". $codesiret . "</b><p>");

      //------------------------------------------------------------------------------------------------------------
      // la fonction ci dessous permet de charger la librairie SP PLUS si elle n'est pas dclare dans le fichier php.ini (rubrique extensions)
      dl('php_spplus.so');

      // on a p charger la librairie php_spplus.so
      if (extension_loaded('SPPLUS'))
      {
         echo ("extension SP PLUS charge<p>");

         //------------------------------------------------------------------------------------------------------------
         // $_SERVER['QUERY_STRING'] : permet de rcuperer tel quel la chaine de requte si elle existe
         // qui est utilise pour accder  la page. Valable uniquement pour les paramtres passs en GET.
         $chaineParam = $_SERVER['QUERY_STRING'];

         echo("<b>Parametres recus : </b><br>" . $chaineParam . "<p>");

         //------------------------------------------------------------------------------------------------------------
         // on cherche la position du premier caractre de la chaine '&hmac'
         // et on teste la valeur du hmac et son type
         $pos = strpos($chaineParam,"&hmac=");

         if($pos == false || !is_integer($pos)) { echo("Erreur : Hmac non present<p>"); }
         else
         {
            // on supprime le paramtre hmac de la chane
            $chaineCalcul = substr($chaineParam,0,$pos);
            $chaineCalcul .= substr($chaineParam,$pos+strlen($_GET["hmac"])+6,strlen($chaineParam));
            $chaineParam = "";

            //------------------------------------------------------------------------------------------------------------
            // on dcoupe la chane de paramtres afin de ne rcuprer que les valeurs concatnes
            $tok = strtok($chaineCalcul,"=&");
            while($tok)
            {
               if($_REQUEST[$tok] != "")
               {
                  $tok = strtok("&=");
                  $chaineParam .= $tok;
               }
               $tok = strtok("&=");
               $tok = urldecode($tok);
            }

            echo("<b>Chaine de paramtres  contrler : </b><br>" . $chaineParam . "<p>");

            //------------------------------------------------------------------------------------------------------------
            // on calcul le sceau numrique hmac
            $hmac_calcule = nthmac($clent, $chaineParam);

            //------------------------------------------------------------------------------------------------------------
            // Si le hmac calcul est gal  celui reu on traite les tats pour mise  jour du site
            if ( strcmp( $hmac_calcule, $_GET["hmac"]) == 0 )
            {
               $message = "HMAC_OK";

               // initialisation des variables locales
               $montant    = 0;
               $reference  = 0;
               $refsfp     = 0;
               $etat       = 0;
               $email      = "";
               $info       = "";

               // Rcupration des paramtres avec mthode GET (mthode par dfaut)
               if(isset($_GET['montant']))   { $montant     = $_GET['montant']; }
               if(isset($_GET['reference'])) { $reference   = $_GET['reference']; }
               if(isset($_GET['refsfp']))    { $refsfp      = $_GET['refsfp']; }
               if(isset($_GET['etat']))      { $etat        = $_GET['etat']; }
               if(isset($_GET['email']))     { $email       = $_GET['email']; }

               // Test de la valeur du paramtre Etat et exemple de traitement correspondant
               switch ($etat)
               {
                  case 0:
                     $info = "etat=0 : pas de traitement";
                     break;
                  case 1:
                     $info = "etat=1 : autorisation de paiement accept - panier vid - commande en attente";
                     break;
                  case 2:
                     $info = "etat=2 : autorisation de paiement refus - panier vid - commande annule";
                     break;
                  case 4:
                     $info = "etat=4 : paiement par carte accept - commande valide";
                     break;
                  case 5:
                     $info = "etat=5 : paiement refus - panier vid - commande annule";
                     break;
                  case 6:
                     $info = "etat=6 : paiement par chque accept - panier vid - commande en attente";
                     break;
                  case 8:
                     $info = "etat=8 : chque encaiss - commande valide";
                     break;
                  case 10:
                     $info = "etat=10 : transaction termine";
                     break;
                  case 11:
                     $info = "etat=11 : Paiement annul par le commerant - panier vid - commande annule";
                     break;
                  case 12:
                     $info = "etat=12 : Abandon de linternaute - panier vid - commande annule";
                     break;
                  case 15:
                     $info = "etat=15 : remboursement - traitement compte client";
                     break;
                  case 99:
                     $info = "etat=99 : Paiement de test en production - panier vid - commande annule";
                     break;
               }
               echo ($info."<p>");

            }
            else { $message = "ERREUR_HMAC"; }

            //------------------------------------------------------------------------------------------------------------
            // on affiche le rsultat du traitement hmac
            echo("<b>Hmac reu : </b>" . $_GET["hmac"] . "<br>");
            echo("<b>Hmac calcul : </b>" . $hmac_calcule . "<p>");
            echo("<b>Rsultat : " . $message . "</b>");
          }
      }
    	// on a pas p charger la librairie php_spplus.so
      else
      {
         echo("extension SP PLUS non charge");
      }
   }
?>