#!/bin/bash
# ------------------------------------------------------------------
# This bash script is useful to perform LAMP backups via FTP.
# The old backups are deleted after 3 weeks by default.
# This script make an archive of yours sources too, like html, php.
# Take care with blank spaces in dirs, because script doesn't.
# ------------------------------------------------------------------
#
#    Copyright (C) 2007-2008 <gilles DOT quenot AT gmail DOT com>
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License published by the Free Software Foundation.
#
# ------------------------------------------------------------------

### personnal settings
Mymail=admin@artoisweb.com					# you can put more than one mail like this : me@host.tld,you@other-host.tld,foobar@base.tld
MyFtpHost=ftp.artoisweb3.com				# ftp ip or hostname
MyFtpUserName=artoiswe-bak					# ftp username
MyFtpPasswd=159000645					# ftp password
MyFtpDir=/kimsufi-serv/totalcartoon						# remote ftp dir
MySqlLogin=totalcar						# mysql user
MyUnixUser=totalcar						# the user for chown
MySourcesPath=/home/totalcar/www			# path for *html/php sources
MyBackupDir=./fichiers			# dir where we store the backup
###

# you can store personnal environement in this file if you don't want to show variables ( see variables above ) in this script.
[[ -f /root/.MyEnv ]] && source /root/.MyEnv

# personnal command(s) to run before processing :
pkill kio_ftp &>/dev/null

# now we start.
trap 'rm -f "${MyBackupDir}"/*;' 0
trap 'echo -e "\nQuitting !"; rm -f "${MyBackupDir:?}"/*; exit' 1 2 3 15

# coded to display messages on stdout
function Info
{
	if [[ -t 0 ]]; then 	# if we are in a real shell or not ( cron )
		tput setaf $1
		echo $2
		tput sgr0
	else
		[[ $1 == 1 ]] && echo $2 | mail -s "[${0##*/}] issue" $Mymail
	fi
}

Info 2 "Hi ${USER}."

# script variables
LANG=C
DateNow=$(date +%s)
ThreeWeeksAgo=$(date -d '3 weeks ago' +%s)
File[0]="${MyBackupDir}/dump-${HOSTNAME}.$(date +%Y%m%d)+${DateNow:?}+.sql.gz"
File[1]="${MyBackupDir}/sources-${HOSTNAME}.$(date +%Y%m%d)+${DateNow:?}+.tar.bz2"
echo File ${File[*]} 
TabOfDate=(
	$(
		echo $(lftp -c "open -u ${MyFtpUserName:?},${MyFtpPasswd:?} ${MyFtpHost:?}; \
								ls wiki" | \
								awk -F'+' '{print $2}')
	)
)

if mysqldump ${MySqlLogin} --all-databases --quote-names --opt | gzip -9 - > "${File[0]}"; then
	Info 2 "Mysql dump done."
else
	Info 1 "Mysql dump failed."
	exit 2
fi

if tar cjf "${File[1]:?}" "$MySourcesPath"; then
	Info 2 "Tar archive done."
else
	Info 1 "Tar archive failed."
	exit 2
fi

chown -cv ${MyUnixUser:?}: "${File[@]}"

if ! [[ -f "${File[0]}" && -f "${File[1]}" ]]; then
	tput setaf 1
	echo "${0##*/} failed ! : ${File[0]} or ${File[1]} isn't consistant" | tee >(mail -s "dump sql $HOSTNAME nok !" ${Mymail:?})
	tput sgr0
	exit 2
fi
	
if lftp -c "open -u ${MyFtpUserName:?},${MyFtpPasswd:?} ${MyFtpHost}; \
								cd "$MyFtpDir"; \
								put "${File[0]}"; \
								put "${File[1]}""
then
	Info 2 "Lftp upload done."
else
	tput setaf 1
	echo "${0##*/} failed !" | tee >(mail -s "dump sql $HOSTNAME nok !" ${Mymail:?})
	tput sgr0
	exit 2
fi

# looking for old archives patterns to delete
c=0
for Match in "${TabOfDate[@]:?}"; do
    if (( Match < ThreeWeeksAgo )); then
        ToDelete[c++]="*$Match*"
    fi
done

# remove old archives with given patterns
(( ${#ToDelete[*]} > 0 )) && {
	lftp -c "open -u ${MyFtpUserName:?},${MyFtpPasswd:?} ${MyFtpHost}; \
								cd "$MyFtpDir"; \
								mrm ${ToDelete[*]}"
}

Info 2 "All done, see ya..."