<?php
/*
  $Id: application_top.php,v 1.1.1.1 2004/03/04 23:40:37 ccwjr Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

// start the timer for the page parse time log
  define('PAGE_PARSE_START_TIME', microtime());

// set the level of error reporting
  error_reporting(E_ALL & ~E_NOTICE);

// check if register_globals is enabled.
// since this is a temporary measure this message is hardcoded. The requirement will be removed before 2.2 is finalized.
  if (function_exists('ini_get')) {
    ini_get('register_globals') or exit('FATAL ERROR: register_globals is disabled in php.ini, please enable it!');
  }

 //set detect to 0 or non found
 $serv_open_basedir = '0';
if (function_exists('ini_get')) {

 // open_basedir check, if invocked limits several php functions
  if(ini_get('open_basedir') == ''){
    //no  open_basedir
    $serv_open_basedir = '1';
  }

}

// Set the local configuration parameters - mainly for developers
  if (file_exists('includes/local/configure.php')) include('includes/local/configure.php');

define('TEXT_PREFIX', 'text_');
define('PRODUCTS_OPTIONS_VALUE_TEXT_ID', 4); //Must match id for user defined "TEXT" value in db table TABLE_PRODUCTS_OPTIONS_VALUES

 
// include server parameters
 # require('includes/configure.php');
if (file_exists('includes/configure.php')) {
  require('includes/configure.php');
} else {
  echo '<a href="install/index.php"><b>Proceed to installation</b></a>';
exit();
}
// define the project version
include('includes/version.php');

// set the type of request (secure or not)
  $request_type = (getenv('HTTPS') == 'on') ? 'SSL' : 'NONSSL';

// set php_self in the local scope
  if (!isset($PHP_SELF)) $PHP_SELF = $HTTP_SERVER_VARS['PHP_SELF'];

  if ($request_type == 'NONSSL') {
    define('DIR_WS_CATALOG', DIR_WS_HTTP_CATALOG);
  } else {
    define('DIR_WS_CATALOG', DIR_WS_HTTPS_CATALOG);
  }

// set php_self in the local scope
  $PHP_SELF = (isset($HTTP_SERVER_VARS['PHP_SELF']) ? $HTTP_SERVER_VARS['PHP_SELF'] : $HTTP_SERVER_VARS['SCRIPT_NAME']);
// include the list of project filenames
  require(DIR_WS_INCLUDES . 'filenames.php');

// include the list of project database tables
  require(DIR_WS_INCLUDES . 'database_tables.php');

// customization for the design layout
//define('BOX_WIDTH', 125); // how wide the boxes should be in pixels (default: 125)

// include the database functions
  require(DIR_WS_FUNCTIONS . 'database.php');

// make a connection to the database... now
  tep_db_connect() or die('Unable to connect to database server!');

// set the application parameters
  $default_left_cols_settings_key="";
  $default_left_cols_settings_value="";
  $configuration_query = tep_db_query('select configuration_key as cfgKey, configuration_value as cfgValue from ' . TABLE_CONFIGURATION);  
  while ($configuration = tep_db_fetch_array($configuration_query)) {     
    define($configuration['cfgKey'], $configuration['cfgValue']);     
  }

// if gzip_compression is enabled, start to buffer the output
  if ( (GZIP_COMPRESSION == 'true') && ($ext_zlib_loaded = extension_loaded('zlib')) && (PHP_VERSION >= '4') ) {
    if (($ini_zlib_output_compression = (int)ini_get('zlib.output_compression')) < 1) {
      if (PHP_VERSION >= '4.0.4') {
        ob_start('ob_gzhandler');
      } else {
        include(DIR_WS_FUNCTIONS . 'gzip_compression.php');
        ob_start();
        ob_implicit_flush();
      }
    } else {
      ini_set('zlib.output_compression_level', GZIP_LEVEL);
    }
  }

// some code to solve compatibility issues
  require(DIR_WS_FUNCTIONS . 'compatibility.php');

  //CRE_SEO Install Begin
  if (file_exists(DIR_FS_CATALOG . 'seo.php') && (CRE_SEO == 'true')) {
    require_once('seo.php');
  }
  //CRE_SEO Install End

include('includes/application_top_cre_setting.php');  
  
if (TEMPLATE_USE_CONFIGURABLE_PRODUCT_INFO == 'true'){
     define('CONTENT_PRODUCT_INFO', 'product_info_configureable');
  }else{ 
     define('CONTENT_PRODUCT_INFO', 'product_info');
  }

define('FILENAME_PRODUCT_INFO', CONTENT_PRODUCT_INFO . '.php');

// define general functions used application-wide
  require(DIR_WS_FUNCTIONS . 'general.php');
  require(DIR_WS_FUNCTIONS . 'html_output.php');

// include calendar class
require(DIR_WS_CLASSES . 'calendar.php');

// set the cookie domain
  $cookie_domain = (($request_type == 'NONSSL') ? HTTP_COOKIE_DOMAIN : HTTPS_COOKIE_DOMAIN);
  $cookie_path = (($request_type == 'NONSSL') ? HTTP_COOKIE_PATH : HTTPS_COOKIE_PATH);

// include cache functions if enabled
  if (USE_CACHE == 'true') include(DIR_WS_FUNCTIONS . 'cache.php');

// include shopping cart class
  require(DIR_WS_CLASSES . 'shopping_cart.php');
// begin PayPal_Shopping_Cart_IPN 2.8 (DMG)
    require(DIR_WS_MODULES . 'payment/paypal/classes/osC/osC.class.php');
// end PayPal_Shopping_Cart_IPN

// include navigation history class
  require(DIR_WS_CLASSES . 'navigation_history.php');


// define how the session functions will be used
  require(DIR_WS_FUNCTIONS . 'sessions.php');

  // set the session name and save path
  tep_session_name('osCsid');
  tep_session_save_path(SESSION_WRITE_DIRECTORY);

  // set the session cookie parameters
  session_set_cookie_params(0, $cookie_path, $cookie_domain);
  
  $session_started = false;
  // Check for spider may be required
  if (SESSION_BLOCK_SPIDERS == 'True') {
    $user_agent = strtolower(getenv('HTTP_USER_AGENT'));
    $spider_flag = false;
    if ( tep_not_null($user_agent) ) {
    //  $spiders = file(DIR_WS_INCLUDES . 'spiders.txt');
      for ($i=0, $n=sizeof($spiders); $i<$n; ++$i) {
        if ( tep_not_null($spiders[$i]) ) {
          if ( is_integer( strpos($user_agent, trim($spiders[$i])) ) ) {
            $spider_flag = true;
            // no need to create a session
            break;
          }
        }
      }
    }
    if ($spider_flag == false) {
      tep_session_start();
      $session_started = true;
    }
  // At this point, all checks are complete, so start a session
  } else {
    tep_session_start();
    $session_started = true;
  }

// set SID once, even if empty
  $SID = (defined('SID') ? SID : '');

// verify the ssl_session_id if the feature is enabled
  if ( ($request_type == 'SSL') && (SESSION_CHECK_SSL_SESSION_ID == 'True') && (ENABLE_SSL == true) && ($session_started == true) ) {
    $ssl_session_id = getenv('SSL_SESSION_ID');
    if (!tep_session_is_registered('SSL_SESSION_ID')) {
      $SESSION_SSL_ID = $ssl_session_id;
      tep_session_register('SESSION_SSL_ID');
    }

    if ($SESSION_SSL_ID != $ssl_session_id) {
      tep_session_destroy();
      tep_redirect(tep_href_link(FILENAME_SSL_CHECK));
    }
  }

// verify the browser user agent if the feature is enabled
  if (SESSION_CHECK_USER_AGENT == 'True') {
    $http_user_agent = getenv('HTTP_USER_AGENT');
    if (!tep_session_is_registered('SESSION_USER_AGENT')) {
      $SESSION_USER_AGENT = $http_user_agent;
      tep_session_register('SESSION_USER_AGENT');
    }

    if ($SESSION_USER_AGENT != $http_user_agent) {
      tep_session_destroy();
      tep_redirect(tep_href_link(FILENAME_LOGIN));
    }
  }

// verify the IP address if the feature is enabled
  if (SESSION_CHECK_IP_ADDRESS == 'True') {
    $ip_address = tep_get_ip_address();
    if (!tep_session_is_registered('SESSION_IP_ADDRESS')) {
      $SESSION_IP_ADDRESS = $ip_address;
      tep_session_register('SESSION_IP_ADDRESS');
    }

    if ($SESSION_IP_ADDRESS != $ip_address) {
      tep_session_destroy();
      tep_redirect(tep_href_link(FILENAME_LOGIN));
    }
  }

// create the shopping cart & fix the cart if necesary
  if (tep_session_is_registered('cart') && is_object($cart)) {
    if (PHP_VERSION < 4) {
      $broken_cart = $cart;
      $cart = new shoppingCart;
      $cart->unserialize($broken_cart);
    }
  } else {
    tep_session_register('cart');
    $cart = new shoppingCart;
  }

// begin PayPal_Shopping_Cart_IPN V2.8 DMG
//   require_once DIR_WS_MODULES . 'payment/paypal/functions/paypal.fnc.php';
  PayPal_osC::check_order_status(true);
// end PayPal_Shopping_Cart_IPN

// include currencies class and create an instance
  require(DIR_WS_CLASSES . 'currencies.php');
  $currencies = new currencies();
//Eversun mod for sppc and qty price breaks
require(DIR_WS_CLASSES . 'PriceFormatter.php');
  $pf = new PriceFormatter;
 // Eversun end mod for sppc and qty price breaks
// include the mail classes
  require(DIR_WS_CLASSES . 'mime.php');
  require(DIR_WS_CLASSES . 'email.php');

  // ensure that the followin variables are loaded from the session information
  if (isset($_SESSION['customer_id'])) {
    $customer_id = (int)$_SESSION['customer_id'];
  } else {
    $customer_id = 0;
  }
  
// initialize the RCI class
  require(DIR_WS_CLASSES . 'rci.php');
  $cre_RCI = new cre_RCI;

// set the language
  if (!tep_session_is_registered('language') || isset($HTTP_GET_VARS['language'])) {
    if (!tep_session_is_registered('language')) {
      tep_session_register('language');
      tep_session_register('languages_id');
    }

    include(DIR_WS_CLASSES . 'language.php');
    $lng = new language();

    if (isset($HTTP_GET_VARS['language']) && tep_not_null($HTTP_GET_VARS['language'])) {
      $lng->set_language($HTTP_GET_VARS['language']);
 //   } else {
//      $lng->get_browser_language();
    }

    $language = $lng->language['directory'];
    $languages_id = $lng->language['id'];
  }

// seb le 26 09 2013  forcage langue 1 pour google panda charlotte boutik lang = 3 
$languages_id = 1;

// include the language translations
  require(DIR_WS_LANGUAGES . $language . '.php');

// Ultimate SEO URLs v2.2
    include_once(DIR_WS_CLASSES . 'seo.class.php');
	if ( !is_object($seo_urls) ){
		$seo_urls = new SEO_URL($languages_id);
	}


// include RCI language extensions
  $cre_RCI->get($language, 'lang', false);

// currency
  if (!tep_session_is_registered('currency') || isset($HTTP_GET_VARS['currency']) || ( (USE_DEFAULT_LANGUAGE_CURRENCY == 'true') && (LANGUAGE_CURRENCY != $currency) ) ) {
    if (!tep_session_is_registered('currency')) tep_session_register('currency');

    if (isset($HTTP_GET_VARS['currency'])) {
      if (!$currency = tep_currency_exists(strtoupper($HTTP_GET_VARS['currency']))) $currency = (USE_DEFAULT_LANGUAGE_CURRENCY == 'true') ? LANGUAGE_CURRENCY : DEFAULT_CURRENCY;
    } else {
      $currency = (USE_DEFAULT_LANGUAGE_CURRENCY == 'true') ? LANGUAGE_CURRENCY : DEFAULT_CURRENCY;
    }
  }

// navigation history
  if (tep_session_is_registered('navigation')) {
    if (PHP_VERSION < 4) {
      $broken_navigation = $navigation;
      $navigation = new navigationHistory;
      $navigation->unserialize($broken_navigation);
    }
  } else {
    tep_session_register('navigation');
    $navigation = new navigationHistory;
  }
  $navigation->add_current_page();

// BOF: Down for Maintenance except for admin ip
if (EXCLUDE_ADMIN_IP_FOR_MAINTENANCE != getenv('REMOTE_ADDR')){
  if (DOWN_FOR_MAINTENANCE=='true' and !strstr($PHP_SELF,DOWN_FOR_MAINTENANCE_FILENAME)) { tep_redirect(tep_href_link(DOWN_FOR_MAINTENANCE_FILENAME)); }
  }
// do not let people get to down for maintenance page if not turned on
if (DOWN_FOR_MAINTENANCE=='false' and strstr($PHP_SELF,DOWN_FOR_MAINTENANCE_FILENAME)) {
    tep_redirect(tep_href_link(FILENAME_DEFAULT));
}
// EOF: WebMakers.com Added: Down for Maintenance


// BOF: WebMakers.com Added: Functions Library
    include(DIR_WS_FUNCTIONS . 'webmakers_added_functions.php');
// EOF: WebMakers.com Added: Functions Library

// Shopping cart actions

  if (isset($HTTP_GET_VARS['action'])) {
// redirect the customer to a friendly cookie-must-be-enabled page if cookies are disabled
    if ($session_started == false) {
      tep_redirect(tep_href_link(FILENAME_COOKIE_USAGE));
    }

    if (DISPLAY_CART == 'true') {
      $goto =  FILENAME_SHOPPING_CART;
      $parameters = array('action', 'cPath', 'products_id', 'pid');
    } else {
      $goto = basename($PHP_SELF);
      if ($HTTP_GET_VARS['action'] == 'buy_now') {
        $parameters = array('action', 'pid', 'products_id');
      } else {
        $parameters = array('action', 'pid');
      }
    }
    switch ($HTTP_GET_VARS['action']) {
      // customer wants to update the product quantity in their shopping cart
      case 'update_product' : for ($i=0, $n=sizeof($HTTP_POST_VARS['products_id']); $i<$n; $i++) {
                                if (in_array($HTTP_POST_VARS['products_id'][$i], (is_array($HTTP_POST_VARS['cart_delete']) ? $HTTP_POST_VARS['cart_delete'] : array()))) {
                                  $cart->remove($HTTP_POST_VARS['products_id'][$i]);
                                } else {
                                  if (PHP_VERSION < 4) {
                                    // if PHP3, make correction for lack of multidimensional array.
                                    reset($HTTP_POST_VARS);
                                    while (list($key, $value) = each($HTTP_POST_VARS)) {
                                      if (is_array($value)) {
                                        while (list($key2, $value2) = each($value)) {
                                          if (ereg ("(.*)\]\[(.*)", $key2, $var)) {
                                            $id2[$var[1]][$var[2]] = $value2;
                                          }
                                        }
                                      }
                                    }
                                    $attributes = ($id2[$HTTP_POST_VARS['products_id'][$i]]) ? $id2[$HTTP_POST_VARS['products_id'][$i]] : '';
                                  } else {
                                    $attributes = ($HTTP_POST_VARS['id'][$HTTP_POST_VARS['products_id'][$i]]) ? $HTTP_POST_VARS['id'][$HTTP_POST_VARS['products_id'][$i]] : '';
                                  }
                                  
                   //Eversun mod for sppc and qty price breaks
                                 // $cart->add_cart($HTTP_POST_VARS['products_id'][$i], $HTTP_POST_VARS['cart_quantity'][$i], $attributes, false);
/*
                  $cart->add_cart($HTTP_POST_VARS['products_id'], $cart->get_quantity(tep_get_uprid($HTTP_POST_VARS['products_id'], $HTTP_POST_VARS['id'])) + $HTTP_POST_VARS['cart_quantity'], $HTTP_POST_VARS['id']);
                  */
                   $cart->add_cart($HTTP_POST_VARS['products_id'][$i],  $HTTP_POST_VARS['cart_quantity'][$i],$attributes, false);
                  //Eversun mod end for sppc and qty price breaks
                                }
                              }
                              tep_redirect(tep_href_link($goto, tep_get_all_get_params($parameters)));
                              break;
/*
      // customer adds a product from the products page
      case 'add_product' :    if (isset($HTTP_POST_VARS['products_id']) && is_numeric($HTTP_POST_VARS['products_id'])) {
                                $cart->add_cart($HTTP_POST_VARS['products_id'], $cart->get_quantity(tep_get_uprid($HTTP_POST_VARS['products_id'], $HTTP_POST_VARS['id']))+1, $HTTP_POST_VARS['id']);
                              }
                              tep_redirect(tep_href_link($goto, tep_get_all_get_params($parameters)));
                              break;
*/



      // customer adds a product from the products page
      case 'add_product' :    if (isset($HTTP_POST_VARS['products_id']) && is_numeric($HTTP_POST_VARS['products_id'])) {
                  if (tep_session_is_registered('customer_id')) tep_db_query("delete from " . TABLE_WISHLIST . " WHERE customers_id=$customer_id AND products_id=" . (int)$HTTP_POST_VARS['products_id']);

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//++++ QT Pro: Begin Changed code
                                $attributes=array();
                                if (isset($HTTP_POST_VARS['attrcomb']) && (preg_match("/^\d{1,10}-\d{1,10}(,\d{1,10}-\d{1,10})*$/",$HTTP_POST_VARS['attrcomb']))) {
                                  $attrlist=explode(',',$HTTP_POST_VARS['attrcomb']);
                                  foreach ($attrlist as $attr) {
                                    list($oid, $oval)=explode('-',$attr);
                                    if (is_numeric($oid) && $oid==(int)$oid && is_numeric($oval) && $oval==(int)$oval)
                                      $attributes[$oid]=$oval;
                                  }
                                }
                                if (isset($HTTP_POST_VARS['id']) && is_array($HTTP_POST_VARS['id'])) {
                                  foreach ($HTTP_POST_VARS['id'] as $key=>$val) {
                                    if (is_numeric($key) && $key==(int)$key && is_numeric($val) && $val==(int)$val)
                                      $attributes=$attributes + $HTTP_POST_VARS['id'];
                                  }
                                }
                                $cart->add_cart($HTTP_POST_VARS['products_id'], $cart->get_quantity(tep_get_uprid($HTTP_POST_VARS['products_id'], $attributes))+$HTTP_POST_VARS['cart_quantity'], $attributes);
//++++ QT Pro: End Changed Code
///////////////////////////////////////////////////////////////////////////////////////////////////////////

                              }
                              tep_redirect(tep_href_link($goto, tep_get_all_get_params($parameters), 'NONSSL'));
   break;
      // customer adds a product from the products page

// Wishlist Checkboxes - start
case 'add_del_products_wishlist' : 
  //delete selected products from wishlist
  if (isset($HTTP_POST_VARS['del_wishprod'])) {
    foreach ($HTTP_POST_VARS['del_wishprod'] as $value) {
      if (ereg('^[0-9]+$', $value)) {
           tep_db_query("delete from " . TABLE_WISHLIST . " where products_id = $value and customers_id = '" . $customer_id . "'");
         }
     }
  }
  // add selected products to wishlist
  if (isset($HTTP_POST_VARS['add_wishprod'])) {
    foreach ($HTTP_POST_VARS['add_wishprod'] as $value) {
      if (ereg('^[0-9]+$', $value)) {
        tep_db_query("delete from " . TABLE_WISHLIST . " where products_id = $value and customers_id = '" . $customer_id . "'");
        $cart->add_cart($value, $cart->get_quantity(tep_get_uprid($value, $HTTP_POST_VARS['id'][$value]))+1, $HTTP_POST_VARS['id'][$value]);
      }
    }
  }
  $wishlist_query_raw = "select * from " . TABLE_WISHLIST . " where customers_id = '" . $customer_id . "' and products_id > 0 and customers_id > 0 order by products_name";
  $wishlist_query = tep_db_query($wishlist_query_raw);

  if ( (!tep_db_num_rows($wishlist_query)) && ($cart->count_contents() > 0) ) {
    tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
  }else{
    tep_redirect(tep_href_link(FILENAME_WISHLIST));
  }
  break;
// Wishlist Checkboxes - end


// Add product to the wishlist
      case 'add_wishlist' :   if (ereg('^[0-9]+$', $HTTP_POST_VARS['products_id'])) {
                                if ($HTTP_POST_VARS['products_id']) {
                                  tep_db_query("delete from " . TABLE_WISHLIST . " where products_id = '" . $HTTP_POST_VARS['products_id'] . "' and customers_id = '" . $customer_id . "'");
                                  tep_db_query("insert into " . TABLE_WISHLIST . " (customers_id, products_id, products_model, products_name, products_price) values ('" . $customer_id . "', '" . $HTTP_POST_VARS['products_id'] . "', '" . tep_db_input($HTTP_POST_VARS['products_model']) . "', '" . tep_db_input($$HTTP_POST_VARS['products_name']) . "', '" . tep_db_input($HTTP_POST_VARS['products_price']) . "' )");
                                  // Eversun mod for wishlist attribute
                                  tep_db_query("delete from " . TABLE_WISHLIST_ATTRIBUTES . " where products_id = '" . $HTTP_POST_VARS['products_id'] . "' and customers_id = '" . $customer_id . "'");
                                  if (isset ($HTTP_POST_VARS['id'])) {
                                    foreach($HTTP_POST_VARS['id'] as $att_option => $att_value) {
                                      tep_db_query("insert into " . TABLE_WISHLIST_ATTRIBUTES . " (customers_id, products_id, products_options_id , products_options_value_id) values ('" . $customer_id . "', '" . $HTTP_POST_VARS['products_id'] . "', '" . (int)$att_option . "', '" . (int)$att_value . "' )");
                                    }
                                  }
                                  // Eversun mod end for wishlist attribute
                                }
                              }
                              tep_redirect(tep_href_link(FILENAME_WISHLIST));
                              break;


      /*  this code has been removed becuase it it is no longer used in the cart
      case 'wishlist_add_cart': reset ($lvnr);
                                reset ($lvanz);
                                  while (list($key,$elem) =each ($lvnr))
                                        {
                                        (list($key1,$elem1) =each ($lvanz));
                                        tep_db_query("update " . TABLE_WISHLIST . " set products_quantity = '" . $elem1 . "' where customers_id = '" . $customer_id . "' and products_id = '" . $elem . "'");
                                        tep_db_query("delete from " . TABLE_WISHLIST . " where customers_id= '" . $customer_id . "' and products_quantity = '999'");
                                        $produkte_mit_anzahl=tep_db_query("select * from " . TABLE_WISHLIST . " where customers_id = '" . $customer_id . "' and products_id = '" . $elem . "' and products_quantity<>'0'");

                                  while ($HTTP_GET_VARS=tep_db_fetch_array($produkte_mit_anzahl))
                                  {
                                  $cart->add_cart($HTTP_POST_VARS['products_id'], $HTTP_POST_VARS['products_quantity']);
                                  }
                                          }
                                reset ($lvanz);
                              tep_redirect(tep_href_link(FILENAME_WISHLIST));
                              break;
      */

// remove item from the wishlist
      case 'remove_wishlist':
                              tep_db_query("delete from " . TABLE_WISHLIST . " where products_id = '" . (int)$HTTP_GET_VARS['pid'] . "' and customers_id = '" . $customer_id . "'");
                              tep_redirect(tep_href_link(FILENAME_WISHLIST));
                              break;

      // performed by the 'buy now' button in product listings and review page
      case 'buy_now' :        if ( isset($HTTP_GET_VARS['products_id']) || ereg('^[0-9]+$', $HTTP_GET_VARS['products_id']) ) {
                                //Wishlist 2.0.1 Modification
                                 if (tep_session_is_registered('customer_id')) { tep_db_query("delete from " . TABLE_WISHLIST . " WHERE customers_id=$customer_id AND products_id= '" . $HTTP_GET_VARS['products_id'] . "'"); }
                                // End Wishlist 2.0.1 Modification
                                if (tep_has_product_attributes($HTTP_GET_VARS['products_id']) || tep_has_product_subproducts($HTTP_GET_VARS['products_id']) ) {
                                  tep_redirect(tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $HTTP_GET_VARS['products_id']));
                                } else {
                                  $cart->add_cart($HTTP_GET_VARS['products_id'], $cart->get_quantity($HTTP_GET_VARS['products_id'])+1);
                                }
                              }
                              tep_redirect(tep_href_link($goto, tep_get_all_get_params($parameters)));
                              break;

      case 'notify' :         if (tep_session_is_registered('customer_id')) {
                                if (isset($HTTP_GET_VARS['products_id'])) {
                                  $notify = $HTTP_GET_VARS['products_id'];
                                } elseif (isset($HTTP_GET_VARS['notify'])) {
                                  $notify = $HTTP_GET_VARS['notify'];
                                } elseif (isset($HTTP_POST_VARS['notify'])) {
                                  $notify = $HTTP_POST_VARS['notify'];
                                } else {
                                  tep_redirect(tep_href_link(basename($PHP_SELF), tep_get_all_get_params(array('action', 'notify'))));
                                }
                                if (!is_array($notify)) $notify = array($notify);
                                for ($i=0, $n=sizeof($notify); $i<$n; $i++) {
                                  $check_query = tep_db_query("select count(*) as count from " . TABLE_PRODUCTS_NOTIFICATIONS . " where products_id = '" . (int)$notify[$i] . "' and customers_id = '" . $customer_id . "'");
                                  $check = tep_db_fetch_array($check_query);
                                  if ($check['count'] < 1) {
                                    tep_db_query("insert into " . TABLE_PRODUCTS_NOTIFICATIONS . " (products_id, customers_id, date_added) values ('" . (int)$notify[$i] . "', '" . $customer_id . "', now())");
                                  }
                                }
                                tep_redirect(tep_href_link(basename($PHP_SELF), tep_get_all_get_params(array('action', 'notify'))));
                              } else {
                                $navigation->set_snapshot();
                                tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
                              }
                              break;
      case 'notify_remove' :  if (tep_session_is_registered('customer_id') && isset($HTTP_GET_VARS['products_id'])) {
                                $check_query = tep_db_query("select count(*) as count from " . TABLE_PRODUCTS_NOTIFICATIONS . " where products_id = '" . (int)$HTTP_GET_VARS['products_id'] . "' and customers_id = '" . $customer_id . "'");
                                $check = tep_db_fetch_array($check_query);
                                if ($check['count'] > 0) {
                                  tep_db_query("delete from " . TABLE_PRODUCTS_NOTIFICATIONS . " where products_id = '" . (int)$HTTP_GET_VARS['products_id'] . "' and customers_id = '" . $customer_id . "'");
                                }
                                tep_redirect(tep_href_link(basename($PHP_SELF), tep_get_all_get_params(array('action'))));
                              } else {
                                $navigation->set_snapshot();
                                tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
                              }
                              break;


      case 'cust_order' :     if (tep_session_is_registered('customer_id') && isset($HTTP_GET_VARS['pid'])) {
                                if (tep_has_product_attributes($HTTP_GET_VARS['pid'])) {
                                  // Although the product has attributes we still delete it from the WISHLIST:
                                  if ($rfw == 1) tep_db_query("delete from " . TABLE_WISHLIST . " WHERE customers_id=$customer_id AND products_id='" . (int)$HTTP_GET_VARS['pid'] . "'");
                                  tep_redirect(tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . (int)$HTTP_GET_VARS['pid'], 'NONSSL'));
                                } else {
                                  // First delete from wishlist:
                                  if ($rfw == 1) tep_db_query("delete from " . TABLE_WISHLIST . " WHERE customers_id=$customer_id AND products_id='" . (int)$HTTP_GET_VARS['pid'] . "'");
                                  $cart->add_cart($HTTP_GET_VARS['pid'], $cart->get_quantity($HTTP_GET_VARS['pid'])+1);
                                }
                              }
                              tep_redirect(tep_href_link($goto, tep_get_all_get_params($parameters), 'NONSSL'));
                              break;

    }
  }



// auto expire special products
  require(DIR_WS_FUNCTIONS . 'specials.php');
  tep_expire_specials();


$cre_RCI->get('top', 'load', false);
//RCI end


?>