<?php
/*
  $Id: abxPage.php,v 1.24 2008/03/13 14:33:25 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  require_once DIR_FS_ABX_CLASSES.'Page/abxPageFactory.php';
  require_once DIR_FS_ABX_CLASSES.'abxHtml.php';

  class abxPage extends abxHtml {

    var $pageTitle, $templateType;

    function abxPage()
    {
      $this->setTitle(TITLE);
      $this->addJavaScript('JSCookMenu.js',DIR_WS_ABX_EXTERNAL . 'jscookmenu');
      $this->addJavaScript('general.js','includes');
      $this->addJavaScript('general.js');
      $this->addJavaScript('theme.js',DIR_WS_ABX_EXTERNAL . 'jscookmenu/ThemeOffice');
      if ($_SESSION['abxConfig']['installed'] === true){
      	$this->addJavaScript(abx_href_link(FILENAME_AUCTIONBLOX,'abx=jscookmenu'));
      }
      $this->addCSS('stylesheet.css','includes');
      $this->addCSS('stylesheet.css');
      $this->addCSS('theme.css',DIR_WS_ABX_EXTERNAL . 'jscookmenu/ThemeOffice');
      $this->setTemplate('admin');
      $this->charSet = CHARSET;
    }

    function display()
    {
      return $this->template();
    }

    function templateType($type = '')
    {
      if(empty($type) && isset($this->templateType))

        return $this->templateType;

      return $this->templateType = !empty($type) ? $type : 'file';
    }

    function template() {
      $sTpl = DIR_FS_MYABX_TEMPLATE_DIR . $this->templateName . '.php';

      if (file_exists($sTpl)) {
        return $sTpl;
      }

      return DIR_FS_ABX_TEMPLATES . $this->templateName . '.php';
    }

    function setTemplate($template)
    {
      $this->templateName = $template;
    }

    function setBaseURL($location)
    {
      $this->baseURL = abxPage::outputString($location);
    }

    function setTitle($title = '')
    {
      $this->pageTitle = abxPage::outputString($title);
      $this->setMetaTitle($title);
    }

    function setMetaTitle($title)
    {
      $this->metaTitle = abxPage::outputString($title);
    }

    function setOnLoad($javascript)
    {
      $this->onLoad = abxPage::outputString($javascript);
    }

    function setContent($content = '')
    {
      $this->content = $content;

      $this->templateType('string');
    }

    function setContentFile($contentFile = '', $contentDirectory = '')
    {

      if ($contentDirectory === DIR_FS_MYABX_PAGES_DIR) {
        if (!file_exists($contentDirectory.$contentFile.'.php')) {
          $contentDirectory = '';
        }
      }

      if (!$contentDirectory) {
        $contentDirectory = DIR_FS_ABX_PAGES;
      }

      $this->contentFile = $contentDirectory . $contentFile . '.php';
    }

    function includeLanguageFile($lng_file)
    {
      $language = abxRegistry::get("language");

      abx_includeLanguageFile(DIR_FS_ABX_INCLUDES,$language,$lng_file);
    }

    function addJavaScript($filename, $javascriptDirectory = '')
    {
      if (empty($javascriptDirectory) === true && substr($filename,-4) === '.php')
        $javascriptDirectory = DIR_FS_ABX_JAVASCRIPT;
      elseif (empty($javascriptDirectory) === true && substr($filename,-3) === '.js')
        $javascriptDirectory = DIR_WS_ABX_JAVASCRIPT;
      elseif (empty($javascriptDirectory) === false && substr($javascriptDirectory,-1) !== '/')
        $javascriptDirectory .= '/';

      $this->javascript[] = $javascriptDirectory . $filename;
    }

    function addCSS($filename, $cssDirectory = '')
    {
      if (empty($cssDirectory) === true && substr($filename,-4) === '.php')
        $cssDirectory = DIR_FS_ABX_STYLESHEET;
      elseif (empty($cssDirectory) === true && substr($filename,-4) === '.css')
        $cssDirectory = DIR_WS_ABX_STYLESHEET;
      elseif (empty($cssDirectory) === false && substr($cssDirectory,-1) !== '/')
        $cssDirectory .= '/';

      $this->css[] = $cssDirectory . $filename;
    }

    function addCalendar()
    {
      $this->addCSS('calendar-blue.css',DIR_WS_ABX_EXTERNAL . 'jscalendar');

      $this->addJavaScript('calendar.js',DIR_WS_ABX_EXTERNAL . 'jscalendar');

      $this->addJavaScript('calendar-en.js',DIR_WS_ABX_EXTERNAL . 'jscalendar/lang');

      $this->addJavaScript('calendar-setup.js',DIR_WS_ABX_EXTERNAL . 'jscalendar');
    }

    function getSearchParams($exclude = array(), $include = array(), $prefix = '&')
    {
      static $searchParams;

      // form, pID and pName are used by paginator items_product_search
      $array = array(
        'searchvalue',
        'searchname',
        'filter',
        'seller_id',
        'form',
        'pID',
        'pName',
        'page'
      );

      $array = array_diff($array,$exclude);
      $array = array_merge($array,$include);
      $params = array();
      foreach($_GET as $key => $val)
        if ($key != session_name() && $key != 'error' && in_array($key,$array) && !empty($val))
          $params[] .= $key . '=' . urlencode($val);

      return empty($params) ? '' : $prefix.implode('&',$params);
    }

    function getParams($exclude = array())
    {
      foreach($_GET as $key => $val)
        if ($key != session_name() && $key != 'error' && !in_array($key, $exclude))
          $params .= $key . '=' . $val . '&';

      return (!empty($params) ? substr($params,'',-1) : '');
    }

    function copyright()
    {
      return '<div class="copyright">AuctionBlox Engine Copyright &copy; 2003-2007 <a href="http://www.auctionblox.com" class="copyright" target="_blank">AuctionBlox</a></div>';
    }

    function setPopupCloseWindow($str)
    {
      $this->closeWindowFunction = $str;
    }

    function popupCloseWindow()
    {
      return (isset($this->closeWindowFunction) ? $this->closeWindowFunction : 'window.close();return(false);' );
    }

    function redirect($url)
    {
      header('Location: ' . $url);
      exit;
    }

    function javascript()
    {
      $js = '';

      for($i=0, $n = count($this->javascript); $i<$n; $i++) {

        if (substr($this->javascript[$i],-7) === '.js.php') {

          $js .= '<script language="JavaScript" type="text/javascript">'."\n".
                 '/*<![CDATA[*/'."\n";
          ob_start();
          require_once($this->javascript[$i]);
          $js .= ob_get_contents();
          ob_end_clean();
          $js .= "\n".'/*]]>*/'."\n".
                 '</script>'."\n";

        } else {

          $js .= '<script language="JavaScript" type="text/javascript" src="' . abxPage::outputString($this->javascript[$i]) . '"></script>'."\n";

        }

      }

      return $js;
    }

    function stylesheet()
    {
      $css = '';

      if (is_array($this->css) === true && empty($this->css) === false) {

        $css = '<style type="text/css" media="all">'."\n";

        for ($i=0, $cssCount = count($this->css); $i<$cssCount; $i++)
          $css .= "  @import url('" . addslashes($this->css[$i]) . "');\n";

       $css .= "</style>\n";

      }

      return $css;
    }

  }//end class

  class abxPage_Catalog extends abxPage {

    function abxPage_Catalog()
    {
      //$this->addCSS('stylesheet.css');
      $this->setTemplate('catalog');
    }

  }//end class
?>
