<?php
/*
  $Id: abxCheckout.php,v 1.20 2009/04/10 14:51:00 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

 class_exists('abxManager') || require_once(dirname(__FILE__).'/abxManager.php');
 class_exists('abxRegistry') || require_once(dirname(__FILE__).'/abxRegistry.php');
 require_once(DIR_FS_ABX_EXTERNAL_CART . 'includes/functions/integration.php');

 if (!class_exists('abxDatabase')) {
    require_once dirname(__FILE__).'/abxDatabase.php';
    $GLOBALS['abxDatabase'] = &abxDatabase::connect(DB_SERVER, DB_SERVER_USERNAME, DB_SERVER_PASSWORD);
    $GLOBALS['abxDatabase']->selectDatabase(DB_DATABASE);
  }
  
  class abxCheckout extends abxManager {

    function canCheckout($auctions)
    {
      return true;
    }

    function getCartItems($email_address)
    {
      global $abxDatabase;
      
      $languages_id = abxRegistry::get("languages_id");
            
      $products_array = array();

      $auctions = $this->getSalesWithStatus($email_address, $this->ENDED);
      if (is_array($auctions)) {

        foreach($auctions as $key => $auction) {
// This is now already handled.  We create orders for paypal payments, so these
// won't show up in the cart during checkout.  However, we do need these to be
// in the cart for product attributes   
//          if($auction['payment_provider'] != null) // item has already been paid for
//            continue;  
            
          $products = $abxDatabase->fetch_row("select p.products_id, pd.products_name, p.products_model, p.products_image, p.products_price, p.products_weight, p.products_tax_class_id from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_id = '" . (int)$auction['product_id'] . "' and pd.products_id = p.products_id and pd.language_id = '" . (int)$languages_id . "'");

          if (empty($products) === false) {
            
            //get cart specific product attrubutes
            $product_attributes=abx_get_auction_product_attributes($auction['id']);

            $this->attributes[$products['products_id']]=$product_attributes;

            $products_array[] = array(
              'id'                => $products['products_id'],
              'name'              => $auction['ext_title'] . " (eBay #" . $auction['ext_id'] . ", " . $auction['buyer_id'] . ")",
              'model'             => $products['products_model'],
              'image'             => $products['products_image'],
              'quantity'          => $auction['qty'],
              'weight'            => $products['products_weight'],
              'currency'          => $auction['currency'],
              'tax_class_id'      => $products['products_tax_class_id'],
              'price'             => abx_currencies_convertCurrency($auction['price_end'], $auction['currency']),
              'final_price'       => abx_currencies_convertCurrency($auction['price_end'], $auction['currency']) + $this->auction_attributes_price($auction['id']),
              'shipping_type'     => $auction['shipping_type'],
              'shipping'          => abx_currencies_convertCurrency($auction['shipping'], $auction['currency']),
              'shipping_global'   => abx_currencies_convertCurrency($auction['shipping_global'], $auction['currency']),
              'insurance'         => abx_currencies_convertCurrency($auction['insurance'], $auction['currency']),
              'insurance_option'  => $auction['insurance_option'],
              'is_auction_item'   => true,
              'listing_id'        => $auction['ext_id'],
              'auction_basket_id' => $auction['id'],
              'item_url'          => $auction['item_url'],
//              'attributes'        => array()
              'attributes'        => $product_attributes['attributes'],
              'attributes_values'  => $product_attributes['attributes_values'] //zen cart specific
            );
            
          } else {

            $sImage = '../'.DIR_WS_MODULES.'auctionblox/images/product.gif';

            // product ID not set
            // We can't use weight based shipping since we don't know the weight
            $products_array[] = array(
              'id'                => 0,
              'name'              => $auction['ext_title'] . " (eBay #" . $auction['ext_id'] . ", " . $auction['buyer_id'] . ")",
              'model'             => '',
              'image'             => $sImage,
              'quantity'          => $auction['qty'],
              'weight'            => -1,
              'tax_class_id'      => 0,
              'price'             => abx_currencies_convertCurrency($auction['price_end'], $auction['currency']),
              'final_price'       => abx_currencies_convertCurrency($auction['price_end'], $auction['currency']),
              'shipping_type'     => $auction['shipping_type'],
              'shipping'          => abx_currencies_convertCurrency($auction['shipping'], $auction['currency']),
              'shipping_global'   => abx_currencies_convertCurrency($auction['shipping_global'], $auction['currency']),
              'insurance'         => abx_currencies_convertCurrency($auction['insurance'], $auction['currency']),
              'insurance_option'  => $auction['insurance_option'],
              'is_auction_item'   => true,
              'listing_id'        => $auction['ext_id'],
              'auction_basket_id' => $auction['id'],
              'item_url'          => $auction['item_url'],
              'attributes'        => array()
            );
          }
         
          // Yuck - TODO: Move order mgmt to cart-specific folders        
          if(CART_INTEGRATION === 'zencart')
          {
            // get last inserted product to add some attributes
            $cart_item =& $products_array[sizeof($products_array)-1];
            
            $cart_item['products_prid'] = $cart_item['id'];
            $cart_item['products_priced_by_attribute'] = 0;
            $cart_item['product_is_free'] = 0;
            $cart_item['products_discount_type'] = 0;
            $cart_item['products_discount_type_from'] = 0;
          }        
                }
            }

            return $products_array;
        }

    function getAdminOrderItems($email_address)
    {
      global $abxDatabase;
      $languages_id = abxRegistry::get("languages_id");
            
      $products_array = array();

      $auctions = $this->getSalesWithStatus($email_address, $this->ENDED);
      if (is_array($auctions)) {

        foreach($auctions as $key => $auction) {
          $products = $abxDatabase->fetch_row("select p.products_id, pd.products_name, p.products_model, p.products_image, p.products_price, p.products_weight, p.products_tax_class_id from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_id = '" . (int)$auction['product_id'] . "' and pd.products_id = p.products_id and pd.language_id = '" . (int)$languages_id . "'");

          if (empty($products) === false) {

            $products_array[] = array(
              'id'                => $products['products_id'],
              'name'              => $auction['ext_title'] . " (eBay #" . $auction['ext_id'] . ", " . $auction['buyer_id'] . ")",
              'model'             => $products['products_model'],
              'image'             => $products['products_image'],
              'quantity'          => $auction['qty'],
              'weight'            => $products['products_weight'],
              'currency'          => $auction['currency'],
              'tax_class_id'      => $products['products_tax_class_id'],
              'price'             => abx_currencies_convertCurrency($auction['price_end'], $auction['currency']),
              'final_price'       => abx_currencies_convertCurrency($auction['price_end'], $auction['currency']) + $this->auction_attributes_price($auction['id']),
              'shipping_type'     => $auction['shipping_type'],
              'shipping'          => abx_currencies_convertCurrency($auction['shipping'], $auction['currency']),
              'shipping_global'   => abx_currencies_convertCurrency($auction['shipping_global'], $auction['currency']),
              'insurance'         => abx_currencies_convertCurrency($auction['insurance'], $auction['currency']),
              'insurance_option'  => $auction['insurance_option'],
              'is_auction_item'   => true,
              'listing_id'        => $auction['ext_id'],
              'auction_basket_id' => $auction['id'],
              'item_url'          => $auction['item_url'],
              'attributes'        => array()
            );
            
          } else {

            $sImage = '../'.DIR_WS_MODULES.'auctionblox/images/product.gif';

            // product ID not set
            // We can't use weight based shipping since we don't know the weight
            $products_array[] = array(
              'id'                => 0,
              'name'              => $auction['ext_title'] . " (eBay #" . $auction['ext_id'] . ", " . $auction['buyer_id'] . ")",
              'model'             => '',
              'image'             => $sImage,
              'quantity'          => $auction['qty'],
              'weight'            => -1,
              'tax_class_id'      => 0,
              'price'             => abx_currencies_convertCurrency($auction['price_end'], $auction['currency']),
              'final_price'       => abx_currencies_convertCurrency($auction['price_end'], $auction['currency']),
              'shipping_type'     => $auction['shipping_type'],
              'shipping'          => abx_currencies_convertCurrency($auction['shipping'], $auction['currency']),
              'shipping_global'   => abx_currencies_convertCurrency($auction['shipping_global'], $auction['currency']),
              'insurance'         => abx_currencies_convertCurrency($auction['insurance'], $auction['currency']),
              'insurance_option'  => $auction['insurance_option'],
              'is_auction_item'   => true,
              'listing_id'        => $auction['ext_id'],
              'auction_basket_id' => $auction['id'],
              'item_url'          => $auction['item_url'],
              'attributes'        => array()
            );
          }
         
          // Yuck - TODO: Move order mgmt to cart-specific folders        
          if(CART_INTEGRATION === 'zencart')
          {
            // get last inserted product to add some attributes
            $cart_item =& $products_array[sizeof($products_array)-1];
            
            $cart_item['products_prid'] = $cart_item['id'];
            $cart_item['products_priced_by_attribute'] = 0;
            $cart_item['product_is_free'] = 0;
            $cart_item['products_discount_type'] = 0;
            $cart_item['products_discount_type_from'] = 0;
          }        
                }
            }

            return $products_array;
        }

        
    function checkoutCartAndSetOrderId($abxList, $order_id)
    {
      global $abxDatabase;

      $abxList = abxArray::set_type($abxList,'integer');
      $abxDatabase->update(TABLE_ABX_BASKET, array( 'listing_status' => $this->CHECKEDOUT, 'orders_id' => (int)$order_id),'auction_basket_id in (' . implode(',',$abxList) . ')');
    }
                
    // We have a separate function here so that we can have logic independent of the cart.  An example might be that we want to exclude
    // sales that do not have product ids associated with them.                
    function getSalesForCreateOrder($email_address)
    {
      global $abxDatabase, $currencies;

      $languages_id = abxRegistry::get("languages_id");

      $query =
        " select a.auction_basket_id as id, a.*, " .
        " b.ext_email_address, " .
        " b.ext_customer_id, " .
        " si.site, si.url " .
        " from " . TABLE_ABX_BASKET . " a " .
        " LEFT JOIN " . TABLE_ABX_SITES . " si on (a.auction_house_id = si.auction_house_id and a.site = si.site)" .
        " LEFT JOIN " . TABLE_ABX_WINNERS . " b on (a.auction_winner_id = b.auction_winner_id)" .
        " WHERE b.ext_email_address = '" . addslashes($email_address) . "'" .
        " AND a.listing_status = " . $this->ENDED .
//        " AND a.time_end > DATE_SUB(now(), INTERVAL 30 DAY)" .         // used by sales-order.  plus confusing for this to be in "not checked out" but not show up in cart        
        " AND a.archived = 0" .         // don't include archived sales        
        " order by a.shipping desc";    // order by highest shipping cost so shipping module will operate correctly

      $auctionQuery = $abxDatabase->query($query);
      return $this->buildSalesArray($auctionQuery);
    }

    function getSalesWithStatus($email_address, $status)
    {
            global $abxDatabase, $currencies;

      $languages_id = abxRegistry::get("languages_id");

      $query =
        " select a.auction_basket_id as id, a.*, " .
        " b.ext_email_address, " .
        " b.ext_customer_id, " .
        " si.site, si.url " .
        " from " . TABLE_ABX_BASKET . " a " .
        " LEFT JOIN " . TABLE_ABX_SITES . " si on (a.auction_house_id = si.auction_house_id and a.site = si.site)" .
        " LEFT JOIN " . TABLE_ABX_WINNERS . " b on (a.auction_winner_id = b.auction_winner_id)" .
        " WHERE b.ext_email_address = '" . addslashes($email_address) . "'" .
        " AND a.listing_status = " . $status .
//        " AND a.time_end > DATE_SUB(now(), INTERVAL 30 DAY)" .         // used by sales-order.  plus confusing for this to be in "not checked out" but not show up in cart        
        " AND a.archived = 0" .         // don't include archived sales     
        " AND a.products_id > 0" .           // Exclude items that don't have products  
        " order by a.shipping desc";    // order by highest shipping cost so shipping module will operate correctly

      $auctionQuery = $abxDatabase->query($query);
      return $this->buildSalesArray($auctionQuery);
    }
    
    function buildSalesArray($resultset)
    {
      $contents = array();
      while($auctions = $resultset->next()) {

        $contents[] =
         array(
          'id'                  => $auctions['auction_basket_id'],
          'auction_house_id'    => $auctions['auction_house_id'],
          'auction_house_label' => $auctions['auction_house_label'],
          'site'                => $auctions['site'],
          'listing_type'        => $auctions['listing_type'],
          'ext_id'              => $auctions['ext_id'],
          'item_url'            => sprintf($auctions['url'], $auctions['ext_id']),
          'ext_title'           => $auctions['ext_title'],
          'qty'                 => $auctions['quantity'],
          'currency'            => $auctions['currency'],
          'price_start'         => $auctions['price_start'],
          'price_end'           => $auctions['price_end'],
          'insurance'           => $auctions['insurance'],
          'insurance_option'    => $auctions['insurance_option'],
          'shipping_type'       => $auctions['shipping_type'],
          'shipping'            => $auctions['shipping'],
          'shipping_global'     => $auctions['shipping_global'],
          'tax'                 => $auctions['sales_tax'],
          'time_start'          => $auctions['time_start'],
          'time_end'            => $auctions['time_end'],
          'status_id'           => $auctions['listing_status'],
          'buyer_id'            => $auctions['ext_customer_id'],
          'email'               => $auctions['ext_email_address'],
          'orders_id'           => $auctions['orders_id'],
          'product_id'          => $auctions['products_id'],
          
          'payment_provider'    => $auctions['payment_provider'],
          'payment_transaction_id' => $auctions['payment_transaction_id'],
          'payment_timestamp'   => $auctions['payment_timestamp'],
          'payment_currency'    => $auctions['payment_currency'],
          'payment_amount'      => $auctions['payment_amount'],
          'payment_fee'         => $auctions['payment_fee'],          

// Removed reference to $currencies global variable since it may not always 
// be declared when this class in included.  We need to create a class
// registry to lookup these damn globals.
        );
      }

          return $contents;
    }
    
    function getCustomerEbayEmail($id)
    {
      global $abxDatabase;

      $query =
        " select ext_email_address" .
        " FROM " . TABLE_ABX_WINNERS .
        " WHERE customers_id = " . (int)$id;

      $dbQuery = $abxDatabase->query($query);

      $email = null;
      if($winner = $dbQuery->next()) {
        $email = $winner['ext_email_address'];
      }
      return $email;
    }

  function auction_attributes_price($auction_basket_id) {
      global $abxDatabase;
      $attributes_price = 0;

      $attr_price_query = "select pa.options_values_price, pa.price_prefix from " . TABLE_PRODUCTS_ATTRIBUTES . " pa, abx_basket_attributes aba, abx_basket ab where ab.auction_basket_id = '" . (int)$auction_basket_id . "' and aba.auction_basket_id = ab.auction_basket_id and ab.products_id = pa.products_id and aba.products_options_id = pa.options_id and aba.products_options_value_id = pa.options_values_id and options_values_id";
      $dbQuery = $abxDatabase->query($attr_price_query);
      while ($result = $dbQuery->next()){
        if ($result['options_values_price'] > '0'){
            if ($result['price_prefix'] == '+'){
                $attributes_price += $result['options_values_price'];
            }
            else{
                $attributes_price -= $result['options_values_price'];
            }
        }
      }
      
      return $attributes_price;
    }
  }//end class
?>