<?php
/*
  $Id: abxItemUploads.php,v 1.26 2008/10/23 21:19:20 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  if (class_exists('abxAPI') === false) {

    require_once(DIR_FS_ABX_CLASSES . 'API/abxAPI.php');

  }

  if (class_exists('abxItemManager') === false) {

    require_once(DIR_FS_ABX_CLASSES . 'abxItemManager.php');

  }

  class abxItemUploads extends abxItemManager {

    var $PENDING   = 'P',
        $SUBMITTED = 'S',
        $ONCE = '0',
        $INTERVAL = '1',
        $KEEP1LISTED = '2',
        $errorCount,
        $successCount;

    function deleteUploads($IDs)
    {
      global $abxDatabase;

      $abxDatabase->delete(TABLE_ABX_UPLOADS,"id in (".implode(',',$IDs).")");
    }

    function getUpload($oID)
    {
      global $abxDatabase;

      $object_info = $abxDatabase->fetch_value('object_info', TABLE_ABX_UPLOADS, 'id = ' . (int) $oID);

      return (empty($object_info) === false) ? unserialize($object_info) : array();
    }

    function getUploadByListingUuid($uuid)
    {
      global $abxDatabase;

      $object_info = $abxDatabase->fetch_value('object_info', TABLE_ABX_UPLOADS, "listing_uuid = '" . addslashes($uuid) . "'");

      return (empty($object_info) === false) ? unserialize($object_info) : array();
    }

    function scheduleQueuedItem($oID,$scheduler_array)
    {
      global $abxDatabase;
      
      $date = $scheduler_array['scheduled_start'];
      $scheduler_array['scheduled_start'] = iso8601_encode($date);

      $sql_array = array(
        'scheduled_start' => $scheduler_array['scheduled_start'],
        'scheduled_info'  => serialize($scheduler_array)
      );

      $abxDatabase->update(TABLE_ABX_UPLOADS, $sql_array,'id = ' . (int)$oID);

      return $oID;
    }

    function getUploadsQuery($status = 'P')
    {
      return "select SQL_CALC_FOUND_ROWS id, title, listing_type, duration, price, quantity, scheduled_start, date_added  from " . TABLE_ABX_UPLOADS . " where upload_status = '". addslashes($status) . "'";
    }

    function performUpload($abxList)
    {
      global $abxDatabase;

      $numProcessed = 0;
      $errorCount   = 0;
      $successCount = 0;

      if (is_array($abxList) && sizeof($abxList) > 0) {

        $uploadsQuery = $abxDatabase->query("select * from " . TABLE_ABX_UPLOADS . " where id in (" . implode(',', $abxList) . ")");

        static $api;

        if (isset($api) === false)
          $api = new abxAPI;

        $successArray = array();

        $failedArray = array();

        while($data = $uploadsQuery->next()) {

          $id = $data['id'];

          $action = $data['action'];

          $upload = unserialize($data['object_info']);

          if($data['upload_status'] == $this->PENDING && !empty($data['scheduled_info'])) {
            $upload = array_merge($upload,unserialize($data['scheduled_info']));
          }

          if ($api->isValidAction($action)) {

            $response = $api->call($action, $upload);

          } else {

            $response['code'] = 'failure';

            $response['message'] = 'An invalid API method was invoked.';

          }

          if (substr($response['code'], 0, 7) === 'success')

            $successArray[] = $id;

          else

            $failedArray[] = $id;

            $sql_array = array(
              'upload_status' => $this->SUBMITTED,
              'listing_uuid'  => $response['listing_uuid'],
              'last_modified' => 'now()'
            );

            $abxDatabase->update(TABLE_ABX_UPLOADS,$sql_array,'id = ' . (int)$id);

            ++$numProcessed;

        }

        $errorCount   += count($failedArray);

        $successCount += count($successArray);

      }

      return array(
        'processed' => $numProcessed,
        'errors'    => $errorCount,
        'success'   => $successCount
      );
    }

    function queueAddItems(&$abxList)
    {
      $uploads = array();

      for($i=0, $n=count($abxList); $i<$n; $i++)
        $uploads[] = $this->queueAddItem( $this->getItem($abxList[$i]) );

      return $uploads;
    }

    function queueAddItem($item, $product = array())
    {
      $upload              = $item;

      $upload['item_uuid'] = $item['uuid'];

      unset($upload['uuid']);

      static $api;

      if (isset($api) === false)
        $api = new abxAPI;

      $abxMacros = abxMacros::getInstance();

      $upload = $abxMacros->runItemMacros($item['site'], $upload, $product);

      return $this->insertUpload($upload, $api->LIST_ITEM);
    }

    function queueRelistListing($listing, $product = array())
    {
      static $api;

      if (!isset($api)) {
        $api = new abxAPI;
      }

      $abxMacros = abxMacros::getInstance();

      //$listing = $abxMacros->runItemMacros($listing, $product);

      return $this->insertUpload($listing, $api->RELIST_ITEM);
    }


    function queueCancelListing($listing, $product = array())
    {
      $upload                 = $listing;
      $upload['item_uuid']    = $listing['item_uuid'];
      $upload['listing_uuid'] = $listing['uuid'];

      static $api;

      if (isset($api) === false)
        $api = new abxAPI;

      return $this->insertUpload($upload, $api->CANCEL_ITEM);
    }

    function insertUpload($item, $action)
    {
      global $abxDatabase;

      unset($item['id']);

      $uploadItem = array();

      $keys = array(
        'seller_id',
        'label',
        'title',
        'site',
        'duration',
        'quantity',
        'listing_type',
        'price',
        'currency',
      );

      $uploadItem                    = abxArray::setArray($keys,$item);
      $uploadItem['uuid']            = md5(uniqid(rand(), true));
//      $uploadItem['scheduled_start'] = trim($item['scheduled_start']);
      $uploadItem['action']          = $action;
      $uploadItem['object_info']     = $this->buildObjectInfo($item);
      $uploadItem['upload_status']   = $this->PENDING;
      $uploadItem['date_added']      = 'now()';

      return $abxDatabase->insert(TABLE_ABX_UPLOADS, $uploadItem);
    }

    function buildObjectInfo($item)
    {
      return serialize($item);
    }

    function createSchedule(&$postvars)
    {

      $timestamp = now_in_utc();
      $submission_time = iso8601_encode($timestamp);
            
      // launch later
      if ($postvars['launch_pref'] === 'L') {
      
        // This code will parse out the date format and put it into a strtotime compatible format
				$format_parts = split('[/.-]', DATE_FORMAT_SHORT);
				$date_parts = split('[/.-]', $postvars['scheduled_date']);
				
				$parts = array();
        for($count = 0; $count < sizeof($format_parts); $count++)
        {
          $format_part = $format_parts[$count];
          $date_part = $date_parts[$count];
          $parts[$format_part] = $date_part;
        }

        $datetime = 
                    $parts['%Y'] . '-' . $parts['%m'] . '-' . $parts['%d'] . ' ' .
                		$postvars['scheduled_hour']  . ':' .
                		$postvars['scheduled_minute'] . ' ' .
                		$postvars['scheduled_ampm'];
				
        $timestamp = local_timestamp_to_gmt_timestamp(strtotime($datetime));
      }

      $scheduled_start = iso8601_encode($timestamp);

      
			// listing *repeat* = listing total - 1
			$repeat_total = 0;
      if($postvars['scheduler_type'] == $this->KEEP1LISTED)
      {
        $repeat_total = (int)$postvars['total_keep1'] - 1;
      }
      else if($postvars['scheduler_type'] == $this->INTERVAL)
      {
        $repeat_total = (int)$postvars['total_interval'] - 1;
      }

      $arr = array(
        'launch_pref'          => $postvars['launch_pref'],
        'submission_time'      => $submission_time,
        'scheduled_start'      => $scheduled_start,
        'scheduler_type'       => $postvars['scheduler_type'],
        'repeat_total'         => $repeat_total,
        'repeat_interval'      => $postvars['repeat_interval'],
        'repeat_interval_unit' => $postvars['repeat_interval_unit'],
        'spacing_interval'     => $postvars['spacing_interval']
      );
      return $arr;
    }

    function processUpload($perform,$listingUuid,$abxListId,$index, &$scheduler_array)
    {
      global $abxListing;

      switch($perform) {

        case 'AddListingsFromUploadsManager':

          return $this->scheduleQueuedItem($abxListId,$scheduler_array);

          break;

        case 'AddListings':

          // this comes from the auction_items table
          $item = $this->getItem($abxListId);

          if (empty($listingUuid) === false) //editing a (failed) item-listing
            $item['listing_uuid'] = $listingUuid;
            
          $item = array_merge($item, $scheduler_array);

          if(intval($scheduler_array['spacing_interval']) > 0 && $index > 0)
          {
          	// spacing applies and this is the second or later item
            
            $item['launch_pref'] = 'L';   // scheduled
            $timestamp = iso8601_decode($item['scheduled_start']);
            $timestamp += ($scheduler_array['spacing_interval'] * $index * 60);  // seconds
            $item['scheduled_start'] = iso8601_encode($timestamp);
          }

          return $this->queueAddItem($item);

          break;

        case 'RelistListings':

          $relisting = array();

          //build the relisting array
          foreach ($_POST as $key => $value) {
            if (is_array($value)) {
              if ($key == 'start_price') {
                $relisting['price'] = $value[$abxListId];
              }
              $relisting[$key] = $value[$abxListId];
            }
          }

          // this comes from the auction_listings table
          $listing = $abxListing->getListingByID($abxListId);

          $listing = array_merge($listing, $relisting,  $scheduler_array);

          return $this->queueRelistListing($listing);

          break;

        case 'CancelListings':

          // this comes from the auction_listings table
          $listing = $abxListing->getListingByID($abxListId);

          return $this->queueCancelListing($listing);

          break;

        default:

          return array();

          break;
      }
    }

  }//end class
?>