<?php
/*
  $Id: abxManager.php,v 1.29 2008/12/15 00:47:29 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  if(!defined('AUCTIONBLOX_VERSION')){
    require_once(realpath(dirname(__FILE__) . '/../configure.php'));
    require_once(DIR_FS_ABX_EXTERNAL_CART . 'includes/functions/integration.php');
  }
  
  if (class_exists('abxDatabase') === false) {
    require_once(dirname(__FILE__) . '/abxDatabase.php');
    $abxDatabase = &abxDatabase::connect(ABX_DB_SERVER, ABX_DB_USERNAME, ABX_DB_PASSWORD);
	  $abxDatabase->selectDatabase(ABX_DB_DATABASE);
  }

  if (class_exists('abxArray') === false) {

    require_once(dirname(__FILE__) . '/abxArray.php');

  }

  class abxManager {

    var $NOT_LISTED = 1,
        $ACTIVE     = 2,
        $ENDED      = 3,
        $CHECKEDOUT = 4,
        $COMPLETED  = 5,
        $auction_house;


    function existsByUuid($sale)
    {
      $id = $this->getSaleIdByUuid($sale);
      return !empty($id);
    }

    function getSaleIdByUuid($sale)
    {
      global $abxDatabase;

      $id = &$abxDatabase->fetch_value('auction_basket_id', TABLE_ABX_BASKET, "uuid = '".addslashes($sale['uuid'])."'");

      return $id;
    }

    function existsByEbayKey($sale)
    {
      $id = $this->getSaleIdByEbayKey($sale);
      return !empty($id);
    }

    function getSaleIdByEbayKey($sale)
    {
      global $abxDatabase;

      $houseId = addslashes($sale['auctionHouseID']);
      $listingId = addslashes($sale['extID']);
      $transId = addslashes($sale['extKey2']);

      $id = &$abxDatabase->fetch_value('auction_basket_id',
                                       TABLE_ABX_BASKET,
                                       "auction_house_id = '$houseId'" .
                                       " AND ext_id = '$listingId'" .
                                       " AND ext_key2 = '$transId'");

      return $id;
    }

    function insertOrUpdateWinner($winner)
    {
      global $abxDatabase;

      if(empty($winner['email']) === false) {

        $dbWinner = array(
          'ext_customer_id'   => $winner['userID'],
          'ext_email_address' => $winner['email'],
          'name'              => $winner['name'],
          'street1'           => $winner['street1'],
          'street2'           => $winner['street2'],
          'city'              => $winner['city'],
          'state'             => $winner['state'],
          'zip'               => $winner['zip'],
          'country'           => $winner['country'],
          'phone'             => $winner['phone'],
          'score'             => $winner['score']
        );

        // remove any nulls
        $dbWinner = abxArray::prune($dbWinner);

        $winnerID = $abxDatabase->fetch_value('auction_winner_id',TABLE_ABX_WINNERS, "ext_email_address = '" . addslashes($winner['email']) . "'");

        if (empty($winnerID) === false) {

          // we have an existing winner id
          $abxDatabase->update(TABLE_ABX_WINNERS, $dbWinner,'auction_winner_id = ' . (int)$winnerID);

          return $winnerID;

        } else {

          return $abxDatabase->insert(TABLE_ABX_WINNERS, $dbWinner);

        }

      }

      return null;
    }

    function insert($winner, &$product)
    {
      global $abxDatabase;

      $winnerID = $this->insertOrUpdateWinner($winner);

      $dbProduct = array(
        'auction_house_id'  => $product['auctionHouseID'],
        'uuid'              => $product['uuid'],
        'ext_id'            => $product['extID'],
        'ext_key2'          => $product['extKey2'],
        'user_id'           => $product['sellerID'],
        'site'              => $product['site'],
        'listing_type'      => $product['listingType'],
        'ext_title'         => $product['extTitle'],
        'ext_desc'          => $product['extDesc'],
        'time_start'        => $product['timeStart'],
        'time_end'          => $product['timeEnd'],
        'listing_status'    => $product['statusID'],
        'auction_winner_id' => $winnerID,
        'quantity'          => $product['qty'],
        'currency'          => $product['currency'],
        'price_start'       => $product['priceStart'],
        'price_end'         => $product['priceEnd'],
        'insurance'         => $product['insurance'],
        'insurance_option'  => $product['insuranceOption'],
        'shipping_type'     => $product['shippingType'],
        'shipping'          => $product['shipping'],
        'shipping_global'   => $product['shippingGlobal'],
        'shipping_zip'      => $product['shippingZip'],
        'shipping_country'  => $product['shippingCountry'],
        'sales_tax'         => $product['tax'],
        'sales_tax_percent' => $product['taxPercent'],
        'orders_id'         => $product['ordersID'],
        'products_id'       => $product['productID'],
        'workflow_state'    => $product['workflow_state'],
        'feedback_left'     => $product['s'],
        'payment_provider'  => $product['paymentProvider'],
        'payment_transaction_id' => $product['paymentTransactionId'],        
        'payment_currency'  => $product['paymentCurrency'],
        'payment_timestamp' => $product['paymentTimestamp'],
        'payment_amount'    => $product['paymentAmount'],
        'payment_fee'       => $product['paymentFee'],
        'shipping_method_actual' => $product['shippingMethodActual'],
      );

      // remove any nulls
      $dbProduct = abxArray::prune($dbProduct);

      return $abxDatabase->insert(TABLE_ABX_BASKET, $dbProduct);
    }

    function update($winner, &$product)
    {
      global $abxDatabase;

      $winnerID = $this->insertOrUpdateWinner($winner);

      $dbProduct = array(
        'auction_house_id'  => $product['auctionHouseID'],
        'uuid'              => $product['uuid'],
        'user_id'           => $product['sellerID'],
        'site'              => $product['site'],
        'listing_type'      => $product['listingType'],
        'ext_id'            => $product['extID'],
        'ext_key2'          => $product['extKey2'],
        'ext_title'         => $product['extTitle'],
        'ext_desc'          => $product['extDesc'],
        'time_start'        => $product['timeStart'],
        'time_end'          => $product['timeEnd'],
        'listing_status'    => $product['statusID'],
        'auction_winner_id' => $winnerID,
        'quantity'          => $product['qty'],
        'currency'          => $product['currency'],
        'price_start'       => $product['priceStart'],
        'price_end'         => $product['priceEnd'],
        'insurance'         => $product['insurance'],
        'insurance_option'  => $product['insuranceOption'],
        'shipping_type'     => $product['shippingType'],
        'shipping'          => $product['shipping'],
        'shipping_global'   => $product['shippingGlobal'],
        'shipping_zip'      => $product['shippingZip'],
        'shipping_country'  => $product['shippingCountry'],
        'sales_tax'         => $product['tax'],
        'sales_tax_percent' => $product['taxPercent'],
        'orders_id'         => $product['ordersID'],
        'products_id'       => $product['productID'],
        'workflow_state'    => $product['workflow_state'],
        'feedback_left'     => $product['feedback_left'],
        'payment_provider'  => $product['paymentProvider'],
        'payment_transaction_id' => $product['paymentTransactionId'],
        'payment_currency'  => $product['paymentCurrency'],
        'payment_timestamp' => $product['paymentTimestamp'],
        'payment_amount'    => $product['paymentAmount'],
        'payment_fee'       => $product['paymentFee'],
        'shipping_method_actual' => $product['shippingMethodActual'],
      );

      /*
            Notes:
            Added workflow_state for sale.updateSale w/s
      */

      // remove any nulls
      $dbProduct = abxArray::prune($dbProduct);

      return $abxDatabase->update(TABLE_ABX_BASKET, $dbProduct,'auction_basket_id = '. (int)$product['ID']);
    }

    function updateByUuid($winner, &$product)
    {
      global $abxDatabase;

      $winnerID = $this->insertOrUpdateWinner($winner);

      $dbProduct = array(
        'auction_house_id'  => $product['auctionHouseID'],
        'user_id'           => $product['sellerID'],
        'site'              => $product['site'],
        'listing_type'      => $product['listingType'],
        'ext_id'            => $product['extID'],
        'ext_key2'          => $product['extKey2'],
        'ext_title'         => $product['extTitle'],
        'ext_desc'          => $product['extDesc'],
        'time_start'        => $product['timeStart'],
        'time_end'          => $product['timeEnd'],
        'listing_status'    => $product['statusID'],
        'auction_winner_id' => $winnerID,
        'quantity'          => $product['qty'],
        'currency'          => $product['currency'],
        'price_start'       => $product['priceStart'],
        'price_end'         => $product['priceEnd'],
        'insurance'         => $product['insurance'],
        'insurance_option'  => $product['insuranceOption'],
        'shipping_type'     => $product['shippingType'],
        'shipping'          => $product['shipping'],
        'shipping_global'   => $product['shippingGlobal'],
        'shipping_zip'      => $product['shippingZip'],
        'shipping_country'  => $product['shippingCountry'],
        'sales_tax'         => $product['tax'],
        'sales_tax_percent' => $product['taxPercent'],
        'orders_id'         => $product['ordersID'],
        'products_id'       => $product['productID'],
        'workflow_state'    => $product['workflow_state'],
        'feedback_left'     => $product['feedback_left'],
        'payment_provider'  => $product['paymentProvider'],
        'payment_transaction_id' => $product['paymentTransactionId'],        
        'payment_currency'  => $product['paymentCurrency'],
        'payment_timestamp' => $product['paymentTimestamp'],
        'payment_amount'    => $product['paymentAmount'],
        'payment_fee'       => $product['paymentFee']
      );

      /*
            Notes:
            Added workflow_state for sale.updateSale w/s
      */

      // remove any nulls
      $dbProduct = abxArray::prune($dbProduct);

      return $abxDatabase->update(TABLE_ABX_BASKET, $dbProduct,"uuid = '".addslashes($produce['uuid'])."'");
    }

    function getAuctionSaleUuids(&$abxList)
    {
      global $abxDatabase;

      $uuids = array();

      $uuidQuery = $abxDatabase->query('select uuid from ' . TABLE_ABX_BASKET . ' where auction_basket_id in (' . implode(',',$abxList) . ')');

      while ($uuidQuery->next())
        $uuids[] = $uuidQuery->value('uuid');

      return $uuids;
    }

    function updateStatusByOrder($status, $order_id)
    {
      global $abxDatabase;

      return $abxDatabase->update(TABLE_ABX_BASKET, array( 'listing_status' => $status), 'orders_id = ' . (int)$order_id);
    }

    function getOrderStatuses()
    {
      global $abxDatabase;
      $languages_id = abxRegistry::get("languages_id");
      
      $orders_statuses = array();
	  $orders_status_array = array();
	  $orders_status_query = $abxDatabase->query("select orders_status_id, orders_status_name from " . TABLE_ORDERS_STATUS . " where language_id = '" . (int)$languages_id . "'");
	  while ($orders_status = $orders_status_query->next()) {
	    $orders_statuses[] = array('id' => $orders_status['orders_status_id'],
	                               'text' => $orders_status['orders_status_name']);
	    $orders_status_array[$orders_status['orders_status_id']] = $orders_status['orders_status_name'];
     }
     
     return $orders_statuses;
   }    
  }//end class
?>