<?php
/*
  $Id: abxShippingModules.php,v 1.6 2008/08/13 19:06:07 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxShippingModules {

    var
      $aModules = array();

    // --------------------------------------------------------------------

    function abxShippingModules() {
      $language = abxRegistry::get("language");

      $aInstalled = explode(';', MODULE_SHIPPING_INSTALLED);

      foreach($aInstalled as $sModule) {
        $aModules[] = array(
          'class' => substr($sModule, 0, strrpos($sModule, '.')),
          'file' => $sModule
        );
      }

      foreach($aModules as $aModule) {
        // called from admin and catalog, so don't use constants unique to each
        include_once(DIR_FS_CATALOG . "includes/languages/$language/modules/shipping/{$aModule['file']}");
        include_once(DIR_FS_CATALOG . "includes/modules/shipping/{$aModule['file']}");

        $Module = new $aModule['class'];

        if ($Module->check() > 0) {
          if ($Module->sort_order > 0) {
            $this->aModules[$Module->sort_order] = $Module;
          } else {
            $this->aModules[] = $Module;
          }
        }
      }
    }

    // --------------------------------------------------------------------

    function getMethods($aOptions) {
      $aArr = array();

      foreach($this->aModules as $Module) {
        $aArr[] = array(
          //'id'   => strip_tags($Module->title),
          'id'   => get_class($Module),
          'text' => strip_tags($Module->title)
        );
      }
      return !empty($aOptions) ? array_merge($aOptions, $aArr) : $aArr;
    }

    // --------------------------------------------------------------------

    function getTaxRates() {
      $aArr = array();

      foreach($this->aModules as $Module) {
        $aArr[] = array(
          //'id'   => strip_tags($module->title),
          'id'   => get_class($Module),
          'class' => $Module->tax_class
        );
      }
      return $aArr;
    }

    // --------------------------------------------------------------------

    function getMethodNameByClassName($sName) {
      foreach($this->aModules as $Module) {
          if (get_class($Module) == $sName) {
            return strip_tags($Module->title);
          }
      }
    }
    // --------------------------------------------------------------------

  }//end class
?>