# $Id: auctionblox.sql.php,v 1.46 2008/12/15 00:47:29 auctionblox Exp $
# AuctionBlox, sell more, work less!
# http://www.auctionblox.com
#
# Copyright (c) 2004 AuctionBlox

#
# Table structure for table abx_configuration
#

CREATE TABLE abx_configuration (
  configuration_id int(11) NOT NULL auto_increment,
  configuration_title varchar(64) NOT NULL default '',
  configuration_key varchar(64) NOT NULL default '',
  configuration_value MEDIUMTEXT,
  configuration_description varchar(255) NOT NULL default '',
  visible int(1) NOT NULL default '0',
  sort_order int(5) default NULL,
  last_modified datetime default NULL,
  date_added datetime NOT NULL default '0000-00-00 00:00:00',
  use_function varchar(255) default NULL,
  set_function varchar(255) default NULL,
  PRIMARY KEY (configuration_id)
) TYPE=MyISAM;

#
# Table structure for table abx_seller_info
#

CREATE TABLE abx_seller_info (
  seller_id int(11) NOT NULL default '0',
  user_id varchar(96) NOT NULL default '',
  notify_url varchar(255) NOT NULL default '',
  checkout_url varchar(255) NOT NULL default '',
  token_status int(1) NOT NULL default '0',
  PRIMARY KEY (seller_id),
  UNIQUE KEY user_id (user_id)
) TYPE=MyISAM;

#
# Table structure for table abx_uploads
#

CREATE TABLE abx_uploads (
  id int(11) NOT NULL auto_increment,
  uuid varchar(32) NOT NULL default '',
  listing_uuid varchar(32) default NULL,
  seller_id int(11) NOT NULL default '0',
  label varchar(32) NOT NULL default '',
  title varchar(55) NOT NULL default '',
  listing_type char(2) NOT NULL default '',
  site char(3) NOT NULL default '',
  duration char(3) NOT NULL default '0',
  quantity int(11) NOT NULL default '0',
  price decimal(11,4) NOT NULL default '0.0000',
  bin_price decimal(11,4) NOT NULL default '0.0000',
  currency char(3) NOT NULL default '',
  scheduled_start datetime NOT NULL default '0000-00-00 00:00:00',
  scheduled_info TEXT,
  version int(11) NOT NULL default '0',
  action varchar(32) NOT NULL default '',
  upload_status char(1) NOT NULL default '',
  object_info TEXT,
  last_modified datetime NOT NULL default '0000-00-00 00:00:00',
  date_added datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY (id),
  UNIQUE KEY uuid (uuid),
  KEY action (action,uuid)
) TYPE=MyISAM;

#
# Table structure for table abx_basket
#

CREATE TABLE abx_basket (
  auction_basket_id int(11) NOT NULL auto_increment,
  uuid varchar(32) NOT NULL default '',
  auction_house_id int(11) NOT NULL default '0',
  user_id varchar(96) NOT NULL default '',
  site char(3) NOT NULL default '',
  listing_type char(2) NOT NULL default '',
  auction_item_id int(11) NOT NULL default '0',
  ext_id varchar(32) NOT NULL default '',
  ext_key2 varchar(16) NOT NULL default '',
  auction_winner_id int(11) NOT NULL default '0',
  listing_status int(4) NOT NULL default '0',
  time_start datetime NOT NULL default '0000-00-00 00:00:00',
  time_end datetime NOT NULL default '0000-00-00 00:00:00',
  orders_id int(11) default NULL,
  ext_title varchar(55) NOT NULL default '',
  ext_desc varchar(255) default NULL,
  quantity int(4) NOT NULL default '1',
  currency varchar(4) NOT NULL default '',
  price_start decimal(11,4) NOT NULL default '0.0000',
  price_end decimal(11,4) NOT NULL default '0.0000',
  insurance decimal(11,4) NOT NULL default '0.0000',
  insurance_option int(1) NOT NULL default '0',
  shipping_type char(1) NOT NULL default '',
  shipping decimal(11,4) NOT NULL default '0.0000',
  shipping_global decimal(11,4) NOT NULL default '0.0000',
  shipping_zip varchar(10) NOT NULL default '',
  shipping_country varchar(5) NOT NULL default '',
  sales_tax decimal(11,4) NOT NULL default '0.0000',
  sales_tax_percent decimal(11,4) NOT NULL default '0.0000',
  products_id int(11) NOT NULL default '0',
  feedback_left varchar(16) NOT NULL default 'LEAVE_FEEDBACK',
  workflow_state varchar(16) NOT NULL default 'INVOICE',
  workflow_state_change_date datetime NOT NULL default '0000-00-00 00:00:00',
  archived tinyint(1) NOT NULL default '0',
  payment_provider VARCHAR( 32 ),
  payment_transaction_id VARCHAR( 32 ),
  payment_timestamp DATETIME ,
  payment_currency VARCHAR( 3 ) ,
  payment_amount DECIMAL( 11, 4 ) ,
  payment_fee DECIMAL( 11, 4 ),
  PRIMARY KEY  (auction_basket_id),
  UNIQUE KEY uuid (uuid),
  UNIQUE KEY ext_key (auction_house_id,ext_id,ext_key2),
  KEY user_id (user_id),
  KEY products_id (products_id),
  KEY auction_winner_id (auction_winner_id),
  KEY site (site),
  KEY ext_id (ext_id),
  KEY time_end (time_end),
  KEY listing_status (listing_status),
  KEY orders_id (orders_id)
) TYPE=MyISAM;

#
# Table structure for table abx_houses
#

CREATE TABLE abx_houses (
  auction_house_id int(11) NOT NULL auto_increment,
  auction_house_label varchar(20) NOT NULL default '',
  auction_house_desc varchar(96) default NULL,
  auction_item_url varchar(255) default NULL,
  PRIMARY KEY (auction_house_id)
) TYPE=MyISAM;

#
# Table structure for table abx_sites
#

CREATE TABLE abx_sites (
  auction_house_id int(11) NOT NULL default '0',
  site char(3) NOT NULL default '',
  url varchar(96) NOT NULL default '',
  PRIMARY KEY  (auction_house_id,site)
) TYPE=MyISAM;


#
# Table structure for table abx_listings
#


CREATE TABLE abx_listings (
  id int(11) NOT NULL auto_increment,
  user_id varchar(96) NOT NULL default '',
  uuid varchar(32) NOT NULL default '',
  parent_uuid varchar(32) default NULL,
  item_uuid varchar(32) default NULL,
  profile_id int(11) NOT NULL default '0',
  auction_house_id int(11) NOT NULL default '0',
  site char(3) NOT NULL default '',
  listing_type char(2) NOT NULL default '',
  ext_id varchar(32) NOT NULL default '',
  ext_title varchar(55) NOT NULL default '',
  is_buy_it_now int(1) NOT NULL default '0',
  start_time datetime NULL,
  end_time datetime NOT NULL default '0000-00-00 00:00:00',
  quantity int(4) NOT NULL default '0',
  quantity_sold int(4) NOT NULL default '0',
  currency char(3) NOT NULL default '',
  start_price decimal(11,4) NOT NULL default '0.0000',
  current_price decimal(11,4) NOT NULL default '0.0000',
  status char(2) NOT NULL default '',
  version int(4) NOT NULL default '0',
  listing_fee decimal(11,4) NULL,
  app_data varchar(255) NOT NULL default '',
  error_code varchar(10) NOT NULL default '',
  error_text mediumtext,
  PRIMARY KEY  (id),
  UNIQUE KEY uuid (uuid),
  KEY parent_uuid (parent_uuid),
  KEY status (status),
  KEY quantity_sold (quantity_sold),
  KEY end_time (end_time),
  KEY seller_id (user_id),
  KEY item_uuid (item_uuid),
  KEY auction_house_id (auction_house_id,ext_id),
  KEY profile_id (profile_id)
) TYPE=MyISAM;

#
# Table structure for table abx_schedule_info
#

CREATE TABLE abx_schedule_info (
  uuid varchar(32) NOT NULL default '',
  trigger_state varchar(32) NOT NULL default '',
  trigger_type varchar(32) NOT NULL default '',
  date_first datetime default NULL,
  date_end datetime default NULL,
  date_next datetime default NULL,
  repeat_total int(11) NOT NULL default '0',
  repeat_count int(11) NOT NULL default '0',
  PRIMARY KEY  (uuid),
  KEY trigger_state (trigger_state),
  KEY trigger_type (trigger_type),
  KEY date_first (date_first),
  KEY date_end (date_end),
  KEY date_next (date_next)
) TYPE=MyISAM;

#
# Table structure for table abx_items
#

CREATE TABLE abx_items (
  id int(11) NOT NULL auto_increment,
  seller_id int(11) NOT NULL default '0',
  profile_id int(11) NOT NULL default '0',
  uuid varchar(32) NOT NULL default '',
  label varchar(128) NOT NULL default '',
  type tinyint(1) NOT NULL default '0',
  title varchar(55) NOT NULL default '',
  subtitle varchar(55) NOT NULL default '',
  listing_type char(2) NOT NULL default '',
  item_specifics mediumtext ,
  site char(3) NOT NULL default '',
  city_state varchar(64) NOT NULL default '',
  country char(2) NOT NULL default '',
  region varchar(10) NOT NULL default '',
  category1 varchar(32) NOT NULL default '',
  category2 varchar(32) NOT NULL default '',
  store_category varchar(32) NOT NULL default '',
  duration char(3) NOT NULL default '0',
  quantity varchar(32) NOT NULL default '0',
  price varchar(32) NOT NULL default '0.0000',
  bin_price varchar(32) NOT NULL default '0.0000',
  reserve_price varchar(32) NOT NULL default '0.0000',
  currency char(3) NOT NULL default '',
  payment_methods varchar(255) NOT NULL default '',
  paypal_email varchar(128) NOT NULL default '',
  payment_description text ,
  sales_tax_state varchar(5) NOT NULL default '',
  sales_tax_percent varchar(32) NOT NULL default '0.0000',
  sales_tax_sandh char(1) NOT NULL default '0',
  shipping_type char(2) NOT NULL default '',
  shipping_location char(1) NOT NULL default '0',
  shipping_pkg int(11) NOT NULL default '0',
  shipping_svc int(11) NOT NULL default '0',
  shipping varchar(32) NOT NULL default '0.0000',
  shipping_addl varchar(32) NOT NULL default '0.0000',
  shipping_global_svc int(11) NOT NULL default '0',
  shipping_global varchar(32) NOT NULL default '0.0000',
  shipping_global_addl varchar(32) NOT NULL default '0.0000',
  shipping_postcode varchar(10) NOT NULL default '',
  shipping_weight varchar(32) NOT NULL default '0.00',
  shipping_weight_unit tinyint(1) NOT NULL default '0',
  insurance_option char(2) NOT NULL default '',
  insurance varchar(32) NOT NULL default '0.0000',
  return_policy text ,
  extra_private char(1) NOT NULL default '0',
  extra_bold char(1) NOT NULL default '0',
  extra_highlight char(1) NOT NULL default '0',
  extra_gallery char(1) NOT NULL default '0',
  extra_gallery_url varchar(128) NOT NULL default '',
  extra_category_featured char(1) NOT NULL default '0',
  extra_homepage_featured char(1) NOT NULL default '0',
  counter char(1) NOT NULL default '0',
  products_id varchar(64) default NULL,
  description longtext ,
  last_modified datetime NOT NULL default '0000-00-00 00:00:00',
  picture1_url varchar(255) NOT NULL default '',
  picture2_url varchar(255) NOT NULL default '',
  picture3_url varchar(255) NOT NULL default '',
  picture4_url varchar(255) NOT NULL default '',
  picture5_url varchar(255) NOT NULL default '',
  picture6_url varchar(255) NOT NULL default '',
  picture7_url varchar(255) NOT NULL default '',
  picture8_url varchar(255) NOT NULL default '',
  app_data varchar(255) NOT NULL default '',
  version int(11) NOT NULL default '0',
  object_info longtext,
  PRIMARY KEY  (id),
  UNIQUE KEY uuid (uuid)
) ENGINE=MyISAM;

#
# Table structure for table abx_winners
#

CREATE TABLE abx_winners (
  auction_winner_id int(11) NOT NULL auto_increment,
  ext_customer_id varchar(96) default NULL,
  ext_email_address varchar(96) NOT NULL default '',
  name varchar(64) NOT NULL default '',
  street1 varchar(64) NOT NULL default '',
  street2 varchar(64) NOT NULL default '',
  city varchar(64) NOT NULL default '',
  state varchar(64) NOT NULL default '',
  zip varchar(12) NOT NULL default '',
  country varchar(64) NOT NULL default '',
  phone varchar(18) NOT NULL default '',
  score int(7) NOT NULL default '0',
  customers_id int(11) default NULL,
  is_anonymous tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY  (auction_winner_id),
  UNIQUE KEY ext_email_address (ext_email_address),
  KEY customers_id (customers_id),
  KEY ext_customer_id (ext_customer_id)
) TYPE=MyISAM;

#
# Table structure for table abx_feedback_state
#

CREATE TABLE abx_feedback_state (
  state_id varchar(16) NOT NULL default '0',
  language_id int(11) NOT NULL default '0',
  label varchar(64) NOT NULL default '',
  PRIMARY KEY (state_id,language_id)
) TYPE=MyISAM;

#
# Table structure for table abx_fixed_shipping
#

CREATE TABLE abx_fixed_shipping (
  products_id int(11) NOT NULL default '0',
  is_enabled int(1) NOT NULL default '0',
  shipping decimal(12,4) NOT NULL default '0.0000',
  shipping_addl decimal(12,4) NOT NULL default '0.0000',
  shipping_global decimal(12,4) NOT NULL default '0.0000',
  shipping_global_addl decimal(12,4) NOT NULL default '0.0000',
  PRIMARY KEY (products_id)
) TYPE=MyISAM;

#
# Table structure for table abx_workflow_state
#

CREATE TABLE abx_workflow_state (
  state_id varchar(16) NOT NULL default '0',
  listing_status int(2) NOT NULL default '0',
  language_id int(11) NOT NULL default '0',
  sort_order int(2) NOT NULL default '0',
  label varchar(64) NOT NULL default '',
  next_state_id varchar(16) NOT NULL default '',
  PRIMARY KEY (state_id,listing_status,language_id)
) TYPE=MyISAM;

#
# Table structure for table abx_api_queue
#

CREATE TABLE abx_api_queue (
  id int(11) NOT NULL auto_increment,
  method varchar(64) NOT NULL default '',
  data LONGTEXT,
  status int(1) NOT NULL default '0',
  retries int(1) NOT NULL default '0',
  updated datetime default NULL,
  created datetime default NULL,
  return_code MEDIUMTEXT,
  custom1 varchar(32) default NULL,
  PRIMARY KEY  (id),
  KEY custom1 (custom1),
  KEY method (method),
  KEY status (status,retries)
) TYPE=MyISAM;

CREATE TABLE abx_products_extra_info (
  products_id int(11) NOT NULL default '0',
  exclude_auction char(3) NOT NULL default '',
  exclude_fixed char(3) NOT NULL default '',
  exclude_store char(3) NOT NULL default '',
  custom1 varchar(255) NOT NULL default '',
  custom2 varchar(255) NOT NULL default '',
  custom3 varchar(255) NOT NULL default '',
  custom4 varchar(255) NOT NULL default '',
  custom5 varchar(255) NOT NULL default '',
  custom6 varchar(255) NOT NULL default '',
  custom7 varchar(255) NOT NULL default '',
  custom8 varchar(255) NOT NULL default '',
  custom9 varchar(255) NOT NULL default '',
  custom10 varchar(255) NOT NULL default '',
  PRIMARY KEY  (products_id),
  KEY exclude_auction (exclude_auction),
  KEY exclude_fixed (exclude_fixed),
  KEY exclude_store (exclude_store)
) TYPE=MyISAM;

#
# Data for table abx_configuration
#

INSERT INTO abx_configuration (configuration_title, configuration_key, configuration_value, configuration_description, visible, sort_order, last_modified, date_added, use_function, set_function) VALUES ('AuctionBlox.com Login Email', 'AUCTIONBLOX_USERID', 'demo@auctionblox.com', 'Set the email address that you registered with at AuctionBlox.com.  This is required to use the AuctionBlox.com API functions.  If you are not sure what this is, please email support@auctionblox.com', 1, 0, NULL, '0000-00-00 00:00:00', NULL, NULL);
INSERT INTO abx_configuration (configuration_title, configuration_key, configuration_value, configuration_description, visible, sort_order, last_modified, date_added, use_function, set_function) VALUES ('AuctionBlox.com API URL', 'ABX_API_URL', 'http://www.auctionblox.net/ab/xmlrpc', 'Set the AuctionBlox.com API Server URL.  If you are not sure what this is, please email support@auctionblox.com', 0, 0, NULL, '0000-00-00 00:00:00', NULL, NULL);
INSERT INTO abx_configuration (configuration_title, configuration_key, configuration_value, configuration_description, visible, sort_order, last_modified, date_added, use_function, set_function) VALUES ('AuctionBlox Authorization Code', 'AUCTIONBLOX_PASSCODE', 'AuctionBlox', 'Set the authorization code assigned to your shop by AuctionBlox.  This is required to use AuctionBlox.com API functions.  If you are not sure what this is, please email support@auctionblox.com', 1, 0, NULL, '0000-00-00 00:00:00', NULL, NULL);
INSERT INTO abx_configuration (configuration_title, configuration_key, configuration_value, configuration_description, visible, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Time Zone', 'STORE_TIME_ZONE', '-06', 'Time Zone in which my store is located', 1, 0, '2005-01-12 17:16:33', '0000-00-00 00:00:00', 'getTimeZoneName', 'timeZoneDropDownList');
INSERT INTO abx_configuration (configuration_title, configuration_key, configuration_value, configuration_description, visible, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Search Results', 'MAX_ABX_DISPLAY_SEARCH_RESULTS', '100', 'Specify maximum number of search results to display', 1, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, NULL);
INSERT INTO abx_configuration (configuration_title, configuration_key, configuration_value, configuration_description, visible, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Search Product Item Results', 'MAX_ABX_DISPLAY_SEARCH_PRODUCT_ITEMT_RESULTS', '10', 'Specify maximum number of Product Item search results to display', 1, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, NULL);
INSERT INTO abx_configuration (configuration_title, configuration_key, configuration_value, configuration_description, visible, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Batch Number Of Uploads', 'ABX_MAX_NUM_PROCESS_UPLOAD', '25', 'Specify maximum number of uploads to process in one batch', 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, NULL);
INSERT INTO abx_configuration (configuration_title, configuration_key, configuration_value, configuration_description, visible, sort_order, last_modified, date_added, use_function, set_function) VALUES ('AuctionBlox Version', 'AUCTIONBLOX_VERSION', '4.16.0', 'AuctionBlox version number', 0, 0, '2007-01-04 18:48:12', '2005-08-24 20:23:40', NULL, NULL);
INSERT INTO abx_configuration (configuration_title, configuration_key, configuration_value, configuration_description, visible, sort_order, last_modified, date_added, use_function, set_function) VALUES ('', 'LAST_UPDATED_ORDERS_STATUS_HISTORY_ID', '0', '', 0, NULL, '2006-01-30 22:55:58', '0000-00-00 00:00:00', NULL, NULL);
INSERT INTO abx_configuration (configuration_title, configuration_key, configuration_value, configuration_description, visible, sort_order, last_modified, date_added, use_function, set_function) VALUES ('', 'INVENTORY_LAST_RUN_TIMESTAMP', now(), '', 0, NULL, '2006-01-30 22:55:58', '0000-00-00 00:00:00', NULL, NULL);
INSERT INTO abx_configuration (configuration_title, configuration_key, configuration_value, configuration_description, visible, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Enable HTML Editor', 'ABX_SPAW_EDITOR_ENABLED', '1', 'Set this value to 1 to enable the HTML Editor or 0 to disable it', 1, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, NULL);
INSERT INTO abx_configuration (configuration_title,	configuration_key, configuration_value,	configuration_description, visible, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Show attributes with cost',	'ABX_SHOW_ATTRIBUTES_WITH_COST', '1', 'Set this value to 1 to allow customers to choose attributes that will change the price of an auction during checkout or 0 to not allow this', 1, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, NULL);
INSERT INTO abx_configuration (configuration_title, configuration_key, configuration_value, configuration_description, visible, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Order Status: Paid orders that DO require further buyer action','AUCTIONBLOX_ORDER_PENDING_STATUS','1','This order status is used for orders that have been imported by AuctionBlox that are paid but require additional interaction with the buyer. Examples include products that have product attributes.',1,0,'2009-07-03 14:27:48','2009-07-02 13:42:24','getOrderStatusText','orderStatusId');
INSERT INTO abx_configuration (configuration_title, configuration_key, configuration_value, configuration_description, visible, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Order Status: Paid orders that require no further buyer action','AUCTIONBLOX_ORDER_PROCESSED_STATUS','2','This order status is used for orders that have been imported by AuctionBlox that are paid and require no further interaction with the buyer. Examples include products that have no product attributes.',1,0,'2009-07-03 14:27:48','2009-07-02 13:42:24','getOrderStatusText','orderStatusId');


#
# Data for table abx_feedback_state
#

INSERT INTO abx_feedback_state (state_id, language_id, label) VALUES ('LEAVE_FEEDBACK', 1, 'Leave Feedback');
INSERT INTO abx_feedback_state (state_id, language_id, label) VALUES ('FEEDBACK_LEFT', 1, 'Feedback Left');

INSERT INTO abx_feedback_state (state_id, language_id, label) VALUES ('LEAVE_FEEDBACK', 2, 'Bewertung abgeben');
INSERT INTO abx_feedback_state (state_id, language_id, label) VALUES ('FEEDBACK_LEFT', 2, 'Bewertung abgegeben');


#
# Data for table abx_houses
#

INSERT INTO abx_houses (auction_house_id, auction_house_label, auction_house_desc, auction_item_url) VALUES (1, 'eBay', 'Visit www.eBay.com', 'http://cgi.ebay.com/ws/eBayISAPI.dll?ViewItem&item=%s');
INSERT INTO abx_houses (auction_house_id, auction_house_label, auction_house_desc, auction_item_url) VALUES (2, 'Yahoo', 'auctions.yahoo.com', NULL);


#
# Data for table abx_workflow_state
#

INSERT INTO abx_workflow_state (state_id, listing_status, sort_order, language_id, label, next_state_id) VALUES ('INVOICE', 3, 1, 1, 'Send Invoice', 'REMINDER');
INSERT INTO abx_workflow_state (state_id, listing_status, sort_order, language_id, label, next_state_id) VALUES ('REMINDER', 3, 2, 1, 'Send Reminder', 'WARNING');
INSERT INTO abx_workflow_state (state_id, listing_status, sort_order, language_id, label, next_state_id) VALUES ('WARNING', 3, 3, 1, 'Send Warning', 'NPB');
INSERT INTO abx_workflow_state (state_id, listing_status, sort_order, language_id, label, next_state_id) VALUES ('NPB', 3, 4, 1, 'File NPB Alert', 'FEE_CREDIT');
INSERT INTO abx_workflow_state (state_id, listing_status, sort_order, language_id, label, next_state_id) VALUES ('FEE_CREDIT', 3, 5, 1, 'Request Fee Credit', 'COMPLETE');
INSERT INTO abx_workflow_state (state_id, listing_status, sort_order, language_id, label, next_state_id) VALUES ('COMPLETE', 3, 6, 1, 'Completed', '');

INSERT INTO abx_workflow_state (state_id, listing_status, sort_order, language_id, label, next_state_id) VALUES ('INVOICE', 3, 1, 2, 'Rechnung senden', 'REMINDER');
INSERT INTO abx_workflow_state (state_id, listing_status, sort_order, language_id, label, next_state_id) VALUES ('REMINDER', 3, 2, 2, 'Erinnerung senden', 'WARNING');
INSERT INTO abx_workflow_state (state_id, listing_status, sort_order, language_id, label, next_state_id) VALUES ('WARNING', 3, 3, 2, 'Mahnung senden', 'NPB');
INSERT INTO abx_workflow_state (state_id, listing_status, sort_order, language_id, label, next_state_id) VALUES ('NPB', 3, 4, 2, 'Unbez. Artikel melden', 'FEE_CREDIT');
INSERT INTO abx_workflow_state (state_id, listing_status, sort_order, language_id, label, next_state_id) VALUES ('FEE_CREDIT', 3, 5, 2, 'Gebhren zurckfordern', 'COMPLETE');
INSERT INTO abx_workflow_state (state_id, listing_status, sort_order, language_id, label, next_state_id) VALUES ('COMPLETE', 3, 6, 2, 'Abgeschlossen', '');

#
# Data for table abx_sites
#

INSERT INTO abx_sites VALUES (1, 'US', 'http://cgi.ebay.com/ws/eBayISAPI.dll?ViewItem&item=%s');
INSERT INTO abx_sites VALUES (1, 'DE', 'http://cgi.ebay.de/ws/eBayISAPI.dll?ViewItem&item=%s');
INSERT INTO abx_sites VALUES (1, 'CA', 'http://cgi.ebay.ca/ws/eBayISAPI.dll?ViewItem&item=%s');
INSERT INTO abx_sites VALUES (1, 'UK', 'http://cgi.ebay.co.uk/ws/eBayISAPI.dll?ViewItem&item=%s');
INSERT INTO abx_sites VALUES (1, 'FR', 'http://cgi.ebay.fr/ws/eBayISAPI.dll?ViewItem&item=%s');
INSERT INTO abx_sites VALUES (1, 'IT', 'http://cgi.ebay.it/ws/eBayISAPI.dll?ViewItem&item=%s');
INSERT INTO abx_sites VALUES (1, 'EMO', 'http://cgi.ebay.com/ebaymotors/ws/eBayISAPI.dll?ViewItem&item=%s');
INSERT INTO abx_sites VALUES (1, 'AU', 'http://cgi.ebay.com.au/ws/eBayISAPI.dll?ViewItem&item=%s');
INSERT INTO abx_sites VALUES (1, 'AT', 'http://cgi.ebay.at/ws/eBayISAPI.dll?ViewItem&item=%s');
INSERT INTO abx_sites VALUES (1, 'NL', 'http://cgi.ebay.nl/ws/eBayISAPI.dll?ViewItem&item=%s');
INSERT INTO abx_sites VALUES (1, 'BNL', 'http://cgi.benl.ebay.be/ws/eBayISAPI.dll?ViewItem&item=%s');
INSERT INTO abx_sites VALUES (1, 'BFR', 'http://cgi.befr.ebay.be/ws/eBayISAPI.dll?ViewItem&item=%s');
INSERT INTO abx_sites VALUES (1, 'CH', 'http://cgi.ebay.ch/ws/eBayISAPI.dll?ViewItem&item=%s');
INSERT INTO abx_sites VALUES (1, 'ES', 'http://cgi.ebay.es/ws/eBayISAPI.dll?ViewItem&item=%s');

# AuctionBlox version 4.7.0
ALTER TABLE abx_basket ADD shipping_method_actual VARCHAR(50);

# AuctionBlox version 4.8.0
CREATE TABLE abx_category_info (
  categories_id int(11) NOT NULL default '0',
  categories_site char(3) NOT NULL default '',
  ebay_category1_id varchar(32) default NULL,
  ebay_category2_id varchar(32) default NULL,
  ebay_shop_category1_id varchar(32) default NULL,
  ebay_shop_category2_id varchar(32) default NULL,
  PRIMARY KEY  (categories_id,categories_site)
) TYPE=MyISAM;

# AuctionBlox version 4.9.0
CREATE TABLE abx_basket_attributes (	
  abx_basket_attributes_id int(11) NOT NULL auto_increment,
  auction_basket_id int(11),
  products_options_id varchar(64) NOT NULL default '0',
  products_options_value_id int(11) NOT NULL default '0',
  products_options_value_text blob,
  PRIMARY KEY  (abx_basket_attributes_id),
  KEY idx_abx_basket_attribues (auction_basket_id)
) TYPE=MyISAM;

# Fix missing indexes in osCommerce tables (ignore if doesnt exist)
ALTER TABLE orders_status_history ADD INDEX (orders_id);
ALTER TABLE orders_products ADD INDEX (orders_id);
ALTER TABLE orders_products ADD INDEX (products_id); 

# Fix missing indexes in Zen Cart tables (ignore if doesnt exist)
ALTER TABLE zen_orders_status_history ADD INDEX (orders_id);
ALTER TABLE zen_orders_products ADD INDEX (orders_id);
ALTER TABLE zen_orders_products ADD INDEX (products_id); 