<?php
/*
  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  AuctionBlox, Inc.
  Copyright (c) 2008 AuctionBlox, Inc.
  http://www.auctionblox.com

  Released under the GNU General Public License
*/

  require_once (DIR_FS_ABX_EXTERNAL_CART . 'includes/classes/abxCurrenciesIpn.php');

  class abxIpnOrdersImport
  {
  	var $orderId,
  		$customerId,
  		$customerPassword,
  		$currency;
    
    function saveOrder($ipnDetails, &$basketItems, &$winnerDetails)
    {

      global $abxDatabase, $languages_id;
      
      $this->currency 			= $basketItems[0]['currency'];

	  // get buyer info
      $buyerCountryId 		= $this->getCountryIdByIsoCode($winnerDetails['country']);
      $buyerZoneId 			= $this->getZoneIdByState($winnerDetails['state'],$buyerCountryId);
      $buyerCountryInfo 	= $this->getCountryInfo($buyerCountryId);    
      
      //  Create the customer details
      if ($customerDetails = $this->getCustomer($winnerDetails['ext_email_address'])) {
			$customerCountryDetails = $this->getCountryInfo($customerDetails['entry_country_id']); 
      	
      		$customerArray = array(	  
	      		'customers_id' 					=> $customerDetails['customers_id'],
				'customers_name' 				=> $customerDetails['customers_firstname'] . ' ' . $customerDetails['customers_lastname'],
				'customers_company' 			=> null,
				'customers_street_address' 		=> $customerDetails['entry_street_address'],
				'customers_city' 				=> $customerDetails['entry_city'],
				'customers_postcode' 			=> $customerDetails['entry_postcode'],
				'customers_state' 				=> $customerDetails['entry_state'],
				'customers_country' 			=> $customerCountryDetails['countries_name'],
				'customers_telephone' 			=> null,
				'customers_email_address' 		=> $winnerDetails['ext_email_address'],
				'customers_address_format_id' 	=> $customerCountryDetails['address_format_id'])
			;
      } else {
     		$customerId = $this->createCustomer($winnerDetails, $buyerCountryId, $buyerZoneId);
      		$customerArray = array(	  
	      		'customers_id' 					=> $customerId,
				'customers_name' 				=> $winnerDetails['name'],
				'customers_company' 			=> null,
				'customers_street_address' 		=> rtrim(implode(",", array($winnerDetails['street1'],$winnerDetails['street2'])),","),
				'customers_city' 				=> $winnerDetails['city'],
				'customers_postcode' 			=> $winnerDetails['zip'],
				'customers_state' 				=> $winnerDetails['state'],
				'customers_country' 			=> $buyerCountryInfo['countries_name'],
				'customers_telephone' 			=> null,
				'customers_email_address' 		=> $winnerDetails['ext_email_address'],
				'customers_address_format_id' 	=> $buyerCountryInfo['address_format_id'])
			;      	
      }
		
      
      $sql_data_array = array(	  
			'delivery_name' 				=> $winnerDetails['name'],
			'delivery_company' 				=> null,
			'delivery_street_address' 		=> rtrim(implode(",", array($winnerDetails['street1'],$winnerDetails['street2'])),","),
			'delivery_city' 				=> $winnerDetails['city'],
			'delivery_postcode' 			=> $winnerDetails['zip'],
			'delivery_state' 				=> $winnerDetails['state'],
			'delivery_country' 				=> $buyerCountryInfo['countries_name'],
			'delivery_address_format_id' 	=> $buyerCountryInfo['address_format_id'],
			'billing_name' 					=> $winnerDetails['name'],
			'billing_company' 				=> null,
			'billing_street_address' 		=> rtrim(implode(",", array($winnerDetails['street1'],$winnerDetails['street2'])),","),
			'billing_city' 					=> $winnerDetails['city'],
			'billing_postcode' 				=> $winnerDetails['zip'],
			'billing_state' 				=> $winnerDetails['state'],
			'billing_country' 				=> $buyerCountryInfo['countries_name'],
			'billing_address_format_id' 	=> $buyerCountryInfo['address_format_id'],
			'payment_method' 				=> 'Paypal',
			'date_purchased' 				=> 'now()',
			'orders_status' 				=> DEFAULT_ORDERS_STATUS_ID,
			'currency' 						=> $ipnDetails['mc_currency'], // set to default currency
			'currency_value' 				=> 1
	  ); 
	  
	  $sql_data_array = array_merge($customerArray, $sql_data_array);

      $this->orderId = $abxDatabase->insert(TABLE_ORDERS, $sql_data_array);
      
      // create items
      foreach ($basketItems as $basketItem) {
      	  $this->addOrderProduct($basketItem, $winnerDetails['ext_customer_id']);		  
	  }
    
      $subTotal = (DISPLAY_PRICE_WITH_TAX == 'true') 
    			? $ipnDetails['mc_gross']
	    		: $ipnDetails['mc_gross'] - $ipnDetails['tax'];

      $nSubTotal = abxCurrenciesIpn::convertCurrency($subTotal - $ipnDetails['shipping'], $this->currency);
      $nTax      = abxCurrenciesIpn::convertCurrency($ipnDetails['tax'], 				  $this->currency);
      $nShipping = abxCurrenciesIpn::convertCurrency($ipnDetails['shipping'],  			  $this->currency);
      $nTotal    = abxCurrenciesIpn::convertCurrency($ipnDetails['mc_gross'],  			  $this->currency);

	  $this->createOrderTotal($this->orderId, 'ot_subtotal', 1, $nSubTotal, 'Subtotal');
	  $this->createOrderTotal($this->orderId, 'ot_tax', 	 2, $nTax, 'Tax');
	  $this->createOrderTotal($this->orderId, 'ot_shipping', 3, $nShipping, 'Shipping'); 
	  $this->createOrderTotal($this->orderId, 'ot_total', 	 4, $nTotal, 'Total', true);

	  $comment = 	"AuctionBlox PayPal
	  			    Payment Status    = " . $ipnDetails['payment_status'] . "
			        Payment Type      = " . $ipnDetails['payment_type'] . "
			        eBay User ID      = " . $ipnDetails['auction_buyer_id'] . "
			        eBay Item Numbers = " . $ipnDetails['item_number'] . "
			        Payment Date      = " . $ipnDetails['payment_date'] ."
			        Payment Amount    = " . abxCurrenciesIpn::format($ipnDetails['mc_gross'], $ipnDetails['mc_currency']) . "
			        Payment Currency  = " . $ipnDetails['mc_currency'];

	  $this->createStatusHistory($this->orderId, ABX_DEFAULT_PAYPAL_ORDER_STATUS_ID, $comment);

      return $this->orderId;
    }

    function createOrderTotal ($orderId, $class, $sortOrder, $value, $title, $bold=false) {

    	global $abxDatabase;

    	$text = ($bold)
    		  ? "<b>" . abxCurrenciesIpn::format($value, $this->currency) . "</b>"
    		  : abxCurrenciesIpn::format($value, $this->currency);

		$sql_data_array = array(
			'orders_id'  		=> $orderId,
			'title'      		=> $title,
			'text'       		=> $text,
			'value'      		=> $value,
			'class'      		=> $class,
			'sort_order' 		=> $sortOrder
		);

		return $abxDatabase->insert(TABLE_ORDERS_TOTAL, $sql_data_array);
    }

	/*
    	This function should be extended to notify customer etc.
	*/
    function createStatusHistory ($orderId, $status, $comment) {

    	global $abxDatabase;
        //js 7/22/08 changed the comments to admin comments...
		$sql_data_array = array(
			'orders_id' 		=> $orderId,
			'orders_status_id' 	=> $status,
			'date_added' 		=> 'now()',
			'customer_notified' => 0,
			'comments' 			=> $comment
		);

      	$abxDatabase->insert(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);
    }

    function addOrderProduct (&$itemDetails, $winnerId) {

    	global $abxDatabase;

		if (STOCK_LIMITED == 'true') {
		  	if (DOWNLOAD_ENABLED == 'true') {
			    $stock_query_raw = "SELECT 			products_quantity, pad.products_attributes_filename " .
			                       "FROM " . 		TABLE_PRODUCTS . " p " .
			                       "LEFT JOIN " . 	TABLE_PRODUCTS_ATTRIBUTES . " pa " .
			                       "ON	 			p.products_id=pa.products_id " .
			                       "LEFT JOIN " . 	TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad " .
			                       "ON 				pa.products_attributes_id=pad.products_attributes_id " .
			                       "WHERE 			p.products_id = " . (int)$itemDetails['products_id'];

			    $stock_values = $abxDatabase->fetch_row($stock_query_raw);
			} else {
		    	$stock_values = $abxDatabase->fetch_row("select products_quantity from " . TABLE_PRODUCTS . " where products_id = " . (int)$itemDetails['products_id']);
		  	}

			if (!empty($stock_values) > 0) {

				// do not decrement quantities if products_attributes_filename exists
				if (DOWNLOAD_ENABLED != 'true' || !$stock_values['products_attributes_filename'])
					$stock_left = $stock_values['products_quantity'] - (int)$itemDetails['quantity'];
				else
					$stock_left = $stock_values['products_quantity'];

				$abxDatabase->update(TABLE_PRODUCTS, array('products_quantity' => $stock_left), 'products_id = ' . (int)$itemDetails['products_id']);

				if ($stock_left < 1 && STOCK_ALLOW_CHECKOUT == 'false')
				  $abxDatabase->update(TABLE_PRODUCTS, array('products_status' => 0), 'products_id = ' . (int)$itemDetails['products_id']);
			}
		}

		// Update products_ordered (for bestsellers list)
		$query = "UPDATE " . TABLE_PRODUCTS . " SET products_ordered = products_ordered + " . (int)$itemDetails['quantity'] . " WHERE products_id = " . (int)$itemDetails['products_id'];
		$abxDatabase->query($query);

		// calculate net from gross
	    $taxRate = 0;
		//total / (total - tax) -1
		if ($itemDetails['sales_tax'] > 0)
		  	$taxRate	 = ($itemDetails['price_end'] / ($itemDetails['price_end'] - $itemDetails['sales_tax']) -1) * 100;
		elseif ($itemDetails['sales_tax_percent'] > 0)
		  	$taxRate	 = $itemDetails['sales_tax_percent'];

		// Update order items
		$sql_data_array = array(
		  'orders_id'         	=> $this->orderId,
		  'products_id'       	=> $itemDetails['products_id'],
		  'products_model'    	=> $this->getProductModel($itemDetails['products_id']),
		  'products_name'     	=> $itemDetails['ext_title'] . " (eBay #" .  $itemDetails['ext_id']. " " . $winnerId . ")",
		  'products_price'    	=> abxCurrenciesIpn::convertCurrency($itemDetails['price_end'], $this->currency),
		  'final_price'       	=> abxCurrenciesIpn::convertCurrency($itemDetails['price_end'], $this->currency),
		  'products_tax'      	=> $taxRate,
		  'products_quantity' 	=> $itemDetails['quantity']
		);

		$order_products_id = $abxDatabase->insert(TABLE_ORDERS_PRODUCTS, $sql_data_array);

		abxBasketService::setOrderId($this->orderId, $itemDetails['auction_basket_id']);

    }

    function getCustomer($email) {

    	global $abxDatabase;

        $sQuery = "SELECT" .
	    		 " c.customers_id," .
	             " c.customers_firstname," .
	             " c.customers_lastname," .
	             " c.customers_default_address_id," .
	             " a.entry_street_address," .
	             " a.entry_suburb," .
	             " a.entry_postcode," .
	             " a.entry_city," .
	             " a.entry_state," .
	             " a.entry_country_id," .
	             " a.entry_zone_id" .
	             " FROM %s c" .
	             " LEFT JOIN %s a ON c.customers_id = a.customers_id" .
	             " WHERE a.address_book_id = c.customers_default_address_id" .
	             " AND c.customers_email_address = '%s'" .
	             " LIMIT 1";

        $sQuery = sprintf(
          $sQuery,
          TABLE_CUSTOMERS,
          TABLE_ADDRESS_BOOK,
          $abxDatabase->escape($email)
        );

        return $abxDatabase->fetch_row($sQuery);

    }

    function createCustomer(&$winnerDetails, $countryID, $zoneId) {

      global $abxDatabase;

      $nameArray = $this->convertName($winnerDetails['name']);

      $aCustomer = array(
        'customers_gender'        => 'U', 	// unknown
        'customers_firstname'     => $nameArray['firstName'],
        'customers_lastname'      => $nameArray['lastName'],
        'customers_email_address' => $winnerDetails['ext_email_address'],
        //'customers_telephone'     => $winnerDetails['phone'],
        'customers_newsletter'    => '0',
        'customers_password'      => $this->getNewPassword()
      );

      $this->customerId = $abxDatabase->insert(TABLE_CUSTOMERS, $aCustomer);

      $aInfo = array(
        'customers_info_id'                         => $this->customerId,
        'customers_info_number_of_logons'           => 0,
        'customers_info_date_account_created'       => date("Y-m-d H:i:s"),
        'customers_info_date_account_last_modified' => '0000-00-00 00:00:00'
      );

      $abxDatabase->insert(TABLE_CUSTOMERS_INFO, $aInfo);

      $aAddress = array(
        'customers_id'         => $this->customerId,
        'entry_gender'         => 'U',
        'entry_firstname'      => $nameArray['firstName'],
        'entry_lastname'       => $nameArray['lastName'],
        'entry_company'        => '',
        'entry_street_address' => rtrim(implode(",", array($winnerDetails['street1'],$winnerDetails['street2'])),","),
        'entry_suburb'         => '',
        'entry_city'           => $winnerDetails['city'],
        'entry_postcode'       => $winnerDetails['zip'],
        'entry_state'          => $winnerDetails['state'],
        'entry_country_id'     => $countryID,
        'entry_zone_id'        => $zoneId
      );

      $addressId = $abxDatabase->insert(TABLE_ADDRESS_BOOK, $aAddress);

      $abxDatabase->update(
        TABLE_CUSTOMERS,
        array('customers_default_address_id' => $addressId),
        'customers_id='. $this->customerId
      );

      return $this->customerId;

    }

    // May not be required, just adds a new address to address book without verifying
    // that it is different from current default address
    function customerUpdate(&$order)
    {
    	return true;

/*      global $abxDatabase;

      $nameArray = $this->convertName($order['buyer']['name']);

      $aAddress = array(
        'customers_id'         => $this->customerId,
        'entry_gender'         => 'U',
        'entry_firstname'      => $nameArray['firstName'],
        'entry_lastname'       => $nameArray['lastName'],
        'entry_company'        => '',
        'entry_street_address' => implode(",", array($order['buyer']['street1'],$order['buyer']['street2'])),
        'entry_suburb'         => '',
        'entry_city'           => $order['buyer']['city'],
        'entry_postcode'       => $order['buyer']['zip'],
        'entry_state'          => $order['buyer']['state'],
        'entry_country_id'     => $this->buyerCountryId,
        'entry_zone_id'        => $this->buyerZoneId
      );

      $addressId = $abxDatabase->insert(TABLE_ADDRESS_BOOK, $aAddress);

      $abxDatabase->update(
        TABLE_CUSTOMERS,
        array('customers_default_address_id' => $addressId),
        'customers_id='.$this->customerId
      );

      $sWhere = sprintf(
        "ext_email_address = '%s' LIMIT 1",
        $abxDatabase->escape($this->sEmail)
      );

      $aUpdate = array(
        'customers_id' => $this->customerId
      );

      $abxDatabase->update(TABLE_ABX_WINNERS, $aUpdate, $sWhere);
*/
    }

    function getNewPassword() {

		$sPassword = '';
		$nLength   = 8;

		for($i=0; $i<$nLength; $i++) {
			$sChar = chr(rand(48, 122));

		while(!ereg("[a-zA-Z0-9]", $sChar)) {
		  if ($sChar == @$sLastChar) {
		    continue;
		  }
		  $sChar = chr(rand(48, 90));
		}
		$sPassword .= $sChar;
		$sLastChar  = $sChar;
		}

		$this->customerPassword = $sPassword;
		$sSalt     				= substr(md5($sPassword), 0, 2);
		$sEncryptedPassword 	= md5($sSalt.$sPassword).':'.$sSalt;

		return $sEncryptedPassword;

    }

    function convertName($name) {

		$firstName = $name;
		$lastName = '';

		$nameArray = explode(' ', $name);

		if (is_array($nameArray)) {

		$firstName = $nameArray[0];  // firstname should be first element
		$name = array_shift($nameArray);  // pop firstname off array

		foreach ($nameArray as $key => $lname)
			$lastName .= $lname . ' ';
		}

		  return array('firstName' => $firstName,
		           'lastName' => rtrim($lastName));
    }

    function getCountryIdByIsoCode($sCountryIsoCode) {

		$aCountries = $this->getCountries();

		foreach($aCountries as $nCountryId => $aCountry) {
			if ($aCountry['countries_iso_code_2'] == $sCountryIsoCode) {
			  return $nCountryId;
			}
		}
    }

    function getCountries($nCountryId = null) {
		static $aCountries;

		if (!$aCountries) {
			global $abxDatabase;

			$sQuery = "SELECT countries_id,"
			                ."countries_name,"
			                ."countries_iso_code_2,"
			                ."countries_iso_code_3,"
			                ."c.address_format_id,"
			                ."address_format "
			        ."FROM %s c "
			        ."LEFT JOIN %s a on c.address_format_id = a.address_format "
			        ."ORDER BY countries_name";

			$sQuery = sprintf($sQuery, TABLE_COUNTRIES, TABLE_ADDRESS_FORMAT);
			$Query = $abxDatabase->query($sQuery);

			while($aCountry = $Query->next()) {
			  $aCountries[$aCountry['countries_id']] = $aCountry;
			}
		}

		return (!$nCountryId) ? $aCountries : $aCountries[$nCountryId];
    }

    function hasCountryZones($nCountry = null) {

    	static $aCountries;

		if (!($nCountry = intval($nCountry))) {
			$nCountry = $this->nCountryId;
		}

		if ($nCountry = intval($nCountry)) {
			if (!isset($aCountries[$nCountry])) {
			  global $abxDatabase;

			  $sQuery = "SELECT count(*) AS total "
			           ."FROM %s "
			           ."WHERE zone_country_id = %d";

			  $aRes = $abxDatabase->fetch_row(sprintf($sQuery, TABLE_ZONES, $nCountry));

			  $aCountries[$nCountry] = ($aRes['total'] > 0);
			}

			return $aCountries[$nCountry];
		}

		return false;
    }

    function getZoneIdByState($sState, $nCountry) {

    	global $abxDatabase;

		$bCountryZones = $this->hasCountryZones($nCountry);

		if ($bCountryZones) {
			$sQuery = "SELECT DISTINCT zone_id "
			         ."FROM %s "
			         ."WHERE zone_country_id = %d "
			          ."AND (zone_name = '%s' OR zone_code = '%s')";

			$sQuery = sprintf(
			  $sQuery,
			  TABLE_ZONES,
			  $nCountry,
			  $abxDatabase->escape($sState),
			  $abxDatabase->escape($sState)
			);
			
			$Query = $abxDatabase->query($sQuery);
			
			if ($Query->numRows() == 1) {
			  return $Query->valueInt('zone_id');
			}
		}
    }
    
    function getCountryInfo($countryId) {
    	
       global $abxDatabase;

        $sQuery = "SELECT DISTINCT c.countries_id,"
                        ."c.countries_name,"
                        ."c.countries_iso_code_2,"
                        ."c.countries_iso_code_3,"
                        ."c.address_format_id,"
                        ."a.address_format "
                ."FROM %s c "
                ."LEFT JOIN %s a on c.address_format_id = a.address_format "
                ."WHERE c.countries_id = %d ";

        $sQuery = sprintf($sQuery, TABLE_COUNTRIES, TABLE_ADDRESS_FORMAT,$countryId);
        $Query = $abxDatabase->query($sQuery);

        // Should only be one row
        return $Query->next();
    }
    
    function getProductModel ($productId) {
    	
      global $abxDatabase;
    	
		  $sql = "SELECT products_model "
			  . " FROM " . TABLE_PRODUCTS 
			  . " WHERE products_id = '" . (int)$productId . "'";
		
		  $results =  $abxDatabase->fetch_row($sql, TABLE_PRODUCTS);
		
		  return $results['products_model'];
    }
    
}  // end class
?>