dojo.provide("abx.widget.DomesticShippingContainer");

dojo.require("dijit._Widget");
dojo.require("dijit._Templated");
dojo.require("dijit.form.CheckBox");
dojo.require("dijit.form.FilteringSelect");
dojo.require("dijit.form.TextBox");
dojo.require("abx.widget.DomesticShippingService");

dojo.declare("abx.widget.DomesticShippingContainer",
        [dijit._Widget,dijit._Templated],
        {        
        templatePath: dojo.moduleUrl("abx","layout/widget/DomesticShippingContainer.html"),
        templateString: "",
        src: "",
        widgetsInTemplate: true,
        
        shippingService1: null,
        shippingService2: null,
        shippingService3: null,
        
        shippingType: null,
        shippingTypeName: 'abxship_dom_shipping_type',
        
        ebayShippingPane: null,
        noShippingPane: null,
        
        flatShippingRule: null,
        flatShippingRuleContainer: null,
        flatShippingRuleName: 'abxship_dom_ship_flat_shipping_rule',
        calcShippingRule: null,
        calcShippingRuleContainer: null,
        calcShippingRuleName: 'abxship_dom_ship_calc_shipping_rule',
        
        insurance: null,
        insuranceName: 'abxship_dom_insurance', 
        insuranceCost: null,
        insuranceCostName: 'abxship_dom_insurance_cost', 
        handlingCost: null,
        handlingCostName: 'abxship_dom_handling_cost',         
        
        typePopulated: false,
        readyForPopulate: false,
        
        changeShippingType: function(){
        	this.redrawContainer();
        
        	dojo.publish('dom_ship_type_change', [this.shippingType.getValue()]);
        	dojo.publish('redraw_shipping_portlet');
        },
        
        redrawContainer: function(){
			if (this.shippingType.getValue()=="C"){
        		dojo.style(this.ebayShippingPane, "display", "none");
        		dojo.style(this.noShippingPane, "display", "");
        	}
        	else{
        		dojo.style(this.noShippingPane, "display", "none");
        		dojo.style(this.ebayShippingPane, "display", "");
        		if (this.shippingType.getValue()=="F"){
        			dojo.style(this.flatShippingRuleContainer, "display", "");
        			dojo.style(this.calcShippingRuleContainer, "display", "none");        			
        		}else{
        			dojo.style(this.flatShippingRuleContainer, "display", "none");        		
        			dojo.style(this.calcShippingRuleContainer, "display", "");        			
        		}
        	}        
        },
        
        dimensionsRequired: function(){
        
        	return (this.shippingService1.dimensionsRequired() || this.shippingService2.dimensionsRequired() || this.shippingService3.dimensionsRequired());
        
        },
        
        packageInfoRequired: function(){
        
        	if (this.shippingType.getValue()=="E"){
        		return true;
        	}
        	return false;
        
        },
        
        setType: function(items, request){
        	var shipTypeVal = abxShipping[this.shippingTypeName];
        	if (null == shipTypeVal){
        		shipTypeVal = 'F';
        	}
        	this.shippingType.setValue(shipTypeVal);
        	
        	this.typePopulated = true;
        },
        
        populateFields: function(){
        	//populate fields
        	this.shippingType.store.fetch({onComplete: dojo.hitch(this, 'setType')});        	        	
        	var insVal = abxShipping[this.insuranceName];
        	if (null == insVal){
        		insVal = '0';
        	}
        	this.insurance.setValue(insVal);
        	
        	if (abxShipping[this.flatShippingRuleName]){
        		this.flatShippingRule.setChecked(true);
        	}
        	if (abxShipping[this.calcShippingRuleName]){
        		this.calcShippingRule.setChecked(true);
        	}
        	this.insuranceCost.setValue(abxShipping[this.insuranceCostName]);
        	this.handlingCost.setValue(abxShipping[this.handlingCostName]);
        	
        	this.shippingService1.populateFields(abxShipping[this.shippingTypeName]);
        	this.shippingService2.populateFields(abxShipping[this.shippingTypeName]);
        	this.shippingService3.populateFields(abxShipping[this.shippingTypeName]);
        },
        
        wireAndDraw: function(){
        	this.shippingType.onChange = dojo.hitch(this, 'changeShippingType');
        	this.redrawContainer();
        	
        	this.shippingService1.wireAndDraw(abxShipping[this.shippingTypeName]);
        	this.shippingService2.wireAndDraw(abxShipping[this.shippingTypeName]);
        	this.shippingService3.wireAndDraw(abxShipping[this.shippingTypeName]);
        },
        
        populated: function(){
        	return this.typePopulated && this.shippingService1.populated() && this.shippingService2.populated() && this.shippingService3.populated();
        },
        
        canBePopulated: function(){
        	return this.readyForPopulate && this.shippingService1.canBePopulated() && this.shippingService2.canBePopulated() && this.shippingService3.canBePopulated();
        },
        
        packageChange: function(){
        
        	dojo.publish('dom_ship_type_change', [this.shippingType.getValue()]);
        
        },
        
        servicesReady: function(){
        	return this.shippingService1.isReady() && this.shippingService2.isReady() && this.shippingService3.isReady();
        },
                        
        postCreate: function(){
        	
        },
        
        startup: function(){
        	        	
        	this.readyForPopulate = true;
        	
        }
        
});