dojo.provide("abx.widget.DomesticShippingService");

dojo.require("dijit._Widget");
dojo.require("dijit._Templated");
dojo.require("dijit.form.CheckBox");
dojo.require("dijit.form.FilteringSelect");
dojo.require("dijit.form.TextBox");
dojo.require("dojo.number");

dojo.declare("abx.widget.DomesticShippingService",
        [dijit._Widget,dijit._Templated],
        {        
        templatePath: dojo.moduleUrl("abx","layout/widget/DomesticShippingService.html"),
        templateString: "",
        src: "",
        widgetsInTemplate: true,
        
        //instance variables
        selectBox: null,
        servicesName: "",
        flatCostField: null,
        flatCostName: "",
        flatCostAddlField: null,
        flatCostAddlName: "",
        flatCostContainer: null,
        
        servicePopulated: false,
        readyForPopulate: false,
        serviceReady: false,
        
        showFreeShipping: false,
        freeShippingContainer: null,
        freeShippingCheckbox: null,
		
		serviceChanged: function(){
        
        	dojo.publish('redraw_shipping_portlet');
        
        },
        
        dimensionsRequired: function(){
        
        	var item = this.selectBox.item;
        	if (item == null){
        		return false;
        	}
        	var dimensionsRequired = this.selectBox.store.getValue(item, 'dimensionsRequired');
        	if (dimensionsRequired != null && dimensionsRequired == '1'){
        		return true;
        	}
        	else{
        		return false;
        	}	
        
        },        
        
        shippingTypeChange: function(shippingType){
        	if (shippingType == "F"){
        		this.selectBox.store = domFlatShippingServicesStore;
        		dojo.style(this.flatCostContainer, "display", "");
        		if (this.showFreeShipping){
        			dojo.style(this.freeShippingContainer, "display", "");
        		}
        	}
        	else if (shippingType == "E"){
        		this.selectBox.store = domCalcShippingServicesStore;
        		dojo.style(this.flatCostContainer, "display", "none");        		
        		dojo.style(this.freeShippingContainer, "display", "none");
        	}
        	this.serviceReady = false;
        	this.selectBox.store.fetch({onComplete: dojo.hitch(this, 'setService')});
        },
        
        setService: function(items, request){
        	var selVal = abxShipping[this.servicesName];
        	if (null == selVal || this.servicePopulated){
        		selVal = '';
        	}
			//due to an apparent dojo bug, we need to look up the 'item' for this box and set it
        	for (var i = 0; i < items.length; i++){
        		if (items[i]['id'] == selVal){
        			this.selectBox.item = items[i];
        		}
        	}
        	this.selectBox.setValue(selVal);
        	
    		this.serviceReady = true;	
        	this.servicePopulated = true;
        },
        
        freeShippingChanged: function(){
        
        	if (this.freeShippingCheckbox.checked){
        		this.flatCostField.setValue('0.00');
        		this.flatCostField.domNode.setAttribute('readonly', 'true');
        		this.flatCostAddlField.setValue('0.00');
        		this.flatCostAddlField.domNode.setAttribute('readonly', 'true');
        	}
        	else{
	        	this.flatCostField.setValue('');
        		this.flatCostField.domNode.removeAttribute('readonly');
        		this.flatCostAddlField.setValue('');
        		this.flatCostAddlField.domNode.removeAttribute('readonly');
        	}
        			
        },
        
        populateFields: function(shippingType){
        	//populate values
        	
        	//we have to do this to make sure the correct store is chosen
        	//before we try to set the initial value of the drop down
        	if (shippingType == "E"){
        		this.selectBox.store = domCalcShippingServicesStore;
        	}
        	else if (shippingType == "F" || shippingType == null){
        		this.selectBox.store = domFlatShippingServicesStore;
        	}
        	else{
        		//we must be doing 'abx' shipping, no need to wait for population
        		this.serviceReady = true;	
        		this.servicePopulated = true;        	
        	}
        	
	       	this.selectBox.store.fetch({onComplete: dojo.hitch(this, 'setService')});
        	this.flatCostField.setValue(abxShipping[this.flatCostName]);
        	this.flatCostAddlField.setValue(abxShipping[this.flatCostAddlName]);
        },
        
        wireAndDraw: function(shippingType){
        	if (this.showFreeShipping){
        		dojo.style(this.freeShippingContainer, "display", "");
        		this.freeShippingCheckbox.onChange = dojo.hitch(this, 'freeShippingChanged');
        		if (dojo.number.parse(abxShipping[this.flatCostName]) <= 0){
        			this.freeShippingCheckbox.setChecked(true);
        			this.flatCostField.setValue('0.00');
        			this.flatCostField.domNode.setAttribute('readonly', 'readonly');
        			this.flatCostAddlField.setValue('0.00');
        			this.flatCostAddlField.domNode.setAttribute('readonly', 'readonly');
        		}
        	}
        	if (shippingType == "F"){
        		dojo.style(this.flatCostContainer, "display", "");
        	}
        	else if (shippingType == "E"){
        		dojo.style(this.flatCostContainer, "display", "none");
        		dojo.style(this.freeShippingContainer, "display", "none");        		
        	}
        	
        	dojo.subscribe("dom_ship_type_change", this, "shippingTypeChange");
        	
        	//intialize select box
        	this.selectBox.onChange = dojo.hitch(this, 'serviceChanged');
        },
        
        populated: function(){
        	return this.servicePopulated;
        },
        
        canBePopulated: function(){
        	return this.readyForPopulate;
        },
        
        isReady: function(){
        	return this.serviceReady;
        },
        
        postCreate: function(){
        	        	
        },
        
        startup: function(){
        	this.readyForPopulate = true;
        }
        
});