<?php
/*
  $Id: listings.php,v 1.9 2008/08/13 19:06:10 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxPaginator_Listings extends abxPaginator {

    function filterTerms()
    {
      static $filterTerms;

      if (isset($filterTerms) === false) {

        $array = abxConstants::getListingsTypes();

        unset($array[5],$array[6]);

        $filterTerms = array(
          'values' => $array
        );

      }

      return $filterTerms;
    }

    function sortDefaultArray()
    {
      return array(
        'name'  => 'end_time',
        'value' => 'desc'
      );
    }

    function searchTerms()
    {
      return array(
        array('id'=>"ext_title",'text'=>'SEARCH_LIST_1'),
        array('id'=>"ext_id",'text'=>'SEARCH_LIST_2'),
        array('id'=>"l.listing_type",'text'=>'SEARCH_LIST_3')
      );
    }

    function sellerIDs()
    {
      static $eBaySellerList;

      if (isset($eBaySellerList) === false) {

        $sellers = abxConstants::getEbaySellerIDs(array(array('id' => '', 'text' => '')));

        $eBaySellerList = array();

        foreach($sellers as $seller)
          $eBaySellerList[] = array( 'id' => $seller['text'], 'text' => $seller['text']);

      }

      return $eBaySellerList;
    }

    function sellerID()
    {
      if (empty($_GET['seller_id']) === false)
        return array(
          'name'  => 'user_id',
          'value' => $_GET['seller_id']
        );

      return array();
    }

    function tableDataHeadings()
    {
      return array(
        array('heading' => '<a href="" onclick="lazyloadimages();return false;">Images +</a>'),
        array('heading' => HEADING_LISTING_TITLE, 'sort_field' => 'ext_title'),
        array('heading' => HEADING_LISTING_ID, 'sort_field' => 'ext_id'),
        array('heading' => HEADING_LISTING_SITE, 'sort_field' => 'site'),
        array('heading' => HEADING_LISTING_TYPE, 'sort_field' => 'listing_type'),
        array('heading' => HEADING_LISTING_PRICE_END, 'sort_field' => 'current_price'),
        array('heading' => HEADING_LISTING_END_DATE, 'sort_field' => 'end_time'),
        array('heading' => HEADING_LISTING_QTY_ON_HAND, 'sort_field' => 'l.products_quantity'),
        array('heading' => HEADING_LISTING_QTY_SOLD),
        array('heading' => HEADING_LISTING_FEE, 'sort_field' => 'listing_fee')
      );
    }

    function tableDataRowContents($array)
    {
      global $currencies;

      $listingTypes = abxConstants::getListingTypesShort();

      return '<td ><script language="JavaScript">lazyimages['.$array['id'].']="'.DIR_WS_ABX_CATALOG_IMAGES .$array['products_image'].'";</script>' . $this->image(DIR_WS_ABX_ICONS . 'info.gif', 'Click to load image', 16, 16,'onclick="lazyloadimage('.$array['id'].',this);" id="lazyimage'.$array['id'].'"') . '</td>'.
             '<td>' . $this->cell('<a href="' . sprintf($array['url'], $array['ext_id']) . '" target="ebay">' . wordwrap($array['ext_title'], 150, "<br />\n") . '</a>') . '</td>'.
             '<td>' . $this->cell($array['ext_id']) . '</td>'.
             '<td>' . $this->cell($array['site']) . '</td>'.
             '<td>' . $this->cell($listingTypes[$array['listing_type']]) . '</td>'.
             '<td align="right">' . $this->cell($currencies->format($array['current_price'], false, $array['currency'])) . '</td>'.
             '<td align="right">' . $this->cellWrapDate(gmt_date_to_local_pretty_format($array['end_time'])) . '</td>'.
             '<td align="right">' . $this->cell($array['products_quantity']) . '</td>'.
             '<td align="right">' . $this->cell($array['quantity_sold'] . '&nbsp;/&nbsp;' . $array['quantity']) . '</td>'.
             '<td align="right">' . $this->cell($currencies->format($array['listing_fee'])) . '</td>';
    }

    function drawExtraHiddenFields()
    {
      return '<input type="hidden" name="abx_last" value="listings">';
    }

    function bulkActions()
    {
      return array(
        'DeleteItems'    => array('icon'=>'delete.gif','alt'=>ACTION_DELETE,'onclick' => "confirmBulkAction('".JAVASCRIPT_CONFIRM_DELETE."','".TEXT_LISTINGS."','DeleteConfirm');"),
        'RelistListings' => array('icon'=>'uploads.gif', 'enabled' => 'true', 'alt'=>ACTION_RELIST,'action'=>'listings-relist'),
        'CancelListings' => array('icon'=>'cancel.gif','alt'=>ACTION_CANCEL_LISTINGS,'onclick' => "confirmBulkAction('".JAVASCRIPT_CONFIRM_CANCEL."','".TEXT_LISTINGS."','CancelListings','uploader','abx_uploader');"),
        'SendSecondChanceOffer' => array('icon'=>'send_offer.png','alt'=>ACTION_SEND_SECOND_CHANCE,'onclick' => "confirmBulkAction('".JAVASCRIPT_CONFIRM_CANCEL."','".TEXT_LISTINGS."','SendSecondChanceOffer','uploader','abx_uploader');")
      );
    }

    function disableBulkActions(&$abxPageIcons)
    {
      switch($_GET['filter']) {
        case 'ACTIVE':
          $abxPageIcons->enable(array('CancelListings'));
          break;
        case 'ENDED':
          $abxPageIcons->enable(array('DeleteItems','RelistListings','SendSecondChanceOffer'));
          break;
        case 'PENDING':
         $abxPageIcons->enable(array('CancelListings'));
          break;
        case 'FAILED':
          $abxPageIcons->enable(array('DeleteItems'));
          break;
        case 'CANCELED':
          $abxPageIcons->enable(array('DeleteItems','RelistListings'));
          break;
        case 'SOLD':
        case 'UNSOLD':
          $abxPageIcons->enable(array('DeleteItems','RelistListings','SendSecondChanceOffer'));
          break;
      }
    }

    function infoBox($action)
    {
      switch($action) {
        case 'CancelListings':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_CANCEL_LISTINGS,'','CancelListingsConfirm');
          break;
        case 'download':
          return $this->infoPageBox(TEXT_INFO_HEADING_DOWNLOAD_LISTINGS,TEXT_INFO_DOWNLOAD_LISTINGS, 'listings', 'downloadConfirm','listings-download','', $this->infoBoxDownloads());
          break;
      }
    }

    function tableDataFooter()
    {
      return '<div style="float: right;"><form name="listingsDownload" method="post">'.$this->submit(TEXT_DOWNLOAD_LISTINGS,'this.form','download','listings-download','','greenButton').'<input type="hidden" name="perform"></form></div>';
    }

    function infoBoxDownloads()
    {
      return array(array('text' =>  '<div style="margin: 10px;">' . $this->select('seller_id',abxConstants::getEbaySellerIDs()) . '</div>'));
    }

  }//end class
?>