<?php
/*
  $Id: shipping_fixed.php,v 1.2 2005/05/27 14:53:41 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxPaginator_Macros extends abxPaginator {

    function filterTerms()
    {
      static $filterTerms;

      if(isset($filterTerms) === false) {

        $filterTerms = array(
          'values' => abx_get_category_tree()
        );

      }

      return $filterTerms;
    }

    function sortDefaultArray()
    {
      return array(
        'name' => 'p.products_last_modified',
        'value' => 'desc'
      );
    }

    function countSellerIDs()
    {
      return 0;
    }

    function searchTerms()
    {
      return array(
        array('id'=>"pd.products_name",'text'=>'SEARCH_LIST_1')
      );
    }

    function tableDataHeadings()
    {
      return array(
        array('heading' => ''),
        array('heading' => TABLE_HEADING_PRODUCTS, 'sort_field' => 'products_name'),
        array('heading' => 'Do not list on eBay as:'),
        array('heading' => '{CUSTOM1}'),
        array('heading' => '{CUSTOM2}'),
        array('heading' => '{CUSTOM3}'),
        array('heading' => '{CUSTOM4}'),
        array('heading' => '{CUSTOM5}'),
        array('heading' => '{CUSTOM6}'),
        array('heading' => '{CUSTOM7}'),
        array('heading' => '{CUSTOM8}'),
        array('heading' => '{CUSTOM9}'),
        array('heading' => '{CUSTOM10}')
      );
    }

    function tableDataRowContents($array)
    {
      global $currencies;

      $id = $array['id'];

      $str = '<td>' . $this->image(DIR_WS_ABX_CATALOG_IMAGES . $array['products_image'], 'No image', 50, 40) . '</td>';
      $str .= '<td>' . $this->cellWrap($array['products_name'], 150) . '</td>';
      $str .= '<td align="left">' . 
               $this->checkbox('exclude_auction-'.$id, '1', '', false, $array['exclude_auction']) . '&nbsp;Auction' .
               $this->checkbox('exclude_fixed-'.$id, '1', '', false, $array['exclude_fixed']) . '&nbsp;Fixed' .
               $this->checkbox('exclude_store-'.$id, '1', '', false, $array['exclude_store']) . '&nbsp;Store'.
              '</td>';

        $str .= '<td align="right">' . $this->input('custom1-'.$id, $array['custom1'], "size=10") . '</td>'.
                '<td align="right">' . $this->input('custom2-'.$id, $array['custom2'], "size=10") . '</td>'.
                '<td align="right">' . $this->input('custom3-'.$id, $array['custom3'], "size=10") . '</td>'.
                '<td align="right">' . $this->input('custom4-'.$id, $array['custom4'], "size=10") . '</td>'.
                '<td align="right">' . $this->input('custom5-'.$id, $array['custom5'], "size=10") . '</td>'.
                '<td align="right">' . $this->input('custom6-'.$id, $array['custom6'], "size=10") . '</td>'.
                '<td align="right">' . $this->input('custom7-'.$id, $array['custom7'], "size=10") . '</td>'.
                '<td align="right">' . $this->input('custom8-'.$id, $array['custom8'], "size=10") . '</td>'.
                '<td align="right">' . $this->input('custom9-'.$id, $array['custom9'], "size=10") . '</td>'.
                '<td align="right">' . $this->input('custom10-'.$id, $array['custom10'], "size=10") . '</td>';
//      }

      return $str;
    }

    function bulkActions()
    {
      return array(
        'SaveItems' => array('icon'=>'save_all.png','alt'=>ACTION_SAVE,'onclick' => "confirmBulkAction('".JAVASCRIPT_CONFIRM_SAVE."','".TEXT_ABX_PRODUCTS_EXTRA_INFO."','save_confirm');"),
        'DeleteItems' => array('icon'=>'delete.gif','alt'=>ACTION_DELETE,'onclick' => "confirmBulkAction('".JAVASCRIPT_CONFIRM_DELETE."','".TEXT_ABX_PRODUCTS_EXTRA_INFO."','delete_confirm');"),
      );
    }
    
    function singleActions($array = array())
    {
      return array(
        'editListing' => array('icon'=>'edit.gif','alt'=>ACTION_EDIT,'url'=>abx_href_link(FILENAME_AUCTIONBLOX, 'abx=macros-edit&oID=' . $array['id'].abxPage::getSearchParams())),
      );
    }
  }//end class
?>