<!DOCTYPE html>
<html lang="en">'
<!-- <meta charset="UTF-8">  -->
<link rel="stylesheet" type="text/css" href="../../includes/stylesheet.css">
<div class="container-fluid">
<?php
if (!class_exists('DateTime')) {
class DateTime {
    public $date;
   
    public function __construct($date) {
        $this->date = strtotime($date);
    }
   
    public function setTimeZone($timezone) {
        return;
    }
   
    private function __getDate() {
        return date(DATE_ATOM, $this->date);   
    }
   
    public function modify($multiplier) {
        $this->date = strtotime($this->__getDate() . ' ' . $multiplier);
    }
   
    public function format($format) {
        return date($format, $this->date);
    }
}
}
/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2009 Amazon Technologies, Inc.
 *  @link        http://aws.amazon.com
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2009-01-01
 */
/******************************************************************************* 

 *  Marketplace Web Service PHP5 Library
 *  Generated: Thu May 07 13:07:36 PDT 2009
 * 
 */

/**
 * Get Feed Submission Result  Sample
 
 */

// header('Content-Type: text/html; charset=utf-8');
$MP = 'fr';

 if (isset($_GET["mp"])) {  
	if ($_GET["mp"] == 'uk')  {
	$MP = 'uk';	
	}
}

 if (isset($_GET["mp"])) {  
	if ($_GET["mp"] == 'us')  {
	$MP = 'us';	
	}
}

require('import_top_special.php');
if ($MP   == 'fr') include_once ('.config.inc.php'); 
if ($MP   == 'uk') include_once ('.config.inc.uk.php'); 

/************************************************************************
* Uncomment to configure the client instance. Configuration settings
* are:
*
* - MWS endpoint URL
* - Proxy host and port.
* - MaxErrorRetry.
***********************************************************************/
// IMPORTANT: Uncomment the appropriate line for the country you wish to
// sell in:
// United States:
if ($MP  == 'us') $serviceUrl = "https://mws.amazonservices.com";
// United Kingdom
if ($MP  == 'uk') $serviceUrl = "https://mws.amazonservices.co.uk";
// Germany
//$serviceUrl = "https://mws.amazonservices.de";
// France
if ($MP  == 'fr') $serviceUrl = "https://mws.amazonservices.fr";
// Italy
//$serviceUrl = "https://mws.amazonservices.it";
// Japan
//$serviceUrl = "https://mws.amazonservices.jp";
// China
//$serviceUrl = "https://mws.amazonservices.com.cn";
// Canada
//$serviceUrl = "https://mws.amazonservices.ca";
// India
//$serviceUrl = "https://mws.amazonservices.in";

$config = array (
  'ServiceURL' => $serviceUrl,
  'ProxyHost' => null,
  'ProxyPort' => -1,
  'MaxErrorRetry' => 3,
);

//$id_feedsubmission = "9873803588" ;

 $idlot = $_GET["idlot"];

$id_feedsubmission = $idlot ;

/************************************************************************
 * Instantiate Implementation of MarketplaceWebService
 * 
 * AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY constants 
 * are defined in the .config.inc.php located in the same 
 * directory as this sample
 ***********************************************************************/
 $service = new MarketplaceWebService_Client(
     AWS_ACCESS_KEY_ID, 
     AWS_SECRET_ACCESS_KEY, 
     $config,
     APPLICATION_NAME,
     APPLICATION_VERSION);
 
/************************************************************************
 * Uncomment to try out Mock Service that simulates MarketplaceWebService
 * responses without calling MarketplaceWebService service.
 *
 * Responses are loaded from local XML files. You can tweak XML files to
 * experiment with various outputs during development
 *
 * XML files available under MarketplaceWebService/Mock tree
 *
 ***********************************************************************/
 // $service = new MarketplaceWebService_Mock();

/************************************************************************
 * Setup request parameters and uncomment invoke to try out 
 * sample for Get Feed Submission Result Action
 ***********************************************************************/
 // @TODO: set request. Action can be passed as MarketplaceWebService_Model_GetFeedSubmissionResultRequest
 // object or array of parameters
 
$parameters = array (
  'Merchant' => MERCHANT_ID,
  'FeedSubmissionId' => $id_feedsubmission,
  'FeedSubmissionResult' => @fopen('php://memory', 'rw+'),
);

$request = new MarketplaceWebService_Model_GetFeedSubmissionResultRequest($parameters);

$request = new MarketplaceWebService_Model_GetFeedSubmissionResultRequest();
$request->setMerchant(MERCHANT_ID);
$request->setFeedSubmissionId($id_feedsubmission);
$request->setFeedSubmissionResult(@fopen('php://memory', 'rw+'));
$fp = fopen('php://memory', 'rw+');

$request->setFeedSubmissionResult($fp);
     
invokeGetFeedSubmissionResult($service, $request);

rewind($fp);

$res = stream_get_contents($fp);

$ret = simplexml_load_string ($res);

$ProcessingSummary = $ret->Message->ProcessingReport->ProcessingSummary;
?>
	<div class="row">
		<div class="col-md-12">
			<div class="page-header">
			<h1>Details rapport de soumission <small><?= $MP ?></small></h1>
			</div>
		</div>		
	</div>	
	<div class="row">
		<div class="col-md-3">
			<button class="btn btn-primary btn-lg" type="button">
				Total Messages <span class="badge"><?php echo $ProcessingSummary->MessagesProcessed ?></span>	
			</button>
		</div>
		<div class="col-md-3">
			<button class="btn btn-success btn-lg" type="button">
				Messages Success <span class="badge"><?php echo $ProcessingSummary->MessagesSuccessful ?></span>	
			</button>
		</div>
		<div class="col-md-3">
			<button class="btn btn-danger btn-lg" type="button">
				Messages en Erreur <span class="badge"><?php echo $ProcessingSummary->MessagesWithError ?></span>	
			</button>
		</div>

		<div class="col-md-3">
			<button class="btn btn-warning btn-lg" type="button">
				Messages en Warning <span class="badge"><?php echo $ProcessingSummary->MessagesWithWarning ?></span>	
			</button>
		</div>
	</div>	
	<p></p>
	<div class="row">
		<div class="col-md-12">
			<table class="table">
				<tr>
				<th>Id message</th>
				<th>type erreur</th>
				<th>code erreur</th>
				<th>Description</th>	
				<th>additionnal info SKU</th>					
				</tr>
				<?php 
				$messages = $ret->Message->ProcessingReport->Result;
				foreach($messages as $k=> $v){?>
				<tr>
				<td><?php echo $v->MessageID; ?></td>	
				<td><?php echo $v->ResultCode; ?></td>	
				<td><?php echo $v->ResultMessageCode; ?></td>	
				<td><?php echo $v->ResultDescription; ?></td>	
				<td><?php echo $v->AdditionalInfo->SKU; ?></td>					
				</tr>
				<?php } ?>
			</table>
		
		</div>
	</div>	




<?php
//echo '<pre>' ; print_r($ret); echo '</pre>';

/**
  * Get Feed Submission Result Action Sample
  * retrieves the feed processing report
  *   
  * @param MarketplaceWebService_Interface $service instance of MarketplaceWebService_Interface
  * @param mixed $request MarketplaceWebService_Model_GetFeedSubmissionResult or array of parameters
  */
  function invokeGetFeedSubmissionResult(MarketplaceWebService_Interface $service, $request) 
  {
      try {
              $response = $service->getFeedSubmissionResult($request);

//echo "<pre>"; print_r($response);echo "</pre>";echo "<hr>";
              
//                echo ("Service Response\n");
 //               echo ("=============================================================================\n");

//                echo("        GetFeedSubmissionResultResponse\n");
                if ($response->isSetGetFeedSubmissionResultResult()) {
                  $getFeedSubmissionResultResult = $response->getGetFeedSubmissionResultResult(); 
//                  echo ("            GetFeedSubmissionResult");
                  
                  if ($getFeedSubmissionResultResult->isSetContentMd5()) {
//                    echo ("                ContentMd5");
//                    echo ("                " . $getFeedSubmissionResultResult->getContentMd5() . "\n");
                  }
                }
                if ($response->isSetResponseMetadata()) { 
//                    echo("            ResponseMetadata\n");
                    $responseMetadata = $response->getResponseMetadata();
                    if ($responseMetadata->isSetRequestId()) 
                    {
//                        echo("                RequestId\n");
//                        echo("                    " . $responseMetadata->getRequestId() . "\n");
                    }
                } 

 //               echo("ResponseHeaderMetadata: " . $response->getResponseHeaderMetadata() . "\n");
     } catch (MarketplaceWebService_Exception $ex) {
         echo("Caught Exception: " . $ex->getMessage() . "\n");
         echo("Response Status Code: " . $ex->getStatusCode() . "\n");
         echo("Error Code: " . $ex->getErrorCode() . "\n");
         echo("Error Type: " . $ex->getErrorType() . "\n");
         echo("Request ID: " . $ex->getRequestId() . "\n");
         echo("XML: " . $ex->getXML() . "\n");
         echo("ResponseHeaderMetadata: " . $ex->getResponseHeaderMetadata() . "\n");
     }
 }
?>
          </div>
</html>                     
