<?php
 set_time_limit (0);

if (!class_exists('DateTime')) {
class DateTime {
    public $date;
   
    public function __construct($date) {
        $this->date = strtotime($date);
    }
   
    public function setTimeZone($timezone) {
        return;
    }
   
    private function __getDate() {
        return date(DATE_ATOM, $this->date);   
    }
   
    public function modify($multiplier) {
        $this->date = strtotime($this->__getDate() . ' ' . $multiplier);
    }
   
    public function format($format) {
        return date($format, $this->date);
    }
}
}

/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2009 Amazon Technologies, Inc.
 *  @link        http://aws.amazon.com
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2009-01-01
 */
/******************************************************************************* 

 *  Marketplace Web Service PHP5 Library
 *  Generated: Thu May 07 13:07:36 PDT 2009
 * 
 */

/**
 * Submit Feed  Sample
 */

require('import_top_special.php');
include_once ('.config.inc.php'); 

/************************************************************************
* Uncomment to configure the client instance. Configuration settings
* are:
*
* - MWS endpoint URL
* - Proxy host and port.
* - MaxErrorRetry.
***********************************************************************/
// IMPORTANT: Uncomment the approiate line for the country you wish to
// sell in:
// United States:
//$serviceUrl = "https://mws.amazonservices.com";
// United Kingdom
//$serviceUrl = "https://mws.amazonservices.co.uk";
// Germany
//$serviceUrl = "https://mws.amazonservices.de";
// France
$serviceUrl = "https://mws.amazonservices.fr";
// Italy
//$serviceUrl = "https://mws.amazonservices.it";
// Japan
//$serviceUrl = "https://mws.amazonservices.jp";
// China
//$serviceUrl = "https://mws.amazonservices.com.cn";
// Canada
//$serviceUrl = "https://mws.amazonservices.ca";
// India
//$serviceUrl = "https://mws.amazonservices.in";

$config = array (
  'ServiceURL' => $serviceUrl,
  'ProxyHost' => null,
  'ProxyPort' => -1,
  'MaxErrorRetry' => 3,
);

/************************************************************************
 * Instantiate Implementation of MarketplaceWebService
 * 
 * AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY constants 
 * are defined in the .config.inc.php located in the same 
 * directory as this sample
 ***********************************************************************/
 $service = new MarketplaceWebService_Client(
     AWS_ACCESS_KEY_ID, 
     AWS_SECRET_ACCESS_KEY, 
     $config,
     APPLICATION_NAME,
     APPLICATION_VERSION);
 
/************************************************************************
 * Uncomment to try out Mock Service that simulates MarketplaceWebService
 * responses without calling MarketplaceWebService service.
 *
 * Responses are loaded from local XML files. You can tweak XML files to
 * experiment with various outputs during development
 *
 * XML files available under MarketplaceWebService/Mock tree
 *
 ***********************************************************************/
 // $service = new MarketplaceWebService_Mock();

/************************************************************************
 * Setup request parameters and uncomment invoke to try out 
 * sample for Submit Feed Action
 ***********************************************************************/
 // @TODO: set request. Action can be passed as MarketplaceWebService_Model_SubmitFeedRequest
 // object or array of parameters

// Note that PHP memory streams have a default limit of 2M before switching to disk. While you
// can set the limit higher to accomidate your feed in memory, it's recommended that you store
// your feed on disk and use traditional file streams to submit your feeds. For conciseness, this
// examples uses a memory stream.




/**************************************************************** traitement produits ******************************************************/

//  Header( 'Content-Type: text/xml' ); 
  define ('DISPLAY_PRICE_WITH_TAX', true);

  define ('DEFAULT_CURRENCY','EUR');


 // require('../../includes/application_top.php');

$string='';
$info_string = '<table border="1" width="100%" cellspacing="0" cellpadding="2" style="	font-family: Arial, Helvetica, sans-serif;font-size:10px;">';
  // On vrifie la langue utilise dans le catalogue
  $language_code = (isset($HTTP_GET_VARS['language']) && tep_not_null($HTTP_GET_VARS['language'])) ? $HTTP_GET_VARS['language'] : DEFAULT_LANGUAGE;

// langue Francais
$languages_id=1;

  // Requte pour identifier les catgories existantes dans le catalogue
  $included_categories_query = tep_db_query("SELECT c.categories_id, c.parent_id, cd.categories_name FROM " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd 

WHERE 

c.categories_id = cd.categories_id 

AND cd.language_id = FLOOR($languages_id)

");

  $inc_cat = array();

  // Identification du nom de la catgorie, et l'id de la catgorie parent
  while ($included_categories = tep_db_fetch_array($included_categories_query)) {
  $inc_cat[] = array (
     'id' => $included_categories['categories_id'],
     'parent' => $included_categories['parent_id'],
     'name' => $included_categories['categories_name']);
  }

  $cat_info = array();
  for ($i=0; $i < sizeof($inc_cat); $i++)
    $cat_info[$inc_cat[$i]['id']] = array (
    'parent'=> $inc_cat[$i]['parent'],
    'name'  => $inc_cat[$i]['name'],
    'path'  => $inc_cat[$i]['id'],
    'link'  => '' );

  for ($i=0; $i < sizeof($inc_cat); $i++) {
  $cat_id = $inc_cat[$i]['id'];
  while ($cat_info[$cat_id]['parent'] != 0){
    $cat_info[$inc_cat[$i]['id']]['path'] = $cat_info[$cat_id]['parent'] . '_' . $cat_info[$inc_cat[$i]['id']]['path'];
    $cat_id = $cat_info[$cat_id]['parent'];
    }
  $link_array = split('_', $cat_info[$inc_cat[$i]['id']] ['path']);
  for ($j=0; $j < sizeof($link_array); $j++) {
    $cat_info[$inc_cat[$i]['id']]['link'] .= '&nbsp;<a href="' . tep_href_link(FILENAME_DEFAULT, 'cPath=' . $cat_info[$link_array[$j]]['path']) . '"><nobr>' . $cat_info[$link_array[$j]]['name'] . '</nobr></a>&nbsp;&raquo;&nbsp;';
    }
  }

  // Requte identifiant les produits disponibles dans le catalogue


//AND pc.categories_id <> '505830'
//AND pc.categories_id <> '707860'
//AND pc.categories_id <> '505840'

// AND p.products_id = '3831' ;
/*
   AND( 
      pc.categories_id = 274
   OR pc.categories_id = 292
   OR pc.categories_id = 273  
)
*/
  $products_query = tep_db_query("SELECT p.*, pd.products_name, pd.products_description,pd.products_mp_short_infos, pc.categories_id, pcat.categorie_id_amazon_fr ,pcatdesc.categories_name  FROM " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_PRODUCTS_TO_CATEGORIES . " pc , " . TABLE_CATEGORIES . " pcat , " . TABLE_CATEGORIES_DESCRIPTION . " pcatdesc 


WHERE 
p.products_id = pd.products_id 

AND p.products_id = pc.products_id 
AND pc.categories_id = pcat.categories_id
AND pc.categories_id = pcatdesc.categories_id
AND pcatdesc.language_id  = FLOOR($languages_id)

   AND( 
      pc.categories_id = 274
   OR pc.categories_id = 292
   OR pc.categories_id = 273
   OR pc.categories_id = 279
   OR pc.categories_id = 283 
   OR pc.categories_id = 275   
   OR pc.categories_id = 277 
   OR pc.categories_id = 280   
   OR pc.categories_id = 281   
  
   OR pc.categories_id = 287 
   OR pc.categories_id = 298 
   OR pc.categories_id = 300 
   OR pc.categories_id = 399 
   OR pc.categories_id = 293 
   OR pc.categories_id = 295 
   OR pc.categories_id = 284 
   OR pc.categories_id = 294 
   OR pc.categories_id = 296 
   OR pc.categories_id = 301

   OR pc.categories_id = 307
   OR pc.categories_id = 305
   OR pc.categories_id = 298
   OR pc.categories_id = 285  
   OR pc.categories_id = 308  
   OR pc.categories_id = 309 
   OR pc.categories_id = 311
   OR pc.categories_id = 329    
)

AND pcat.categorie_id_amazon_fr <> ''

AND pd.language_id = FLOOR($languages_id) 

ORDER BY pc.categories_id, pd.products_name");

  $product_num = 0;
  $liste_produits='';

  while($products = tep_db_fetch_array($products_query)) {

  if (intval($products['manufacturers_id']) > 0) {
  	$manufacturers_query = tep_db_query("SELECT manufacturers_name FROM " . TABLE_MANUFACTURERS_INFO . " WHERE manufacturers_id = " . $products['manufacturers_id'] ." and languages_id = ".FLOOR($languages_id));
  	$manufacturers_result = tep_db_fetch_array($manufacturers_query);
  	$products['manufacturers_name'] = $manufacturers_result['manufacturers_name'];
 }

  $special_query = tep_db_query("SELECT specials_new_products_price  FROM " . TABLE_SPECIALS . " WHERE products_id = " . $products['products_id'] ." AND status = 1 ");
  if ($special_result = tep_db_fetch_array($special_query))
  	$products['products_price'] = $special_result['specials_new_products_price'];

$prixprod =tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']));
$description = substr(strip_tags(str_replace(array('<BR>','<br>','<br />'), "</P>\n<P>",html_entity_decode($products['products_description']))),0,2000);
$nom_produit = ($products['products_name']);

//$prix_marketplace =  round(tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']))*1.25,2);

// ecotaxe

$ecotax_rates_id = verif_ecotax($products['ecotax_rates_id']);
$valeur_ecotaxe = round(tep_get_ecotax_price_value($ecotax_rates_id)*(1+(tep_get_tax_rate($products['products_tax_class_id'])/100)),2);

$prix_marketplace = round((($products['products_price']) * (1+(tep_get_tax_rate($products['products_tax_class_id'])/100))) *1,2);
$prix_marketplace = $prix_marketplace + $valeur_ecotaxe;

$prix_marketplace = number_format($prix_marketplace, 2, '.', '');
$valeur_ecotaxe = number_format($valeur_ecotaxe, 2, '.', '');

$exter_product_type="EAN";
$SKU_item = $products['products_ean'];
if ( $products['products_asin_amazon_fr'] != "") { $exter_product_type="ASIN"; $SKU_item = $products['products_asin_amazon_fr']; }

if ( $products['products_pvapf'] != 0) { $prix_marketplace = $products['products_pvapf']; }


$qty = $products['products_quantity'];

$produit_a_traiter = 0 ;
$delais_traitement_commande = 4;  // 4 jours

  $update_or_delete="Update";
  
  
  if (($products['goto_amazon'] == 0) && ($products['products_in_amazon_fr'] = '')) $produit_a_traiter = 0 ;
  
if ($products['goto_amazon'] == 0) 
					{ $qty =0;
					$update_or_delete="Delete";
					}

if ($qty <= 0 ) { 
					$qty =0;
					$update_or_delete="Delete";
				}




 if  (( strlen($products['products_ean']) == 13 )&& ( $products['categorie_id_amazon_fr'] <> 0 )) $produit_a_traiter = 1 ; else $produit_a_traiter = 0;
 if  (( $exter_product_type == "ASIN" )&& ( $products['categorie_id_amazon_fr'] <> 0 )) $produit_a_traiter = 1 ; 

 if ($produit_a_traiter == 1) 
{
//////////////////////////////

  $product_num++;

  $info_string.= 	
					"<tr><td width=50>". 
					"<font color=red>". 
					"" . $products['products_id'] . 
					"</font>". 
					"</td><td width=130>". 
					"ean : " . $products['products_ean'] .
					"</td><td width=70>".  
					"<font color=red><b>". 
					"" . $prix_marketplace . 	"</b></font>  | q : ".  $qty .
					"<br>ecotaxe : " .  $valeur_ecotaxe .
					"</td><td width=100>". 
					"<font color=red><b>". 
					"node : " . $products['categorie_id_amazon_fr'] . 
					"</b></font>". 
					"</td><td>". 
					"" . $description . 
					"</td>".
					"<td width=200>". 
					"cat CB: " . $products['categories_id'] . "<font color=red><b>  " . $products['categories_name'] . "<font color=red><b>".
					"</td></tr>";

  $string.= '<offer>';
  $string.= '<product_reference type="Ean"><![CDATA['. $products['products_ean'] .']]></product_reference>';
  $string.= '<offer_reference type="SellerSku"><![CDATA['. $products['products_id'] .']]></offer_reference>';
  $string.= '<price><![CDATA['. $prix_marketplace .']]></price>';
  $string.= '<product_state>11</product_state>';
  $string.= '<quantity><![CDATA['.$qty.']]></quantity>';
  $string.= '<description><![CDATA['. substr(strip_tags(str_replace(array('<BR>','<br>','<br />'), "</P>\n<P>",html_entity_decode($products['products_description']))),0,250) .'.]]></description>';
  $string.= '<internal_comment></internal_comment>';
  $string.= '<showcase><![CDATA[100]]></showcase>';



/************************************** frais de transport **************************************/
/************************************** pour les market place ***********************************/



		$prix_transport = (5.4347  + (floatval($products['products_weight']) * 3));
	//	echo round($prix_transport,2) ;


if ( $products['products_image_med'] == '' )
{ $image =  HTTP_SERVER . DIR_WS_HTTP_CATALOG . DIR_WS_IMAGES . $products['products_image'] ; }
else
{ $image =  HTTP_SERVER . DIR_WS_HTTP_CATALOG . DIR_WS_IMAGES . $products['products_image_med'] ; }
				/*	
				Type de produit
				feed_product_type
				_________________
					AVFurniture		Meuble AV
					AccessoryOrPartOrSupply		Accessoire ou une partie ou d'approvisionnement
					AudioOrVideo		Audio ou vido
					Battery		batterie
					Binocular	binoculaire
					CableOrAdapter	Cble ou un adaptateur
					Camcorder	camscope
					CameraFlash	Flash de l'appareil photo
					CameraLenses	Objectifs
					CameraOtherAccessories	Camra Autres accessoires
					CameraPowerSupply	Camra Alimentation
					CarElectronics	Electronique de voiture
					ConsumerElectronics	Consumer Electronics
					DigitalCamera	Appareil Photo Numrique
					DigitalPictureFrame	Cadre photo numrique
					FilmCamera	Film Camera
					GpsOrNavigationSystem	GPS ou systme de navigation
					Headphones	couteurs
					Phone	tlphone
					PhoneAccessory	accessoire de tlphone
					PhotographicStudioItems	StudioItems photographiques
					PortableAvDevice	Av. Portable Device
					PowerSuppliesOrProtection	Alimentations ou de protection
					Radio	radio
					RemoteControl	tlcommande
					Speakers	Haut-parleurs
					Telescope	tlescope
					Television	tlvision
					VideoProjector	Video Projecteur
					camerabagsandcases	sacs pour appareils photo et les cas

				*/



if ($products['categories_id'] == 292 ) $productType= "AudioOrVideo"; // 
if ($products['categories_id'] == 274 ) $productType= "DigitalCamera"; // 
if ($products['categories_id'] == 273 ) $productType= "DigitalCamera"; // 
if ($products['categories_id'] == 279 ) $productType= "DigitalCamera"; // 
if ($products['categories_id'] == 283 ) $productType= "CameraFlash"; // 
if ($products['categories_id'] == 275 ) $productType= "Television"; // 
if ($products['categories_id'] == 277 ) $productType= "AudioOrVideo"; // 
if ($products['categories_id'] == 278 ) $productType= "AudioOrVideo"; // 
if ($products['categories_id'] == 280 ) $productType= "DigitalCamera"; // 
if ($products['categories_id'] == 281 ) $productType= "CameraOtherAccessories"; // 

if ($products['categories_id'] == 287 ) $productType= "Battery"; // 
if ($products['categories_id'] == 298 ) $productType= "CameraOtherAccessories"; // 
if ($products['categories_id'] == 299 ) $productType= "CameraOtherAccessories"; // 
if ($products['categories_id'] == 300 ) $productType= "CameraOtherAccessories"; // 
if ($products['categories_id'] == 293 ) $productType= "Binocular"; // 
if ($products['categories_id'] == 295 ) $productType= "CameraOtherAccessories"; // 
if ($products['categories_id'] == 284 ) $productType= "camerabagsandcases"; // 
if ($products['categories_id'] == 294 ) $productType= "CameraOtherAccessories"; // 
if ($products['categories_id'] == 296 ) $productType= "CameraOtherAccessories"; // 
if ($products['categories_id'] == 301 ) $productType= "DigitalCamera"; // 
if ($products['categories_id'] == 305 ) $productType= "CameraFlash"; // 
if ($products['categories_id'] == 307 ) $productType= "RemoteControl"; // 
if ($products['categories_id'] == 298 ) $productType= "CameraOtherAccessories"; // 
if ($products['categories_id'] == 310 ) $productType= "CameraOtherAccessories"; // 
if ($products['categories_id'] == 308 ) $productType= "AudioOrVideo"; // 
if ($products['categories_id'] == 309 ) $productType= "CameraOtherAccessories"; // 
if ($products['categories_id'] == 311 ) $productType= "CameraOtherAccessories"; // 

if ($products['categories_id'] == 329 ) $productType= "PhoneAccessory"; // 

/************************************** frais de transport FIN ***********************************/
  
  $condition_note = "*** ENVOI SOUS 24-48 H EN SUIVI *** EMBALLAGE PROFESSIONNEL SOIGNE *** SAV ASSURE";
  if (!empty($products['products_mp_short_infos'])) $condition_note = filter_text($products['products_mp_short_infos']);
  if (empty($products['manufacturers_name'])) $products['manufacturers_name'] = "NA";
	
/********************************************************  produits ********************************************************************/

$item_sku = $products['products_id'];
$external_product_id = $SKU_item;;
$external_product_id_type = $exter_product_type;
$item_name = filter_text($nom_produit);
$brand_name = filter_text($products['manufacturers_name']);
$manufacturer = filter_text($products['manufacturers_name']);
$product_description = filter_text($description);
$feed_product_type = $productType;
$part_number = '';
$model = filter_text($products['products_model']);
$update_delete = $update_or_delete;
$standard_price = $prix_marketplace;
$currency = 'EUR';
$quantity = $qty;
$condition_type = 'New';
$condition_note = $condition_note;
$max_order_quantity = '';
$fulfillment_latency = $delais_traitement_commande;
$sale_price = '';
$sale_from_date = '';
$sale_end_date = '';
$number_of_items = '';
$max_aggregate_ship_quantity = '';
$offering_can_be_gift_messaged = '';
$offering_can_be_giftwrapped = '';
$product_site_launch_date = '';
$merchant_release_date = '';
$restock_date = '';
$is_discontinued_by_manufacturer = '';
$missing_keyset_reason = '';
$weee_tax_value = $valeur_ecotaxe;
$weee_tax_value_unit_of_measure = 'EUR';
$item_height = '';
$item_length = '';
$item_width = '';
$item_dimensions_unit_of_measure = '';
$item_weight = $products['products_weight'];
$item_weight_unit_of_measure = 'KG';
$item_display_length = '';
$item_display_length_unit_of_measure = '';
$website_shipping_weight = '';
$website_shipping_weight_unit_of_measure = '';
$bullet_point1 = '';
$bullet_point2 = '';
$bullet_point3 = '';
$bullet_point4 = '';
$bullet_point5 = '';
$recommended_browse_nodes = $products['categorie_id_amazon_fr'];
$generic_keywords1 = '';
$generic_keywords2 = '';
$generic_keywords3 = '';
$generic_keywords4 = '';
$generic_keywords5 = '';
$platinum_keywords1 = '';
$platinum_keywords2 = '';
$platinum_keywords3 = '';
$platinum_keywords4 = '';
$platinum_keywords5 = '';
$main_image_url = $image;
$other_image_url1 = '';
$other_image_url2 = '';
$other_image_url3 = '';
$other_image_url4 = '';
$other_image_url5 = '';
$other_image_url6 = '';
$other_image_url7 = '';
$other_image_url8 = '';
$fulfillment_center_id = '';
$package_height = '';
$package_width = '';
$package_length = '';
$package_dimensions_unit_of_measure = '';
$package_weight = '';
$package_weight_unit_of_measure = '';
$parent_child = '';
$parent_sku = '';
$relationship_type = '';
$variation_theme = '';
$country_of_origin = '';
$eu_toys_safety_directive_age_warning = '';
$eu_toys_safety_directive_warning = '';
$eu_toys_safety_directive_language = '';
$legal_disclaimer_description = '';
$safety_warning = '';
$included_components = '';
$seller_warranty_description = '';
$special_features1 = '';
$special_features2 = '';
$special_features3 = '';
$special_features4 = '';
$special_features5 = '';
$color_name = '';
$color_map = '';
$size_name = '';
$material_composition = '';
$form_factor = '';
$finish_type = '';
$water_resistance_level = '';
$maximum_weight_capacity = '';
$maximum_weight_capacity_unit_of_measure = '';
$software_included = '';
$minimum_system_requirement_description = '';
$compatible_devices = '';
$remote_control_description = '';
$compatible_mountings = '';
$cable_length = '';
$cable_length_unit_of_measure = '';
$connector_gender1 = '';
$connector_gender2 = '';
$connector_gender3 = '';
$coating_description = '';
$core_material_type = '';
$total_power_outlets = '';
$package_content_type = '';
$digital_zoom = '';
$camera_film_speed = '';
$camera_flash = '';
$flash_dedication = '';
$guide_number = '';
$focal_length_description = '';
$image_stabilization = '';
$viewfinder_type = '';
$photo_lens_thread_size = '';
$photo_lens_thread_size_unit_of_measure = '';
$lens_fixed_focal_length = '';
$photo_filter_effect_type = '';
$photo_filter_mount_type = '';
$photo_filter_bayonet_size = '';
$photo_filter_drop_in_size = '';
$photo_filter_thread_size = '';
$photo_filter_thread_size_unit_of_measure = '';
$gps_navigation = '';
$annual_energy_consumption = '';
$annual_energy_consumption_unit_of_measure = '';
$specification_met1 = '';
$specification_met2 = '';
$specification_met3 = '';
$specification_met4 = '';
$specification_met5 = '';
$maximum_surge_rating = '';
$maximum_surge_rating_unit_of_measure = '';
$power_source_type = '';
$voltage = '';
$specific_absorption_rate = '';
$specific_absorption_rate_unit_of_measure = '';
$power_plug_type = '';
$battery_average_life = '';
$battery_average_life_unit_of_measure = '';
$battery_power = '';
$battery_cell_composition = '';
$battery_type1 = '';
$battery_type2 = '';
$battery_type3 = '';
$lithium_battery_energy_content = '';
$lithium_battery_packaging = '';
$lithium_battery_voltage = '';
$battery_average_life_recharge = '';
$number_of_batteries = '';
$are_batteries_included = '';
$display_size = '';
$display_size_unit_of_measure = '';
$_3d_technology = '';
$refresh_rate_base = '';
$refresh_rate_unit_of_measure = '';
$connectivity_technology = '';
$total_dvi_ports = '';
$connector_type = '';
$removable_memory = '';
$memory_slots_available = '';
$material_type = '';
$effective_still_resolution = '';
$focus_type = '';
$max_focal_length = '';
$display_type = '';
$display_technology = '';
$display_resolution_maximum = '';
$flash_memory_installed_size = '';
$flash_memory_installed_size_unit_of_measure = '';
$digital_storage_capacity = '';
$digital_storage_capacity_unit_of_measure = '';
$video_output_format = '';
$video_encoding = '';
$media_type_base1 = '';
$media_type_base2 = '';
$media_type_base3 = '';
$media_type_base4 = '';
$media_type_base5 = '';
$human_interface_input1 = '';
$human_interface_input2 = '';
$human_interface_input3 = '';
$human_interface_input4 = '';
$human_interface_input5 = '';
$optical_zoom = '';
$min_shutter_speed = '';
$max_shutter_speed = '';
$continuous_shooting_speed = '';
$flash_modes_description = '';
$hot_shoe_included = '';
$min_focal_length = '';
$min_aperture = '';
$max_aperture = '';
$video_capture_resolution = '';
$wireless_communication_technology1 = '';
$wireless_communication_technology2 = '';
$wireless_communication_technology3 = '';
$wireless_communication_technology4 = '';
$wireless_communication_technology5 = '';
$total_hdmi_ports = '';
$total_s_video_out_ports = '';
$total_firewire_ports = '';
$total_usb_ports = '';
$supported_internet_services1 = '';
$supported_internet_services2 = '';
$supported_internet_services3 = '';
$supported_internet_services4 = '';
$supported_internet_services5 = '';
$audio_output_mode = '';
$battery_average_life_talk_time = '';
$battery_average_life_talk_time_unit_of_measure = '';
$optical_digital_input = '';
$tuner_technology = '';
$total_subwoofer_outputs = '';
$number_of_radio_bands_supported = '';
$power_consumption = '';
$power_consumption_unit_of_measure = '';
$total_ethernet_ports = '';
$speaker_type = '';
$speaker_connectivity = '';
$impedance = '';
$impedance_unit_of_measure = '';
$speaker_maximum_input_power = '';
$speaker_maximum_input_power_unit_of_measure = '';
$audio_sensitivity = '';
$audio_sensitivity_unit_of_measure = '';
$tweeter_driver_diameter = '';
$tweeter_driver_diameter_unit_of_measure = '';
$tweeter_driver_cone_material_type = '';
$midrange_driver_diameter = '';
$midrange_driver_diameter_unit_of_measure = '';
$midrange_driver_cone_material_type = '';
$woofer_driver_diameter = '';
$woofer_driver_diameter_unit_of_measure = '';
$woofer_driver_cone_material_type = '';
$subwoofer_diameter = '';
$subwoofer_diameter_unit_of_measure = '';
$subwoofer_cone_material_type = '';
$subwoofer_power_description = '';
$subwoofer_amplifier_wattage = '';
$speaker_grille_material_type = '';
$speaker_grille_description = '';
$item_shape = '';
$output_wattage = '';
$wattage = '';
$built_in_decoders1 = '';
$built_in_decoders2 = '';
$built_in_decoders3 = '';
$built_in_decoders4 = '';
$built_in_decoders5 = '';
$parental_control_technology = '';
$amplifier_type = '';
$surround_sound_channel_configuration = '';
$blu_ray_region = '';
$dvd_region = '';
$dvd_type = '';
$eu_energy_label_efficiency_class = '';
$efficiency = '';
$image_brightness = '';
$image_brightness_unit_of_measure = '';
$image_contrast_ratio = '';
$screen_surface_description = '';
$aspect_ratio = '';
$total_vga_in_ports = '';
$total_component_in_ports = '';
$total_coaxial_inputs = '';
$total_s_video_in_ports = '';
$speaker_count = '';
$mounting_type = '';
$exterior_finish = '';
$audio_output_effects = '';
$number_of_recording_loops = '';
$headphones_form_factor = '';
$maximum_aperture_range = '';
$map_type1 = '';
$map_type2 = '';
$map_type3 = '';
$map_type4 = '';
$map_type5 = '';
$traffic_features_description1 = '';
$traffic_features_description2 = '';
$traffic_features_description3 = '';
$traffic_features_description4 = '';
$traffic_features_description5 = '';
$waypoints_type = '';
$operating_system1 = '';
$operating_system2 = '';
$number_of_handsets = '';
$total_composite_ports = '';
$total_preamp_outputs = '';
$total_video_out_ports = '';
$total_microphone_ports = '';


$line = $item_sku . chr(9);
$line.= $external_product_id . chr(9);
$line.= $external_product_id_type . chr(9);
$line.= $item_name . chr(9);
$line.= $brand_name . chr(9);
$line.= $manufacturer . chr(9);
$line.= $product_description . chr(9);
$line.= $feed_product_type . chr(9);
$line.= $part_number . chr(9);
$line.= $model . chr(9);
$line.= $update_delete . chr(9);
$line.= $standard_price . chr(9);
$line.= $currency . chr(9);
$line.= $quantity . chr(9);
$line.= $condition_type . chr(9);
$line.= $condition_note . chr(9);
$line.= $max_order_quantity . chr(9);
$line.= $fulfillment_latency . chr(9);
$line.= $sale_price . chr(9);
$line.= $sale_from_date . chr(9);
$line.= $sale_end_date . chr(9);
$line.= $number_of_items . chr(9);
$line.= $max_aggregate_ship_quantity . chr(9);
$line.= $offering_can_be_gift_messaged . chr(9);
$line.= $offering_can_be_giftwrapped . chr(9);
$line.= $product_site_launch_date . chr(9);
$line.= $merchant_release_date . chr(9);
$line.= $restock_date . chr(9);
$line.= $is_discontinued_by_manufacturer . chr(9);
$line.= $missing_keyset_reason . chr(9);
$line.= $weee_tax_value . chr(9);
$line.= $weee_tax_value_unit_of_measure . chr(9);
$line.= $item_height . chr(9);
$line.= $item_length . chr(9);
$line.= $item_width . chr(9);
$line.= $item_dimensions_unit_of_measure . chr(9);
$line.= $item_weight . chr(9);
$line.= $item_weight_unit_of_measure . chr(9);
$line.= $item_display_length . chr(9);
$line.= $item_display_length_unit_of_measure . chr(9);
$line.= $website_shipping_weight . chr(9);
$line.= $website_shipping_weight_unit_of_measure . chr(9);
$line.= $bullet_point1 . chr(9);
$line.= $bullet_point2 . chr(9);
$line.= $bullet_point3 . chr(9);
$line.= $bullet_point4 . chr(9);
$line.= $bullet_point5 . chr(9);
$line.= $recommended_browse_nodes . chr(9);
$line.= $generic_keywords1 . chr(9);
$line.= $generic_keywords2 . chr(9);
$line.= $generic_keywords3 . chr(9);
$line.= $generic_keywords4 . chr(9);
$line.= $generic_keywords5 . chr(9);
$line.= $platinum_keywords1 . chr(9);
$line.= $platinum_keywords2 . chr(9);
$line.= $platinum_keywords3 . chr(9);
$line.= $platinum_keywords4 . chr(9);
$line.= $platinum_keywords5 . chr(9);
$line.= $main_image_url . chr(9);
$line.= $other_image_url1 . chr(9);
$line.= $other_image_url2 . chr(9);
$line.= $other_image_url3 . chr(9);
$line.= $other_image_url4 . chr(9);
$line.= $other_image_url5 . chr(9);
$line.= $other_image_url6 . chr(9);
$line.= $other_image_url7 . chr(9);
$line.= $other_image_url8 . chr(9);
$line.= $fulfillment_center_id . chr(9);
$line.= $package_height . chr(9);
$line.= $package_width . chr(9);
$line.= $package_length . chr(9);
$line.= $package_dimensions_unit_of_measure . chr(9);
$line.= $package_weight . chr(9);
$line.= $package_weight_unit_of_measure . chr(9);
$line.= $parent_child . chr(9);
$line.= $parent_sku . chr(9);
$line.= $relationship_type . chr(9);
$line.= $variation_theme . chr(9);
$line.= $country_of_origin . chr(9);
$line.= $eu_toys_safety_directive_age_warning . chr(9);
$line.= $eu_toys_safety_directive_warning . chr(9);
$line.= $eu_toys_safety_directive_language . chr(9);
$line.= $legal_disclaimer_description . chr(9);
$line.= $safety_warning . chr(9);
$line.= $included_components . chr(9);
$line.= $seller_warranty_description . chr(9);
$line.= $special_features1 . chr(9);
$line.= $special_features2 . chr(9);
$line.= $special_features3 . chr(9);
$line.= $special_features4 . chr(9);
$line.= $special_features5 . chr(9);
$line.= $color_name . chr(9);
$line.= $color_map . chr(9);
$line.= $size_name . chr(9);
$line.= $material_composition . chr(9);
$line.= $form_factor . chr(9);
$line.= $finish_type . chr(9);
$line.= $water_resistance_level . chr(9);
$line.= $maximum_weight_capacity . chr(9);
$line.= $maximum_weight_capacity_unit_of_measure . chr(9);
$line.= $software_included . chr(9);
$line.= $minimum_system_requirement_description . chr(9);
$line.= $compatible_devices . chr(9);
$line.= $remote_control_description . chr(9);
$line.= $compatible_mountings . chr(9);
$line.= $cable_length . chr(9);
$line.= $cable_length_unit_of_measure . chr(9);
$line.= $connector_gender1 . chr(9);
$line.= $connector_gender2 . chr(9);
$line.= $connector_gender3 . chr(9);
$line.= $coating_description . chr(9);
$line.= $core_material_type . chr(9);
$line.= $total_power_outlets . chr(9);
$line.= $package_content_type . chr(9);
$line.= $digital_zoom . chr(9);
$line.= $camera_film_speed . chr(9);
$line.= $camera_flash . chr(9);
$line.= $flash_dedication . chr(9);
$line.= $guide_number . chr(9);
$line.= $focal_length_description . chr(9);
$line.= $image_stabilization . chr(9);
$line.= $viewfinder_type . chr(9);
$line.= $photo_lens_thread_size . chr(9);
$line.= $photo_lens_thread_size_unit_of_measure . chr(9);
$line.= $lens_fixed_focal_length . chr(9);
$line.= $photo_filter_effect_type . chr(9);
$line.= $photo_filter_mount_type . chr(9);
$line.= $photo_filter_bayonet_size . chr(9);
$line.= $photo_filter_drop_in_size . chr(9);
$line.= $photo_filter_thread_size . chr(9);
$line.= $photo_filter_thread_size_unit_of_measure . chr(9);
$line.= $gps_navigation . chr(9);
$line.= $annual_energy_consumption . chr(9);
$line.= $annual_energy_consumption_unit_of_measure . chr(9);
$line.= $specification_met1 . chr(9);
$line.= $specification_met2 . chr(9);
$line.= $specification_met3 . chr(9);
$line.= $specification_met4 . chr(9);
$line.= $specification_met5 . chr(9);
$line.= $maximum_surge_rating . chr(9);
$line.= $maximum_surge_rating_unit_of_measure . chr(9);
$line.= $power_source_type . chr(9);
$line.= $voltage . chr(9);
$line.= $specific_absorption_rate . chr(9);
$line.= $specific_absorption_rate_unit_of_measure . chr(9);
$line.= $power_plug_type . chr(9);
$line.= $battery_average_life . chr(9);
$line.= $battery_average_life_unit_of_measure . chr(9);
$line.= $battery_power . chr(9);
$line.= $battery_cell_composition . chr(9);
$line.= $battery_type1 . chr(9);
$line.= $battery_type2 . chr(9);
$line.= $battery_type3 . chr(9);
$line.= $lithium_battery_energy_content . chr(9);
$line.= $lithium_battery_packaging . chr(9);
$line.= $lithium_battery_voltage . chr(9);
$line.= $battery_average_life_recharge . chr(9);
$line.= $number_of_batteries . chr(9);
$line.= $are_batteries_included . chr(9);
$line.= $display_size . chr(9);
$line.= $display_size_unit_of_measure . chr(9);
$line.= $_3d_technology . chr(9);
$line.= $refresh_rate_base . chr(9);
$line.= $refresh_rate_unit_of_measure . chr(9);
$line.= $connectivity_technology . chr(9);
$line.= $total_dvi_ports . chr(9);
$line.= $connector_type . chr(9);
$line.= $removable_memory . chr(9);
$line.= $memory_slots_available . chr(9);
$line.= $material_type . chr(9);
$line.= $effective_still_resolution . chr(9);
$line.= $focus_type . chr(9);
$line.= $max_focal_length . chr(9);
$line.= $display_type . chr(9);
$line.= $display_technology . chr(9);
$line.= $display_resolution_maximum . chr(9);
$line.= $flash_memory_installed_size . chr(9);
$line.= $flash_memory_installed_size_unit_of_measure . chr(9);
$line.= $digital_storage_capacity . chr(9);
$line.= $digital_storage_capacity_unit_of_measure . chr(9);
$line.= $video_output_format . chr(9);
$line.= $video_encoding . chr(9);
$line.= $media_type_base1 . chr(9);
$line.= $media_type_base2 . chr(9);
$line.= $media_type_base3 . chr(9);
$line.= $media_type_base4 . chr(9);
$line.= $media_type_base5 . chr(9);
$line.= $human_interface_input1 . chr(9);
$line.= $human_interface_input2 . chr(9);
$line.= $human_interface_input3 . chr(9);
$line.= $human_interface_input4 . chr(9);
$line.= $human_interface_input5 . chr(9);
$line.= $optical_zoom . chr(9);
$line.= $min_shutter_speed . chr(9);
$line.= $max_shutter_speed . chr(9);
$line.= $continuous_shooting_speed . chr(9);
$line.= $flash_modes_description . chr(9);
$line.= $hot_shoe_included . chr(9);
$line.= $min_focal_length . chr(9);
$line.= $min_aperture . chr(9);
$line.= $max_aperture . chr(9);
$line.= $video_capture_resolution . chr(9);
$line.= $wireless_communication_technology1 . chr(9);
$line.= $wireless_communication_technology2 . chr(9);
$line.= $wireless_communication_technology3 . chr(9);
$line.= $wireless_communication_technology4 . chr(9);
$line.= $wireless_communication_technology5 . chr(9);
$line.= $total_hdmi_ports . chr(9);
$line.= $total_s_video_out_ports . chr(9);
$line.= $total_firewire_ports . chr(9);
$line.= $total_usb_ports . chr(9);
$line.= $supported_internet_services1 . chr(9);
$line.= $supported_internet_services2 . chr(9);
$line.= $supported_internet_services3 . chr(9);
$line.= $supported_internet_services4 . chr(9);
$line.= $supported_internet_services5 . chr(9);
$line.= $audio_output_mode . chr(9);
$line.= $battery_average_life_talk_time . chr(9);
$line.= $battery_average_life_talk_time_unit_of_measure . chr(9);
$line.= $optical_digital_input . chr(9);
$line.= $tuner_technology . chr(9);
$line.= $total_subwoofer_outputs . chr(9);
$line.= $number_of_radio_bands_supported . chr(9);
$line.= $power_consumption . chr(9);
$line.= $power_consumption_unit_of_measure . chr(9);
$line.= $total_ethernet_ports . chr(9);
$line.= $speaker_type . chr(9);
$line.= $speaker_connectivity . chr(9);
$line.= $impedance . chr(9);
$line.= $impedance_unit_of_measure . chr(9);
$line.= $speaker_maximum_input_power . chr(9);
$line.= $speaker_maximum_input_power_unit_of_measure . chr(9);
$line.= $audio_sensitivity . chr(9);
$line.= $audio_sensitivity_unit_of_measure . chr(9);
$line.= $tweeter_driver_diameter . chr(9);
$line.= $tweeter_driver_diameter_unit_of_measure . chr(9);
$line.= $tweeter_driver_cone_material_type . chr(9);
$line.= $midrange_driver_diameter . chr(9);
$line.= $midrange_driver_diameter_unit_of_measure . chr(9);
$line.= $midrange_driver_cone_material_type . chr(9);
$line.= $woofer_driver_diameter . chr(9);
$line.= $woofer_driver_diameter_unit_of_measure . chr(9);
$line.= $woofer_driver_cone_material_type . chr(9);
$line.= $subwoofer_diameter . chr(9);
$line.= $subwoofer_diameter_unit_of_measure . chr(9);
$line.= $subwoofer_cone_material_type . chr(9);
$line.= $subwoofer_power_description . chr(9);
$line.= $subwoofer_amplifier_wattage . chr(9);
$line.= $speaker_grille_material_type . chr(9);
$line.= $speaker_grille_description . chr(9);
$line.= $item_shape . chr(9);
$line.= $output_wattage . chr(9);
$line.= $wattage . chr(9);
$line.= $built_in_decoders1 . chr(9);
$line.= $built_in_decoders2 . chr(9);
$line.= $built_in_decoders3 . chr(9);
$line.= $built_in_decoders4 . chr(9);
$line.= $built_in_decoders5 . chr(9);
$line.= $parental_control_technology . chr(9);
$line.= $amplifier_type . chr(9);
$line.= $surround_sound_channel_configuration . chr(9);
$line.= $blu_ray_region . chr(9);
$line.= $dvd_region . chr(9);
$line.= $dvd_type . chr(9);
$line.= $eu_energy_label_efficiency_class . chr(9);
$line.= $efficiency . chr(9);
$line.= $image_brightness . chr(9);
$line.= $image_brightness_unit_of_measure . chr(9);
$line.= $image_contrast_ratio . chr(9);
$line.= $screen_surface_description . chr(9);
$line.= $aspect_ratio . chr(9);
$line.= $total_vga_in_ports . chr(9);
$line.= $total_component_in_ports . chr(9);
$line.= $total_coaxial_inputs . chr(9);
$line.= $total_s_video_in_ports . chr(9);
$line.= $speaker_count . chr(9);
$line.= $mounting_type . chr(9);
$line.= $exterior_finish . chr(9);
$line.= $audio_output_effects . chr(9);
$line.= $number_of_recording_loops . chr(9);
$line.= $headphones_form_factor . chr(9);
$line.= $maximum_aperture_range . chr(9);
$line.= $map_type1 . chr(9);
$line.= $map_type2 . chr(9);
$line.= $map_type3 . chr(9);
$line.= $map_type4 . chr(9);
$line.= $map_type5 . chr(9);
$line.= $traffic_features_description1 . chr(9);
$line.= $traffic_features_description2 . chr(9);
$line.= $traffic_features_description3 . chr(9);
$line.= $traffic_features_description4 . chr(9);
$line.= $traffic_features_description5 . chr(9);
$line.= $waypoints_type . chr(9);
$line.= $operating_system1 . chr(9);
$line.= $operating_system2 . chr(9);
$line.= $number_of_handsets . chr(9);
$line.= $total_composite_ports . chr(9);
$line.= $total_preamp_outputs . chr(9);
$line.= $total_video_out_ports . chr(9);
$line.= $total_microphone_ports . chr(9);
$line.= chr(13);

$liste_produits .= $line;



/********************************************************  produits ********************************************************************/


////////////////produits suprieur  15 euro ///////////////
}// fin if is ( tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id'])) >= 15 ) {
//////////////////////////////
  }
$info_string.='</table>';
echo $info_string;
/******************************************************** Fin traitement de produits ********************************************************************/




$feed = "";

$feed = <<<EOD
TemplateType=ConsumerElectronics	Version=2014.0305	Les 3 lignes suprieures sont rserves  Amazon.com. Ne pas modifier ou supprimer les 3 lignes suprieures.									Informations sur l'offre - Informations sur l'offre : ces attributs sont requis pour que votre article puisse tre achet par les clients sur le site.																					Dimensions - Dimensions du produit : ces attributs spcifient la taille et le poids d'un produit.										Dcouverte d'article - Informations de dcouverte d'article : ces attributs ont un effet sur la manire dont les clients peuvent trouver votre produit sur le site  l'aide du navigateur ou de la fonction de recherche.																Image - Informations d'image : voir l'onglet Instructions sur l'image pour plus de dtails.									Expdition - Ces colonnes sont destines  toute information concernant lexpdition de commandes traites par Expdi par Amazon ou par le vendeur.							Variation - Informations de variation : diffusez ces attributs si votre produit est disponible en diffrents modles (par exemple, couleur ou puissance en watts).				Compliance - Conformit - Informations de conformit : attributs utiliss pour la conformit avec les lois en matire de consommation dans le pays ou la rgion o l'article est vendu						Ces attributs crent des listes de produits bien fournies pour vos acheteurs.																																																																																																																																																																																																																							
SKU	ID du produit	Type d'ID du produit	titre	marque	fabriquant	description	Type de produit	numro de pice	numro du modle	Mettre  jour Supprimer	Prix ??standard	Devise	quantit	Etat de larticle	commentaire sur l'offre	quantit maximale pouvant tre commande	Dlai de traitement	Prix rduit	Date de dbut de la remise	Date de fin de la remise	nombre d'articles	quantit expdiable au maximum	le message cadeau est-il disponible	l'emballage cadeau est-il disponible	date de lancement	date de parution	Date de remise en stock	production stoppe par le fabriquant	Paramtre d'enregistrement	Taxe DEEE pour les produits lectriques ou lectroniques	devise de la taxe deee	hauteur de l'article	longueur de l'article	largeur de l'article	Unit de mesure des dimensions de larticle	poids de l'article	Unit de mesure du poids de larticle	Longueur du produit	Unit de mesure - longueur du produit	poids de l'envoi	Unit de mesure du poids de lexpdition du site internet	puce1	puce2	puce3	puce4	puce5	nud d'arborescence recommand	termes de recherche1	termes de recherche2	termes de recherche3	termes de recherche4	termes de recherche5	mots clefs platinum1	mots clefs platinum2	mots clefs platinum3	mots clefs platinum4	mots clefs platinum5	URL de l'image principale	URL d'une autre image1	URL d'une autre image2	URL d'une autre image3	URL d'une autre image4	URL d'une autre image5	URL d'une autre image6	URL d'une autre image7	URL d'une autre image8	ID du centre de distribution	hauteur du colis	largeur du colis	longueur du colis	Unit de mesure des dimensions du paquet	poids du colis	Unit de mesure du poids du paquet	Parent	SKU Parent	Type de relation	Thme variation	pays d'origine	avertissement sur l'age pour la directive europenne sur la scurit des jouets	avertissement sur la directive europenne sur la scurit des jouets	language de l'avertissement pour la directive europenne sur la scurit des jouets	Toute clause de non-responsabilit obligatoire pour le produit	avertissement de scurit	contenu de la bote	description de la garantie vendeur	fonctionnalits du produit1	fonctionnalits du produit2	fonctionnalits du produit3	fonctionnalits du produit4	fonctionnalits du produit5	couleur	table des couleurs	Taille	matriel composant le produit	facteur de forme	finition	niveau de rsistance  l'eau	capacit de poids maximal	Unit de mesure de la capacit du poids maximal	logiciel de sauvegarde automatique inclus	description des capacits requise minimales pour le systme	appareils compatibles	description de la tlcommande	supports compatibles	unit de mesure de la longueur du cble	Unit de mesure de la longueur du cble	genre du connecteur1	genre du connecteur2	genre du connecteur3	description du placage	conducteur	nombre de sorties	type de contenu du colis	zoom digital	rapidit de la pellicule	flash de l'appareil	dvou au flash	numro du guide	objectif	stabilisateur dimage	type de viseur	taille du connecteur d'objectif	Unit de mesure de la taille du filetage de lobjectif photo	longueur de la focale	type d'effet du filtre photo	type de monture du filtre photo	taille de la baonnette du filtre photo	taille du drop-in du filtre photo	taille du filtage du filtre photo	Unit de mesure de la taille du filetage du filtre photo	fonctionnalit gps de gopositionnement	consommation annuelle nergtique	Unit de mesure de consommation annuelle dnergie	spcifications nergtique remplies1	spcifications nergtique remplies2	spcifications nergtique remplies3	spcifications nergtique remplies4	spcifications nergtique remplies5	brusque pousse de puissance maximum	Unit de mesure du taux daugmentation maximal	source nergtique	voltage	Dbit d'absorption spcifique	L'unit de mesure de Dbit d'absorption spcifique	type de prise lectrique	dure de vie moyenne de la batterie	Unit de mesure de la moyenne de vie de la batterie	alimentation de la batterie	type de pile de la batterie	Batterie de type1	Batterie de type2	Batterie de type3	contenu nergtique de la pile au lithium	emballage de la pile au lithium	voltage de la pile au lithium	nombre de rechargements maximum	nombre de piles	les piles sont elles inclues	unit de mesure de la taille de l'cran	Unit de mesure de la taille de laffichage	technologie 3d	taux de rafraichissement	taux de rafraichissement	technologie de la connectivit	nombre total de ports dvi	entre rgb analogique	mmoire pouvant tre retire	emplacements mmoire disponibles	matriel interne	resolution effective de la capture	type de focus	longueur maximale de la focale	type d'affichage	technologie d'affichage	rsolution maximale de l'affichage	taille de la mmoire flash installe	Unit de mesure de la taille de la mmoire flash installe	capacit digitale de stockage	Unit de mesure de la capacit de stockage digitale	format de sortie video	encodage de la video	type de media1	type de media2	type de media3	type de media4	type de media5	apport humain1	apport humain2	apport humain3	apport humain4	apport humain5	zoom optique	vitesse minimale d'obturation	vitesse maximale d'obturation	vitesse de capture en continu	description des modes du flash	sabut inclut	longueur minimale de la focale	ouverture minimale	ouverture maximale	rsolution de la capture d'cran	technologie sans fil1	technologie sans fil2	technologie sans fil3	technologie sans fil4	technologie sans fil5	nombre total de ports hdmi	nombre total de ports de sortie s-video	nombre total de ports firewire	nombre total de ports usb	application internet1	application internet2	application internet3	application internet4	application internet5	mode de sortie audio	dure de vie moyenne de la batterie en conversation	Unit de mesure de la moyenne de vie de la batterie en conversation	nombre d'entres optique	type de tuner	nombre total de sorties subwoofer	nombre de bandes de radio supportes	consommation nergtique	unit de mesure de la consommation nergtique	nombre total de ports ethernet	type d'enceinte	connectivit des enceintes	unit de mesure de l'impdance	Unit de mesure - rsistance	alimentation maximale pour l'enceinte	Unit de mesure de la puissance maximale dentre de lenceinte	sensibilit auditive	Unit de mesure de la sensibilit Audio	diamtre du haut-parleur aigu	unit de mesure du diamtre du haut-parleur aigu	Matriel haut-parleur medium	diamtre du haut-parleur median	Unit de mesure du diamtre du medium	Matriel tweeter	diamtre du caisson de basses	Unit de mesure du diamtre du woofer	Matriel dans lequel est fabriqu le caisson de basse	unit de mesure du diamtre du caisson de basse	Unit de mesure du diamtre du subwoofer	Matriel dans lequel est fabriqu le  cone du caisson de basse	technologie d'alimentation du caisson de basse	wattage du caisson de basse	matriel dans lequel est fabriqu la grille de l'enceinte	la grille peut elle tre te	forme	wattage en sortie	wattage	dcodeurs intgrs1	dcodeurs intgrs2	dcodeurs intgrs3	dcodeurs intgrs4	dcodeurs intgrs5	technologie de contrle parentale	type d'amplificateur	nombre de canaux audio	region du blu-ray	Dvd Region	type de dvd	Classe d'efficacit Label nergtique UE	mise en veille de l'alimentation	luminosit	Unit de mesure - luminosit	ratio du contraste	finition de l'cran	ratio de l'aspect	nombre d'entres vga	nombre d'entres composants	nombre d'entres coaxiales digitales	nombre d'entres s-video	nombre d'enceintes	type de monture vesa	finition externe	effets spciaux en sortie	nombre total de boucles d'enregistrements	facteur de forme des couteurs	gamme maximale d'ouverture	types de carte1	types de carte2	types de carte3	types de carte4	types de carte5	fonctionnalit trafic1	fonctionnalit trafic2	fonctionnalit trafic3	fonctionnalit trafic4	fonctionnalit trafic5	type de point de repre	Systme dexploitation1	Systme dexploitation2	nombre de combins	nombre d'entres video composites	nombre de sorties preamp	nombre total de ports de sortie	nombre total de sorties microphones
item_sku	external_product_id	external_product_id_type	item_name	brand_name	manufacturer	product_description	feed_product_type	part_number	model	update_delete	standard_price	currency	quantity	condition_type	condition_note	max_order_quantity	fulfillment_latency	sale_price	sale_from_date	sale_end_date	number_of_items	max_aggregate_ship_quantity	offering_can_be_gift_messaged	offering_can_be_giftwrapped	product_site_launch_date	merchant_release_date	restock_date	is_discontinued_by_manufacturer	missing_keyset_reason	weee_tax_value	weee_tax_value_unit_of_measure	item_height	item_length	item_width	item_dimensions_unit_of_measure	item_weight	item_weight_unit_of_measure	item_display_length	item_display_length_unit_of_measure	website_shipping_weight	website_shipping_weight_unit_of_measure	bullet_point1	bullet_point2	bullet_point3	bullet_point4	bullet_point5	recommended_browse_nodes	generic_keywords1	generic_keywords2	generic_keywords3	generic_keywords4	generic_keywords5	platinum_keywords1	platinum_keywords2	platinum_keywords3	platinum_keywords4	platinum_keywords5	main_image_url	other_image_url1	other_image_url2	other_image_url3	other_image_url4	other_image_url5	other_image_url6	other_image_url7	other_image_url8	fulfillment_center_id	package_height	package_width	package_length	package_dimensions_unit_of_measure	package_weight	package_weight_unit_of_measure	parent_child	parent_sku	relationship_type	variation_theme	country_of_origin	eu_toys_safety_directive_age_warning	eu_toys_safety_directive_warning	eu_toys_safety_directive_language	legal_disclaimer_description	safety_warning	included_components	seller_warranty_description	special_features1	special_features2	special_features3	special_features4	special_features5	color_name	color_map	size_name	material_composition	form_factor	finish_type	water_resistance_level	maximum_weight_capacity	maximum_weight_capacity_unit_of_measure	software_included	minimum_system_requirement_description	compatible_devices	remote_control_description	compatible_mountings	cable_length	cable_length_unit_of_measure	connector_gender1	connector_gender2	connector_gender3	coating_description	core_material_type	total_power_outlets	package_content_type	digital_zoom	camera_film_speed	camera_flash	flash_dedication	guide_number	focal_length_description	image_stabilization	viewfinder_type	photo_lens_thread_size	photo_lens_thread_size_unit_of_measure	lens_fixed_focal_length	photo_filter_effect_type	photo_filter_mount_type	photo_filter_bayonet_size	photo_filter_drop_in_size	photo_filter_thread_size	photo_filter_thread_size_unit_of_measure	gps_navigation	annual_energy_consumption	annual_energy_consumption_unit_of_measure	specification_met1	specification_met2	specification_met3	specification_met4	specification_met5	maximum_surge_rating	maximum_surge_rating_unit_of_measure	power_source_type	voltage	specific_absorption_rate	specific_absorption_rate_unit_of_measure	power_plug_type	battery_average_life	battery_average_life_unit_of_measure	battery_power	battery_cell_composition	battery_type1	battery_type2	battery_type3	lithium_battery_energy_content	lithium_battery_packaging	lithium_battery_voltage	battery_average_life_recharge	number_of_batteries	are_batteries_included	display_size	display_size_unit_of_measure	_3d_technology	refresh_rate_base	refresh_rate_unit_of_measure	connectivity_technology	total_dvi_ports	connector_type	removable_memory	memory_slots_available	material_type	effective_still_resolution	focus_type	max_focal_length	display_type	display_technology	display_resolution_maximum	flash_memory_installed_size	flash_memory_installed_size_unit_of_measure	digital_storage_capacity	digital_storage_capacity_unit_of_measure	video_output_format	video_encoding	media_type_base1	media_type_base2	media_type_base3	media_type_base4	media_type_base5	human_interface_input1	human_interface_input2	human_interface_input3	human_interface_input4	human_interface_input5	optical_zoom	min_shutter_speed	max_shutter_speed	continuous_shooting_speed	flash_modes_description	hot_shoe_included	min_focal_length	min_aperture	max_aperture	video_capture_resolution	wireless_communication_technology1	wireless_communication_technology2	wireless_communication_technology3	wireless_communication_technology4	wireless_communication_technology5	total_hdmi_ports	total_s_video_out_ports	total_firewire_ports	total_usb_ports	supported_internet_services1	supported_internet_services2	supported_internet_services3	supported_internet_services4	supported_internet_services5	audio_output_mode	battery_average_life_talk_time	battery_average_life_talk_time_unit_of_measure	optical_digital_input	tuner_technology	total_subwoofer_outputs	number_of_radio_bands_supported	power_consumption	power_consumption_unit_of_measure	total_ethernet_ports	speaker_type	speaker_connectivity	impedance	impedance_unit_of_measure	speaker_maximum_input_power	speaker_maximum_input_power_unit_of_measure	audio_sensitivity	audio_sensitivity_unit_of_measure	tweeter_driver_diameter	tweeter_driver_diameter_unit_of_measure	tweeter_driver_cone_material_type	midrange_driver_diameter	midrange_driver_diameter_unit_of_measure	midrange_driver_cone_material_type	woofer_driver_diameter	woofer_driver_diameter_unit_of_measure	woofer_driver_cone_material_type	subwoofer_diameter	subwoofer_diameter_unit_of_measure	subwoofer_cone_material_type	subwoofer_power_description	subwoofer_amplifier_wattage	speaker_grille_material_type	speaker_grille_description	item_shape	output_wattage	wattage	built_in_decoders1	built_in_decoders2	built_in_decoders3	built_in_decoders4	built_in_decoders5	parental_control_technology	amplifier_type	surround_sound_channel_configuration	blu_ray_region	dvd_region	dvd_type	eu_energy_label_efficiency_class	efficiency	image_brightness	image_brightness_unit_of_measure	image_contrast_ratio	screen_surface_description	aspect_ratio	total_vga_in_ports	total_component_in_ports	total_coaxial_inputs	total_s_video_in_ports	speaker_count	mounting_type	exterior_finish	audio_output_effects	number_of_recording_loops	headphones_form_factor	maximum_aperture_range	map_type1	map_type2	map_type3	map_type4	map_type5	traffic_features_description1	traffic_features_description2	traffic_features_description3	traffic_features_description4	traffic_features_description5	waypoints_type	operating_system1	operating_system2	number_of_handsets	total_composite_ports	total_preamp_outputs	total_video_out_ports	total_microphone_ports
$liste_produits
EOD;

// Constructing the MarketplaceId array which will be passed in as the the MarketplaceIdList 
// parameter to the SubmitFeedRequest object.
//$marketplaceIdArray = array("Id" => array('<Marketplace_Id_1>','<Marketplace_Id_2>'));
$marketplaceIdArray = array("Id" => array('A13V1IB3VIYZZH'));
     
 // MWS request objects can be constructed two ways: either passing an array containing the 
 // required request parameters into the request constructor, or by individually setting the request
 // parameters via setter methods.
 // Uncomment one of the methods below.
 

/********* Begin Comment Block *********/
//$feedHandle = fopen('php://memory', 'rw+');
//$feedHandle = fopen('php://memory', 'rw+');

$feedHandle = fopen('amazon-High-Tech-fr.txt', 'w+');

echo "<hr>";
fwrite($feedHandle, $feed);
rewind($feedHandle);


//$feedHandle = @fopen('php://memory', 'rw+');
//fwrite($feedHandle, $fileContent);
rewind($feedHandle);
$parameters = array (
'Marketplace' => MARKETPLACE_ID,
'Merchant' => MERCHANT_ID,
'FeedType' => '_POST_FLAT_FILE_LISTINGS_DATA_',
'FeedContent' => $feedHandle,

'ContentMd5' => base64_encode(md5(stream_get_contents($feedHandle), true)),
);

$request = new MarketplaceWebService_Model_SubmitFeedRequest($parameters);

/********* End Comment Block *********/

  invokeSubmitFeed($service, $request); // appel pour transmettre le fichier

echo "<hr>";
echo "<pre>";
print_r($request);
echo "</pre>";


@fclose($feedHandle);
                                        
/**
  * Submit Feed Action Sample
  * Uploads a file for processing together with the necessary
  * metadata to process the file, such as which type of feed it is.
  * PurgeAndReplace if true means that your existing e.g. inventory is
  * wiped out and replace with the contents of this feed - use with
  * caution (the default is false).
  *   
  * @param MarketplaceWebService_Interface $service instance of MarketplaceWebService_Interface
  * @param mixed $request MarketplaceWebService_Model_SubmitFeed or array of parameters
  */
  function invokeSubmitFeed(MarketplaceWebService_Interface $service, $request) 
  {
      try {
              $response = $service->submitFeed($request);
              

echo "<hr>response";
echo "<pre>";
 print_r($response);
echo "</pre>";
echo "<hr>";
                echo ("Service Response\n");
                echo ("=============================================================================\n");

                echo("        SubmitFeedResponse\n");

                if ($response->isSetResponseMetadata()) { 
                    echo("            ResponseMetadata\n");
                    $responseMetadata = $response->getResponseMetadata();
                    if ($responseMetadata->isSetRequestId()) 
                    {
                        echo("                RequestId\n");
                        echo("                    " . $responseMetadata->getRequestId() . "\n");
                    }
                } 

                echo("ResponseHeaderMetadata: " . $response->getResponseHeaderMetadata() . "\n");
     } catch (MarketplaceWebService_Exception $ex) {
         echo("Caught Exception: " . $ex->getMessage() . "\n");
         echo("Response Status Code: " . $ex->getStatusCode() . "\n");
         echo("Error Code: " . $ex->getErrorCode() . "\n");
         echo("Error Type: " . $ex->getErrorType() . "\n");
         echo("Request ID: " . $ex->getRequestId() . "\n");
         echo("XML: " . $ex->getXML() . "\n");
         echo("ResponseHeaderMetadata: " . $ex->getResponseHeaderMetadata() . "\n");
     }
 }
             
function filter_text($CatList) {
  $CatList = html_entity_decode ($CatList);
  $CatList = strip_tags ($CatList);
  $CatList = trim ($CatList);
  // $CatList = strtolower ($CatList);
  $CatList = str_replace("&nbsp;","",$CatList);
  $CatList = str_replace("&#39;","'",$CatList);
  $CatList = str_replace("&#150;","-",$CatList);
  $CatList = str_replace("","e",$CatList);
  $CatList = str_replace("","e",$CatList);
  $CatList = str_replace("","e",$CatList);
  $CatList = str_replace("&eacute;","e",$CatList);
  $CatList = str_replace("&agrave;","",$CatList);
  $CatList = str_replace("&egrave;","e",$CatList);

  $CatList = str_replace("&nbsp","",$CatList);
  $CatList = str_replace("&#39","'",$CatList);
  $CatList = str_replace("&#150","-",$CatList);
  $CatList = str_replace("&eacute","e",$CatList);
  $CatList = str_replace("&agrave","",$CatList);
  $CatList = str_replace("&egrave","e",$CatList);
  $CatList = str_replace("&hellip","...",$CatList);
  $CatList = str_replace("&rsquo","'",$CatList);

  $CatList = str_replace("&ecirc;;","e",$CatList);
//  $CatList = str_replace(";"," ",$CatList);

  $CatList = str_replace("","i",$CatList);
  $CatList = str_replace(""," graden",$CatList);
  $CatList = str_replace("","'",$CatList);
  $CatList = str_replace("","'",$CatList);
  $CatList = str_replace('"',' ',$CatList);
  $CatList = str_replace(chr(9)," ",$CatList); 
  $CatList = str_replace(chr(10)," ",$CatList);
  $CatList = str_replace(chr(13)," ",$CatList);
  $CatList = preg_replace("[<(.*?)>]","",$CatList);
//  if (strlen($CatList) > $length) {
//    $CatList = substr($CatList, 0, $length-3) . "";
//  }
  return $CatList;  
} // function for the filter