<?php
/*
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  See http://www.gnu.org/licenses/gpl.txt
 *
 *	This contribution is specially modified for OsCommerce by 
 *	Nieko Maatjes (nieko.net) and Pascal IJssermans (realpascal@zonnet.nl).
 *
 *  This script can be used to create barcode-images in the following formats:
 *  EAN-13    /^[0-9]{13}$/
 *  EAN-8     /^[0-9]{8}$/
 *  Also, UPC- and EAN-codes can be suffixed with additional 2- or 5-digit
 *  supplemental code.
 *  Additional info: when printing, 38 pixels take up 1 cm of space.
 *
 *	This mod uses the product's model number to create a barcode, and places it behind the products listing in your invoice.
 *	The model number must be 8 or 13 characters for creating EAN barcodes.
 *
 *	Simply put this script in your admin/ directory, and adjust the following in invoice.php:
 *	Find the line that says:	<td class="dataTableHeadingContent" align="right"><?php echo TABLE_HEADING_TOTAL_INCLUDING_TAX; ?></td>
 *	Directly below it, insert a new line with:	<td class="dataTableHeadingContent" align="right"><?php echo TABLE_HEADING_BARCODE; ?></td>
 *	Next, find the line that says:	'        <td class="dataTableContent" align="right" valign="top"><b>' . $currencies->format(tep_add_tax($order->products[$i]['final_price'], $order->products[$i]['tax']) * $order->products[$i]['qty'], true, $order->info['currency'], $order->info['currency_value']) . '</b></td>' . "\n";
 *	Change, at the end of this line, 	. "\n";	 into	. "\n" .
 *	Directly below this line, add the following line:
 *	      '      	<td class="dataTableContent" align="right" valign="top"><img src="osbarcode.php?barcode=' . $order->products[$i]['model']. '"></td>' . "\n";
 *
 *	Go to your language files, in admin/includes/languages/yourlanguage/invoice.php , and add anywhere before ?>:
 *	define('TABLE_HEADING_BARCODE', 'Barcode');
 *
 *	The last step, is to make sure that your model number can be large enough for translating into EAN-13.
 *	To do this, increase the size of the following entries in your database: products and order_products. 
 *	I suggest inceasing them to 19 characters, 13 for the ean-13 code, 1 for the comma and 5 for suffixes.
 *
 *	Now that's all ! Have fun !
 */



$dispcod = true;  //Make this true if you want printed above the barcode 'EAN-13/8'.
$numbers = true;   //Make this true to make the numbers below the barcode printed.


//data for encoding digits/letters to bars (=1) and spaces (=0)
$a =        array('0001101',  //0
                  '0011001',  //1
                  '0010011',  //2
                  '0111101',  //3
                  '0100011',  //4
                  '0110001',  //5
                  '0101111',  //6
                  '0111011',  //7
                  '0110111',  //8
                  '0001011'); //9
$b =        array('0100111',  //0
                  '0110011',  //1
                  '0011011',  //2
                  '0100001',  //3
                  '0011101',  //4
                  '0111011',  //5
                  '0000101',  //6
                  '0010001',  //7
                  '0001001',  //8
                  '0010111'); //9
$right =    array('1110010',  //0
                  '1100110',  //1
                  '1101100',  //2
                  '1000010',  //3
                  '1011100',  //4
                  '1001110',  //5
                  '1010000',  //6
                  '1000100',  //7
                  '1001000',  //8
                  '1110100'); //9
$AB =       array('aaaaaa',   //0 
                  'aababb',   //1
                  'aabbab',   //2
                  'aabbba',   //3
                  'abaabb',   //4
                  'abbaab',   //5
                  'abbbaa',   //6
                  'ababab',   //7
                  'ababba',   //8
                  'abbaba');  //9
$UPCE =     array('bbbaaa',   //0
                  'bbabaa',   //1
                  'bbaaba',   //2
                  'bbaaab',   //3
                  'babbaa',   //4
                  'baabba',   //5
                  'baaabb',   //6
                  'bababa',   //7
                  'babaab',   //8
                  'baabab');  //9


if (isset($_GET['barcode']))  //process $barcode only if it really contains something
{
  $barcode    = $_GET['barcode'];
  $dispcod    = ($dispcod ? 15 : 0);  //15 is number of pixels image should be moved downwards
  $numbers    = ($numbers ? 0 : 12);

  //process barcode
  //if correct EAN-13-code
  if (preg_match("/^[0-9]{13}(,[0-9]{2,5})?$/", $barcode))
  {
    if (strlen($barcode) == 13)
    { CreateImage(105,  62 + $dispcod - $numbers); } //By '- $numbers' the image becomes to small to show the text
    elseif (strlen($barcode) == 16)
    { CreateImage(132, 62 + $dispcod - $numbers); }
    elseif (strlen($barcode) == 19)
    { CreateImage(168, 62 + $dispcod - $numbers); }

    ImageString($image, 3, 2, 50 + $dispcod, $barcode[0], $black);

    if ($dispcod)  //draw preceeding EAN-number
    { ImageString($image, 3, 36, 0, 'EAN-13', $black); }
    ImageString($image, 3, 14, 50 + $dispcod, substr($barcode, 1, 6), $black);
    ImageString($image, 3, 60, 50 + $dispcod, substr($barcode, 7, 6), $black);

    //draw guard bars
    ImageLine($image, 10, $dispcod, 10, 62 + $dispcod, $black);
    ImageLine($image, 12, $dispcod, 12, 62 + $dispcod, $black);
    ImageLine($image, 56, $dispcod, 56, 62 + $dispcod, $black);
    ImageLine($image, 58, $dispcod, 58, 62 + $dispcod, $black);
    ImageLine($image, 102, $dispcod, 102, 62 + $dispcod, $black);
    ImageLine($image, 104, $dispcod, 104, 62 + $dispcod, $black);

    $position = 13;   //start drawing bars at x = 13;

    for ($digit = 1; $digit <= 6; $digit++)  //first digit should be skipped, is either 0 (UPC) or encoded in next six (EAN)
    {
       for ($offset = 0; $offset < 7; $offset++)
       {
         $color = $AB[$barcode[0]];               //$barcode[0] is first digit that is coded into first 42 (6*7) bars
         $color = substr($color, $digit - 1, 1);
         $color = ${$color};
         $color = substr($color[$barcode[$digit]], $offset, 1);
         $color = ($color == '1' ? $black : $white);
         ImageLine($image, $position, $dispcod, $position, 50 + $dispcod, $color);
         $position++;
       }
    }
    $position += 5;
    for ($digit = 7; $digit <= 12; $digit++)
    {
       for ($offset = 0; $offset < 7; $offset++)
       {
         $color = substr($right[$barcode[$digit]], $offset, 1);
         $color = ($color == '1' ? $black : $white);
         ImageLine($image, $position, $dispcod, $position, 50 + $dispcod, $color);
         $position++;
       }
    }

    if (preg_match("/,[0-9]{2,5}$/", $barcode))
    { suffix($position, preg_replace("/^[0-9]{13},([0-9]{2,5})$/", "\\1", $barcode)); }

    header('Content-type: image/png');   //send image-header
    ImagePNG($image);
    ImageDestroy($image);
  }
  elseif (preg_match("/^[0-9]{8}(,[0-9]{2,5})?$/", $barcode))    //if correct EAN-8-code
  {
    if (strlen($barcode) == 8)
    { CreateImage(67, 62 + $dispcod - $numbers); }
    elseif (strlen($barcode) == 11)
    { CreateImage(94, 62 + $dispcod - $numbers); }
    elseif (strlen($barcode) == 14)
    { CreateImage(130, 62 + $dispcod - $numbers); }

    //draw numbers
    ImageString($image, 3, 4, 50 + $dispcod, substr($barcode, 0, 4), $black);
    ImageString($image, 3, 36, 50 + $dispcod, substr($barcode, 4, 4), $black);
    if ($dispcod) { ImageString($image, 3, 17, 0, 'EAN-8', $black); }


    //draw guard bars
    ImageLine($image, 0, $dispcod, 0, 62 + $dispcod, $black);
    ImageLine($image, 2, $dispcod, 2, 62 + $dispcod, $black);
    ImageLine($image, 32, $dispcod, 32, 62 + $dispcod, $black);
    ImageLine($image, 34, $dispcod, 34, 62 + $dispcod, $black);
    ImageLine($image, 64, $dispcod, 64, 62 + $dispcod, $black);
    ImageLine($image, 66, $dispcod, 66, 62 + $dispcod, $black);

    $position = 3;   //start drawing bars at x = 3;

    for ($digit = 0; $digit <= 3; $digit++)
    {
       for ($offset = 0; $offset < 7; $offset++)
       {
         $color = substr($a[$barcode[$digit]], $offset, 1);   //$a contains left-A spaces/bars
         $color = ($color == '1' ? $black : $white);
         ImageLine($image, $position, $dispcod, $position, 50 + $dispcod, $color);
         $position++;
       }
    }
    $position += 5;
    for ($digit = 4; $digit <= 7; $digit++)
    {
       for ($offset = 0; $offset < 7; $offset++)
       {
         $color = substr($right[$barcode[$digit]], $offset, 1);
         $color = ($color == '1' ? $black : $white);
         ImageLine($image, $position, $dispcod, $position, 50 + $dispcod, $color);
         $position++;
       }
    }

    if (preg_match("/,[0-9]{2,5}$/", $barcode))
    { suffix($position, preg_replace("/^[0-9]{8},([0-9]{2,5})$/", "\\1", $barcode)); }

    header('Content-type: image/png');   //send image-header
    ImagePNG($image);
    ImageDestroy($image);
  }
}

function createImage($x, $y)
{
  global $image;
  global $white;
  global $black;
  $image = ImageCreate($x, $y);   //create image
  $white = ImageColorAllocate($image, 255, 255, 255);  //define colors
  $black = ImageColorAllocate($image, 0, 0, 0);
}

function suffix(&$position, $value)  //draw supplemental barcodes
{
  global $image;
  global $black;
  global $white;
  global $a;
  global $b;
  global $UPCE;
  global $dispcod;
  global $numbers;

  if (strlen($value) == 2)   //suffix can only be 2 or 5 digits wide
  {
    $position += 10;  //leave a gap 7 bars wide, and skip 3 guard bars => 10
    ImageLine($image, $position, 12 + $dispcod, $position, 62 + $dispcod, $black);
    ImageLine($image, $position + 2, 12 + $dispcod, $position + 2, 62 + $dispcod, $black);
    ImageLine($image, $position + 3, 12 + $dispcod, $position + 3, 62 + $dispcod, $black);
    if (!$numbers) { ImageString($image, 3, $position + 5, $dispcod, $value, $black); }

    $position += 4;
    switch (((int)$value) % 4)
    {
      case 0: $parity = 'aa'; break;
      case 1: $parity = 'ab'; break;
      case 2: $parity = 'ba'; break;
      case 3: $parity = 'bb'; break;
    }

    for ($digit = 0; $digit <= 1; $digit++)
    {
       for ($offset = 0; $offset < 7; $offset++)
       {
         $color = substr($parity, $digit, 1);
         $color = ${$color};
         $color = $color[substr($value, $digit, 1)];
         $color = substr($color, $offset, 1);
         $color = ($color == '1' ? $black : $white);
         ImageLine($image, $position, 12  + $dispcod, $position, 62 + $dispcod, $color);
         $position++;
       }
       if ($digit == 0)  //draw guardbar '01'
       { $position++; ImageLine($image, $position, 12 + $dispcod, $position, 62 + $dispcod, $black); $position++; }
    }
  }
  elseif (strlen($value) == 5)
  {
    $position += 10;  //leave a gap 7 bars wide, and skip 3 guard bars => 10
    ImageLine($image, $position, 12 + $dispcod, $position, 62 + $dispcod, $black);
    ImageLine($image, $position + 2, 12 + $dispcod, $position + 2, 62 + $dispcod, $black);
    ImageLine($image, $position + 3, 12 + $dispcod, $position + 3, 62 + $dispcod, $black);
    if (!$numbers) { ImageString($image, 3, $position + 12, $dispcod, $value, $black); }

    $position += 4;
    $parity = ((int)substr($value, 0, 1) + (int)substr($value, 2, 1) + (int)substr($value, 4, 1)) * 3;
    $parity += ((int)substr($value, 1, 1) + (int)substr($value, 3, 1)) * 9;
    $parity = $parity % 10;
    $parity = $UPCE[$parity];

    for ($digit = 0; $digit <= 5; $digit++)
    {
       for ($offset = 0; $offset < 7; $offset++)
       {
         $color = substr($parity, $digit, 1);
         $color = ${$color};
         $color = $color[substr($value, $digit, 1)];
         $color = substr($color, $offset, 1);
         $color = ($color == '1' ? $black : $white);
         ImageLine($image, $position, 12 + $dispcod, $position, 62 + $dispcod, $color);
         $position++;
       }
       if ($digit < 5)  //draw guardbar '01'
       { $position++; ImageLine($image, $position, 12 + $dispcod, $position, 62 + $dispcod, $black); $position++; }
    }
  }
}
?>
