<?php
    /**
     * Google Sitemap Generator - Manufacturers
     * 
     * Script to generate a Google sitemap (categories) for osCommerce based stores
     *
     * @license http://opensource.org/licenses/gpl-license.php GNU Public License
     * @version 1.1
     * @link http://www.oscommerce-freelancers.com/ osCommerce-Freelancers
     * @copyright Copyright 2006, Bobby Easland 
     * @author Bobby Easland 
     * @filesource
     */

    /*
     * Include the application_top.php script
     */


    /*
     * Send the XML content header
     */
    header('Content-Type: text/xml');

    /*
     * Echo the XML out tag
     */
    echo '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
?>
<urlset xmlns="http://www.google.com/schemas/sitemap/0.84">
<?php
	include_once('includes/application_top.php');

    /*
     * Define the uniform node function 
     */
    function GenerateNode($data){
        $content = '';
        $content .= "\t" . '<url>' . "\n";
        $content .= "\t\t" . '<loc>'.trim($data['loc']).'</loc>' . "\n";
        $content .= "\t\t" . '<lastmod>'.trim($data['lastmod']).'</lastmod>' . "\n";
        $content .= "\t\t" . '<changefreq>'.trim($data['changefreq']).'</changefreq>' . "\n";
        $content .= "\t\t" . '<priority>'.trim($data['priority']).'</priority>' . "\n";
        $content .= "\t" . '</url>' . "\n";
        return $content;
    } # end function

    /*
     * Define the SQL for the categories query 
     */
    $sql = "SELECT * FROM " . TABLE_MANUFACTURERS . "    ORDER BY last_modified DESC, date_added DESC, manufacturers_name ASC";
    
    /*
     * Execute the query
     */
    $query = tep_db_query($sql);

    /*
     * If there are returned rows...
     * Basic sanity check 
     */
    if ( tep_db_num_rows($query) > 0 ){
        /*
         * Initialize the container
         */
        $container = array();

        /*
         * Loop query result and populate container
         */
        while( $result = tep_db_fetch_array($query) ){
            $container[$result['manufacturers_id']] = max( $result['lsat_modified'], 
                                                                                                         $result['date_added']
                                                                                                         );
        } # end while

        /*
         * Free the resource...could be large
         * ...clean as we go
         */
        tep_db_free_result($query);

        /*
         * Sort the container based on last mod date
         */
        arsort($container);
    } # end if

    /*
     * Loop the result set
     * Basic sanity check
     */
    if ( sizeof($container) > 0 ){
        $total = sizeof($container);
        $_total = $total;
        foreach( $container as $mID => $last_mod ){
            $location = tep_href_link(FILENAME_DEFAULT, 'manufacturers_id=' . $mID, 'NONSSL', false);
            $changefreq = 'weekly';
            $priority = max( number_format($_total/$total, 1, '.', ','), .1);
            $_total--;        
            $container = array('loc' => htmlspecialchars(utf8_encode($location)),
                                                 'lastmod' => date ("Y-m-d", strtotime($last_mod)),
                                                 'changefreq' => $changefreq,
                                                 'priority' => $priority
                                                );
            /*
             * Echo the generated node
             */
            echo generateNode($container);
        } # end while
    } # end if

    /*
     * Close the urlset
     */
    echo '</urlset>';
    
    /*
     * Include the application_bottom.php script 
     */
    include_once('includes/application_bottom.php');
?>
