<?php
/*
  $Id: abxRSSReader.php,v 1.3 2007/04/01 01:35:24 auctionblox Exp $

    PHP RSS Reader v1.1
    By Richard James Kendall
    Bugs to richard@richardjameskendall.com
    Free to use, please acknowledge me

    Modified by AuctionBlox

    Place the URL of an RSS feed in the $file variable.

    The $this->rss_channel array will be filled with data from the feed,
    every RSS feed is different by by and large it should contain:

    Array {
      [TITLE] = feed title
      [DESCRIPTION] = feed description
      [LINK] = link to their website

      [IMAGE] = Array {
            [URL] = url of image
            [DESCRIPTION] = alt text of image
          }

      [ITEMS] = Array {
            [0] = Array {
                [TITLE] = item title
                [DESCRIPTION] = item description
                [LINK = a link to the story
              }
            .
            .
            .
          }
    }
*/

  class abxRSSReader {

    var $max_articles    = '5',
        $max_characters = '90',
        $rss_channel,
        $currently_writing,
        $main,
        $item_counter;

    function abxRSSReader()
    {
      $this->rss_channel = array();
      $this->currently_writing = '';
      $this->main = '';
      $this->item_counter = 0;
    }

    function readRSS($file)
    {

      $rss_content = '';

      $rssReader = new abxRSSReader;

      $rss_channel = $rssReader->read($file);

      if (count($rss_channel['ITEMS']) > 0) {

        $maxCount = (count($rss_channel['ITEMS']) > $rssReader->max_articles) ? $rssReader->max_articles : count($rss_channel['ITEMS']);

        $rss_content = '<div class="smallText" style="color: #000000;">';

        for($i = 0;$i < $maxCount; $i++) {

          $rss_content .= '<strong>' . $rss_channel['ITEMS'][$i]["TITLE"] . '</strong><br>';

          $rss_content .=  $rss_channel['ITEMS'][$i]["DESCRIPTION"];

          if ($length > $rssReader->max_characters) {

            $rss_content .= '...<br />';

            $rss_content .= '<a target="_blank" href="' . $rss_channel['ITEMS'][$i]['LINK'] . '"><font color="#dd0000">['.TEXT_SEE_ARTICLE.']</font></a><hr>';

          } else {

            $rss_content .= '<br><br>';

          }

        }

        $rss_content .= '</div>';

      }

      return $rss_content;
    }

    function read($file)
    {
      if (!ini_get('safe_mode'))
        set_time_limit(0);

      if ($fp = @fopen($file, "r")) {

        $xml_parser = @xml_parser_create();

        @xml_set_element_handler($xml_parser,array(&$this,'startElement'),array(&$this,'endElement'));
        @xml_set_character_data_handler($xml_parser, array(&$this,'characterData'));

        while ($data = @fread($fp, 4096))
          @xml_parse($xml_parser, $data, feof($fp));

        @xml_parser_free($xml_parser);
      }

      return $this->rss_channel;
    }

    function startElement($parser, $name, $attrs)
    {
      switch($name) {
        case 'RSS':
        case 'RDF:RDF':
        case 'ITEMS':
          $this->currently_writing = "";
          break;
        case 'CHANNEL':
          $this->main = 'CHANNEL';
          break;
        case 'IMAGE':
          $this->main = 'IMAGE';
          $this->rss_channel['IMAGE'] = array();
          break;
        case 'ITEM':
          $this->main = 'ITEMS';
          break;
        default:
          $this->currently_writing = $name;
          break;
      }
    }

    function endElement($parser, $name)
    {
      $this->currently_writing = '';
      if ($name == 'ITEM')
        $this->item_counter++;
    }

    function characterData($parser, $data)
    {
      if ($this->currently_writing != '') {
        switch($this->main) {
          case 'CHANNEL':
            if (isset($this->rss_channel[$this->currently_writing]))
              $this->rss_channel[$this->currently_writing] .= $data;
            else
              $this->rss_channel[$this->currently_writing] = $data;
            break;
          case 'IMAGE':
            if (isset($this->rss_channel[$this->main][$this->currently_writing]))
              $this->rss_channel[$this->main][$this->currently_writing] .= $data;
            else
              $this->rss_channel[$this->main][$this->currently_writing] = $data;
            break;
          case 'ITEMS':
            if (isset($this->rss_channel[$this->main][$this->item_counter][$this->currently_writing]))
              $this->rss_channel[$this->main][$this->item_counter][$this->currently_writing] .= $data;
            else
              $this->rss_channel[$this->main][$this->item_counter][$this->currently_writing] = $data;
            break;
        }
      }
    }

  }//end class
?>