<?php
/*
  $Id: abxSalesReport.php,v 1.4 2005/10/03 03:20:46 auctionblox Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2002 osCommerce

  Released under the GNU General Public License
*/

  class abxSalesReport {
    var $mode, $globalStartDate, $startDate, $endDate, $info, $previous, $next, $startDates, $endDates, $size;

    function abxSalesReport($report = 2, $startDate = '', $endDate = '', $filter = '') {

      // report views (1: hourly 2: [default]daily 3: weekly 4: monthly 5: yearly)
      $this->sales_report_view = ($report > 5) ? 2 : (!empty($report) ? $report : 2);

      switch($report) {

        case '1':
          $this->summary1 = AVERAGE_HOURLY_TOTAL;
          $this->summary2 = TODAY_TO_DATE;
          $this->report_desc = REPORT_TYPE_HOURLY;
          $this->reportLabel = TEXT_HOURLY;
          break;

        default:
        case '2':
          $this->summary1 = AVERAGE_DAILY_TOTAL;
          $this->summary2 = WEEK_TO_DATE;
          $this->report_desc = REPORT_TYPE_DAILY;
          $this->reportLabel = TEXT_DAYS;
          break;

        case '3':
          $this->summary1 = AVERAGE_WEEKLY_TOTAL;
          $this->summary2 = MONTH_TO_DATE;
          $this->report_desc = REPORT_TYPE_WEEKLY;
          $this->reportLabel = TEXT_WEEKS;
          break;

        case '4':
          $this->summary1 = AVERAGE_MONTHLY_TOTAL;
          $this->summary2 = YEAR_TO_DATE;
          $this->report_desc = REPORT_TYPE_MONTHLY;
          $this->reportLabel = TEXT_MONTHS;
          break;

        case '5' :
          $this->summary1 = AVERAGE_YEARLY_TOTAL;
          $this->summary2 = YEARLY_TOTAL;
          $this->report_desc = REPORT_TYPE_YEARLY;
          $this->reportLabel = TEXT_YEARLY;
          break;

      }
      // check filters
      if (!empty($filter)) {
        $this->sales_report_filter = $filter;
        $this->sales_report_filter_link = "&filter=$filter";
      }

      $this->init($this->sales_report_view, $startDate, $endDate, $filter);

      if (strlen($this->sales_report_filter) == 0) {
        $this->sales_report_filter = $this->filter;
        $this->sales_report_filter_link = "";
      }

    }

    function init($mode, $startDate = "", $endDate = "", $filter = "") {
    global $abxDatabase;
      // startDate and endDate have to be a unix timestamp. Use mktime !
      // if set then both have to be valid startDate and endDate
      $this->mode = $mode;
      $this->previous = "";
      $this->next = "";
      $this->filter = "";
      $this->info = array(array());

      // get date of first sale
      $first_query =  $abxDatabase->query("select UNIX_TIMESTAMP(min(time_end)) as first FROM " . TABLE_ABX_BASKET);
      $first = $first_query->next();
      $this->globalStartDate = mktime(0, 0, 0, date("m", $first['first']), date("d", $first['first']), date("Y", $first['first']));

      // get all possible status for filter
/*      $tmp_query = tep_db_query("SELECT * FROM " . TABLE_ABX_SALE_STATUS);
      $i = 0;
      while ($status = tep_db_fetch_array($tmp_query)) {
        $tmp[$i]['index'] = $status['status_id'];
        $tmp[$i]['value'] = $status['status_label'];
        $i++;
      }
      $this->status_available = $tmp;
      $this->status_available_size = $i;
*/
      if ($endDate == "" or $startDate == "") {
        // set startDate to nothing
        $dateGiven = false;
        $startDate = 0;
        // endDate is today
        $this->endDate = mktime(0, 0, 0, date("m"), date("d"), date("Y"));
      } else {
        $dateGiven = true;
        if ($endDate > mktime(0, 0, 0, date("m"), date("d"), date("Y"))) {
          $this->endDate = mktime(0, 0, 0, date("m"), date("d") + 1, date("Y"));
        } else {
          // set endDate to the given Date with "round" on days
          $this->endDate = mktime(0, 0, 0, date("m", $endDate), date("d", $endDate) + 1, date("Y", $endDate));
        }
      }
      switch ($this->mode) {
        // hourly
        case '1':
          if ($dateGiven) {
            // "round" to midnight
            $this->startDate = mktime(0, 0, 0, date("m", $startDate), date("d", $startDate), date("Y", $startDate));
            $this->endDate = mktime(0, 0, 0, date("m", $startDate), date("d", $startDate) + 1, date("Y", $startDate));
            // size to number of hours
            $this->size = 24;
          } else {
            // startDate to start of this day
            $this->startDate = mktime(0, 0, 0, date("m"), date("d"), date("Y"));
            $this->endDate = mktime(date("G") + 1, 0, 0, date("m"), date("d"), date("Y"));
            // size to number of hours
            $this->size = date("G") + 1;
            if ($this->startDate < $this->globalStartDate) {
              $this->startDate = $this->globalStartDate;
            }
          }
          for ($i = 0; $i < $this->size; $i++) {
            $this->startDates[$i] = mktime($i, 0, 0, date("m", $this->startDate), date("d", $this->startDate), date("Y", $this->startDate));
            $this->endDates[$i] = mktime($i + 1, 0, 0, date("m", $this->startDate), date("d", $this->startDate), date("Y", $this->startDate));
          }
          break;
        // day
        case '2':
          if ($dateGiven) {
            // "round" to day
            $this->startDate = mktime(0, 0, 0, date("m", $startDate), date("d", $startDate), date("Y", $startDate));
            // size to number of days
            $this->size = ($this->endDate - $this->startDate) / (60 * 60 * 24);
          } else {
            // startDate to start of this week
            $this->startDate = mktime(0, 0, 0, date("m"), date("d") - date("w"), date("Y"));
            $this->endDate = mktime(0, 0, 0, date("m"), date("d") + 1, date("Y"));
            // size to number of days
            $this->size = date("w") + 1;
            if ($this->startDate < $this->globalStartDate) {
              $this->startDate = $this->globalStartDate;
            }
          }
          for ($i = 0; $i < $this->size; $i++) {
            $this->startDates[$i] = mktime(0, 0, 0, date("m", $this->startDate), date("d", $this->startDate) + $i, date("Y", $this->startDate));
            $this->endDates[$i] = mktime(0, 0, 0, date("m", $this->startDate), date("d", $this->startDate) + ($i + 1), date("Y", $this->startDate));
          }
          break;
        // week
        case '3':
          if ($dateGiven) {
            $this->startDate = mktime(0, 0, 0, date("m", $startDate), date("d", $startDate) - date("w", $startDate), date("Y", $startDate));

          } else {
            // startDate to beginning of first week of this month
            $firstDayOfMonth = mktime(0, 0, 0, date("m"), 1, date("Y"));
            $this->startDate = mktime(0, 0, 0, date("m"), 1 - date("w", $firstDayOfMonth), date("Y"));
          }
          if ($this->startDate < $this->globalStartDate) {
            $this->startDate = $this->globalStartDate;
          }
          // size to the number of weeks in this month till endDate
          $this->size = ceil((($this->endDate - $this->startDate + 1) / (60 * 60 * 24)) / 7);
          for ($i = 0; $i < $this->size; $i++) {
            $this->startDates[$i] = mktime(0, 0, 0, date("m", $this->startDate), date("d", $this->startDate) +  $i * 7, date("Y", $this->startDate));
            $this->endDates[$i] = mktime(0, 0, 0, date("m", $this->startDate), date("d", $this->startDate) + ($i + 1) * 7, date("Y", $this->startDate));
          }
          break;
        // month
        case '4':
          if ($dateGiven) {
            $this->startDate = mktime(0, 0, 0, date("m", $startDate), 1, date("Y", $startDate));
            // size to number of days
          } else {
            // startDate to first day of the first month of this year
            $this->startDate = mktime(0, 0, 0, 1, 1, date("Y"));
            // size to number of months in this year
          }
          if ($this->startDate < $this->globalStartDate) {
            $this->startDate = mktime(0, 0, 0, date("m", $this->globalStartDate), 1, date("Y", $this->globalStartDate));
          }
          $this->size = (date("Y", $this->endDate) - date("Y", $this->startDate)) * 12 + (date("m", $this->endDate) - date("m", $this->startDate)) + 1;
          $tmpMonth = date("m", $this->startDate);
          $tmpYear = date("Y", $this->startDate);
          for ($i = 0; $i < $this->size; $i++) {
            // the first of the $tmpMonth + $i
            $this->startDates[$i] = mktime(0, 0, 0, $tmpMonth + $i, 1, $tmpYear);
            // the first of the $tmpMonth + $i + 1 month
            $this->endDates[$i] = mktime(0, 0, 0, $tmpMonth + $i + 1, 1, $tmpYear);
          }
          break;
        // year
        case '5':
          if ($dateGiven) {
            $this->startDate = mktime(0, 0, 0, 1, 1, date("Y", $startDate));
            $this->endDate = mktime(0, 0, 0, 1, 1, date("Y", $endDate) + 1);
          } else {
            // startDate to first of current year - $max_years
            $this->startDate = mktime(0, 0, 0, 1, 1, date("Y") - 5 + 1);
            // endDate to today
            $this->endDate = mktime(0, 0, 0, date("m"), date("d"), date("Y"));
          }
          if ($this->startDate < $this->globalStartDate) {
            $this->startDate = $this->globalStartDate;
          }
          $this->size = date("Y", $this->endDate) - date("Y", $this->startDate) + 1;
          $tmpYear = date("Y", $this->startDate);
          for ($i = 0; $i < $this->size; $i++) {
            $this->startDates[$i] = mktime(0, 0, 0, 1, 1, $tmpYear + $i);
            $this->endDates[$i] = mktime(0, 0, 0, 1, 1, $tmpYear + $i + 1);
          }
          break;
      }

      if (($this->mode < 3) or ($this->mode == 4)) {
        // set previous to start - diff
        $tmpDiff = $this->endDate - $this->startDate;
        if ($this->size == 0) {
          $tmpUnit = 0;
        } else {
          $tmpUnit = $tmpDiff / $this->size;
        }
        //echo $tmpDiff . " " . $tmpUnit . "<br>";

        switch($this->mode) {
          // hourly
          case '1':
            $tmp1 =  24 * 60 * 60;
            break;
          // daily
          case '2':
            $tmp1 = 7 * 24 * 60 * 60;
            break;
          // weekly
          case '3':
            $tmp1 = 30 * 24 * 60 * 60;
            break;
          // monthly
          case '4':
            $tmp1 = 365 * 24 * 60 * 60;
            break;
        }
        $tmp = ceil($tmpDiff / $tmp1);
        if ($tmp > 1) {
          $tmpShift = ($tmp * $tmpDiff) + $tmpUnit;
        } else {
          $tmpShift = $tmp1 + $tmpUnit;
        }

        $tmpStart = $this->startDate - $tmpShift + $tmpUnit;
        $tmpEnd = $this->startDate - $tmpUnit;
        if ($tmpStart >= $this->globalStartDate or $this->mode == 4) {
          //echo strftime("%T %x", $tmpStart). " - " . strftime("%T %x", $tmpEnd) . "<br>";
          $this->previous = "report=" . $this->mode . "&startDate=" . $tmpStart . "&endDate=" . $tmpEnd;
        }

        $tmpStart = $this->endDate;
        $tmpEnd = $this->endDate + $tmpShift - 2 * $tmpUnit;
        if ($tmpEnd < mktime(0, 0, 0, date("m"), date("d"), date("Y"))) {
          //echo strftime("%T %x", $tmpStart). " - " . strftime("%T %x", $tmpEnd);
          $this->next = "report=" . $this->mode . "&startDate=" . $tmpStart . "&endDate=" . $tmpEnd;
        } else {
          if ($tmpEnd - $tmpDiff < mktime(0, 0, 0, date("m"), date("d"), date("Y"))) {
            $tmpEnd = mktime(0, 0, 0, date("m"), date("d"), date("Y"));
            //echo strftime("%T %x", $tmpStart). " - " . strftime("%T %x", $tmpEnd);
            $this->next = "report=" . $this->mode . "&startDate=" . $tmpStart . "&endDate=" . $tmpEnd;
          }
        }
      }

      // handle filters
      // submit the filters that way:
      // 01001 means use filter for status 2 and 5 set.
      if (strlen($filter) > 0) {
        $tmp = "";
        $tmp1 = "";
        for ($i = 0; $i < $this->status_available_size; $i++) {
          if (substr($filter, $i, 1) == "1") {
            $tmp1 .= "1";
            if (strlen($tmp) == 0) {
              $tmp = "listing_status <> " . $this->status_available[$i]['index'];
            } else {
              $tmp .= " and listing_status <> " . $this->status_available[$i]['index'];
            }
          } else {
            $tmp1 .= "0";
          }
        }
        $this->filter_sql = $tmp;
        $this->filter = $tmp1;
      }
      $this->filter_link = "report=" . $this->mode . "&startDate=" . $startDate . "&endDate=" . $endDate;


      // if ($dateGiven) {
      //  echo "<br>" . strftime("%H %x", $this->startDate). " - " . strftime("%H %x", $this->endDate);
      //} else {
        $this->query();
      //}
    }

    function query() {
		global $abxDatabase;
      if (strlen($this->filter_sql) > 0) {
        $tmp_query = "SELECT sum(price_end) as value, avg(price_end) as avg, count(price_end) as count FROM " . TABLE_ABX_BASKET . " WHERE " . $this->filter_sql;
      } else {
        $tmp_query = "SELECT sum(price_end) as value, avg(price_end) as avg, count(price_end) as count FROM " . TABLE_ABX_BASKET . " WHERE 1=1";
      }

      for ($i = 0; $i < $this->size; $i++) {
        $report_query = $abxDatabase->query($tmp_query . " AND time_end >= '" . date("Y-m-d\TH:i:s", $this->startDates[$i]) . "' AND time_end < '" . date("Y-m-d\TH:i:s", $this->endDates[$i]) . "'");
        $report = $report_query->next();
              $this->info[$i]['sum'] = $report['value'];
        $this->info[$i]['avg'] = $report['avg'];
        $this->info[$i]['count'] = $report['count'];
        switch ($this->mode) {
          // hourly
          case '1':
            $this->info[$i]['text'] = strftime("%H", $this->startDates[$i]) . " - " . strftime("%H", $this->endDates[$i]);
            $this->info[$i]['link'] = "";
            break;
          // daily
          case '2':
            $this->info[$i]['text'] = strftime("%x", $this->startDates[$i]);
            $this->info[$i]['link'] = "report=1&startDate=" . $this->startDates[$i] . "&endDate=" . mktime(0, 0, 0, date("m", $this->endDates[$i]), date("d", $this->endDates[$i]) + 1, date("Y", $this->endDates[$i]));
            break;
          // weekly
          case '3':
            $this->info[$i]['text'] = strftime("%x", $this->startDates[$i]) . " - " . strftime("%x", mktime(0, 0, 0, date("m", $this->endDates[$i]), date("d", $this->endDates[$i]) - 1, date("Y", $this->endDates[$i])));
            $this->info[$i]['link'] = "report=2&startDate=" . $this->startDates[$i] . "&endDate=" . mktime(0, 0, 0, date("m", $this->endDates[$i]), date("d", $this->endDates[$i]) - 1, date("Y", $this->endDates[$i]));
            break;
          // monthly
          case '4':
            $this->info[$i]['text'] = strftime("%b %y", $this->startDates[$i]);
            $this->info[$i]['link'] = "report=3&startDate=" . $this->startDates[$i] . "&endDate=" . mktime(0, 0, 0, date("m", $this->endDates[$i]), date("d", $this->endDates[$i]) - 1, date("Y", $this->endDates[$i]));
            break;
          // yearly
          case '5':
            $this->info[$i]['text'] = date("Y", $this->startDates[$i]);
            $this->info[$i]['link'] = "report=4&startDate=" . $this->startDates[$i] . "&endDate=" . mktime(0, 0, 0, date("m", $this->endDates[$i]) - 1, date("d", $this->endDates[$i]), date("Y", $this->endDates[$i]));
            break;
        }
      }
    }

    function drawJSGraph($sales_report_view = 0) {

      $js = abxPage::image(DIR_WS_ABX_IMAGES . 'spacer.gif', '', '250', '10').'<br>';

      if ($sales_report_view > 1) {

        if ($this->size > 1) {

          $js .= abxPage::image(DIR_WS_ABX_IMAGES . 'spacer.gif', '', '250', '10').'<br>';

          $last_value = 0;
          $this->order_cnt = 0;
          $sum = 0;

          for ($i = 0; $i < $this->size; $i++) {

            if ($last_value != 0) {
              $percent = 100 * $this->info[$i]['sum'] / $last_value - 100;
            } else {
              $percent = "0";
            }

            $sum += $this->info[$i]['sum'];
            $avg += $this->info[$i]['avg'];
            $this->order_cnt += $this->info[$i]['count'];
            $last_value = $this->info[$i]['sum'];
          }
        }

        $scale_x = ($sum / ($this->size == 0 ? 1 : $this->size)) / 4;
        $scale_y = $scale_x + 50;
        $scale_z = $scale_y / 100;
        $scale = round($scale_z) * 100;

        $js .= '<SCRIPT LANGUAGE="JavaScript1.2">'."\n".'<!--'."\n";

        $js .= 'var g = new Graph(' . ($this->size > 2 ? 200 : $this->size * 50) . ',100,true);'."\n";

        $js .= 'g.addRow(';

        for ($i = 0; $i < $this->size; $i++) {

          if ($this->info[$i]['sum'] == "")

            $js .= '0';

          else

            $js .= $this->info[$i]['sum'] - $this->info[$i]['avg'];


          if (($i+1) < $this->size)
            $js .= ',';

        }

        $js .= ');' . "\n";

        if($sales_report_view == 2) {

          $js .= 'g.addRow(';

          for ($i = 0; $i < $this->size; $i++) {

            if($this->info[$i]['sum'] == "")

              $js .= '0';

            else

              $js .= $this->info[$i]['avg'];

            if (($i+1) < $this->size)
              $js .= ',';

          }

          $js .= ');' . "\n";

          $js .= 'g.setLegend(\'daily total\',\'avg. listing\');' . "\n";


        }

        $js .= 'g.setXScaleValues("';

        for ($i = 0; $i < $this->size; $i++) {

          if (($sales_report_view == 5) && ($this->size > 5)) {

            $js .= substr($this->info[$i]['text'], 0,1);

          } else {

            if ($sales_report_view == 4) {

              $js .= substr($this->info[$i]['text'], 0,3);

            } else {

              if($this->size > 5) {

                $js .= substr($this->info[$i]['text'], 3,2);

              } else {

                $js .= substr($this->info[$i]['text'], 0,5);
              }
            }

          }

          if (($i+1) < $this->size)
            $js .= '","';

       }

       $js .= '");'."\n";

       $js .= 'g.scale = ' . $scale . ';'."\n";

       $js .= 'g.title = "' . HEADING_GRAPH_TITLE . '"'."\n";
       $js .= 'g.xLabel = "' . $this->reportLabel . '"'."\n";
       $js .= 'g.yLabel = "' . TEXT_SALES . '"'."\n";

       $js .= 'g.build();'."\n";

       $js .= '//-->'."\n".'</SCRIPT>'."\n";

      }

      return $js;
    }

  function reportMenuLinks($sales_report_filter_link) {


    $table = '<table border="0" width="100%" cellspacing="0" cellpadding="0">' .
             '  <tr>' .
             '    <td align="right">' .
             '      <a href="' . abx_href_link(FILENAME_AUCTIONBLOX, 'abx=sales-reports&report=1' . $sales_report_filter_link, 'NONSSL') . '">' . REPORT_TYPE_HOURLY .'</a> | ' .
             '      <a href="' . abx_href_link(FILENAME_AUCTIONBLOX, 'abx=sales-reports&report=2' . $sales_report_filter_link, 'NONSSL') . '">' . REPORT_TYPE_DAILY .'</a> | ' .
             '      <a href="' . abx_href_link(FILENAME_AUCTIONBLOX, 'abx=sales-reports&report=3' . $sales_report_filter_link, 'NONSSL') . '">' . REPORT_TYPE_WEEKLY . '</a> | ' .
             '      <a href="' . abx_href_link(FILENAME_AUCTIONBLOX, 'abx=sales-reports&report=4' . $sales_report_filter_link, 'NONSSL') . '">' . REPORT_TYPE_MONTHLY . '</a> | ' .
             '      <a href="' . abx_href_link(FILENAME_AUCTIONBLOX, 'abx=sales-reports&report=5' . $sales_report_filter_link, 'NONSSL') . '">' . REPORT_TYPE_YEARLY . '</a>' .
             '    </td>'.
             '  </tr>'.
             '</table>';

    return $table;
  }

  function reportsTable() {
    global $currencies;

    $table = '<table border="0" width="100%" cellspacing="0" cellpadding="2" class="tableData">' .
             '  <tr>' .
             '    <th>' . $this->reportLabel . '</th>' .
             '    <th align="center">' . TABLE_HEADING_ORDERS . '</th>' .
             '    <th align="right">' . TABLE_HEADING_CONV_PER_ORDER . '</th>' .
             '    <th align="right">' . TABLE_HEADING_CONVERSION . '</th>' .
             '    <th align="right">' . TABLE_HEADING_VARIANCE . '</th>' .
             '  </tr>';

  $rows = '';
  $last_value = 0;
  $this->sum = 0;
  $trOdd = 'tableDataRowOdd'; $trEven = 'tableDataRowEven'; $trClass = $trOdd;
  for ($i = 0; $i < $this->size; $i++) {
    if ($last_value != 0) {
      $percent = 100 * $this->info[$i]['sum'] / $last_value - 100;
    } else {
      $percent = "0";
    }
    $this->sum += $this->info[$i]['sum'];
    $avg += $this->info[$i]['avg'];
    $last_value = $this->info[$i]['sum'];

    $trClass = $trClass == $trOdd  ? $trEven : $trOdd;

    $row = '  <tr class="' . $trClass . '">' .
           '    <td>';

    if (strlen($this->info[$i]['link']) > 0 ) {
      $row .= '<a href="' . abx_href_link(FILENAME_AUCTIONBLOX, 'abx=sales-reports&' . $this->info[$i]['link'], 'NONSSL') . '">';
    }
    $row .= $this->info[$i]['text'] . $date_text[$i];
    if (strlen($this->info[$i]['link']) > 0 ) {
      $row .= '</a>';
    }

    $row .= '    </td>' .
            '    <td align="center">' . $this->info[$i]['count'] . '</td>' .
            '    <td align="right">' . $currencies->format($this->info[$i]['avg']) . '</td>' .
            '    <td align="right">' . $currencies->format($this->info[$i]['sum']) . '</td>' .
            '    <td align="right">';

    if ($percent == 0){
      $row .= "---";
    } else {
      $row .= number_format($percent,0) . "%";
    }

    $row .= '    </td>' .
            '  </tr>';

    $rows .= $row;
 }

  $table .= $rows;

  if (strlen($this->previous . " " . $this->next) > 1) {
  $table .= '  <tr>' .
            '    <td width="100%" colspan="5">' .
            '      <table width="100%">' .
            '        <tr>' .
            '          <td>';

    if (strlen($this->previous) > 0) {
      $table .=  '<a href="' . abx_href_link(FILENAME_AUCTIONBLOX, 'abx=sales-reports&' . $this->previous, 'NONSSL') . '">&lt;&lt;&nbsp;Previous</a>';
    }

  $table .= '          </td>' .
            '          <td align="right">';

    if (strlen($this->next) > 0) {
      $table .='<a href="' . abx_href_link(FILENAME_AUCTIONBLOX, 'abx=sales-reports&' . $this->next, 'NONSSL') . '">Next&nbsp;&gt;&gt;</a>';
    }

  $table .= '          </td>' .
            '        </tr>' .
            '      </table>' .
            '    </td>' .
            '  </tr>';
  }

  $table .= '</table>';

    return $table;
  }//end reportsTable



  function summaryTable() {
    global $currencies;

    $table  = '<div class="tableData">';
    $table .= '<table border="0" width="100%" cellspacing="0" cellpadding="2">';

    if ($this->order_cnt != 0){

      $table .= '  <tr>' .
                '    <td width="100%" align="right">' . '<b>'. AVERAGE_ORDER . ' </b>' . '</td>' .
                '    <td align="right">' . $currencies->format($this->sum / $this->order_cnt) . '</td>' .
                '  </tr>';
    }

    if ($this->size != 0) {

      $table .= '  <tr>' .
                '    <td width=100% align="right">' . '<b>'. $this->summary1 . ' </b>' . '</td>' .
                '    <td align="right">' . $currencies->format($this->sum / $this->size) . '</td>' .
                '  </tr>';
    }

    $table .= '  <tr>' .
              '    <td width=100% align="right">' . '<b>'. $this->summary2 . ' </b>' . '</td>' .
              '    <td align="right">' . $currencies->format($this->sum) . '</td>' .
              '  </tr>'.
              '</table>';

    $table .= '</div>';

    return $table;
  }

  function filterStatusTable($sales_report_filter = 0) {

    $table = '<table border="0" width="100%" cellspacing="0" cellpadding="2" class="tableData">' .
           '  <tr>' .
           '    <th align="left" nowrap>&nbsp;' . FILTER_STATUS_LABEL . '</th>' .
           '    <th align="right">' . FILTER_STATUS . '&nbsp;</th>' .
           '  </tr>';

    if (($sales_report_filter) == 0) {
      for ($i = 0; $i < $this->status_available_size; $i++) {
        $sales_report_filter .= "0";
      }
    }

    $rows = '';

    $trOdd = 'tableDataRowOdd'; $trEven = 'tableDataRowEven'; $trClass = $trOdd;

    for ($i = 0; $i < ($this->status_available_size); $i++) {

      $trClass = $trClass == $trOdd  ? $trEven : $trOdd;

      $row  = '  <tr class="' . $trClass . '">' .
      $row .= '    <td nowrap>' . $this->status_available[$i]['value'] . '</td>';
      $row .= '    <td align="right">';

      if (substr($sales_report_filter,$i,1) ==  "0") {

        $tmp = substr($sales_report_filter, 0, $i) . "1" . substr($sales_report_filter, $i+1, $this->status_available_size - ($i + 1));

        $tmp = abx_href_link(FILENAME_AUCTIONBLOX, 'abx=sales-reports&' . $this->filter_link . "&filter=". $tmp, 'NONSSL');

        $row .= abxPage::image(DIR_WS_ABX_EXTERNAL_CART_IMAGES . 'icon_status_green.gif', IMAGE_ICON_STATUS_GREEN, 10, 10) . '&nbsp;' . '<a href="' . $tmp . '">' . abxPage::image(DIR_FS_ABX_EXTERNAL_CART_IMAGES . 'icon_status_red_light.gif', IMAGE_ICON_STATUS_RED_LIGHT, 10, 10) . '</a>';

      } else {

        $tmp = substr($sales_report_filter, 0, $i) . "0" . substr($sales_report_filter, $i+1);
        $tmp = abx_href_link(FILENAME_AUCTIONBLOX, 'abx=sales-reports&' . $this->filter_link . "&filter=". $tmp, 'NONSSL');

        $row .= '<a href="' . $tmp . '">' . abxPage::image(DIR_WS_ABX_EXTERNAL_CART_IMAGES . 'icon_status_green_light.gif', IMAGE_ICON_STATUS_GREEN, 10, 10) . '</a>' . '&nbsp;' . abxPage::image(DIR_FS_ABX_EXTERNAL_CART_IMAGES . 'icon_status_red.gif', IMAGE_ICON_STATUS_RED_LIGHT, 10, 10);

      }

      $row .= '    </td>';

      $row .= '  </tr>';

      $rows .= $row;

      unset($row);
    }

    $table .= $rows;

    $table .= '</table>';

    return $table;
  }

    function display() {

      $table = '<table border="0" width="100%" cellspacing="0" cellpadding="2" class="abxMain">' .
               '  <tr>' .
               '    <td colspan="2">' .
               '      <table border="0" width="100%" cellspacing="0" cellpadding="0">' .
               '        <tr>' .
               '          <td class="pageHeading">' . $this->report_desc . ' ' . HEADING_TITLE . '</td>' .
               '        </tr>'.
               '      </table>' .
               '    </td>' .
               '  </tr>' .
               '  <tr>' .
               '    <td colspan="2">' . $this->reportMenuLinks($this->sales_report_filter_link) . '</td>' .
               '  </tr>' .
               '  <tr>' .
               '    <td valign="top" width="250">' . $this->drawJSGraph($this->sales_report_view) . '</td>' .
               '    <td width="100%" valign="top">' .
               '      <table border="0" width="100%" cellspacing="0" cellpadding="2">' .
               '        <tr>' .
               '          <td valign="top">' . $this->reportsTable() . '<br class="h10"/>' . $this->summaryTable() . '<br class="h10"/>' . $this->filterStatusTable($this->sales_report_filter) . '</td>' .
               '        </tr>' .
               '      </table>' .
               '    </td>' .
               '  </tr>' .
               '</table>';

      return $table;
    }

  }//end class
?>
