<?php
/*
  $Id: abxPaginator.php,v 1.21 2008/02/27 15:38:11 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  require_once DIR_FS_ABX_CLASSES.'Page/abxPageIcons.php';
  require_once DIR_FS_ABX_CLASSES.'Page/abxPaginatorQuery.php';
  require_once DIR_FS_ABX_CLASSES.'Page/abxPage.php';
  require_once DIR_FS_ABX_CLASSES.'abxConstants.php';

  abx_includeLanguageFile(DIR_FS_ABX_INCLUDES,$language,'abxPaginator');

  class abxPaginator extends abxPage {

    function abxPaginator() {
      parent::abxPage();

      $this->resultsName('SPLIT_PAGE_RESULTS_NAME');

      $this->performAction = !empty($_POST['perform']);

      $this->displayPageLinks = true;
    }

    function resultsName($name='')
    {
      static $resultsName = '';

      if (empty($name) === false)
        $resultsName = $name;

      return $resultsName;
    }

    function tableDataHeadings()
    {
      return array();
    }

    function getTableHeadings()
    {
      $str = '';

      $cHeadings = $this->tableDataHeadings();

      for( $i=0,$n=count($cHeadings); $i<$n; $i++) {

        $td = $cHeadings[$i];

        $td_align = (isset($td['align']) && !empty($td['align'])) ? $td['align'] : 'center';

        $td_heading = defined($cHeadings[$i]['heading']) ? constant($cHeadings[$i]['heading']) : $cHeadings[$i]['heading'];

        $str .= '<th width="'.$td['width'].'" align="' . $td_align . '">' . $this->drawSortHeader(FILENAME_AUCTIONBLOX, $td_heading, $cHeadings[$i]['sort_field']) . "</th>\n";

      }

      return $str;
    }

    function drawExtraHiddenFields()
    {
      return '';
    }

    function bulkActions($array = array())
    {
      return array();
    }

    function &bulkActionIcons()
    {
      return new bulkActionIcons($this->bulkActions());
    }

    function disableBulkActions(&$abxPageIcons)
    {
      if ($this->performAction === false) {

        $array = array();

        if (count($abxPageIcons->icons)>0)
          foreach($abxPageIcons->icons as $key => $val)
            $array[] = $key;

        if ($array > 0)
          $abxPageIcons->enable($array);

      }

      return false;
    }

    function countBulkActions()
    {
      static $countBulkActions;

      if (isset($countBulkActions) === true)
        return $countBulkActions;

      return $countBulkActions = count($this->bulkActions());
    }

    function singleActions($array = array())
    {
      return array();
    }

    function &singleActionIcons($array = array())
    {
      return new abxPageIcons($this->singleActions($array));
    }

    function disableSingleActions($array,&$abxPageIcons)
    {
      if ($this->performAction === false) {

        $array = array();

        if (count($abxPageIcons->icons) > 0)
          foreach($abxPageIcons->icons as $key => $val)
            $array[] = $key;

        if ($array > 0)
          $abxPageIcons->enable($array);

      }

      return false;
    }

    function countSingleActions()
    {
      static $countSingleActions;

      if (isset($countSingleActions) === true)
        return $countSingleActions;

      return $countSingleActions = count($this->singleActions());
    }

    function countTableDataColumns()
    {
      static $countTableDataColumns;

      if (isset($countTableDataColumns) === true)
        return $countTableDataColumns;

      return $countTableDataColumns = count($this->tableDataHeadings()) + $this->countSingleActions() + ($this->countBulkActions() > 0 ? 1 : 0);
    }

    function searchArray()
    {
      if (isset($_GET['searchname']) === true)
        return array(
          'name' => $_GET['searchname'],
          'value' => $_GET['searchvalue']
        );

      return array();
    }

    function sortArray()
    {
      if (isset($_GET['sortname']) === true)
        return array(
          'name' => $_GET['sortname'],
          'value' => $_GET['sortvalue']
        );

      return array();
    }

    function sortDefaultArray()
    {
      return array();
    }

    function searchTerms()
    {
      return array();
    }

    function filterTerms()
    {
      return array(
        'name' => '',
        'values' => array()
      );
    }

    function sellerIDs()
    {
      return abxConstants::getEbaySellerIDs(array(array('id' => '', 'text' => '')));
    }

    function countSellerIDs()
    {
      static $countSellerIDs;

      if (isset($countSellerIDs) === true)
        return $countSellerIDs;

      return $countSellerIDs = count(abxConstants::getEbaySellerIDs());
    }

    function countFilterTerms()
    {
      static $countFilterTerms;

      if (isset($countFilterTerms) === true)
        return $countFilterTerms;

      $filterTerms = $this->filterTerms();

      return $countFilterTerms = count($filterTerms['values']);
    }

    function sellerID()
    {
      if (empty($_GET['seller_id']) === false)
        return array(
          'name' => 'seller_id',
          'value' => $_GET['seller_id']
        );

      return array();
    }

    function filterBy()
    {
      if (empty($_GET['filter']) === false)
        return $_GET['filter'];

      return '';
    }

    function allSelected()
    {
      static $checkbox_SelectAll;

      if (isset($checkbox_SelectAll) === true)
        return $checkbox_SelectAll;

      return $checkbox_SelectAll = (isset($GLOBALS['checkbox_SelectAll']) && $GLOBALS['checkbox_SelectAll'] == 'on') ? 'CHECKED' : '';
    }

    function tableDataHeader()
    {
      $str = '<table border="0" width="100%" cellspacing="0" cellpadding="2">' .
             '  <tr>' .
             '    <td class="pageHeading" nowrap>' . HEADING_TITLE . '&nbsp;</td>';

      if($this->performAction === false && count($this->searchTerms()) > 0)
        $str .= '<td class="smallText" align="right" nowrap>' . $this->drawSearchForm(FILENAME_AUCTIONBLOX, $this->searchTerms()) . '</td>';

      $str .= '</tr>';

      if ($this->performAction === false) {

        $pageFilters = '';

        $colspan = '2';

        if($this->countSellerIDs() > 0) {
          $colspan = '1';

          $seller_id_onChange = '';

          if($this->countFilterTerms() > 0)
            $seller_id_onChange .= 'document.forms[\'abxsearch\'].filter.value = document.forms[\'search_filter\'].filter[document.forms[\'search_filter\'].filter.selectedIndex].value;';

          $seller_id_onChange .= 'document.forms[\'abxsearch\'].seller_id.value = document.forms[\'seller_filter\'].seller_id[document.forms[\'seller_filter\'].seller_id.selectedIndex].value; document.forms[\'abxsearch\'].submit();';

          $pageFilters .= '<td colspan="'.$colspan.'" class="smallText">' . $this->drawFilterForm(FILENAME_AUCTIONBLOX, $this->sellerIDs(), ENTRY_EBAY_SELLER_ID, 'seller_filter', 'seller_id', 'onchange="' . $seller_id_onChange . '"') . '</td>';

        }

        if($this->countFilterTerms() > 0) {

          $filterTerms = $this->filterTerms();

          $filter_terms_onChange = '';

          if($this->countSellerIDs() > 0)
            $filter_terms_onChange .= 'document.forms[\'abxsearch\'].seller_id.value = document.forms[\'seller_filter\'].seller_id[document.forms[\'seller_filter\'].seller_id.selectedIndex].value;';

          $filter_terms_onChange .= 'document.forms[\'abxsearch\'].filter.value = document.forms[\'search_filter\'].filter[document.forms[\'search_filter\'].filter.selectedIndex].value;document.forms[\'abxsearch\'].submit();';

          $pageFilters .= '<td colspan="'.$colspan.'" class="smallText" align="right">' . $this->drawFilterForm(FILENAME_AUCTIONBLOX, $filterTerms['values'], HEADING_TITLE_GOTO, 'search_filter', 'filter', 'onchange="' . $filter_terms_onChange . '"') . '</td>';

        }

        $str .= (empty($pageFilters) === false) ? '<tr>' . $pageFilters . '</tr>' : '';

      }

      $str .= '</table>';

      return $str;
    }

    function tableDataSubHeader()
    {
      return '';
    }

    function tableDataFooter()
    {
      return '';
    }

    function tableDataLegend(&$abxPageIcons)
    {
      $str = '';

      if (count($abxPageIcons->icons) > 0) {

        $str .= '<strong>'.TEXT_LEGEND.'</strong>&nbsp;';

          foreach($abxPageIcons->icons as $key => $val)

            $str .= $this->image(DIR_WS_ABX_ICONS . $val['img_on'],$val['alt'], '16', '16') . '&nbsp;' . $val['alt'] . '&nbsp;&nbsp;';
      }

      return $str;
    }

    function drawSearchForm($filename, $searchterms, $additionalFormFields = null)
    {
      foreach($searchterms as $key => $val)
        $searchList[] = array('id' => $val['id'], 'text' => @constant($val['text']));

      $str = $this->form('abxsearch', $filename, '', 'GET').$this->hidden('abx',$_GET['abx']) . HEADING_SEARCH_TERM . '&nbsp;' . $this->input('searchvalue','','size="26" maxlength="64"') . '&nbsp;' . HEADING_SEARCH_FIELD . '&nbsp;' . $this->select('searchname', $searchList, $_GET['searchname']) . '&nbsp;';
      
      if(is_array($additionalFormFields))
      {
        foreach($additionalFormFields as $field)
          $str .= $this->hidden($field, $_GET[$field]);
      }

      if ($this->countFilterTerms() > 0 || $this->countSellerIDs() > 0) {

        if ($this->countSellerIDs() > 0) {
          $str .= $this->hidden('seller_id',$_GET['seller_id']);
//          $seller_id_onclick = 'this.form.seller_id.value = document.forms[\'seller_filter\'].seller_id[document.forms[\'seller_filter\'].seller_id.selectedIndex].value;';
        }

//        if ($this->countFilterTerms() > 0) {
          $str .= $this->hidden('filter', $_GET['filter']);
//          $filter_onclick = 'this.form.filter.value = document.forms[\'search_filter\'].filter[document.forms[\'search_filter\'].filter.selectedIndex].value;';
//        }

        $str .= $this->button(IMAGE_SEARCH,$filter_onclick.$seller_id_onclick.' if (this.form.searchvalue.value != \'\') { this.form.submit(); }');

      } else {

        $str .= $this->submit(IMAGE_SEARCH,'this.form');

      }

      $str .= '&nbsp;' . $this->submit(TEXT_RESET_SEARCH,'','',$_GET['abx'],'','aquaButton');

      $str .= '</form>';

      return $str;
    }

    function drawFilterForm($filename, $filterterms, $label, $formname, $filtername, $onchange = 'onchange="this.form.submit()"')
    {
      return $this->form($formname, FILENAME_AUCTIONBLOX, '', 'GET').$this->hidden('abx',$_GET['abx']) . $label . '&nbsp;&nbsp;' . $this->select($filtername, $filterterms, $_GET[$filtername], $onchange).'</form>';
    }

    function getPaginatorQueryResults()
    {
      return $this->query->results();
    }

    function setPaginatorQueryResults(&$array)
    {
      if (isset($this->query) === true)
        $this->query->setResults($array);
    }

    function &paginatorQuery($query)
    {
      if ($this->performAction === false) {

        $this->query = & new abxPaginatorQuery($_GET['page'],MAX_ABX_DISPLAY_SEARCH_RESULTS,$query, $this->sortDefaultArray(), $this->sortArray(), $this->searchArray(), $this->filterTerms(), $this->filterBy(), $this->sellerID());

        return $this->query;

      }

      return FALSE;
    }

    function drawSortHeader($filename, $header, $sortname)
    {
      if ($_GET['sortvalue'] == 'desc') {

        $arrow_filename = 'asc.gif';
        $sortvalue = 'asc';

      } else {

        $arrow_filename = 'desc.gif';
        $sortvalue = 'desc';

      }

      $string = '<table class="tableSortTable" border="0" cellspacing="0" cellpadding="1">';

      if (empty($sortname) === false && $_GET['sortname'] === $sortname) {

        $string .= '<tr><td align="center">' . $header . "</td>";
        $string .= '<td style="padding-top: 2px;padding-left: 3px;">' . '<a href="' . abx_href_link($filename, $this->getSearchParams(array('sortname', 'sortvalue'),array('abx'),'') . '&sortname=' . $sortname . '&sortvalue='.$sortvalue) . '">' . $this->image(DIR_WS_ABX_ICONS . $arrow_filename, '','13','13').'</a></td>';

      } elseif (empty($sortname) === false) {

        $string .= '<td>' . '<a href="' . abx_href_link($filename, $this->getSearchParams(array('sortname', 'sortvalue'),array('abx'),'') . '&sortname=' . $sortname . '&sortvalue=desc') . '">' . $header.'</a></td>';

      } else {

        $string .= '<td>' . $header. '</td>';

      }

      $string .= "</tr></table>";

      return $string;
    }

    function generatePaginatorContent()
    {
      return $this->setContent($this->displayPaginator());
    }

    function displayPaginator()
    {
      $bulkIcons = &$this->bulkActionIcons();

      $str .= '<table border="0" cellspacing="0" cellpadding="0" class="abxMain">' . "\n" .
              '  <tr>' . "\n" .
              '    <td>' . $this->tableDataHeader() . '</td>' . "\n" .
              '  </tr>' . "\n";

      $tableDataSubHeader = $this->tableDataSubHeader();

      if ($tableDataSubHeader != '') {

        $str .= '  <tr>' . "\n" .
                '    <td>' . $tableDataSubHeader . '</td>' . "\n" .
                '  </tr>' . "\n";
      }

      $infoBox = $this->infoBox($_POST['perform']);

      if ($infoBox !='') {

        if (($this->countSellerIDs > 0) || ($this->countFilterTerms() == 0 && $tableDataSubHeader == ''))
          $str .= '  <tr>' . "\n" .
                  '    <td><br class="h10"></td>' . "\n" .
                  '  </tr>' . "\n";


        $str .= '  <tr>' . "\n" .
                '    <td><div style="width: 250px;padding-top: 5px;">' . "\n" . $infoBox . "\n" .'</div></td>' . "\n" .
                '  </tr>' . "\n";
      }

      if (isset($this->query) === true) {

        if ($tableDataSubHeader != '')
          $str .= '  <tr>' . "\n" .
                  '    <td><br class="h10"></td>' . "\n" .
                  '  </tr>' . "\n";


        $str .= '  <tr>' . "\n" .
                '    <td>' . "\n" .
                '      <table border="0" width="100%" cellspacing="0" cellpadding="0">' . "\n" .
                '        <tr>' . "\n" .
                '          <td valign="top">' . $this->form('abxPaginator', FILENAME_AUCTIONBLOX, $this->getSearchParams(array('oID'),array('abx'),'')) . '<input type="hidden" name="perform" value="">' . "\n" .
                '            <table border="0" cellspacing="0" cellpadding="2" class="tableData">' . "\n";

        if ($this->countBulkActions() > 0 || $this->displayPageLinks === true) {

          $str .= '              <tr>' . "\n" .
                  '                <td class="bulkActions" colspan="' . $this->countTableDataColumns() . '" height="30">';

          if ($this->countBulkActions() > 0) {

            $this->disableBulkActions($bulkIcons);
            $str .= '<div style="float: left; padding-top:7px; vertical-align: middle;">' . $this->image(DIR_WS_ABX_IMAGES . 'bulk_item_arrow.gif','','38','22') . '</div>' .
                    '<div class="main" style="float: left; padding-top:5px; vertical-align: middle;">' . TEXT_BULK_ITEM_ACTION . '&nbsp;' . $bulkIcons->display($this) . '</div>';

          }

          if ($this->displayPageLinks === true) {

            $pageLinks = $this->query->displayPageLinks('page', $this->getSearchParams(array('page'),array('abx','form','pID','pName'),''));

            $str .= '<div style="float: right; padding: 10px 0px 2px 0px; vertical-align: middle;"><table border="0" cellspacing="0" cellpadding="2"><tr><td>'.$pageLinks.'</td></tr></table></div>';

          }

          $str .= '</td>' . "\n" .
                  '              </tr>' . "\n";

        }

        $str .= '              <tr>' . "\n";

        if ($this->countBulkActions() > 0)
          $str .= '                <th width="1%">' . $this->checkbox('checkbox_SelectAll', $_POST['checkbox_SelectAll'], 'onclick="checkboxSelectAll(this.form,this)" '.($this->performAction ? 'DISABLED' : ''), ($this->allSelected() == 'CHECKED' ? true: false)) . '</th>' . "\n";

        if ($this->countSingleActions() > 0)
          $str .= '                <th align="center">' . TABLE_HEADING_CHECKBOX_ACTION . '</th>' . "\n";

        $str .= $this->getTableHeadings();
        $str .= '              </tr>' . "\n";

        $i=0; $row = 1; $trPtr = 'tableDataRowPtr'; $trOdd = 'tableDataRowOdd'; $trEven = 'tableDataRowEven'; $trClass = $trOdd;

				if($this->query->results() != null)
				{
	        foreach($this->query->results() as $key => $tableDataRow) {
	
	          $singleIcons = &$this->singleActionIcons($tableDataRow);
	          $this->disableSingleActions($tableDataRow,$singleIcons);
	          $trClass = $trClass == $trOdd  ? $trEven : $trOdd;
	
	          if ($this->countBulkActions() > 0)
	            $str .= "            <tr class=\"$trClass\" onMouseOver=\"this.className='$trPtr'\" onMouseOut=\"this.className='$trClass';deSelectCheckBoxAll(document.forms['abxPaginator'],document.getElementById('checkbox_$i'))\" onmousedown=\"if(document.getElementById('checkbox_$i').disabled == false) document.getElementById('checkbox_$i').checked = (document.getElementById('checkbox_$i').checked ? false : true);\">" . "\n";
	          elseif ($_GET['oID'] == $tableDataRow['id'])
	            $str .= "            <tr class=\"$trPtr\">" . "\n";
	          else
	            $str .= "            <tr class=\"$trClass\">" . "\n";
	
	          if ($this->countBulkActions() > 0) {
	            $str .= '              <td>' . "\n";
	            $tableDataRowChecked = false;
	            if ((is_array($_POST['abxList']) && in_array($tableDataRow['id'],$_POST['abxList'])) || ($this->allSelected() == 'CHECKED'))
	              $tableDataRowChecked = true;
	            $str .= $this->checkbox('abxList[]', $tableDataRow['id'], 'id="checkbox_'.$i.'" onclick="javascript: return false;"'.($this->performAction ? 'DISABLED' : ''), $tableDataRowChecked);
	            $str .= '              </td>' . "\n";
	          }
	
	          if ($this->countSingleActions() > 0)
	            $str .= '              <td align="center" nowrap>' . $singleIcons->display($this) . '</td>' . "\n";
	
	          $str .= $this->tableDataRowContents($tableDataRow);
	
	          $str .= '            </tr>' . "\n";
	
	          ++$i; ++$row;
	
	        }//end foreach tableDataRow
				}
				
        $str .= '            </table>' . $this->drawExtraHiddenFields() . '</form>' . "\n" .
                '          </td>' . "\n" .
                '        </tr>' . "\n";

        if ($this->displayPageLinks === true) {

          $str .= '        <tr>' . "\n" .
                  '          <td style="padding-top: 3px;">' . "\n" .
                  '            <table border="0" width="100%" cellspacing="0" cellpadding="2">' . "\n" .
                  '              <tr>' . "\n" .
                  '                <td class="smallText">' . $pageLinks . '</td>' . "\n" .
                  '                <td class="smallText" align="right">' . $this->query->displayPageLinksTotal(TEXT_DISPLAY_NUMBER_OF_SPLIT_PAGE_RESULTS,@constant($this->resultsName())) . '</td>' . "\n" .
                  '              </tr>' . "\n";

          if (count($this->countSingleActions()) >0)
            $str .= '              <tr>' . "\n" .
                    '                <td class="smallText" colspan="2" style="padding-top: 7px; vertical-align: middle;">' . $this->tableDataLegend($singleIcons) . '</td>' . "\n" .
                    '              </tr>' . "\n";


          $str .= '            </table>' . "\n" .
                  '          </td>' . "\n" .
                  '        </tr>' . "\n";
        }

      }//if isset($this->query)

      $tableDataFooter = ($this->performAction === true) ? '' : $this->tableDataFooter();

      if ($tableDataFooter != '')
        $str .= '        <tr>' . "\n" .
                '          <td><br class="h10"></td>' . "\n" .
                '        </tr>' . "\n" .
                '        <tr>' . "\n" .
                '          <td>' . $tableDataFooter . '</td>' . "\n" .
                '        </tr>' . "\n";


      $str .= '      </table>' . "\n" .
              '    </td>' . "\n" .
              '  </tr>' . "\n" .
              '</table>' . "\n";

//      $str .= '<form name="htmlarea" method="post"><input type="hidden" name="text" value="null" /><input type="hidden" name="parentForm" value="null" /><input type="hidden" name="parentID" value="null" /></form>' . "\n";

      return $str;
    }

    function infoBoxProfiles()
    {
      $contents = array();

      if (empty($_POST['profileNotSet']) === true)
        return $contents;

      $str = '<div>' . TEXT_SELECT_DEFAULT_PROFILE . '</div>'.
             '<div style="margin: 10px;">' . $this->select('defaultProfileId',abxConstants::getProfilesDropDown()) . '</div>';

      $contents[] = array('text' =>  $str);

      return $contents;
    }

    function infoBoxDisplay($heading, $contents)
    {
      $box = new box;

      return $box->infoBox($heading, $contents);
    }

    function infoBox($action)
    {
      return false;
    }

    function infoBoxConfirmation($headingText, $subText, $perform, $action = '',$target = '', $arrAddSubText = array())
    {
      $heading=array();

      $contents=array();

      $nSelectedRows = count($_POST['abxList']);

      $form = '';

      if ($nSelectedRows > 0) {

        $heading[] = array('text' =>$headingText);

        if (empty($subText) === false)
          $contents[] = array('text' => sprintf($subText, $nSelectedRows));

        if (count($arrAddSubText)>0)
          foreach($arrAddSubText as $content)
            $contents[] = $content;

        $searchParams = $this->getSearchParams();

        $action = empty($action) ? $_GET['abx'] : $action;

        $contents[] = array('align' => 'center', 'text' => '<div style="padding: 5px;">' . $this->submit(IMAGE_CONFIRM,'this.form',$perform,$action.$searchParams,$target) . '&nbsp;' . $this->cancel($_GET['abx'].$searchParams) . '<div>' );

        $form .= $this->form('confirm', FILENAME_AUCTIONBLOX, 'abx='.$_GET['abx'].$searchParams);

        $form .= $this->hidden('perform','null');

        $form .= $this->infoBoxDisplay($heading, $contents);

        foreach($_POST['abxList'] as $key => $val)
          $form .= $this->hidden('abxList[]',$val);

        if (empty($_POST['checkbox_SelectAll']) === false)
          $form .= $this->hidden('checkbox_SelectAll',$_POST['checkbox_SelectAll']);

        if (empty($_POST['abx_last']) === false)
          $form .= $this->hidden('abx_last',$_POST['abx_last']);

        $form .= '</form>';

        $this->performAction = true;

        return $form;
      }

      return $form;
    }

    function infoPageBox($headingText, $subText, $cancel, $perform, $action = '',$target = '', $arrAddSubText = array())
    {
      $heading=array();

      $contents=array();

      $form = '';

      $heading[] = array('text' =>$headingText);

      if (empty($subText) === false)
        $contents[] = array('text' => $subText);

      if (count($arrAddSubText)>0)
        foreach($arrAddSubText as $content)
          $contents[] = $content;

      $searchParams = $this->getSearchParams();

      $action = empty($action) ? $_GET['abx'] : $action;

      $contents[] = array('align' => 'center', 'text' => '<div style="padding: 5px;">' . $this->submit(IMAGE_CONFIRM,'this.form',$perform,$action.$searchParams,$target) . '&nbsp;' . $this->cancel($cancel.$searchParams) . '<div>' );

      $form .= $this->form('confirm', FILENAME_AUCTIONBLOX, 'abx='.$_GET['abx'].$searchParams);

      $form .= $this->hidden('perform','null') . "\n";

      $form .= $this->infoBoxDisplay($heading, $contents) . "\n";

      if (empty($_POST['abx_last']) === false)
        $form .= $this->hidden('abx_last',$_POST['abx_last']);

      $form .= '</form>'."\n".'<br class="h10">'."\n";

      $this->performAction = true;

      return $form;
    }

    function cell($data)
    {
      return $data = trim($data) != '' ? $data : '&nbsp;';
    }

    function cellWrap($data, $length = '150', $br = "<br />\n")
    {
      return wordwrap($this->cell($data),$length,$br);
    }

    function cellWrapDate($data, $length = '8', $br = "<br />\n")
    {
      return $this->cellWrap($data,$length,$br);
    }

  }//end class
?>