<?php
/*
  $Id: abxPaginatorWebService.php,v 1.7 2005/11/02 00:56:41 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  include_once DIR_FS_ABX_CLASSES.'Page/abxPaginatorQuery.php';

  class abxWebServicePaginatorQuery extends abxPaginatorQuery {

    var $service;

    function abxWebServicePaginatorQuery($service, $page_number,$maximum_rows,$sortDefaultArray,$sortArray,$searchArray,$filterTerms,$filterBy,$sellerID)
    {
      $this->service = $service;

      $this->page_number = (!empty($page_number) && $page_number > 1) ? (int) $page_number : 1;

      $this->page_rows   = (int) $maximum_rows;

      $this->page_size   = $this->execute($this->page_number,$maximum_rows,$sortDefaultArray,$sortArray,$searchArray,$filterTerms,$filterBy,$sellerID);

      $this->page_to     = ($this->page_rows * $this->page_number);

      $this->page_to     = ($this->page_to > $this->page_size) ? $this->page_size : $this->page_to;

      $this->page_from   = ($this->page_rows * ($this->page_number - 1));

      $this->page_from   = ($this->page_to == 0) ? 0 : $this->page_from++;
    }

    function execute($page_number,$maximum_rows,$sortDefaultArray,$sortArray,$searchArray,$filterTerms,$filterBy,$sellerIDArray)
    {

      $aParams = array(
        'page'        => $page_number,
        'count'       => $maximum_rows,
        'sortDefault' => $sortDefaultArray,
        'sort'        => $sortArray,
        'search'      => $searchArray,
        'filterTerms' => $filterTerms,
        'filter'      => $filterBy,
        'sellerId'    => $sellerIDArray
      );

      $aResults = abxAPI::call($this->service, $aParams);

      if (!abxAPI::isError($aResults)) {
        $this->setResults($aResults['list']);
        return $aResults['totalCount'];
      }

      return 0;
    }

  }//end class
?>