<?php
/*
  $Id: abxAccount.php,v 1.7 2007/03/08 00:17:17 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  if (class_exists('abxAPI') === false) {

    require_once(DIR_FS_ABX_CLASSES . 'API/abxAPI.php');

  }

  if (class_exists('abxConstants') === false) {

    require_once(DIR_FS_ABX_CLASSES . 'abxConstants.php');

  }

  class abxAccount {

    function configure()
    {
      global $abxDatabase;

      $abxAPI = new abxAPI();

      $abxAccount = $abxAPI->getAccount();
      if (!ini_get('safe_mode'))
        set_time_limit(0);

      //var_dump($abxAccount);

      if ($abxAccount['numSellers'] == 0)
        return FALSE;

      $abxDatabase->delete(TABLE_ABX_SELLER_INFO);

      $seller_ids = array();
      $upload_urls = array(abx_catalog_href_link(FILENAME_ABXN,'','NONSSL'),abx_catalog_href_link(FILENAME_ABXN,'','SSL'));

      $abxSeller = array();

      for($i=0; $i < $abxAccount['numSellers']; $i++) {

        $abxSeller['seller_id'] = (int)$abxAccount['sellers'][$i]['id'];
        $abxSeller['user_id'] = $abxAccount['sellers'][$i]['userId'];
        $abxSeller['notify_url'] = $abxAccount['sellers'][$i]['uploadUrl'];
        $abxSeller['checkout_url'] = $abxAccount['sellers'][$i]['checkoutUrl'];
        $abxSeller['token_status'] = $abxAccount['sellers'][$i]['tokenStatus'];

        //if(in_array($abxSeller['notify_url'], $upload_urls))

        if (in_array($abxSeller['seller_id'], $seller_ids) === false) {

          $seller_ids[] = (int) $abxSeller['seller_id'];

          $abxDatabase->insert(TABLE_ABX_SELLER_INFO, $abxSeller);

        }

      }

      return TRUE;
    }

    function paginatorAccountsQuery()
    {
      return "select seller_id as id, user_id, notify_url, checkout_url, token_status from " . TABLE_ABX_SELLER_INFO;
    }

  }//end class
?>