<?php
/*
  $Id: abxCart.php,v 1.26 2008/12/15 00:47:29 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  if(!defined('AUCTIONBLOX_VERSION')){
    require_once(realpath(dirname(__FILE__) . '/../configure.php'));
    require_once(DIR_FS_ABX_EXTERNAL_CART . 'includes/functions/integration.php');
    require_once(DIR_FS_ABX_FUNCTIONS . 'abx_currencies.php');
  }
  
  // DIR_FS_CATALOG is necessary so that this class will also work in the admin
  class_exists('shoppingCart') || require_once(DIR_FS_CATALOG . DIR_WS_CLASSES . 'shopping_cart.php');
  class_exists('abxCheckout')  || require_once(DIR_FS_ABX_CLASSES . 'abxCheckout.php');

  class abxCart extends shoppingCart {

    var $email, $abxProducts = array();

    function abxCart($email_address = '')
    {
	    $this->email = $email_address;
	    parent::shoppingCart();
    }
    
    function isAbxCart()
    {
    	return true;
    }
    
    function setEmail($email_address = '')
    {
	    $this->email = $email_address;
    }
    
    function restore_contents() 
    {
      parent::restore_contents();
      
      // This is necessary because stupid CRE Loaded 6.3 does not store the cart in the session any longer
      // Instead, they store the cart *contents*, breaking the original contract.  The CRE developers need
      // better training.
      if(strlen($this->email) == 0 && isset($_SESSION['auctionblox_email_address']))
        $this->email = $_SESSION['auctionblox_email_address'];
      
      if(strlen($this->email) > 0)
    	{
    	  // load her up
        $abxCheckout = new abxCheckout();
			  $this->abxProducts = $abxCheckout->getCartItems($this->email);
			}
      else if (intval($GLOBALS['customer_id']) > 0)
      {
        $abxCheckout = new abxCheckout();
        $email = $abxCheckout->getCustomerEbayEmail($GLOBALS['customer_id']);
        if($email != null && strlen($email) > 0)
        {
          $this->email = $email;
        }       
      }
      
      
    }
    
    function remove($id) {

        // AM: We used to have a conditional in here to check if
        // it was a shop item in the cart first.  But, some
        // squirrelly logic in the base shopping cart class
        // adds the abx item to the base shopping cart list.
        // Trying to remove an auction item always required
        // submitting twice.  So, now we dont care...we just
        // remove from both.
        parent::remove($id); // $id == products id

        $temp = array();
        foreach($this->abxProducts as $key => $product)
        {
          // remove from abxCart
        	if($product['listing_id'] !== $id) //$id == listing id
          {
          	$temp[] = $product; 
          }
        }
        $this->abxProducts = $temp;
    }
        

    // This function does not ALWAYS set the order id, but at least it updates the status
    // to checked out
    function reset($reset_database = false, $order_id = 0)
    {
    global $abxDatabase;
      
      parent::reset($reset_database);

      if ($reset_database == true) {
      
      	if($order_id === 0)
      	{
      		// find the last order id in the history table -- that's our target order.  surely, we don't have
      		// a site that is THAT active
      	  $orders_status = $abxDatabase->fetch_row("select orders_id from " . TABLE_ORDERS_STATUS_HISTORY . " order by orders_status_history_id desc limit 1");
      		$order_id = $orders_status['orders_id'];
      	}

        // Mark the items in the shopping cart completed.
        $auctionProducts = $this->internal_get_auction_products();

        $ids = array();
        foreach($auctionProducts as $key => $auction) {

          //quick fudge to accomodate selected admin Sales Order Entry
          if (isset($auction['is_excluded']) && $auction['is_excluded'] === true)
            continue;

          $ids[] = $auction['auction_basket_id'];
        }
        
        if(sizeof($ids) > 0)
        {
          $checkout = new abxCheckout();
          $checkout->checkoutCartAndSetOrderId($ids, $order_id);
        }
        
        // clear session cart
        $this->abxProducts = array();
        $this->email = null;
      }
    }
    
    //@@deprecated
    function checkStatus()
    {
    }

    function internal_get_auction_products()
    {
      // This is necessary because stupid CRE Loaded 6.3 does not store the cart in the session any longer
      // Instead, they store the cart *contents*, breaking the original contract.  The CRE developers need
      // better training.
      if(strlen($this->email) == 0 && isset($_SESSION['auctionblox_email_address']))
      {
        $this->restore_contents();
      }
      
      return $this->abxProducts;
    }

    function internal_get_store_products($check_for_valid_cart = false)
    {
        if($check_for_valid_cart == true)
          return parent::get_products(true);    // Only valid in Zen Cart
        else
          return parent::get_products();        // Will work for osc, zen cart and cre loaded
    }


    function get_products($check_for_valid_cart = false)    // This optional parameter is in Zen Cart
    {
      $store_products_array = $this->internal_get_store_products($check_for_valid_cart);

      // Fix for bad programming in shopping cart
      if (is_array($store_products_array) === false)
        $store_products_array = array();

      $auction_products_array = $this->internal_get_auction_products();
      return array_merge($auction_products_array, $store_products_array);
    }

    // get total number of items in cart
    function count_contents()
    {
      $count = 0;

      foreach($this->get_products() as $key => $product)
        $count += $product['quantity'];

      return $count;
    }

    function count_auction_contents()
    {
      $count = 0;

      foreach($this->internal_get_auction_products() as $key => $product)
        $count += $product['quantity'];

      return $count;
    }

    function count_store_contents()
    {
      $count = 0;

      foreach($this->internal_get_store_products() as $key => $product)
        $count += $product['quantity'];

      return $count;
    }

    function calculate()
    {
      parent::calculate();

      $auctionProducts = $this->internal_get_auction_products();

      if (is_array($auctionProducts) === false || empty($auctionProducts))
        return 0;

      reset($auctionProducts);

      foreach($auctionProducts as $key => $auctionProduct) {

        $qty = $auctionProduct['quantity'];

        //$prid = $product['products_id'];

        $products_tax = abx_get_tax_rate($auctionProduct['tax_class_id']);

        //$products_price = $auctionProduct['price'];
        $products_price = $auctionProduct['final_price']; //we need to use this value for products with attributes that have a price

        $products_weight = $auctionProduct['weight'];

        $this->total += abx_add_tax($products_price, $products_tax) * $qty;

        $this->weight += ($qty * $products_weight);

      }
    }
    
    /*
     * MMD - in order for order creation to correctly handle attribute pricing for auction
     * items, we must override this method.  There will be a limitation for attribute pricing
     * in an outlying use case.  This is where both this->contents and this->abxProducts have
     * an entry with the same product id.  In this case we will not know whether we should return
     * the attribute pricing for the auction item or the product in the cart.  The default 
     * behavior for this use case will be for this function to return the attribute pricing for
     * the auction item.
     */
    function attributes_price($products_id){
    	$auction_products = $this->internal_get_auction_products();
    	for ($i = 0; $i < count($auction_products); $i++){
    		if ($auction_products[$i]['id'] == $products_id){
    			$abxCheckout = new abxCheckout();
    			return $abxCheckout->auction_attributes_price($auction_products[$i]['auction_basket_id']);
    		}
    	}
    	return parent::attributes_price($products_id);
    }

  }//end class
?>