<?php
/*
  $Id: abxConfiguration.php,v 1.7 2008/04/02 18:46:24 devosc Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxConfiguration {

    function update($id,$value)
    {
      global $abxDatabase;

      $array = array(
        'configuration_value' => $value,
        'last_modified'       => 'now()'
      );

      return $abxDatabase->update(TABLE_ABX_CONFIGURATION,$array,'configuration_id = ' .(int)$id);
    }

    function updateByKey($key,$value)
    {
      global $abxDatabase;

      $array = array(
        'configuration_value' => $value,
        'last_modified'       => 'now()'
      );

      return $abxDatabase->update(TABLE_ABX_CONFIGURATION,$array,"configuration_key = '$key'");
    }

    function queryById($id)
    {
      global $abxDatabase;

      return $abxDatabase->fetch_row("select configuration_id, configuration_title, configuration_value, configuration_key, configuration_description, date_added, last_modified, use_function, set_function from " . TABLE_ABX_CONFIGURATION . " where configuration_id = " . (int)$id);
    }

    function queryByKey($key)
    {
      global $abxDatabase;
      return $abxDatabase->fetch_row("select configuration_id, configuration_title, configuration_value, configuration_key, configuration_description, date_added, last_modified, use_function, set_function from " . TABLE_ABX_CONFIGURATION . " where configuration_key = '$key'");
    }

    function paginatorQuery()
    {
      return "select SQL_CALC_FOUND_ROWS configuration_id as id, configuration_title, configuration_key, configuration_value, use_function from " . TABLE_ABX_CONFIGURATION . " where visible = 1 order by sort_order";
    }

    function getTimeZoneName($zone_id)
    {
      foreach(abxConfiguration::getTimeZones() as $index => $timezone)

        if($timezone['id'] === $zone_id)

          return $timezone['text'];

      return '';
    }

    function timeZoneDropDownList($zone_id)
    {
      return abxPage::select('configuration_value',abxConfiguration::getTimeZones(), $zone_id);
    }

    function getTimeZones()
    {
      return array(
        array('id' => '-12',    'text' => '(GMT - 12:00) Eniwetok, Kwajalein'),
        array('id' => '-11',    'text' => '(GMT - 11:00) Midway Island, Samoa'),
        array('id' => '-10',    'text' => '(GMT - 10:00) Hawaii'),
        array('id' => '-09',    'text' => '(GMT - 9:00) Alaska'),
        array('id' => '-08',    'text' => '(GMT - 8:00) Pacific Time, Tijuana'),
        array('id' => '-07',    'text' => '(GMT - 7:00) Mountain Time, Arizona'),
        array('id' => '-06',    'text' => '(GMT - 6:00) Central Time, Mexico City'),
        array('id' => '-05',    'text' => '(GMT - 5:00) Eastern Time, Lima, Indiana'),
        array('id' => '-04',    'text' => '(GMT - 4:00) Atlantic Time, Caracas'),
        array('id' => '-03.5',  'text' => '(GMT - 3:30) Newfoundland'),
        array('id' => '-03',    'text' => '(GMT - 3:00) Greenland, Buenos Aires'),
        array('id' => '-02',    'text' => '(GMT - 2:00) Mid-Atlantic'),
        array('id' => '-01',    'text' => '(GMT - 1:00) Cape Verde Islands, Azores'),
        array('id' => '-00',    'text' => '(GMT + 0:00) Casablanca, London'),
        array('id' => '+01',    'text' => '(GMT + 1:00) Berlin, Rome, Paris '),
        array('id' => '+02',    'text' => '(GMT + 2:00) Cairo, Athens, Instanbul'),
        array('id' => '+03',    'text' => '(GMT + 3:00) Moscow, St. Petersburg'),
        array('id' => '+03.5',  'text' => '(GMT + 3:30) Tehran'),
        array('id' => '+04',    'text' => '(GMT + 4:00) Abu Dhabi, Muscat'),
        array('id' => '+04.5',  'text' => '(GMT + 4:30) Kabul'),
        array('id' => '+05',    'text' => '(GMT + 5:00) Islamabad, Karachi'),
        array('id' => '+05.5',  'text' => '(GMT + 5:30) Calcutta, New Delhi'),
        array('id' => '+05.75', 'text' => '(GMT + 5:45) K�hmand'),
        array('id' => '+06',    'text' => '(GMT + 6:00) Sri Lanka'),
        array('id' => '+07',    'text' => '(GMT + 7:00) Bangkok, Hanoi, Jakarta'),
        array('id' => '+08',    'text' => '(GMT + 8:00) Beijing, Singapore, Taipei'),
        array('id' => '+09',    'text' => '(GMT + 9:00) Seoul, Osaka, Tokyo'),
        array('id' => '+09.5',  'text' => '(GMT + 9:30) Darwin, Adelaide'),
        array('id' => '+10',    'text' => '(GMT + 10:00) Melbourne, Sydney, Guam'),
        array('id' => '+11',    'text' => '(GMT + 11:00) Magadan, Solomon Islands'),
        array('id' => '+12',    'text' => '(GMT + 12:00) Fiji Islands'),
        array('id' => '+13',    'text' => '(GMT + 13:00) Nuku\'alofa, Tonga'));
    }

    function upgrade($currentVersion)
    {
      global $abxDatabase;

      include(DIR_FS_ABX_INCLUDES.'sql/abx_upgrade.sql.php');

      for ($i = 0, $n = count($abxSQL); $i < $n; $i++ ) {

        $upgrade = true;

        if(version_compare($abxSQL[$i]['target'], $currentVersion) > 0) {

          if (isset($abxSQL[$i]['condition'])) {
            $conditions = $abxSQL[$i]['condition'];

            for ($j = 0, $m = count($conditions); $j < $m; $j++ ) {

              static $tables = array();

              $table = $conditions[$j]['table'];

              if (!isset($tables[$table])) {
                $tableColumns = $abxDatabase->query("show columns from $table");
                while ($column = $tableColumns->next()) {
                $tables[$table][$column['Field']] = 1;
                }
              }

              if (isset($tables[$table][$conditions[$j]['column']])) {
                $upgrade = false;
              }
            }
          }

          if ($upgrade) {
            $abxDatabase->query($abxSQL[$i]['SQL']);
          }
        }
      }

      if (empty($currentVersion)) {
        $versionInfo = array(
          'configuration_title'       => 'AuctionBlox Version',
          'configuration_key'         => 'AUCTIONBLOX_VERSION',
          'configuration_value'       => AUCTIONBLOX_VERSION,
          'configuration_description' => 'AuctionBlox version number',
          'visible'                   => '0',
          'sort_order'                => '0',
          'date_added'                => 'now()'
        );
        $abxDatabase->insert(TABLE_ABX_CONFIGURATION, $versionInfo);
      } else {
        $versionInfo = array(
          'configuration_value' => AUCTIONBLOX_VERSION,
          'last_modified'       => 'now()'
        );
        $abxDatabase->update(TABLE_ABX_CONFIGURATION, $versionInfo, "configuration_key='AUCTIONBLOX_VERSION'");
      }

      return TRUE;
    }
    
    //NIL
	function orderStatusId($status_id){
	    return abxPage::select('configuration_value',abxConfiguration::getOrderStatuses(), $status_id);
    }

    function getOrderStatuses(){
    	global $abxDatabase;
    	$languages_id = $_SESSION['languages_id'];
    	$option_array = array();
    	$resultset = $abxDatabase->fetch_results("SELECT * FROM ". TABLE_ORDERS_STATUS ." WHERE language_id = ".$languages_id);
    	if (is_array($resultset)) {
    		  foreach ($resultset as $key => $value) {
    		  	  $temp_arr['id'] 	  	= $value['orders_status_id'];
    		  	  $temp_arr['text'] 	= $value['orders_status_name'];
    		  	  array_push($option_array,$temp_arr);
    		  }
        }
        return $option_array;
    }

	function getOrderStatusText($status_id){
		foreach(abxConfiguration::getOrderStatuses() as $index => $orderstatus)
        if($orderstatus['id'] === $status_id)
          return $orderstatus['text'];
      	return '';
	}
	//NIL
  }//end class
?>