<?php
/*
  $Id: abxHtml.php,v 1.10 2008/03/13 14:33:06 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxHtml {
    
    function getSessionIdName()
    {
      return abx_draw_hidden_field(abx_session_name());
    }
    
    function getSessionId()
    {
        return abx_session_id();
    }    

    function imageButton($src,$alt,$width,$height,$onClickJS,$params='')
    {
      $onClick = "onclick=\"{$onClickJS}\" ";

      return abxHtml::image($src,$alt,$width,$height,$onClick . $params. ' class="imageButton"');
    }

    function image($src, $alt = '', $width = '', $height = '', $params = '')
    {
      $image = '<img src="' . abxHtml::outputString($src) . '" border="0" alt=" ' . abxHtml::outputString($alt) . ' "';

      $image .= ' title=" ' . abxHtml::outputString($alt) . ' "';

      $image .= ' width="' . (int)$width . '"';

      $image .= ' height="' . (int)$height . '"';

      $image .= !empty($params) ? ' ' . $params : '';

      $image .= '>';

      return $image;
    }

    function menu_link($parameters = '', $connection = 'NONSSL', $script = '')
    {
      return abx_href_link((!empty($script) ? $script : FILENAME_AUCTIONBLOX),$parameters,$connection);
    }

    function javascript_href($url, $text, $params = '', $target = '_blank', $js = true)
    {
      $url = abx_href_link($url,$params);

      if ($js === true)

        $link = '<script language="JavaScript">'."\n".
                '<!--'."\n".
                'document.write("<a href=\"javascript:openWindow(\''.$url.'\');\" tabindex=\"-1\">'.$text.'</a>");'."\n".
                '-->'."\n".
                '</script>'."\n".
                '<noscript><a href="'.$url.'" target="'.$target.'">'.$text.'</a></noscript>'."\n";

      else

        $link = '<a href="'.$url.'" target="'.$target.'">'.$text.'</a>';

      return $link;
    }

    function button($value,$onclick='',$params='',$class='')
    {
      $class = empty($class) ? 'blueButton' : $class;

      return '<input type="button" value="' . abxHtml::outputString($value) . '" class="' . abxHtml::outputString($class) . '"' . ' onclick="' . $onclick . '" ' . $params . '>';
    }

    function reset($value,$form='',$class='greenButton')
    {
      $form = empty($form) ? "this.form" : $form;

      $onclick = "$form.reset(); return false;";

      return $this->button($value,$onclick,'',$class);
    }

    function submit($value,$form='',$perform='',$action='',$target='',$class='')
    {
      $form = empty($form) ? "''" : $form;

      $onclick = "submit_form($form,'$perform','$action','$target'); return false;";

      return $this->button($value,$onclick,'',$class);
    }

    function submitCancel($action,$class='aquaButton')
    {
      return $this->submit(IMAGE_CANCEL,'','',$action,'',$class);
    }

    function cancel($action,$class='aquaButton')
    {
      return $this->button(IMAGE_CANCEL,"document.location.href='auctionblox.php?abx={$action}'",'',$class);
    }

    function navigation($value,$action='',$target='',$class='greenButton')
    {
      return $this->submit($value,'','',$action,$target,$class);
    }

    function form($name, $action, $parameters = '', $method = 'post', $params = '', $connection = 'NONSSL')
    {
      $form = '<form name="' . abxHtml::outputString($name) . '" action="';

      $form .= abx_href_link($action, $parameters, $connection);

      $form .= '" method="' . abxHtml::outputString($method) . '"';

      $form .= !empty($params) ? ' ' . $params : '';

      $form .= '>';

      return $form;
    }

    function select($name, $values, $selected = '', $parameters = '', $required = false, $reinsert_value = true)
    {
      $select = '<select name="' . abxHtml::outputString($name) . '"' . (!empty($parameters) ? ' ' . $parameters : '') . '>';

      $selected = ((is_string($selected) || is_numeric($selected)) && trim($selected) != '' && strtolower($selected) != 'null') ? $selected : NULL;

      $global_value = (isset($GLOBALS[$name]) && (is_string($GLOBALS[$name]) || is_numeric($GLOBALS[$name])) && $reinsert_value == true) ? $GLOBALS[$name] : NULL;

      $selected_value = !is_null($selected) ? $selected : (!is_null($global_value) ? $global_value : NULL);

      foreach((array)$values as $index => $option) {

        $select .= '<option value="' . abxHtml::outputString($option['id']) . '"';

        $select .= ($selected_value == $option['id']) ? ' SELECTED' : '';

        $select .= '>';

        $select .= abxHtml::outputString($option['text'], array('"' => '&quot;', '\'' => '&#039;', '<' => '&lt;', '>' => '&gt;'));

        $select .= '</option>';

      }

      $select .= '</select>';

      $select .= ($required == true) ? TEXT_FIELD_REQUIRED : '';

      return $select;
    }

    function text($values, $selected_value)
    {
       foreach((array)$values as $index => $option) {

        if($selected_value == $option['id']) 
          return abxHtml::outputString($option['text']);
      }
      return $selected_value;
    }


    function textarea($name, $wrap, $width, $height, $text = '', $params = '', $reinsert_value = true)
    {
      $textarea = '<textarea name="' . abxHtml::outputString($name) . '" wrap="' . abxHtml::outputString($wrap) . '" cols="' . abxHtml::outputString($width) . '" rows="' . abxHtml::outputString($height) . '"' . (!empty($params) ? ' ' . $params : '') . '>';

      $text = ((is_string($text) || is_numeric($text)) && trim($text) != '' && strtolower($text) != 'null') ? $text : NULL;

      $global_value = (isset($GLOBALS[$name]) && (is_string($GLOBALS[$name]) || is_numeric($GLOBALS[$name])) && $reinsert_value == true) ? $GLOBALS[$name] : NULL;

      $text_value = !is_null($text) ? $text : (!is_null($global_value) ? $global_value : NULL);

      $textarea .= !is_null($text_value) ? $text_value : '';

      $textarea .= '</textarea>';

      return $textarea;
    }

    function hidden($name, $value = '', $params = '', $reinsert_value = true)
    {
      return $this->input($name, $value, $params, false, 'hidden', $reinsert_value);
    }

    function input($name, $value = '', $params = 'size="32" maxlength="64"', $required = false, $type = 'text', $reinsert_value = true, $checked = false, $class='formInput')
    {
      //echo '<hr><nowrap>input $type = '.$type. ' $value='.$value.' $global_value='.$global_value.' $checked = '.($checked == true ? 'true' : 'false').'</nowrap><hr>';

      $input = '<input type="' . abxHtml::outputString($type) . '" name="' . abxHtml::outputString($name) . '"';

      $value = ((is_string($value) || is_numeric($value)) && trim($value) != '' && strtolower($value) != 'null') ? $value : NULL;

      $global_value = (isset($GLOBALS[$name]) && (is_string($GLOBALS[$name]) || is_numeric($value)) && $reinsert_value == true) ? $GLOBALS[$name] : NULL;

      $input_value = !is_null($value) ? $value : (!is_null($global_value) ? $global_value : NULL);

      $input .= !is_null($input_value) ? ' value="' . abxHtml::outputString($input_value) . '"' : '';

      $input .= !empty($params) ? ' ' . $params : '';

      //echo '<hr><nowrap>input $type = '.$type. ' $input_value=' . $input_value . ' $value='.$value.' $global_value='.$global_value.' $checked = '.($checked == true ? 'true' : 'false').'</nowrap><hr>';
      if(in_array(strtolower($type),array('radio','checkbox')) && ($checked == true || $global_value == 'on' || (!is_null($global_value) && !is_null($value) && $global_value == $value)) )
        $input .= ' CHECKED';

      $input .= ' class="'.$class.'">';

      $input .= $required == true ? '&nbsp;'.TEXT_FIELD_REQUIRED : '';

      return $input;
    }

    function checkbox($name, $value = '', $params = '', $checked = false, $compare = '', $reinsert_value = true)
    {
      $checked = $checked == true ? true : ((is_string($compare) || is_numeric($compare)) && trim($compare) != '' && $compare == $value) ? true : false;
      //echo '<hr><nowrap>checkbox $value = '.$value.' $compare='.$compare.' $checked = '.($checked == true ? 'true' : 'false').'</nowrap><hr>';
      return $this->input($name, $value, $params, false, 'checkbox', true, $checked,'formCheckbox');
    }

    function radio($name, $value = '', $params = '', $checked = false, $compare = '')
    {
      $checked = $checked == true ? true : ((is_string($compare) || is_numeric($compare)) && trim($compare) != '' && $compare == $value) ? true : false;
      return $this->input($name, $value, $params, false, 'radio', true, $checked,'');
    }

    function password($name, $value = '', $params = 'size="16" maxlength="32"', $required = false)
    {
      return $this->input($name, $value, $params, $required, 'password', false);
    }

    function file($name, $value = '', $params = '', $required = false)
    {
      return $this->input($name, $value, $params, $required, 'file');
    }

    function imageBox($image_url='',$image_tag_name='',$fees = false)
    {
      $hidden_tag_name = $image_tag_name.'_url';

      $src = !empty($image_url) ? $image_url : DIR_WS_ABX_IMAGES . 'noimage.gif';
      $alt = !empty($image_url) ? '' : IMAGE_NOIMAGE;

      $maximize = $this->imageButton(DIR_WS_ABX_IMAGES . 'enlarge.gif',TEXT_MAXIMIZE,'9','9',"popupImage('$image_tag_name');");

      $remove = $this->imageButton(DIR_WS_ABX_IMAGES . 'close_file_small.gif',TEXT_REMOVE,'12','9',"removeImage('$image_tag_name','$hidden_tag_name');");

      $image = $this->imageButton($src,$alt,'78','72',"ImageSelector.select('abxItem',this);","name=\"$image_tag_name\" id=\"$image_tag_name\"");

      $str .= $this->hidden($hidden_tag_name, $src, 'id="'.$hidden_tag_name.'"');

      $str .=  '<table border="0" cellspacing="0" cellpadding="0" style="border: 1px solid #f1f1ec; background-color: #f8f8f9;">'.
               '  <tr>'.
               '    <td colspan="3" style="text-align: right; padding: 0px;">' . '<div style="float: left; padding-left: 3px;">' . ($fees == true ? '<span class="fees">&#36;</span>' : '') . '</div>' . $maximize . '&nbsp;' . $remove . '</td>'.
               '    </tr>'.
               '    <tr>'.
               '      <td>' . $this->image(DIR_WS_ABX_IMAGES . 'spacer.gif', '', '3', '1') . '</td>'.
               '      <td>' . $image . '</td>'.
               '      <td>' . $this->image(DIR_WS_ABX_IMAGES . 'spacer.gif', '', '2', '1') . '</td>'.
               '    </tr>'.
               '    <tr>'.
               '      <td colspan="3"><td>' . $this->image(DIR_WS_ABX_IMAGES . 'spacer.gif', '', '1', '3') . '</td></td>'.
               '    </tr>'.
               '</table>';

      return $str;
    }
    
    function bool($string)
    {
   	  if(intval($string) == 1)
      	return "True"; 
	  
	  return "False";
    }
    

    function outputString($string)
    {
      return strtr(trim($string), array('"' => '&quot;'));
    }

  }//end class
?>