<?php
/*
  $Id: abxItemManager.php,v 1.49 2008/12/15 00:47:29 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  require_once(DIR_FS_ABX_CLASSES . 'abxItem.php');
  require_once(DIR_FS_ABX_CLASSES . 'abxMacros.php');

  class abxItemManager extends abxItem {
    
    // templates == 1
    // items == 0 (or <> 1)
    var $ITEM_VERSION = '401'; 

    function newItem($oID,&$postvars)
    {
      $item = array();

      if (!empty($oID) && empty($postvars)) {

        $item                          = abxItemManager::getItem($oID);
        $item['oID']                   = $oID;
        $item['productsDisplayName']   = abxItemManager::getProductNameByID($item['products_id']);
        $item['productsDisplayName']   = !empty($item['productsDisplayName']) ? $item['productsDisplayName'] : ABX_TEXT_NO_PRODUCT_SELECTED;
        $item['payment_methods']       = explode(',',$item['payment_methods']);

      } elseif (empty($postvars)) {

        $item['title']                     = '{PRODUCTS_NAME}';
        $item['description']               = '{PRODUCTS_DESCRIPTION}';
        $item['price']                     = '{PRODUCTS_PRICE}';
        $item['extra_gallery_url']         = '{PRODUCTS_IMAGE}';
        $item['picture1_url']         		 = '{PRODUCTS_IMAGE}';
        $item['site']                      = 'US';
        $item['country']                   = abxConstants::getCountryIsoCode2(STORE_COUNTRY);
        $item['duration']                  = '7';
        $item['quantity_min']              = '1';
        $item['quantity']                  = '{PRODUCTS_QUANTITY}';
        $item['productsDisplayName']       = ABX_TEXT_NO_PRODUCT_SELECTED;
        $item['payment_methods']           = array();
        $item['return_policy_no_of_days']  = '32032';
        $item['return_policy_refund_type'] = '32037';
        $item['checkout_redirect']         = '1';
        $item['abxship_handling_time']     = '1';

      } elseif (!empty($postvars)) {

        $item = $postvars;

        if (empty($item['payment_methods']) || !is_array($item['payment_methods'])){
          $item['payment_methods'] = array();
        }

      }

      return $item;
    }

    function insertItem($item, $product = array()) {
      global $abxDatabase;

      unset($item['id']);

      if (strtolower(get_class($this)) != 'abxitemtemplates') {

        if (!$product) {
          $product = $this->getProduct($item['products_id']);
        }

        $abxMacros = abxMacros::getInstance();

        $item = $abxMacros->runItemMacros($item['site'],$item,$product);
      }

      // if not set, make it an item
      if(!isset($item['type'])) $item['type'] = 0;

      if (!empty($item['payment_methods']) && is_array($item['payment_methods'])) {
        $item['payment_methods'] = implode(',', $item['payment_methods']);
      }

      $item = $this->buildSQLArray($item);

      //Generate a Unique GUID for the UUID Parameter
      $item['uuid'] = md5(uniqid(rand(), true));

      $item['version'] = $this->ITEM_VERSION;
      $insertID = $abxDatabase->insert(TABLE_ABX_ITEMS, $item);

      return $insertID;
    }

    function deleteItems($ids)
    {
      global $abxDatabase;

      $abxDatabase->delete(TABLE_ABX_ITEMS,'id in (' . implode(',',$ids) . ')');
    }

    function updateItem($item, $id)
    {
      global $abxDatabase;

      if (empty($id))
        return 0;

      if (strtolower(get_class($this)) != 'abxitemtemplates') {

        $product = $this->getProduct($item['products_id']);

        $abxMacros = abxMacros::getInstance();

        $item = $abxMacros->runItemMacros($item['site'], $item,$product);

      }

      if (!empty($item['payment_methods'])
            && is_array($item['payment_methods'])) {
          $item['payment_methods'] = implode(',', $item['payment_methods']);
      }

      $item = $this->buildSQLArray($item);

      $item['version'] = $this->ITEM_VERSION;
      $abxDatabase->update(TABLE_ABX_ITEMS, $item,'id = ' . (int)$id);

      return $id;
    }

    function getItem($oID)
    {
      global $abxDatabase;

      $listingQuery = $abxDatabase->query("select * from " . TABLE_ABX_ITEMS . " where id = " . (int)$oID . " limit 1");

      if ($record = $listingQuery->next()) {

        if (!empty($record['object_info'])) {
          $objArray = unserialize($record['object_info']);
          $record = array_merge($record, $objArray);
        }

        if (!empty($record['return_policy'])) {
          $return_policy_info = explode('&', $record['return_policy']);
          for($i = 0, $n = count($return_policy_info); $i < $n; $i++) {
            list($key, $value) = explode('=', $return_policy_info[$i]);
            if ($key == 'vcsid') {
              $vcsid = $value;
              continue;
            }
            if (isset($vcsid)) {
              if ($key == "attr{$vcsid}_3803")
                $record['return_policy_accepted'] = '1'; //'32040'
              elseif ($key == "attr{$vcsid}_3804")
                $record['return_policy_no_of_days']  = $value;
              elseif ($key == "attr{$vcsid}_3805")
                $record['return_policy_refund_type']  = $value;
              elseif ($key == "attr_t{$vcsid}_3806")
                $record['return_policy_description'] = urldecode($value);
            }
          }
        }
        
        // Need to know the current inventory levels!
        if(!empty($record['products_id'])) {
          $query = $abxDatabase->query("select * from " . TABLE_PRODUCTS . " where products_id = " . (int)$record['products_id'] . " limit 1");
          if ($product = $query->next()) {
            $record['quantity_current'] = $product['products_quantity'];
          }
        }
        
        return $record;
      }

      return array();
    }

    function getID($itemID)
    {
      global $abxDatabase;

      return $abxDatabase->fetch_value('id', TABLE_ABX_ITEMS, "uuid = '" . addslashes($itemID) . "'");
    }

    function getItemsPaginatorQuery()
    {
      $languages_id = abxRegistry::get("languages_id");

      if (strtolower(get_class($this)) == 'abxitemtemplates')

        $listings_query_raw="select SQL_CALC_FOUND_ROWS i.* from " . TABLE_ABX_ITEMS . " i where i.type = 1";

      else

        $listings_query_raw=
				"select SQL_CALC_FOUND_ROWS" .
				" i.id" .
				", i.uuid" .
				", i.title" .
				", i.listing_type" .
        ", i.site" .
				", i.quantity" .
				", i.duration" .
				", i.price" .
				", i.bin_price" .
				", i.label" .
				", i.profile_id" .
				", i.products_id" .
				", i.last_modified" .
        ", p.products_model" .
        ", p.products_image" .
        ", p.products_quantity" .
        ", pd.products_name" .
        ", m.manufacturers_id" .
        ", m.manufacturers_name" .
        ", m.manufacturers_image" .
        ", m.date_added" .
        " from " . TABLE_ABX_ITEMS . " i" .
				" left join " . TABLE_PRODUCTS . " p on (i.products_id = p.products_id) " .
				" left join " . TABLE_PRODUCTS_DESCRIPTION . " pd on (i.products_id = pd.products_id)" . 
        " left join " . TABLE_MANUFACTURERS . " m on (p.manufacturers_id = m.manufacturers_id)" . 
				" where i.type != 1 and (pd.language_id is null or pd.language_id = ".(int)$languages_id . ")";

      return $listings_query_raw;
    }

    // --------------------------------------------------------------------

    function getProduct($nProductId) {
      global $abxDatabase;

      $languages_id = abxRegistry::get("languages_id");

      $aProductIds = $nProductId;
      if (!is_array($nProductId)) {
        $aProductIds = array(intval($nProductId));
      }

      $Macros = abxMacros::getInstance();

      $sQuery
        = $Macros->productMacrosQueryString($aProductIds, $languages_id).
          ' LIMIT 1';

      $Query = $abxDatabase->query($sQuery);

      if ($aProduct = $Query->next()) {
        return $aProduct;
      }

      return array(
        'title'       => '{PRODUCTS_NAME}',
        'description' => '{PRODUCTS_DESCRIPTION}'
      );
    }

    function getProductsQuery($filter = null)
    {
      global $abxDatabase;
      
      $languages_id = abxRegistry::get("languages_id");

      $whereclause = "pd.language_id = " . (int)$languages_id;
      if (empty($filter) === false) 
      {
        switch($filter)
        {
          case 'product-bestsellers':
            $product_query_filter = "SELECT products_id, sum(products_quantity) as sales FROM " . TABLE_ORDERS_PRODUCTS . " GROUP BY products_id ORDER BY sales DESC";
            break;

          case 'product-anylisting-notactive':
		        $product_query_filter = "SELECT DISTINCT app_data FROM " . TABLE_ABX_LISTINGS . " WHERE STATUS = 'A'";
            $productsQuery = $abxDatabase->query($product_query_filter);

						$inarray = array();
	        	while($productsQuery->next())
							$inarray[] = $productsQuery->valueInt('app_data');

						if(sizeof($inarray) > 0)
		        	$product_query_filter = "SELECT DISTINCT p.products_id FROM " . TABLE_PRODUCTS . " p WHERE p.products_id not in (" . implode(",",$inarray) . ")";
		        else
		        	$product_query_filter = "SELECT DISTINCT p.products_id FROM " . TABLE_PRODUCTS . " p";
		        break;

          case 'product-storelisting-notactive':
		        $product_query_filter = "SELECT DISTINCT app_data FROM " . TABLE_ABX_LISTINGS . " WHERE status = 'A' AND listing_type = '7'";
            $productsQuery = $abxDatabase->query($product_query_filter);

						$inarray = array();
	        	while($productsQuery->next())
							$inarray[] = $productsQuery->valueInt('app_data');

						if(sizeof($inarray) > 0)
		        	$product_query_filter = "SELECT DISTINCT p.products_id FROM " . TABLE_PRODUCTS . " p WHERE p.products_id not in (" . implode(",",$inarray) . ")";
		        else
		        	$product_query_filter = "SELECT DISTINCT p.products_id FROM " . TABLE_PRODUCTS . " p";
		        break;

          case 'product-fixedlisting-notactive':
		        $product_query_filter = "SELECT DISTINCT app_data FROM " . TABLE_ABX_LISTINGS . " WHERE status = 'A' AND listing_type = '9'";
            $productsQuery = $abxDatabase->query($product_query_filter);

						$inarray = array();
	        	while($productsQuery->next())
							$inarray[] = $productsQuery->valueInt('app_data');

						if(sizeof($inarray) > 0)
		        	$product_query_filter = "SELECT DISTINCT p.products_id FROM " . TABLE_PRODUCTS . "  p WHERE p.products_id not in (" . implode(",",$inarray) . ")";
		        else
		        	$product_query_filter = "SELECT DISTINCT p.products_id FROM " . TABLE_PRODUCTS . "  p";
		        break;

          case 'product-auctionlisting-notactive':
		        $product_query_filter = "SELECT DISTINCT app_data FROM " . TABLE_ABX_LISTINGS . " WHERE status = 'A' AND (listing_type = '1' OR listing_type = '2')";
            $productsQuery = $abxDatabase->query($product_query_filter);

						$inarray = array();
	        	while($productsQuery->next())
							$inarray[] = $productsQuery->valueInt('app_data');

						if(sizeof($inarray) > 0)
		        	$product_query_filter = "SELECT DISTINCT p.products_id FROM " . TABLE_PRODUCTS . "  p WHERE p.products_id not in (" . implode(",",$inarray) . ")";
		        else
		        	$product_query_filter = "SELECT DISTINCT p.products_id FROM " . TABLE_PRODUCTS . "  p";
		        break;

          case 'listing-auction':
            $product_query_filter = "SELECT products_id FROM " . TABLE_ABX_PRODUCTS_EXTRA_INFO . " WHERE exclude_auction <> '1'";
            break;

          case 'listing-fixed':
            $product_query_filter = "SELECT products_id FROM " . TABLE_ABX_PRODUCTS_EXTRA_INFO . " WHERE exclude_fixed <> '1'";
            break;

          case 'listing-store':
            $product_query_filter = "SELECT products_id FROM " . TABLE_ABX_PRODUCTS_EXTRA_INFO . " WHERE exclude_store <> '1'";
            break;

          case 'inventory-instock':
            $product_query_filter = "SELECT products_id FROM " . TABLE_PRODUCTS . " WHERE products_quantity > 0";
            break;

//          case 'inventory-avail':
//            $product_query_filter = "SELECT p.products_id FROM " . TABLE_PRODUCTS . " p LEFT JOIN " . TABLE_ABX_BASKET . " b ON p.products_id = b.products_id WHERE b.listing_status = 3 AND b.archived = 0 AND (p.products_quantity - sum(b.quantity) > 0) GROUP BY b.products_id";
            break;

        	default:
            $subcat_array = array();
			$subcat_array[] = $filter;
			abx_get_subcategories($subcat_array, $filter);
			$product_query_filter = "select products_id from " . TABLE_PRODUCTS_TO_CATEGORIES . " p left join " . TABLE_CATEGORIES_DESCRIPTION . " cd on (p.categories_id = cd.categories_id) where cd.categories_id in (". implode(", ", $subcat_array) .") and cd.language_id = " . (int)$languages_id;
            
            break;
        }

        $productsQuery = $abxDatabase->query($product_query_filter);

				$inarray = array();
        while($productsQuery->next())
          $inarray[] = $productsQuery->valueInt('products_id');

        $inclause = '';

        if (isset($inarray) === true) {

          $inclause = implode(',',$inarray);
          $whereclause .= ' AND pd.products_id in (' . $inclause . ')';

        } else {

          // basically return no products
          $whereclause .= ' AND pd.products_id in (0)';

        }

      }

      $products = 
            "select SQL_CALC_FOUND_ROWS p.*, m.*," .
            " p.products_id as id, pd.products_name, pd.products_description," .
            " pei.custom1, pei.custom2, pei.custom3, pei.custom4, pei.custom5," .
            " pei.custom6, pei.custom7, pei.custom8, pei.custom9, pei.custom10," .
            " pfs.shipping, pfs.shipping_addl," .
            " sum(op.products_quantity) as total_sold" .
            " FROM " . TABLE_PRODUCTS . " p" .
            " LEFT JOIN " . TABLE_PRODUCTS_DESCRIPTION . " pd on (p.products_id = pd.products_id)" .
            " LEFT JOIN " . TABLE_MANUFACTURERS . " m on (p.manufacturers_id = m.manufacturers_id)" .
            " LEFT JOIN " . TABLE_ABX_PRODUCTS_EXTRA_INFO . " pei on (p.products_id = pei.products_id)" .
            " LEFT JOIN " . TABLE_ABX_FIXED_SHIPPING . " pfs on (p.products_id = pfs.products_id)" .
            " LEFT JOIN " . TABLE_ORDERS_PRODUCTS . " op on (p.products_id = op.products_id)" .
            " WHERE $whereclause " .
            " GROUP BY p.products_id";

      return $products;
    }

    function getStoreProducts()
    {
      global $abxDatabase;

      $languages_id = abxRegistry::get("languages_id");

      $products[] = array('id' => '0', 'text' => '[No product selected]');

      $productsQuery = $abxDatabase->query("select pd.products_id, pd.products_name from " . TABLE_PRODUCTS_DESCRIPTION . " pd where pd.language_id = " . (int)$languages_id . " order by pd.products_name");

      while($productsQuery->next())

        $products[] = array('id' => $productsQuery->valueInt('products_id'),'text' => $productsQuery->value('products_name'));

      return $products;
    }

    function getProductNameByID($products_id)
    {
      global $abxDatabase;
      $languages_id = abxRegistry::get("languages_id");

      return $abxDatabase->fetch_value('products_name',TABLE_PRODUCTS_DESCRIPTION,'products_id = ' . (int)$products_id . ' and language_id = ' . (int)$languages_id);
    }

    function getItemsFromListings($products_id)
    {
      global $abxDatabase;
      $languages_id = abxRegistry::get("languages_id");
      

      $in = implode(',', $products_id);

      $strQuery = " select l.id, l.uuid, i.* from abx_items i" .
                  " left join abx_listings l on l.item_uuid = i.uuid" .
                  " where l.id in ($in)";

      $itemsQuery = $abxDatabase->query($strQuery);

      while($itemsQuery->next())
        $items[] = array('id'    => $itemsQuery->valueInt('id'),
                         'title'  => $itemsQuery->value('title'));

      return $items;
    }

    function getCountriesAndCodes()
    {
      $countries = abx_get_countries_with_iso_codes();
      return $countries;
    }
  }//end class
?>